% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik-phybreak.R
\name{logLik.phybreak}
\alias{logLik.phybreak}
\title{Log-likelihood of a phybreak-object.}
\usage{
\method{logLik}{phybreak}(object, genetic = TRUE, withinhost = TRUE,
  sampling = TRUE, generation = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{phybreak}.}

\item{genetic}{Whether to include the likelihood of the mutation model.}

\item{withinhost}{Whether to include the likelihood of within-host (coalescent) model.}

\item{sampling}{Whether to include the likelihood of the sampling model (sampling intervals).}

\item{generation}{Whether to include the likelihood of the transmission model (generation intervals).}

\item{...}{Some methods for this generic require additional arguments. None are used in this method.}
}
\value{
The log-likelihood as an object of class logLik.
}
\description{
The likelihood of a \code{phybreak}-object is calculated, with the option to include or exclude parts of the 
likelihood for genetic data, phylogenetic tree (within-host model), sampling times and generation times.
}
\details{
The sequence likelihood is calculated by Felsenstein's pruning algorithm, assuming a prior probability of 0.25 
for each nucleotide. The within-host likelihood is the likelihood of coalescence times given the within-host model 
and slope. The generation interval and sampling interval likelihood are log-densities of the gamma distributions 
for these variables.
}
\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation)
logLik(MCMCstate)

MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
logLik(MCMCstate)

tree0 <- get.phylo(MCMCstate)
seqdata <- get.seqdata(MCMCstate)
pml(tree0, seqdata, rate = 0.75*get.parameters(MCMCstate)["mu"]) 
logLik(MCMCstate, genetic = TRUE, withinhost = FALSE, 
       sampling = FALSE, generation = FALSE) #should give the same result as 'pml'
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
