% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.g.r
\name{GEN_G}
\alias{GEN_G}
\title{Constructor of GPAS (Green) weighted waveband}
\usage{
GEN_G(norm = 300, w.low = 275, w.high = 313.3)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting function
and normalization wavelength.
}
\description{
Generalized Plant Action BSWF of Caldwell as formulated by Green et al.
}
\note{
In the original publication [2] describing the formulation, the long-end
wavelength boundary is specified as 313.3 nm. This is the default used here.
However, in some cases it is of interest to vary this limit in sensitivity analyses.
The effect on the RAF and doses of changing this boundary is substantial, and
has been analysed by Micheletti et al. [3].
}
\examples{
GEN_G()
GEN_G(300)

}
\references{
[1]Caldwell, M. M. (1971) Solar UV irradiation and the growth and development
of higher plants. In Giese, A. C. (Ed.) Photophysiology, Academic Press,
1971, 6, 131-177

[2] Green, A. E. S.; Sawada, T. & Shettle, E. P. (1974) The middle
ultraviolet reaching the ground Photochemistry and Photobiology, 1974, 19,
251-259

[3] Micheletti, M. I.; Piacentini, R. D. & Madronich, S. (2003) Sensitivity
of Biologically Active UV Radiation to Stratospheric Ozone Changes: Effects
of Action Spectrum Shape and Wavelength Range Photochemistry and
Photobiology, 78, 456-461
}
\seealso{
\code{\link[photobiology]{waveband}}

Other BSWF weighted wavebands: \code{\link{CH4}},
  \code{\link{CIE}}, \code{\link{DNA_GM}},
  \code{\link{DNA_N}}, \code{\link{DNA_P}},
  \code{\link{FLAV}}, \code{\link{GEN_M}},
  \code{\link{GEN_T}}, \code{\link{ICNIRP}},
  \code{\link{PG}}
}
