#' @title Spectra acquired with Macam SR-9010-PC
#'
#' @description Lamp emission spectra measured with a Macam
#'   SR-9010-PC spectroradiometer.
#'
#' @details \code{macam_lamps} is a character vector with indexes to members of 
#'   \code{\link{lamps.mspct}}.
#'
#' @note Instrument used: Macam SR-9010-PC scanning double monochromator
#'   spectroradiometer with a cosine corrected input optics. Recently
#'   calibrated. The lamps were probably driven by a high frequency electronic
#'   ballast. Measured between 1996 to 1998.
#'
#' @references Aphalo, P J, R Tegelberg, and R Julkunen-Tiitto. 1999. The
#'   Modulated UV-B Irradiation System at the University of Joensuu. Biotronics
#'   28: 109-120.
#'   \url{https://cir.nii.ac.jp/crid/1050001335921484032?lang=en}.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples
#' macam_lamps
#' 
"macam_lamps"
