% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caverphone.R
\name{caverphone}
\alias{caverphone}
\title{Caverphone}
\usage{
caverphone(word, maxCodeLen = NULL, modified = FALSE)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}

\item{modified}{if \code{TRUE}, use the Caverphone 2 algorithm}
}
\value{
the Caverphone encoded character vector
}
\description{
The Caverphone family of phonetic algorithms
}
\details{
The variable \code{maxCodeLen} is the limit on how long the returned
Caverphone code should be.  The default is 6, unless \code{modified}
is set to \code{TRUE}, then the default is 10.

The variable \code{modified} directs \code{caverphone} to use the
Caverphone2 method, instead of the original.
}
\examples{
caverphone("William")
caverphone(c("Peter", "Peady"), modified = TRUE)
caverphone("Stevenson", maxCodeLen = 4)

}
\references{
David Hood, "Caverphone: Phonetic matching algorithm," Technical
Paper CTP060902, University of Otago, New Zealand, 2002.

David Hood, "Caverphone Revisited," Technical Paper CTP150804
University of Otago, New Zealand, 2004.
}
\seealso{
Other phonics: \code{\link{lein}}, \code{\link{metaphone}},
  \code{\link{mra_encode}}, \code{\link{nysiis}},
  \code{\link{rogerroot}}, \code{\link{soundex}},
  \code{\link{statcan}}
}

