% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubleLogistics_fitting.R
\name{FitDL}
\alias{FitDL}
\alias{FitDL.Zhang}
\alias{FitDL.AG}
\alias{FitDL.Beck}
\alias{FitDL.Elmore}
\alias{FitDL.Gu}
\alias{FitDL.Klos}
\title{Fine fitting}
\usage{
FitDL.Zhang(y, t = index(y), tout = t, method = "nlm", w, ...)

FitDL.AG(y, t = index(y), tout = t, method = "nlminb", w, ...)

FitDL.Beck(y, t = index(y), tout = t, method = "nlminb", w, ...)

FitDL.Elmore(y, t = index(y), tout = t, method = "nlminb", w, ...)

FitDL.Gu(y, t = index(y), tout = t, method = "nlminb", w, ...)

FitDL.Klos(y, t = index(y), tout = t, method = "BFGS", w, ...)
}
\arguments{
\item{y}{input vegetation index time-series.}

\item{t}{the corresponding doy(day of year) of y.}

\item{tout}{the time of output curve fitting time-series.}

\item{method}{method passed to \code{optimx} or \code{optim} function.}

\item{w}{weights}

\item{...}{other paraters passed to \code{\link[=optim_pheno]{optim_pheno()}}.}
}
\value{
\itemize{
\item \code{tout}: The time of output curve fitting time-series.
\item \code{zs}  : Smoothed vegetation time-series of every iteration.
\item \code{ws}  : Weights of every iteration.
\item \code{par} : Final optimized parameter of fine fitting.
\item \code{fun} : The name of fine fitting.
}
}
\description{
Fine curve fitting function is used to fit vegetation
time-series in every growing season.
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c( mn  = 0.1, mx  = 0.7, sos = 50, rsp = 0.1, eos = 250, rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)
methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang")

r <- FitDL.AG(y, t, tout)
plot(t, y)
lines(tout, r$zs$iter2, col = "red")
legend('topright', c('Original time-series', 'AG smoothed'), 
    lty = c(0, 1), pch = c(16, NA), col = c("black", "red"))
}
\references{
\enumerate{
\item Beck, P.S.A., Atzberger, C., Hogda, K.A., Johansen, B., Skidmore, A.K.,
2006. Improved monitoring of vegetation dynamics at very high latitudes:
A new method using MODIS NDVI. Remote Sens. Environ.
https://doi.org/10.1016/j.rse.2005.10.021.
\item Elmore, A.J., Guinn, S.M., Minsley, B.J., Richardson, A.D., 2012.
Landscape controls on the timing of spring, autumn, and growing season
length in mid-Atlantic forests. Glob. Chang. Biol. 18, 656-674.
https://doi.org/10.1111/j.1365-2486.2011.02521.x. \cr
\item Gu, L., Post, W.M., Baldocchi, D.D., Black, TRUE.A., Suyker, A.E., Verma,
S.B., Vesala, TRUE., Wofsy, S.C., 2009. Characterizing the Seasonal Dynamics
of Plant Community Photosynthesis Across a Range of Vegetation Types,
in: Noormets, A. (Ed.), Phenology of Ecosystem Processes: Applications
in Global Change Research. Springer New York, New York, NY, pp. 35-58.
https://doi.org/10.1007/978-1-4419-0026-5_2. \cr
\item https://github.com/kongdd/phenopix/blob/master/R/FitDoubleLogGu.R
}
}
