% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{align}
\alias{align}
\alias{align<-}
\alias{set_align}
\title{Return or set text alignment}
\usage{
align(x, ...)

align(x) <- value

set_align(x, value)
}
\arguments{
\item{x}{\code{hf_line} object}

\item{...}{Additional arguments passed to method dispatch.}

\item{value}{A string representing the alignment.}
}
\value{
For \code{align()}, the alignment of the supplied \code{hf_line} object.
  For \code{set_align()} and \code{`align<-`()}, the modified object.
}
\description{
These property functions modify or return the text alignment in a \code{hf_line}
object. Supported options are: 'left', 'right', 'center', and 'split'.

An alignment option of 'split' requires that two text elements are provided
in the titles/footnotes \code{hf_line} object. The first text element will
be aligned on the left and the second on the right.
}
\examples{
library(huxtable)
ht <- huxtable(
  column1 = 1:5,
  column2 = letters[1:5]
)
rtf <- rtf_doc(ht, list(hf_line("aTitle")))

pharmaRTF::align(rtf$titles[[1]])
# Returns "center"

pharmaRTF::align(rtf$titles[[1]]) <- "left"
# Sets alignment to 'left'

pharmaRTF::text(rtf$titles[[1]]) <- c("Left Text", "Right Text")
pharmaRTF::align(rtf$titles[[1]]) <- "split"
# When rtf is printed, "Left Text" will be left aligned, and "Right Text"
# will be right aligned. Both will appear on the same line in the document.

}
