% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simon_admissible.R
\name{binom.power}
\alias{binom.power}
\title{The power function for Simon (admissible) two-stage design}
\usage{
binom.power(r1,n1,r,n,p)
}
\arguments{
\item{r1}{first stage threshold to stop the trial for futility.}

\item{n1}{first stage sample size.}

\item{r}{overall threshold to stop the trial for futility.}

\item{n}{total sample size.}

\item{p}{pre-specified response rate, \eqn{p=p_0} for calculating type I error, \eqn{p=p_1} for calculating power.}
}
\value{
\item{prob}{the power function: \eqn{\alpha = Pr(R \le r| p=p_0)} or \eqn{1-\beta=Pr(R \le r| p=p_1)}}
}
\description{
Calculate the type I error or power of a two-stage design
}
\examples{
## Calculate type I error
binom.power(5, 31, 16, 76, 0.15)
binom.power(5, 31, 16, 76, 0.3)

}
\references{
Simon, R. (1989).
\emph{Optimal two-stage designs for phase II clinical trials.}
\emph{Controlled clinical trials} \strong{10(1)}, 1-10.
}
\seealso{
binom.design
}

