#I'm not thoroughly testing the output of the quantile, mantel, etc. methods, because those are maintained by other people
# - though perhaps a few worked examples? Might help to check my own code...
#Setup
require(testthat)
require(picante)
require(pez)
data(phylocom)
data <- comparative.comm(phylocom$phylo, phylocom$sample, traits=phylocom$traits, warn=FALSE)

context("eco.trait.regression")

test_that("quantile", {
  set.seed(123)
  basic.quantile <<- eco.trait.regression(data)
  set.seed(123)
  expect_that(basic.quantile$method, equals(eco.trait.regression(data, method="quantile")$method))
  expect_that(basic.quantile$method, equals("quantile"))
  expect_that(names(basic.quantile), equals(c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "data", "altogether")))
  expect_that(basic.quantile$permute, equals(0))
  expect_that(basic.quantile$altogether, equals(TRUE))
  expect_that(basic.quantile$method, equals("quantile"))
  expect_that(basic.quantile$randomisations, equals(list()))
  expect_that(round(basic.quantile$obs.slope,4), is_equivalent_to(-0.1127))
  expect_that(basic.quantile$data, equals(data))
  expect_that(basic.quantile$type, equals("eco.trait.regression"))
  expect_that(class(basic.quantile), equals("eco.xxx.regression"))
  
  set.seed(123)
  complex.quantile <<- eco.trait.regression(data, randomisation="richness", permute=10, altogether=FALSE, tau=c(0.3, 0.7))
  expect_that(complex.quantile$method, equals(eco.trait.regression(data, method="quantile", randomisation="richness", permute=10, altogether=FALSE, tau=c(0.3, 0.7))$method))
  expect_that(round(coef(complex.quantile[[1]]$observed),4), is_equivalent_to(matrix(c(0,0,0.3333,-0.0635), nrow=2, ncol=2)))
  expect_that(names(complex.quantile), equals(c("", "", "", "", "type", "data", "altogether", "permute", "method")))
  expect_that(complex.quantile$permute, equals(10))
  expect_that(complex.quantile$altogether, equals(FALSE))
  expect_that(complex.quantile$method, equals("quantile"))
  expect_that(complex.quantile$data, equals(data))
  expect_that(names(complex.quantile[[1]]), equals(c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "altogether")))
  expect_that(round(coef(complex.quantile[[1]]$randomisations[[5]]),4), is_equivalent_to(matrix(c(0,0,0.25,0), nrow=2, ncol=2)))
  expect_that(complex.quantile$type, equals("eco.trait.regression"))
  expect_that(class(complex.quantile), equals("eco.xxx.regression.list"))
})

test_that("mantel", {
  set.seed(123)
  basic.mantel <<- eco.trait.regression(data, method="mantel")
  expect_that(names(basic.mantel), equals(names(basic.quantile)))
  expect_that(basic.mantel$permute, equals(basic.quantile$permute))
  expect_that(basic.mantel$altogether, equals(basic.quantile$altogether))
  expect_that(basic.mantel$method, equals("mantel"))
  expect_that(basic.mantel$randomisations, equals(basic.quantile$randomisations))
  expect_that(round(basic.mantel$obs.slope,4), equals(-0.4393))
  expect_that(basic.mantel$data, equals(data))
  expect_that(basic.mantel$type, equals("eco.trait.regression"))
  expect_that(class(basic.mantel), equals("eco.xxx.regression"))
  
  set.seed(123)
  complex.mantel <<- eco.trait.regression(data, method="mantel", randomisation="frequency", permute=10, altogether=FALSE)
  expect_that(names(complex.mantel), equals(names(complex.quantile)))
  expect_that(complex.mantel$permute, equals(complex.quantile$permute))
  expect_that(complex.mantel$altogether, equals(complex.quantile$altogether))
  expect_that(complex.mantel$method, equals("mantel"))
  expect_that(complex.mantel$data, equals(data))
  expect_that(names(complex.mantel[[1]]), equals(c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "altogether")))
  expect_that(round(complex.mantel[[1]]$observed$statistic,4), equals(-0.1839))
  expect_that(round(complex.mantel[[1]]$randomisations[[5]]$statistic,4), equals(-0.0723))
  expect_that(complex.mantel$type, equals("eco.trait.regression"))
  expect_that(class(complex.mantel), equals("eco.xxx.regression.list"))
})

test_that("lm", {
  set.seed(123)
  basic.lm <<- eco.trait.regression(data, method="lm")
  set.seed(123)
  expect_that(names(basic.lm), equals(names(basic.quantile)))
  expect_that(basic.lm$permute, equals(basic.quantile$permute))
  expect_that(basic.lm$altogether, equals(basic.quantile$altogether))
  expect_that(basic.lm$method, equals("lm"))
  expect_that(basic.lm$randomisations, equals(basic.lm$randomisations))
  expect_that(round(basic.lm$obs.slope,4), is_equivalent_to(-0.1255))
  expect_that(basic.lm$data, equals(data))
  expect_that(basic.lm$type, equals("eco.trait.regression"))
  expect_that(class(basic.lm), equals("eco.xxx.regression"))
  
  set.seed(123)
  complex.lm <- eco.trait.regression(data, method="lm", randomisation="independentswap", permute=10, altogether=FALSE)
  expect_that(round(coef(complex.lm[[1]]$observed),4), is_equivalent_to(c(0.2221,-0.0449)))
  expect_that(names(complex.lm), equals(names(complex.quantile)))
  expect_that(complex.lm$permute, equals(complex.quantile$permute))
  expect_that(complex.lm$altogether, equals(complex.quantile$altogether))
  expect_that(complex.lm$method, equals("lm"))
  expect_that(complex.lm$data, equals(data))
  expect_that(names(complex.lm[[1]]), equals(c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "altogether")))
  expect_that(round(coef(complex.lm[[1]]$randomisations[[5]]),4), is_equivalent_to(c(0.1691,0.0134)))
  expect_that(complex.lm$type, equals("eco.trait.regression"))
  expect_that(class(complex.lm), equals("eco.xxx.regression.list"))
})
