% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4pl.R
\name{fourPL}
\alias{fourPL}
\title{4-Parameter Logistic Curve.}
\usage{
fourPL(a = 1, b, c = 0, d = 1, theta)
}
\arguments{
\item{a}{Discrimination parameter (slope).}

\item{b}{Difficulty (severity) parameter (inflection point).}

\item{c}{Guessing parameter (lower asymptote).}

\item{d}{Careless errors parameter (upper asymptote).}

\item{theta}{Person's level on the construct.}
}
\value{
Probability of item endorsement (or expected value on the item).
}
\description{
4-parameter logistic curve for item response theory.
}
\details{
Estimates the probability of item endorsement as function of the
four-parameter logistic (4PL) curve and the person's level on the construct
(theta).
}
\examples{
fourPL(b = 2, theta = -4:4) #1PL
fourPL(b = 2, a = 1.5, theta = -4:4) #2PL
fourPL(b = 2, a = 1.5, c = 0.10, theta = -4:4) #3PL
fourPL(b = 2, a = 1.5, c = 0.10, d = 0.95, theta = -4:4) #4PL

}
\seealso{
\doi{10.1177/0146621613475471}

Other IRT: 
\code{\link{discriminationToFactorLoading}()},
\code{\link{itemInformation}()},
\code{\link{reliabilityIRT}()},
\code{\link{standardErrorIRT}()}
}
\concept{IRT}
