% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateComplement.R
\name{complement}
\alias{complement}
\title{Simulate Complement Variable.}
\usage{
complement(y, rho, x)
}
\arguments{
\item{y}{The existing variable against which to simulate a complement
variable.}

\item{rho}{The correlation magnitude, ranging from [-1, 1].}

\item{x}{(optional) Vector with the same length as \code{y}. Used for
calculating the residuals of the least squares regression of \code{x}
against \code{y}, to remove the \code{y} component from \code{x}.}
}
\value{
Vector of a variable that has a specified correlation in relation to a given
variable \code{y}.
}
\description{
Simulate data with a specified correlation in relation to an existing
variable.
}
\details{
Simulates data with a specified correlation in relation to an existing
variable.
}
\examples{
v1 <- rnorm(100)
complement(y = v1, rho = .5)
complement(y = v1, rho = -.5)

v2 <- complement(y = v1, rho = .85)
plot(v1, v2)

}
\seealso{
\url{https://stats.stackexchange.com/a/313138/20338}

Other simulation: 
\code{\link{simulateAUC}()},
\code{\link{simulateIndirectEffect}()}
}
\concept{simulation}
