% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/personograph.R
\docType{package}
\name{personograph-package}
\alias{personograph-package}
\title{Generate personograph plots from data}
\description{
A personograph (Kuiper-Marshall plot) is a pictographic
representation of relative harm and benefit from an intervention. It is
similar to
\href{http://www.nntonline.net/visualrx/examples/}{Visual Rx (Cates
Plots)}. Each icon on the grid is colored to indicate whether that
percentage of people is harmed by the intervention, would benefit from the
intervention, has good outcome regardless of intervention, or bad outcome regardless of
intervention.
This terminology is similar to that of Uplift Modelling.
}
\details{
The plot function \code{\link{personograph}} is implemented in such
a way that it's easy to just pass a named list of percentages,
colors, and an icon. Making it potentially useful for other use
cases as well.

\if{html}{
The example code will generate the following graph if \code{higher_is_better=F}:

\figure{green.png}{}

}
\if{latex}{
The example code will generate the following graph if \code{higher_is_better=F}:

\figure{green.pdf}{options: width=5in}
}

\subsection{Funding & Acknowledgments}{
This software was commissioned and sponsored by \href{http://www.doctorevidence.com/}{Doctor Evidence}.
The Doctor Evidence mission is to improve clinical outcomes by
finding and delivering medical evidence to healthcare
professionals, medical associations, policy makers and
manufacturers through revolutionary solutions that enable anyone to
make informed decisions and policies using medical data that is
more accessible, relevant and readable.}

\subsection{Source & Issues}{
Source code and issue tracker can be found on \href{https://github.com/joelkuiper/personograph}{Github}.
}
}
\examples{
# Example data
data <- read.table(textConnection('
          name ev.trt n.trt ev.ctrl n.ctrl
1     Auckland     36   532      60    538
2        Block      1    69       5     61
3        Doran      4    81      11     63
4        Gamsu     14   131      20    137
5     Morrison      3    67       7     59
6 Papageorgiou      1    71       7     75
7      Tauesch      8    56      10     71
'
), header=TRUE)

sm <- "RR" # The outcome measure (either Relative Risk or Odds Ratio)
if (requireNamespace("meta", quietly = TRUE)) { # use meta if available
    ## Calculate the pooled OR or RR point estimate
    m <- with(data,
           meta::metabin(ev.trt, n.trt, ev.ctrl, n.ctrl, sm=sm))
    point <- exp(m$TE.random) # meta returns random effects estimate on the log scale
} else {
    # Calculated Random Effects RR, using the meta package
    point <- 0.5710092
}

# Approximate the Control Event Rates using a weighed median
cer <- w.approx.cer(data[["ev.ctrl"]], data[["n.ctrl"]])

# Calculate the Intervention Event Rates (IER) from the CER and point estimate
ier <- calc.ier(cer, point, sm)

# Calcaulte the "uplift" statistics
# Note that this depends on the direction of the outcome effect (higher_is_better)
u <- uplift(ier, cer, higher_is_better=FALSE)
plot(u, fig.title="Example", fig.cap="Example from rMeta")
}
\seealso{
\code{\link{personograph}}

\code{\link{uplift}}
}

