# this file creates the *full* dodecahedron group.  This file is a
# derivative of dodecahedron_group.py, which contains more
# documentation.  Execute this file in a SAGE environment; the last
# two lines print the output to the screen.

# The full dodecahedron group is the group of rotations and
# reflections of the dodecahedron (compare the dodecahedron group,
# which does not include reflections).

# (NB: although the full dodecahedron group has 120 elements, it is
# *not* isomorphic to S_5).

# This file creates objects full_dod_face and full_dod_edge, the full
# dodecahedron group on the faces and the edges of the dodecahedron
# respectively.

# The basic idea is that full_dod_face is the group generated by
# {face1,face2,face_reflect}, where face1 and face2 are the same as in
# dodecahedron_group.py, and face_reflect is a reflection of the
# model.



face1 = PermutationGroupElement([(2,3,4,5,6),(7,11,10,9,8)])  
face2 = PermutationGroupElement([(3,1,2),(6,8,4),(9,7,5),(10,12,11)])

# reflect about plane defined by the centers of faces 1,2,11,12:
face_reflect = PermutationGroupElement([(3,6),(4,5),(8,9),(7,10)]) 

full_dod_face  = PermutationGroup([face1,face2,face_reflect])

full_dod_face.is_isomorphic(SymmetricGroup(5))   #should  be 'False'



# Now do full_dod_edge, the group generated by {edge1,edge2,edge_reflect}

edge1 = PermutationGroupElement([
    (10, 12, 14, 16, 18),
    (20, 32, 44, 56, 24),
    (26, 38, 40, 52, 64),
    (28, 30, 42, 54, 66),
    (72, 76,108, 96, 84),
    (74,112,100, 98, 86)]) 


edge2 = PermutationGroupElement([
    (16,20,18),
    (10,24,38),
    (14,28,32),
    (12,26,30),
    (40,56,84),
    (44,66,72),
    (42,64,86),
    (52,96,74),
    (54,98,76),
    (100,112,108)])


# put the model with face 1 uppermost, edge 16 towards you; reflection
# is left-right about a vertical plane.


edge_reflect = PermutationGroupElement([  
    (10,  12),
    (14,  18),
    (20,  24),
    (26,  28),
    (30,  64),
    (32,  56),
    (38,  66),
    (40,  54),
    (42,  52),
    (72,  96),
    (74, 100),
    (76, 108),
    (86,  98)    
])
    

full_dod_edge  = PermutationGroup([edge1,edge2,edge_reflect])

full_dod_edge.is_isomorphic(SymmetricGroup(5))  # should be FALSE
full_dod_edge.is_isomorphic(full_dod_face)      # Should be TRUE


actual_edges=(10,12,14,16,18,20,24,26,28,30,32,38,40,42,44,52,54,56,64,66,72,74,76,84,86,96,98,100,108,112)


# print them to output:

full_dod_face.list()
full_dod_edge.list()
