% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_normality.R
\name{check_normality}
\alias{check_normality}
\alias{check_normality.merMod}
\title{Check model for (non-)normality of residuals.}
\usage{
check_normality(x, ...)

\method{check_normality}{merMod}(x, effects = c("fixed", "random"), ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}

\item{effects}{Should normality for residuals (\code{"fixed"}) or random
effects (\code{"random"}) be tested? Only applies to mixed-effects models.
May be abbreviated.}
}
\value{
Invisibly returns the p-value of the test statistics. A p-value
< 0.05 indicates a significant deviation from normal distribution
}
\description{
Check model for (non-)normality of residuals.
}
\details{
\code{check_normality()} calls \code{stats::shapiro.test}
and checks the standardized residuals (or Studentized residuals for mixed
models) for normal distribution. Note that this formal test almost always
yields significant results for the distribution of residuals and visual
inspection (e.g. Q-Q plots) are preferable.
}
\note{
For mixed-effects models, studentized residuals, and \emph{not}
  standardized residuals, are used for the test. There is also a
  \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method}
   implemented in the
  \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
m <<- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_normality(m)

# plot results
if (require("see")) {
  x <- check_normality(m)
  plot(x)
}
\dontrun{
# QQ-plot
plot(check_normality(m), type = "qq")

# PP-plot
plot(check_normality(m), type = "pp")
}
}
