% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.R
\name{penfaOptions}
\alias{penfaOptions}
\title{\code{penfa} Options}
\usage{
penfaOptions(
  opt = list(meanstructure = FALSE, int.ov.free = FALSE, int.lv.free = FALSE,
    orthogonal = FALSE, std.lv = FALSE, auto.fix.first = FALSE, auto.fix.single = FALSE,
    std.ov = FALSE, information = "fisher", control = list(), optim.dx.tol = 100, a.scad
    = 3.7, a.mcp = 3, a.alasso = 1, weights = NULL, cbar = 1e-08, gamma = 4, user.start =
    FALSE, start.val = c(), verbose = TRUE, warn = TRUE, debug = FALSE)
)
}
\arguments{
\item{opt}{List of default options. See below for details.}
}
\value{
A list of default options internally used by the \code{\link{penfa}}
function.
}
\description{
The default options internally used by the \code{\link{penfa}}
function. These options can be changed by passing "name = value" arguments to
the \code{penfa} function call, where they are being added to the "..."
argument.
}
\details{
The following section details the full list of options currently
accepted by the \code{penfa} function.

Model features:

\describe{
\item{\code{meanstructure}:}{Logical. If \code{TRUE}, a meanstructure is
requested. It should be used in conjunction with \code{int.ov.free} and
\code{int.lv.free} or intercept-like formulas in the model syntax.
Default to \code{FALSE}.}
\item{\code{int.ov.free}:}{Logical. If \code{FALSE}, the intercepts of the
observed variables are fixed to zero. Default to \code{FALSE}.}
\item{\code{int.lv.free}:}{Logical. If \code{FALSE}, the intercepts of the
common factors are fixed to zero. Default to \code{FALSE}.}
\item{\code{orthogonal}:}{Logical. If \code{TRUE}, all covariances among the
common factors are set to zero. Default to \code{FALSE}.}
\item{\code{std.lv}:}{Logical. If \code{TRUE}, the factor variances are fixed
to 1.0. Default to \code{FALSE}.}
\item{\code{auto.fix.first}:}{Logical. If \code{TRUE}, the factor loading of
the first indicator is set to 1.0 for every factor. Default to \code{FALSE}.}
\item{\code{auto.fix.single}:}{Logical. If \code{TRUE}, the residual variance
(if included) of an observed indicator is set to zero if it is the only
indicator of a common factor. Default to \code{FALSE}.}
}

Data options:
\describe{
\item{\code{std.ov}:}{Logical. If \code{TRUE}, all observed variables are
standardized before entering the analysis. Default to \code{FALSE}.}
}

Estimation and optimization:
\describe{
\item{\code{information}:}{Character. If \code{"fisher"}, the penalized
expected Fisher information matrix is used as second-order derivatives
in the trust-region algorithm and for computing the standard errors of the
model parameters. If \code{"hessian"}, the penalized Hessian matrix
is used. Default to \code{"fisher"}.}
\item{\code{control}:}{A list containing control parameters passed to the
trust-region optimizer. See the manual page of \code{trust} from the
\code{trust} package for an overview of its control parameters. Default
values for these parameters are \code{rinit=1L}, \code{rmax=100L},
\code{iterlim=1000L}, \cr \code{fterm = sqrt(.Machine$double.eps)},
\code{mterm = sqrt(.Machine$double.eps)}. }
\item{\code{optim.dx.tol}}{Numeric. The tolerance value used when checking
the size of the elements of the gradient of the objective function. Default
equal to 100.}
}

Penalization:
\describe{
\item{\code{a.scad}}{Numeric. The shape parameter for the scad penalty.
Default to 3.7, as recommended by Fan & Li (2001).}
\item{\code{a.mcp}}{Numeric. The shape parameter of the mcp penalty. Default
to 3.}
\item{\code{a.alasso}}{Numeric. The exponent in the adaptive weights for the
alasso penalty. Default to 1.}
\item{\code{weights}}{Numeric. Only valid when either \code{pen.shrink} or
\code{pen.diff} is equal to "alasso". An optional vector of values provided
by the user representing a consistent estimate for each model parameter. The
vector is then internally used for computing the adaptive weights. If
unspecified, the maximum likelihood estimates (MLE) from the unpenalized
model are used. }
\item{\code{cbar}}{Numeric. Numerical constant used in the local approximation
of the penalty functions. Default to 1e-08.}

Automatic procedure:
\item{\code{gamma}}{Numeric. The value of the influence factor used in the
automatic tuning parameter procedure. Default to 4.}
\item{\code{user.start}}{Logical whether the user has provided a vector of
starting values for the model parameter estimates. }
\item{\code{start.val}}{Numeric. An optional vector of parameter estimates to
be used as starting values for the model parameters. This option is also
internally used by the automatic procedure.}
}

Verbosity options:
\describe{
\item{\code{verbose}:}{Logical. If \code{TRUE}, some information on the
estimation process (e.g., convergence and admissibility checks, effective
degrees of freedom) are printed out. Default to \code{TRUE}.}
\item{\code{warn}:}{Logical. If \code{TRUE}, some warnings are printed out
during the iterations. Default to \code{TRUE}.}
\item{\code{debug}:}{Logical. If \code{TRUE}, debugging information is
printed out. Default to \code{FALSE}.}
}
}
