% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutRate.R
\name{mutRate}
\alias{mutRate}
\title{Overall mutation rate}
\usage{
mutRate(mut, afreq = NULL)
}
\arguments{
\item{mut}{A \code{\link[=mutationModel]{mutationModel()}} or \code{\link[=mutationMatrix]{mutationMatrix()}}.}

\item{afreq}{A vector of allele frequencies.}
}
\value{
A single number, or (if \code{mut} is a \code{\link[=mutationModel]{mutationModel()}} and the female
and male rates differ) a list of two numbers, named "female" and "male".
}
\description{
Calculate the overall mutation rate at a locus, given a mutation model an a
set of allele frequencies.
}
\details{
The mutation rate is found by the formula \code{1 - sum(diag(mut) * afreq)}.

If \code{mut} is a \code{\link[=mutationModel]{mutationModel()}}, the rate is calculated separately for the
male and female matrices.
}
\examples{
m = mutationMatrix("stepwise", alleles = 1:4, afreq = c(.1,.2,.3,.4),
                   rate = 0.01, rate2 = 1e-6, range = 0.1)
r = mutRate(m)

stopifnot(all.equal(r, 0.01))
}
