% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_properties.R
\name{model_properties}
\alias{model_properties}
\alias{isStationary}
\alias{isReversible}
\alias{isLumpable}
\alias{alwaysLumpable}
\title{Mutation model properties}
\usage{
isStationary(mutmat, afreq = NULL)

isReversible(mutmat, afreq = NULL)

isLumpable(mutmat, lump)

alwaysLumpable(mutmat)
}
\arguments{
\item{mutmat}{A \code{\link[=mutationMatrix]{mutationMatrix()}} or a \code{\link[=mutationModel]{mutationModel()}}.}

\item{afreq}{A vector with allele frequencies, of the same length as the size
of \code{mutmat}.}

\item{lump}{A nonempty subset of the colnames of \code{mutmat} (i.e. the allele
labels).}
}
\value{
Each of these functions returns TRUE of FALSE.
}
\description{
Functions for checking various properties of a mutation model, including
stationarity, reversibility and lumpability.
}
\examples{

# "proportional" models are stationary and reversible
afr = c(0.2, 0.3, 0.5)
m_prop = mutationMatrix(model = "prop", alleles = 1:3, afreq = afr, rate = 0.1)
stopifnot(isStationary(m_prop, afr), isReversible(m_prop, afr))

# "equal" model is stationary and reversible only when freqs are equal
m_eq = mutationMatrix(model = "eq", alleles = 1:3, rate = 0.1)
stopifnot(isStationary(m_eq, rep(1/3, 3)), isReversible(m_eq, rep(1/3, 3)))
stopifnot(!isStationary(m_eq, afr), !isReversible(m_eq, afr))

# "equal" and "proportional" models allow allele lumping
stopifnot(isLumpable(m_eq, lump = 1:2))
stopifnot(isLumpable(m_prop, lump = 1:2))

# In fact lumpable for any allele subset
stopifnot(alwaysLumpable(m_eq), alwaysLumpable(m_prop))

}
