% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{relfactor}
\alias{relfactor}
\title{Relationship factor from a pedigree}
\usage{
relfactor(ped, labs)
}
\arguments{
\item{ped}{a pedigree that includes the individuals who occur in svec}

\item{labs}{a character vector or a factor giving the labels to
which to restrict the relationship matrix. If \code{labs} is a
factor then the levels of the factor are used as the labels.
Default is the complete set of labels in the pedigree.}
}
\value{
an object that inherits from \linkS4class{CHMfactor}
}
\description{
Determine the right Cholesky factor of the relationship matrix for
the pedigree \code{ped}, possibly restricted to the specific labels
that occur in \code{labs}.
}
\examples{
ped <- pedigree(sire=c(NA,NA,1,1,4,5), dam=c(NA,NA,2,NA,3,2), label=1:6)
relfactor(ped)
}

