% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gml_part}
\alias{gml_part}
\title{Participant Summaries of the GML-MID Data}
\format{
A data frame with 5217 observations on the following 21 variables.
\describe{
\item{\code{dispnum}}{the dispute ID in the GML MID data}
\item{\code{ccode}}{the Correlates of War code for the participant}
\item{\code{styear}}{the start year for the participant}
\item{\code{stmon}}{the start month for the participant}
\item{\code{stday}}{the start day for the participant}
\item{\code{endyear}}{the end year for the participant}
\item{\code{endmon}}{the end month for the participant}
\item{\code{endday}}{the end day for the participant}
\item{\code{obsid_start}}{an observational ID from \code{archigos} for the leader at the participant onset}
\item{\code{obsid_end}}{an observational ID from \code{archigos} for the leader at the participant conclusion}
\item{\code{dummy_stday}}{a "dummy" start day for the participant. See details for more.}
\item{\code{dummy_endday}}{a "dummy" end day for the participant. See details for more.}
\item{\code{sidea}}{was participant on Side A of the dispute}
\item{\code{hiact}}{highest action for participant in dispute(-episode)}
\item{\code{orig}}{was participant an originator?}
\item{\code{anymiss_leader_start}}{a dummy variable for disputes that equals 1 for a dispute in which \emph{any} participant has a missing leader ID at the start date.}
\item{\code{anymiss_leader_end}}{a dummy variable for disputes that equals 1 for a dispute in which \emph{any} participant has a missing leader ID at the end date.}
\item{\code{allmiss_leader_start}}{a dummy variable for disputes that equals 1 for a dispute in which \emph{all} participants have a missing leader ID at the start date.}
\item{\code{allmiss_leader_end}}{a dummy variable for disputes that equals 1 for a dispute in which \emph{all} participants have a missing leader ID at the end date.}
}
}
\usage{
gml_part
}
\description{
These are the participant summaries of the most recent GML-MID data. The data also include leaders at the onset
and conclusion of a participant episode in the GML MID data.
}
\details{
Information about leaders come from Archigos (v. 4.1). GML MID Data are version 2.2.1. The \code{data-raw} directory
contains information about how these data were generated. There is invariably going to be some guesswork here because
dates are sometimes not known with precision. Sometimes, a dispute coincides even with a leadership change when dates are
known with precision. The source script includes a discussion of these cases and shows how the data were generated with all
these caveats in mind.

Do note that participants can have several episodes within a dispute. Sometimes participants switch sides (e.g. Romania in World War 2).
Sometime participants drop in and out of a long-running dispute (e.g. Syria, prominently, in MID#4182).

"Dummy" start days and end days are there to serve as a parlor trick in assigning disputes to leaders in leader-level analyses. Where days
are known with precision, the dummy day is that number. In most cases, where the day is not known with precision coincides with a month
that has no leader transition. Thus, the start day that gets imputed is going to be the first of the month (for the dummy start day)
or the last of the month (for the dummy end day). Cases where there was a leader transition (or two) that month may require some more
sensitive imputing. For example, our best guess is Antonio Guzmán Blanco of Venezuela is president for the end of MID#1639, given his
role in trying to negotiate a conclusion to the dispute. Archigos has him leaving office on the 7th, so that's the end day that gets imputed
for him. Again, these are here to serve as a parlor trick in assigning disputes to leaders for leader-level analyses. Be careful about using
these data for calculating dispute-participant duration. In fact: don't do that.
}
\references{
Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis of the Militarized
Interstate Dispute (MID) Dataset, 1816-2001.” International Studies Quarterly 60(4): 719-730.

Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009. "Introducing Archigos: A Dataset of Political Leaders"
\emph{Journal of Peace Research} 46(2): 269--83.
}
\keyword{datasets}
