% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{pdSpecClust2D}
\alias{pdSpecClust2D}
\title{Intrinsic 2D wavelet-based clustering of multivariate time-varying spectra.}
\usage{
pdSpecClust2D(P, K, jmax, metric = "Riemannian", m = 2, d.jmax = 0.1,
  eps = c(1e-04, 1e-04), tau = 0.5, max.iter = 50, return.centers = F,
  ...)
}
\arguments{
\item{P}{a (\eqn{d,d,n_1,n_2,S})-dimensional array corresponding to discretized surfaces of HPD matrices for \code{S}
different subjects at \eqn{n_1 \times n_2} different time-frequency points (on a rectangular tensor grid), with \eqn{n_1}
and \eqn{n_2} dyadic numbers.}

\item{K}{the number of clusters, should be a integer larger than 1.}

\item{jmax}{an upper bound on the maximum wavelet scale to be considered in the clustering procedure. If
\code{jmax} is not specified, it is set equal to the largest (i.e. finest) possible wavelet scale.}

\item{metric}{the metric that the space of HPD matrices is equipped with. The default choice is \code{"Riemannian"},
but this can also be one of: \code{"logEuclidean"}, \code{"Cholesky"}, \code{"rootEuclidean"} or
\code{"Euclidean"}. The intrinsic distance measures in the clustering algorithm fundamentally rely on the chosen metric.}

\item{m}{the fuzziness parameter for both the fuzzy c-medoids and the weighted fuzzy c-means algorithm. \code{m}
should be larger or equal to \eqn{1}. If \eqn{m = 1} the cluster assignments are no longer fuzzy (i.e. the procedure
performs hard clustering).}

\item{d.jmax}{a proportion that is used to determine the maximum wavelet scale to be considered in the clustering
procedure. A larger value \code{d.jmax} leads to less wavelet coefficients being taken into account, and therefore
lower computational effort in the procedure. If \code{d.jmax} is not specified, by default \code{d.jmax = 0.1}.}

\item{eps}{an optional vector with two elements determining the stopping criterion. The fuzzy c-medoids algorithm
(i.e. first clustering step) terminates if the (integrated) intrinsic distance between cluster centers is smaller than
\code{eps[1]}. The weighted fuzzy c-means (i.e. second clustering step) terminates if the (integrated) distance between
cluster centers is smaller than \code{eps[2]}. If \code{eps} is not specified, by default \code{eps = c(1E-4, 1E-4)}.}

\item{tau}{an optional argument tuning the weight given to the cluster assignments obtained in the first step of
the clustering algorithm. If \code{tau} is not specified, by default \code{tau = 0.5}.}

\item{max.iter}{an optional argument tuning the maximum number of iterations in both the first and second step of the
clustering algorithm, defaults to \code{max.iter = 50}.}

\item{return.centers}{should the cluster centers transformed back the space of HPD matrices also be returned?
Defaults to \code{return.centers = F}.}

\item{...}{additional arguments for internal use.}
}
\value{
The function returns a list with 6 components:
\describe{
  \item{cl.prob }{an (\eqn{S,K})-dimensional matrix, where the value at position (\eqn{s,k}) in the
  matrix corresponds to the probabilistic cluster membership assignment of subject \eqn{s} with respect
  to cluster \eqn{k}.}
  \item{cl.centers.D }{a list of \code{K} wavelet coefficient pyramids, where each 2D pyramid of wavelet
  coefficients is associated to a cluster center.}
  \item{cl.centers.M0 }{an array \code{K} \eqn{(d,d)}-dimensional coarse-scale midpoints at scale \code{j = 0},
  where each midpoint is associated to a cluster center.}
  \item{cl.centers.f }{if \code{return.centers = T} returns a list of \code{K} \eqn{(d,d,n_1,n_2)}-dimensional arrays,
  where each array corresponds to a discretized surface of HPD matrices associated to a cluster center. If
  \code{return.centers = F}, \code{cl.centers.f} returns \code{NULL}.}
  \item{cl.jmax }{the maximum wavelet scale taken into account in the clustering procedure determined by
  the input arguments \code{jmax} and \code{d.jmax}.}
  \item{iters }{the number of iterations in respectively the first and second step of the clustering procedure.}
}
}
\description{
\code{pdSpecClust2D} performs clustering of multivariate time-varying spectral matrices via a two-step fuzzy
clustering algorithm in the intrinsic manifold wavelet domain of surface in the space of HPD matrices
equipped with a metric, e.g. the Riemannian metric, specified by the user. This function extends
\code{pdSpecClust2D} for clustering surfaces instead of curves of HPD matrices.
}
\details{
The input array \code{P} corresponds to initial noisy HPD time-varying spectral estimates of the (\eqn{d, d})-
dimensional spectral matrices at \eqn{m_1 \times m_2} different time-frequency points for \eqn{S} different
subjects, with \eqn{m_1, m_2} dyadic numbers. The initial spectral estimates can be e.g. the tapered HPD
time-varying  periodograms given as output by \code{\link{pdPgram2D}}. \cr
For each subject \eqn{s}, thresholded wavelet coefficients in the intrinsic 2D manifold wavelet domain are
calculated by \code{\link{pdSpecEst2D}}.\cr
The maximum wavelet scale taken into account in the clustering procedure is determined by the arguments
\code{jmax} and \code{d.jmax}. The maximum scale is set to the minimum of \code{jmax} and the wavelet
scale \eqn{j} for which the proportion of nonzero thresholded wavelet coefficients (averaged
across subjects) is smaller than \code{d.jmax}.\cr
The \eqn{S} subjects are assigned to \eqn{K} different clusters in a probabilistic fashion according to a
two-step procedure:
\enumerate{
\item In the first step, an intrinsic fuzzy c-medoids algorithm, with fuzziness parameter \eqn{m} is applied to the
\eqn{S} coarsest midpoints at scale \code{j = 0} in the subject-specific 2D midpoints pyramids. Note that the intrinsic
c-medoids algorithm crucially relies on the metric that the space of HPD matrices gets equipped with.
\item In the second step, a weighted fuzzy c-means algorithm based on the Euclidean
distance function, also with fuzziness parameter \eqn{m}, is applied to the nonzero thresholded wavelet
coefficients of the \eqn{S} different subjects. The tuning parameter \code{tau} controls the weight given
to the cluster assignments obtained in the first step of the clustering algorithm.
}
If \code{return.centers = T}, the function also returns the \code{K} HPD time-varying spectral matrices corresponding
to the cluster centers based on the given metric by applying the intrinsic inverse 2D wavelet transform (
\code{\link{InvWavTransf2D}}) to the cluster centers in the wavelet domain.
}
\examples{
## Generate periodogram date for 4 subjects
pgram <- function(seed) rExamples2D(c(2^5, 2^5), 2, example = "smiley", seed = seed)$per
P <- array(c(replicate(2, pgram(1)), replicate(2, pgram(2))), dim=c(2,2,2^5,2^5,4))

cl <- pdSpecClust2D(P, K = 2, metric = "logEuclidean")

}
\seealso{
\code{\link{pdSpecEst2D}}, \code{\link{WavTransf2D}}, \code{\link{pdDist}}, \code{\link{pdPgram2D}}
}
