% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karchMean.R
\name{pdMean}
\alias{pdMean}
\title{Weighted geometric mean of HPD matrices}
\usage{
pdMean(M, w, grad_desc = F, max_iter = 1000, tol, ...)
}
\arguments{
\item{M}{a \eqn{(d,d,S)}-dimensional array of Hermitian PD matrices.}

\item{w}{an \eqn{S}-dimensional nonnegative weight vector, such that \code{sum(w) = 1}.}

\item{grad_desc}{a logical value deciding if the gradient descent algorithm be used, defaults to
\code{FALSE}.}

\item{max_iter}{maximum number of iterations in gradient descent algorithm, only used if
\code{isTRUE(grad_desc)}.}

\item{tol}{optional tolerance parameter in gradient descent algorithm, only used if
\code{isTRUE(grad_desc)}, defaults to \code{.Machine$double.eps}.}

\item{...}{additional arguments for internal usage.}
}
\description{
\code{pdMean} calculates an (approximate) weighted geometric mean of \eqn{S} different
\eqn{(d \times d)}-dimensional Hermitian PD matrices based on the Riemannian metric by
the fast recursive algorithm in (Chau and von Sachs, 2017) or the slower but more accurate
gradient descent algorithm in (Pennec, 2006). By default, the unweighted geometric mean is computed.
}
\examples{
m <- function(){
 X <- matrix(complex(real=rnorm(9), imaginary=rnorm(9)), nrow=3)
 t(Conj(X)) \%*\% X
}
M <- replicate(100, m())
z <- rnorm(100)
w <- abs(z)/sum(abs(z))
Ave <- pdMean(M, w)

}
\references{
Chau, J. and von Sachs, R. (2017). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.

Pennec, X. (2006). Intrinsic statistics on Riemannian manifolds: Basic tools for geometric
measurements. \emph{Journal of Mathematical Imaging and Vision} 25(1), 127-154.
}
\seealso{
\code{\link{Mid}}
}
