% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pct.R
\name{get_pct_routes_fast}
\alias{get_pct_routes_fast}
\title{Get fast road network results from the PCT}
\usage{
get_pct_routes_fast(
  region = NULL,
  purpose = "commute",
  geography = "msoa",
  extension = ".geojson"
)
}
\arguments{
\item{region}{The PCT region or local authority to download data from (e.g. \code{west-yorkshire} or \code{Leeds}).
See \code{View(pct_regions_lookup)} for a full list of possible region names.}

\item{purpose}{Trip purpose (typically \code{school} or \code{commute})}

\item{geography}{Geographic resolution of outputs (\code{msoa} or \code{lsoa})}

\item{extension}{The type of file to download (only \code{.geojson} supported at present)}
}
\description{
Wrapper around \verb{[get_pct()]} that gets rf data from the PCT.
}
\examples{
z = get_pct_routes_fast("isle-of-wight")
plot(z)
}
