\name{contrast.plot}
\alias{contrast.plot}
\title{
Contrast Plot of Relative Effect Sizes
}
\description{
\code{contrast.plot} generates contrast plot, which shows 95\% credible intervals (CIs) for relative effect sizes.
}
\usage{
contrast.plot(nma.obj, effect.size, reference, digits = 2, width = 5, height,
              network.name)
}
\arguments{
  \item{nma.obj}{
  a list object obtained by function \code{\link{nma.ab.bin}}, \code{\link{nma.ab.cont}}, \code{\link{nma.ab.py}}, or \code{\link{nma.ab.followup}}.
}
  \item{effect.size}{
  a character string indicating the relative effect size to be shown in the contrast plot. If \code{nma.obj} is obtained from \code{\link{nma.ab.bin}}, this argument can be \code{"OR"} (default), \code{"LOR"}, \code{"RR"}, \code{"LRR"}, or \code{"RD"}. If \code{nma.obj} is obtained from \code{\link{nma.ab.cont}}, this argument should be \code{"diff"} (default). If \code{nma.obj} is obtained from \code{\link{nma.ab.py}} or \code{\link{nma.ab.followup}}, this argument can be \code{"ratio"} (default) or \code{"logratio"}. Note that the specified effect sizes (or its logarithm/exponential) must have been estimated in \code{nma.obj}.
}
  \item{reference}{
  a character string indicating the reference treatment name to be compared against.
}
  \item{digits}{
  an integer indicating the number of decimal places to be used for the point estimates and 95\% CIs. The default is \code{2}.
}
  \item{width}{
  a positive number indicating the plot width. The default is 5.
}
  \item{height}{
  a positive number indicating the plot height. The default is the treatment number minus 1.
}
  \item{network.name}{
  a character string indicating the network name to be used for the produced .pdf file name.
}
}
\value{
A contrast plot for relative effect sizes is saved as a .pdf file in users' current working directory.
}

\examples{
data(smoke)
# increase n.iter to reach convergence
# increase n.adapt to enhance efficiency
set.seed(1234)
nma.out <- nma.ab.bin(s.id, t.id, r, n, data = smoke,
  trtname = c("NC", "SH", "IC", "GC"), param= "LOR",
  model = "het_cor", n.adapt = 400, n.iter = 100, n.chains = 1)
contrast.plot(nma.out)
}
