% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{IndNPEint}
\alias{IndNPEint}
\title{The indicator for the presence of an arc from a point to another for
Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one interval case}
\usage{
IndNPEint(p1, p2, int, r, c = 0.5)
}
\arguments{
\item{p1}{A 1D point for which the proximity region is constructed.}

\item{p2}{A 1D point for which it is checked whether it resides in the proximity region
of \eqn{p_1} or not.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
\eqn{I(p_2 \in N_{PE}(p_1,r,c))}, that is, returns 1 if \eqn{p_2} in \eqn{N_{PE}(p_1,r,c)}, returns 0 otherwise
}
\description{
Returns \eqn{I(p_2 \in N_{PE}(p_1,r,c))} for points \eqn{p_1} and \eqn{p_2}, that is, returns 1 if \eqn{p_2} is in \eqn{N_{PE}(p_1,r,c)},
returns 0 otherwise, where \eqn{N_{PE}(x,r,c)} is the PE proximity region for point \eqn{x} with expansion parameter \eqn{r \ge 1}
and centrality parameter \eqn{c \in (0,1)}.

PE proximity region is constructed with respect to the
interval \eqn{(a,b)}. This function works whether \eqn{p_1} and \eqn{p_2} are inside or outside the interval \code{int}.

Vertex regions for middle intervals are based on the center associated with the centrality parameter \eqn{c \in (0,1)}.
If \eqn{p_1} and \eqn{p_2} are identical, then it returns 1 regardless of their locations
(i.e., loops are allowed in the digraph).

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

IndNPEint(7,5,int,r,c)
IndNPEint(15,17,int,r,c)
IndNPEint(1,3,int,r,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNPEmid.int}}, \code{\link{IndNPEend.int}} and \code{\link{IndNCSint}}
}
\author{
Elvan Ceyhan
}
