% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsMuVarPEend1D}
\alias{funsMuVarPEend1D}
\alias{muPEend1D}
\alias{asyvarPEend1D}
\title{Returns the mean and (asymptotic) variance of arc density of Proportional Edge Proximity Catch Digraph (PE-PCD)
for 1D data - end interval case}
\usage{
muPEend1D(r)

asyvarPEend1D(r)
}
\arguments{
\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}
}
\value{
\code{muPEend1D} returns the mean and \code{asyvarPEend1D} returns the asymptotic variance of the
arc density of PE-PCD for uniform data in end intervals
}
\description{
Two functions: \code{muPEend1D} and \code{asyvarPEend1D}.

\code{muPEend1D} returns the mean of the arc density of PE-PCD
and \code{asyvarPEend1D} returns the asymptotic variance of the arc density of PE-PCD
for a given expansion parameter \eqn{r \ge 1} for 1D uniform data in the left and right end intervals
for the interval \eqn{(a,b)}.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
#Examples for muPEend1D
muPEend1D(1.2)

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

mu.end<-vector()
for (i in 1:lrseq)
{
  mu.end<-c(mu.end,muPEend1D(rseq[i]))
}

plot(rseq, mu.end,type="l",
ylab=expression(paste(mu,"(r)")),xlab="r",lty=1,xlim=range(rseq),ylim=c(0,1))

#Examples for asyvarPEend1D
asyvarPEend1D(1.2)

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

var.end<-vector()
for (i in 1:lrseq)
{
  var.end<-c(var.end,asyvarPEend1D(rseq[i]))
}

oldpar <- par(mfrow = c(1,2))
par(mar=c(5,5,4,2))
plot(rseq, var.end,type="l",
xlab="r",ylab=expression(paste(sigma^2,"(r)")),lty=1,xlim=range(rseq))
par(oldpar)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{muCSend1D}} and \code{\link{asyvarCSend1D}}
}
