% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_get_dama_file.R
\name{f_get_dama_file}
\alias{f_get_dama_file}
\title{Get a File within 'DataMashup'}
\usage{
f_get_dama_file(input_file_pbix, variable, index_collection)
}
\arguments{
\item{input_file_pbix}{Path of the input '.pbix'.}

\item{variable}{File to be extracted ("xml", "zip", "ziponly" or "hf"). "xml"
refers to one or more uncompressed '.xml' files inside 'DataMashup'. "zip"
refers to compressed ('.zip') data within 'DataMashup'.  "ziponly" refers to
"zip" excluding "xml". "hf" refers to data occuring before and
after compressed data.}

\item{index_collection}{Index created with f_get_dama_index.}
}
\value{
The byte sequnce of 'DataMashup' based on an index.
}
\description{
The byte sequence of 'DataMashup' within a '.pbix' is retrieved
and the relevant file within 'DataMashup' is extracted.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

index_collection <- f_get_dama_index(pathFileSample)
# Run the function with different options
# xml
test_xml <- f_get_dama_file(pathFileSample, "xml", index_collection)
# zip
test_zip <- f_get_dama_file(pathFileSample, "zip", index_collection)
# ziponly
test_zip <- f_get_dama_file(pathFileSample, "ziponly", index_collection)
# hf
test_hf <- f_get_dama_file(pathFileSample, "hf", index_collection)
  }
}
\seealso{
Uses: \code{\link{f_get_dama}}.
}
\author{
Don Diproto
}
