% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_update_file_system}
\alias{efs_update_file_system}
\title{Updates the throughput mode or the amount of provisioned throughput of
an existing file system}
\usage{
efs_update_file_system(
  FileSystemId,
  ThroughputMode = NULL,
  ProvisionedThroughputInMibps = NULL
)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system that you want to update.}

\item{ThroughputMode}{(Optional) Updates the file system's throughput mode. If you're not
updating your throughput mode, you don't need to provide this value in
your request. If you are changing the \code{ThroughputMode} to \code{provisioned},
you must also set a value for \code{ProvisionedThroughputInMibps}.}

\item{ProvisionedThroughputInMibps}{(Optional) The throughput, measured in mebibytes per second (MiBps),
that you want to provision for a file system that you're creating.
Required if \code{ThroughputMode} is set to \code{provisioned}. Valid values are
1-3414 MiBps, with the upper limit depending on Region. To increase this
limit, contact Amazon Web Services Support. For more information, see
\href{https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits}{Amazon EFS quotas that you can increase}
in the \emph{Amazon EFS User Guide}.}
}
\description{
Updates the throughput mode or the amount of provisioned throughput of an existing file system.

See \url{https://www.paws-r-sdk.com/docs/efs_update_file_system/} for full documentation.
}
\keyword{internal}
