% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_ownership_controls}
\alias{s3_put_bucket_ownership_controls}
\title{Creates or modifies OwnershipControls for an Amazon S3 bucket}
\usage{
s3_put_bucket_ownership_controls(
  Bucket,
  ContentMD5 = NULL,
  ExpectedBucketOwner = NULL,
  OwnershipControls
)
}
\arguments{
\item{Bucket}{[required] The name of the Amazon S3 bucket whose \code{OwnershipControls} you want to
set.}

\item{ContentMD5}{The MD5 hash of the \code{OwnershipControls} request body.

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}

\item{OwnershipControls}{[required] The \code{OwnershipControls} (BucketOwnerEnforced, BucketOwnerPreferred, or
ObjectWriter) that you want to apply to this Amazon S3 bucket.}
}
\description{
Creates or modifies \code{OwnershipControls} for an Amazon S3 bucket. To use this operation, you must have the \code{s3:PutBucketOwnershipControls} permission. For more information about Amazon S3 permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide//using-with-s3-actions.html}{Specifying permissions in a policy}.

See \url{https://paws-r.github.io/docs/s3/put_bucket_ownership_controls.html} for full documentation.
}
\keyword{internal}
