% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_head_bucket}
\alias{s3_head_bucket}
\title{This action is useful to determine if a bucket exists and you have
permission to access it}
\usage{
s3_head_bucket(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The bucket name.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When using this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When using this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts bucket ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This action is useful to determine if a bucket exists and you have permission to access it. The action returns a \verb{200 OK} if the bucket exists and you have permission to access it.

See \url{https://paws-r.github.io/docs/s3/head_bucket.html} for full documentation.
}
\keyword{internal}
