% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_get_job_output}
\alias{glacier_get_job_output}
\title{This operation downloads the output of the job you initiated using
InitiateJob}
\usage{
glacier_get_job_output(accountId, vaultName, jobId, range = NULL)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{jobId}{[required] The job ID whose data is downloaded.}

\item{range}{The range of bytes to retrieve from the output. For example, if you want
to download the first 1,048,576 bytes, specify the range as
\code{bytes=0-1048575}. By default, this operation downloads the entire
output.

If the job output is large, then you can use a range to retrieve a
portion of the output. This allows you to download the entire output in
smaller chunks of bytes. For example, suppose you have 1 GB of job
output you want to download and you decide to download 128 MB chunks of
data at a time, which is a total of eight Get Job Output requests. You
use the following process to download the job output:
\enumerate{
\item Download a 128 MB chunk of output by specifying the appropriate byte
range. Verify that all 128 MB of data was received.
\item Along with the data, the response includes a SHA256 tree hash of the
payload. You compute the checksum of the payload on the client and
compare it with the checksum you received in the response to ensure
you received all the expected data.
\item Repeat steps 1 and 2 for all the eight 128 MB chunks of output data,
each time specifying the appropriate byte range.
\item After downloading all the parts of the job output, you have a list
of eight checksum values. Compute the tree hash of these values to
find the checksum of the entire output. Using the
\code{\link[=glacier_describe_job]{describe_job}} API, obtain job information
of the job that provided you the output. The response includes the
checksum of the entire archive stored in Amazon S3 Glacier. You
compare this value with the checksum you computed to ensure you have
downloaded the entire archive content with no errors.
}}
}
\description{
This operation downloads the output of the job you initiated using \code{\link[=glacier_initiate_job]{initiate_job}}. Depending on the job type you specified when you initiated the job, the output will be either the content of an archive or a vault inventory.

See \url{https://paws-r.github.io/docs/glacier/get_job_output.html} for full documentation.
}
\keyword{internal}
