% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_access_points}
\alias{s3control_list_access_points}
\title{Returns a list of the access points currently associated with the
specified bucket}
\usage{
s3control_list_access_points(AccountId, Bucket, NextToken, MaxResults)
}
\arguments{
\item{AccountId}{[required] The AWS account ID for owner of the bucket whose access points you want
to list.}

\item{Bucket}{The name of the bucket whose associated access points you want to list.}

\item{NextToken}{A continuation token. If a previous call to \code{ListAccessPoints} returned
a continuation token in the \code{NextToken} field, then providing that value
here causes Amazon S3 to retrieve the next page of results.}

\item{MaxResults}{The maximum number of access points that you want to include in the
list. If the specified bucket has more than this number of access
points, then the response will include a continuation token in the
\code{NextToken} field that you can use to retrieve the next page of access
points.}
}
\description{
Returns a list of the access points currently associated with the
specified bucket. You can retrieve up to 1000 access points per call. If
the specified bucket has more than 1,000 access points (or the number
specified in \code{maxResults}, whichever is less), the response will include
a continuation token that you can use to list the additional access
points.
}
\section{Request syntax}{
\preformatted{svc$list_access_points(
  AccountId = "string",
  Bucket = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
