% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_shutdown_gateway}
\alias{storagegateway_shutdown_gateway}
\title{Shuts down a gateway}
\usage{
storagegateway_shutdown_gateway(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\value{
A list with the following syntax:\preformatted{list(
  GatewayARN = "string"
)
}
}
\description{
Shuts down a gateway. To specify which gateway to shut down, use the
Amazon Resource Name (ARN) of the gateway in the body of your request.

The operation shuts down the gateway service component running in the
gateway's virtual machine (VM) and not the host VM.

If you want to shut down the VM, it is recommended that you first shut
down the gateway component in the VM to avoid unpredictable conditions.

After the gateway is shutdown, you cannot call any other API except
\code{\link[=storagegateway_start_gateway]{start_gateway}},
\code{\link[=storagegateway_describe_gateway_information]{describe_gateway_information}},
and \code{\link[=storagegateway_list_gateways]{list_gateways}}. For more
information, see \code{\link[=storagegateway_activate_gateway]{activate_gateway}}.
Your applications cannot read from or write to the gateway's storage
volumes, and there are no snapshots taken.

When you make a shutdown request, you will get a \verb{200 OK} success
response immediately. However, it might take some time for the gateway
to shut down. You can call the
\code{\link[=storagegateway_describe_gateway_information]{describe_gateway_information}}
API to check the status. For more information, see
\code{\link[=storagegateway_activate_gateway]{activate_gateway}}.

If do not intend to use the gateway again, you must delete the gateway
(using \code{\link[=storagegateway_delete_gateway]{delete_gateway}}) to no longer
pay software charges associated with the gateway.
}
\section{Request syntax}{
\preformatted{svc$shutdown_gateway(
  GatewayARN = "string"
)
}
}

\examples{
\dontrun{
# This operation shuts down the gateway service component running in the
# storage gateway's virtual machine (VM) and not the VM.
svc$shutdown_gateway(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"
)
}

}
\keyword{internal}
