% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_notification_configuration}
\alias{s3_get_bucket_notification_configuration}
\title{Returns the notification configuration of a bucket}
\usage{
s3_get_bucket_notification_configuration(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the notification configuration.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Returns the notification configuration of a bucket.

If notifications are not enabled on the bucket, the operation returns an
empty \code{NotificationConfiguration} element.

By default, you must be the bucket owner to read the notification
configuration of a bucket. However, the bucket owner can use a bucket
policy to grant permission to other users to read this configuration
with the \code{s3:GetBucketNotification} permission.

For more information about setting and reading the notification
configuration on a bucket, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html}{Setting Up Notification of Bucket Events}.
For more information about bucket policies, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html}{Using Bucket Policies}.

The following operation is related to \code{GetBucketNotification}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html}{PutBucketNotification}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_notification_configuration(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
