% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_update_domain_contact_privacy}
\alias{route53domains_update_domain_contact_privacy}
\title{This operation updates the specified domain contact's privacy setting}
\usage{
route53domains_update_domain_contact_privacy(
  DomainName,
  AdminPrivacy = NULL,
  RegistrantPrivacy = NULL,
  TechPrivacy = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to update the privacy setting for.}

\item{AdminPrivacy}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS ("who is") queries return contact information
either for Amazon Registrar (for .com, .net, and .org domains) or for
our registrar associate, Gandi (for all other TLDs). If you specify
\code{false}, WHOIS queries return the information that you entered for the
admin contact.

You must specify the same privacy setting for the administrative,
registrant, and technical contacts.}

\item{RegistrantPrivacy}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS ("who is") queries return contact information
either for Amazon Registrar (for .com, .net, and .org domains) or for
our registrar associate, Gandi (for all other TLDs). If you specify
\code{false}, WHOIS queries return the information that you entered for the
registrant contact (domain owner).

You must specify the same privacy setting for the administrative,
registrant, and technical contacts.}

\item{TechPrivacy}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS ("who is") queries return contact information
either for Amazon Registrar (for .com, .net, and .org domains) or for
our registrar associate, Gandi (for all other TLDs). If you specify
\code{false}, WHOIS queries return the information that you entered for the
technical contact.

You must specify the same privacy setting for the administrative,
registrant, and technical contacts.}
}
\description{
This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, your contact information is replaced with contact information for the registrar or with the phrase "REDACTED FOR PRIVACY", or "On behalf of \<domain name\> owner."

See \url{https://www.paws-r-sdk.com/docs/route53domains_update_domain_contact_privacy/} for full documentation.
}
\keyword{internal}
