% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_update_domain_contact_privacy}
\alias{route53domains_update_domain_contact_privacy}
\title{This operation updates the specified domain contact's privacy setting}
\usage{
route53domains_update_domain_contact_privacy(DomainName, AdminPrivacy,
  RegistrantPrivacy, TechPrivacy)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to update the privacy setting for.}

\item{AdminPrivacy}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS (\"who is\") queries return contact
information either for Amazon Registrar (for .com, .net, and .org
domains) or for our registrar associate, Gandi (for all other TLDs). If
you specify \code{false}, WHOIS queries return the information that you
entered for the admin contact.}

\item{RegistrantPrivacy}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS (\"who is\") queries return contact
information either for Amazon Registrar (for .com, .net, and .org
domains) or for our registrar associate, Gandi (for all other TLDs). If
you specify \code{false}, WHOIS queries return the information that you
entered for the registrant contact (domain owner).}

\item{TechPrivacy}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS (\"who is\") queries return contact
information either for Amazon Registrar (for .com, .net, and .org
domains) or for our registrar associate, Gandi (for all other TLDs). If
you specify \code{false}, WHOIS queries return the information that you
entered for the technical contact.}
}
\description{
This operation updates the specified domain contact\'s privacy setting.
When privacy protection is enabled, contact information such as email
address is replaced either with contact information for Amazon Registrar
(for .com, .net, and .org domains) or with contact information for our
registrar associate, Gandi.
}
\details{
This operation affects only the contact information for the specified
contact type (registrant, administrator, or tech). If the request
succeeds, Amazon Route 53 returns an operation ID that you can use with
GetOperationDetail to track the progress and completion of the action.
If the request doesn\'t complete successfully, the domain registrant
will be notified by email.
}
\section{Request syntax}{
\preformatted{svc$update_domain_contact_privacy(
  DomainName = "string",
  AdminPrivacy = TRUE|FALSE,
  RegistrantPrivacy = TRUE|FALSE,
  TechPrivacy = TRUE|FALSE
)
}
}

\keyword{internal}
