% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_create_service}
\alias{servicediscovery_create_service}
\title{Creates a service, which defines the configuration for the following
entities:}
\usage{
servicediscovery_create_service(Name, NamespaceId, CreatorRequestId,
  Description, DnsConfig, HealthCheckConfig, HealthCheckCustomConfig,
  Tags)
}
\arguments{
\item{Name}{[required] The name that you want to assign to the service.

If you want AWS Cloud Map to create an \code{SRV} record when you register an
instance, and if you're using a system that requires a specific \code{SRV}
format, such as \href{http://www.haproxy.org/}{HAProxy}, specify the
following for \code{Name}:
\itemize{
\item Start the name with an underscore (_), such as \verb{_exampleservice}
\item End the name with \emph{._protocol}, such as \code{._tcp}
}

When you register an instance, AWS Cloud Map creates an \code{SRV} record and
assigns a name to the record by concatenating the service name and the
namespace name, for example:

\verb{_exampleservice._tcp.example.com}}

\item{NamespaceId}{The ID of the namespace that you want to use to create the service.}

\item{CreatorRequestId}{A unique string that identifies the request and that allows failed
\code{\link[=servicediscovery_create_service]{create_service}} requests to be
retried without the risk of executing the operation twice.
\code{CreatorRequestId} can be any unique string, for example, a date/time
stamp.}

\item{Description}{A description for the service.}

\item{DnsConfig}{A complex type that contains information about the Amazon Route 53
records that you want AWS Cloud Map to create when you register an
instance.}

\item{HealthCheckConfig}{\emph{Public DNS and HTTP namespaces only.} A complex type that contains
settings for an optional Route 53 health check. If you specify settings
for a health check, AWS Cloud Map associates the health check with all
the Route 53 DNS records that you specify in \code{DnsConfig}.

If you specify a health check configuration, you can specify either
\code{HealthCheckCustomConfig} or \code{HealthCheckConfig} but not both.

For information about the charges for health checks, see \href{https://aws.amazon.com/cloud-map/pricing/}{AWS Cloud Map Pricing}.}

\item{HealthCheckCustomConfig}{A complex type that contains information about an optional custom health
check.

If you specify a health check configuration, you can specify either
\code{HealthCheckCustomConfig} or \code{HealthCheckConfig} but not both.

You can't add, update, or delete a \code{HealthCheckCustomConfig}
configuration from an existing service.}

\item{Tags}{The tags to add to the service. Each tag consists of a key and an
optional value, both of which you define. Tag keys can have a maximum
character length of 128 characters, and tag values can have a maximum
length of 256 characters.}
}
\value{
A list with the following syntax:\preformatted{list(
  Service = list(
    Id = "string",
    Arn = "string",
    Name = "string",
    NamespaceId = "string",
    Description = "string",
    InstanceCount = 123,
    DnsConfig = list(
      NamespaceId = "string",
      RoutingPolicy = "MULTIVALUE"|"WEIGHTED",
      DnsRecords = list(
        list(
          Type = "SRV"|"A"|"AAAA"|"CNAME",
          TTL = 123
        )
      )
    ),
    HealthCheckConfig = list(
      Type = "HTTP"|"HTTPS"|"TCP",
      ResourcePath = "string",
      FailureThreshold = 123
    ),
    HealthCheckCustomConfig = list(
      FailureThreshold = 123
    ),
    CreateDate = as.POSIXct(
      "2015-01-01"
    ),
    CreatorRequestId = "string"
  )
)
}
}
\description{
Creates a service, which defines the configuration for the following
entities:
\itemize{
\item For public and private DNS namespaces, one of the following
combinations of DNS records in Amazon Route 53:
\itemize{
\item \code{A}
\item \code{AAAA}
\item \code{A} and \code{AAAA}
\item \code{SRV}
\item \code{CNAME}
}
\item Optionally, a health check
}

After you create the service, you can submit a
\code{\link[=servicediscovery_register_instance]{register_instance}} request, and
AWS Cloud Map uses the values in the configuration to create the
specified entities.

For the current quota on the number of instances that you can register
using the same namespace and using the same service, see \href{https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html}{AWS Cloud Map Limits}
in the \emph{AWS Cloud Map Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_service(
  Name = "string",
  NamespaceId = "string",
  CreatorRequestId = "string",
  Description = "string",
  DnsConfig = list(
    NamespaceId = "string",
    RoutingPolicy = "MULTIVALUE"|"WEIGHTED",
    DnsRecords = list(
      list(
        Type = "SRV"|"A"|"AAAA"|"CNAME",
        TTL = 123
      )
    )
  ),
  HealthCheckConfig = list(
    Type = "HTTP"|"HTTPS"|"TCP",
    ResourcePath = "string",
    FailureThreshold = 123
  ),
  HealthCheckCustomConfig = list(
    FailureThreshold = 123
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Example: Create service
svc$create_service(
  CreatorRequestId = "567c1193-6b00-4308-bd57-ad38a8822d25",
  DnsConfig = list(
    DnsRecords = list(
      list(
        TTL = 60L,
        Type = "A"
      )
    ),
    NamespaceId = "ns-ylexjili4cdxy3xm",
    RoutingPolicy = "MULTIVALUE"
  ),
  Name = "myservice",
  NamespaceId = "ns-ylexjili4cdxy3xm"
)
}

}
\keyword{internal}
