# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudfront_service.R
NULL

#' Creates a cache policy
#'
#' @description
#' Creates a cache policy.
#' 
#' After you create a cache policy, you can attach it to one or more cache
#' behaviors. When it’s attached to a cache behavior, the cache policy
#' determines the following:
#' 
#' -   The values that CloudFront includes in the *cache key*. These values
#'     can include HTTP headers, cookies, and URL query strings. CloudFront
#'     uses the cache key to find an object in its cache that it can return
#'     to the viewer.
#' 
#' -   The default, minimum, and maximum time to live (TTL) values that you
#'     want objects to stay in the CloudFront cache.
#' 
#' The headers, cookies, and query strings that are included in the cache
#' key are automatically included in requests that CloudFront sends to the
#' origin. CloudFront sends a request when it can’t find an object in its
#' cache that matches the request’s cache key. If you want to send values
#' to the origin but *not* include them in the cache key, use
#' `OriginRequestPolicy`.
#' 
#' For more information about cache policies, see [Controlling the cache
#' key](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_cache_policy(CachePolicyConfig)
#'
#' @param CachePolicyConfig &#91;required&#93; A cache policy configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CachePolicy = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CachePolicyConfig = list(
#'       Comment = "string",
#'       Name = "string",
#'       DefaultTTL = 123,
#'       MaxTTL = 123,
#'       MinTTL = 123,
#'       ParametersInCacheKeyAndForwardedToOrigin = list(
#'         EnableAcceptEncodingGzip = TRUE|FALSE,
#'         EnableAcceptEncodingBrotli = TRUE|FALSE,
#'         HeadersConfig = list(
#'           HeaderBehavior = "none"|"whitelist",
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         CookiesConfig = list(
#'           CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'           Cookies = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         QueryStringsConfig = list(
#'           QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'           QueryStrings = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_cache_policy(
#'   CachePolicyConfig = list(
#'     Comment = "string",
#'     Name = "string",
#'     DefaultTTL = 123,
#'     MaxTTL = 123,
#'     MinTTL = 123,
#'     ParametersInCacheKeyAndForwardedToOrigin = list(
#'       EnableAcceptEncodingGzip = TRUE|FALSE,
#'       EnableAcceptEncodingBrotli = TRUE|FALSE,
#'       HeadersConfig = list(
#'         HeaderBehavior = "none"|"whitelist",
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CookiesConfig = list(
#'         CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'         Cookies = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       QueryStringsConfig = list(
#'         QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'         QueryStrings = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_cache_policy
cloudfront_create_cache_policy <- function(CachePolicyConfig) {
  op <- new_operation(
    name = "CreateCachePolicy",
    http_method = "POST",
    http_path = "/2020-05-31/cache-policy",
    paginator = list()
  )
  input <- .cloudfront$create_cache_policy_input(CachePolicyConfig = CachePolicyConfig)
  output <- .cloudfront$create_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_cache_policy <- cloudfront_create_cache_policy

#' Creates a new origin access identity
#'
#' @description
#' Creates a new origin access identity. If you're using Amazon S3 for your
#' origin, you can use an origin access identity to require users to access
#' your content using a CloudFront URL instead of the Amazon S3 URL. For
#' more information about how to use origin access identities, see [Serving
#' Private Content through
#' CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig)
#'
#' @param CloudFrontOriginAccessIdentityConfig &#91;required&#93; The current configuration information for the identity.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CloudFrontOriginAccessIdentity = list(
#'     Id = "string",
#'     S3CanonicalUserId = "string",
#'     CloudFrontOriginAccessIdentityConfig = list(
#'       CallerReference = "string",
#'       Comment = "string"
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig = list(
#'     CallerReference = "string",
#'     Comment = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_cloud_front_origin_access_identity
cloudfront_create_cloud_front_origin_access_identity <- function(CloudFrontOriginAccessIdentityConfig) {
  op <- new_operation(
    name = "CreateCloudFrontOriginAccessIdentity",
    http_method = "POST",
    http_path = "/2020-05-31/origin-access-identity/cloudfront",
    paginator = list()
  )
  input <- .cloudfront$create_cloud_front_origin_access_identity_input(CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig)
  output <- .cloudfront$create_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_cloud_front_origin_access_identity <- cloudfront_create_cloud_front_origin_access_identity

#' Creates a new web distribution
#'
#' @description
#' Creates a new web distribution. You create a CloudFront distribution to
#' tell CloudFront where you want content to be delivered from, and the
#' details about how to track and manage content delivery. Send a `POST`
#' request to the `/CloudFront API version/distribution`/`distribution ID`
#' resource.
#' 
#' When you update a distribution, there are more required fields than when
#' you create a distribution. When you update your distribution by using
#' [`update_distribution`][cloudfront_update_distribution], follow the
#' steps included in the documentation to get the current configuration and
#' then make your updates. This helps to make sure that you include all of
#' the required fields. To view a summary, see [Required Fields for Create
#' Distribution and Update
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_distribution(DistributionConfig)
#'
#' @param DistributionConfig &#91;required&#93; The distribution's configuration information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Distribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InProgressInvalidationBatches = 123,
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     ActiveTrustedKeyGroups = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           KeyGroupId = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DistributionConfig = list(
#'       CallerReference = "string",
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       DefaultRootObject = "string",
#'       Origins = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             DomainName = "string",
#'             OriginPath = "string",
#'             CustomHeaders = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   HeaderName = "string",
#'                   HeaderValue = "string"
#'                 )
#'               )
#'             ),
#'             S3OriginConfig = list(
#'               OriginAccessIdentity = "string"
#'             ),
#'             CustomOriginConfig = list(
#'               HTTPPort = 123,
#'               HTTPSPort = 123,
#'               OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'               OriginSslProtocols = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                 )
#'               ),
#'               OriginReadTimeout = 123,
#'               OriginKeepaliveTimeout = 123
#'             ),
#'             ConnectionAttempts = 123,
#'             ConnectionTimeout = 123,
#'             OriginShield = list(
#'               Enabled = TRUE|FALSE,
#'               OriginShieldRegion = "string"
#'             )
#'           )
#'         )
#'       ),
#'       OriginGroups = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             FailoverCriteria = list(
#'               StatusCodes = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   123
#'                 )
#'               )
#'             ),
#'             Members = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   OriginId = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       DefaultCacheBehavior = list(
#'         TargetOriginId = "string",
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         TrustedKeyGroups = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'         AllowedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           ),
#'           CachedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             )
#'           )
#'         ),
#'         SmoothStreaming = TRUE|FALSE,
#'         Compress = TRUE|FALSE,
#'         LambdaFunctionAssociations = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               LambdaFunctionARN = "string",
#'               EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'               IncludeBody = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         FieldLevelEncryptionId = "string",
#'         RealtimeLogConfigArn = "string",
#'         CachePolicyId = "string",
#'         OriginRequestPolicyId = "string",
#'         ForwardedValues = list(
#'           QueryString = TRUE|FALSE,
#'           Cookies = list(
#'             Forward = "none"|"whitelist"|"all",
#'             WhitelistedNames = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           QueryStringCacheKeys = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MinTTL = 123,
#'         DefaultTTL = 123,
#'         MaxTTL = 123
#'       ),
#'       CacheBehaviors = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PathPattern = "string",
#'             TargetOriginId = "string",
#'             TrustedSigners = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             TrustedKeyGroups = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'             AllowedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               ),
#'               CachedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 )
#'               )
#'             ),
#'             SmoothStreaming = TRUE|FALSE,
#'             Compress = TRUE|FALSE,
#'             LambdaFunctionAssociations = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   LambdaFunctionARN = "string",
#'                   EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                   IncludeBody = TRUE|FALSE
#'                 )
#'               )
#'             ),
#'             FieldLevelEncryptionId = "string",
#'             RealtimeLogConfigArn = "string",
#'             CachePolicyId = "string",
#'             OriginRequestPolicyId = "string",
#'             ForwardedValues = list(
#'               QueryString = TRUE|FALSE,
#'               Cookies = list(
#'                 Forward = "none"|"whitelist"|"all",
#'                 WhitelistedNames = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               QueryStringCacheKeys = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             MinTTL = 123,
#'             DefaultTTL = 123,
#'             MaxTTL = 123
#'           )
#'         )
#'       ),
#'       CustomErrorResponses = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             ErrorCode = 123,
#'             ResponsePagePath = "string",
#'             ResponseCode = "string",
#'             ErrorCachingMinTTL = 123
#'           )
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         IncludeCookies = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE,
#'       ViewerCertificate = list(
#'         CloudFrontDefaultCertificate = TRUE|FALSE,
#'         IAMCertificateId = "string",
#'         ACMCertificateArn = "string",
#'         SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'         MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'         Certificate = "string",
#'         CertificateSource = "cloudfront"|"iam"|"acm"
#'       ),
#'       Restrictions = list(
#'         GeoRestriction = list(
#'           RestrictionType = "blacklist"|"whitelist"|"none",
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       WebACLId = "string",
#'       HttpVersion = "http1.1"|"http2",
#'       IsIPV6Enabled = TRUE|FALSE
#'     ),
#'     AliasICPRecordals = list(
#'       list(
#'         CNAME = "string",
#'         ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'       )
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_distribution(
#'   DistributionConfig = list(
#'     CallerReference = "string",
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     DefaultRootObject = "string",
#'     Origins = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           DomainName = "string",
#'           OriginPath = "string",
#'           CustomHeaders = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 HeaderName = "string",
#'                 HeaderValue = "string"
#'               )
#'             )
#'           ),
#'           S3OriginConfig = list(
#'             OriginAccessIdentity = "string"
#'           ),
#'           CustomOriginConfig = list(
#'             HTTPPort = 123,
#'             HTTPSPort = 123,
#'             OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'             OriginSslProtocols = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'               )
#'             ),
#'             OriginReadTimeout = 123,
#'             OriginKeepaliveTimeout = 123
#'           ),
#'           ConnectionAttempts = 123,
#'           ConnectionTimeout = 123,
#'           OriginShield = list(
#'             Enabled = TRUE|FALSE,
#'             OriginShieldRegion = "string"
#'           )
#'         )
#'       )
#'     ),
#'     OriginGroups = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           FailoverCriteria = list(
#'             StatusCodes = list(
#'               Quantity = 123,
#'               Items = list(
#'                 123
#'               )
#'             )
#'           ),
#'           Members = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 OriginId = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DefaultCacheBehavior = list(
#'       TargetOriginId = "string",
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       TrustedKeyGroups = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'       AllowedMethods = list(
#'         Quantity = 123,
#'         Items = list(
#'           "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'         ),
#'         CachedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           )
#'         )
#'       ),
#'       SmoothStreaming = TRUE|FALSE,
#'       Compress = TRUE|FALSE,
#'       LambdaFunctionAssociations = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             LambdaFunctionARN = "string",
#'             EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'             IncludeBody = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       FieldLevelEncryptionId = "string",
#'       RealtimeLogConfigArn = "string",
#'       CachePolicyId = "string",
#'       OriginRequestPolicyId = "string",
#'       ForwardedValues = list(
#'         QueryString = TRUE|FALSE,
#'         Cookies = list(
#'           Forward = "none"|"whitelist"|"all",
#'           WhitelistedNames = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         QueryStringCacheKeys = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       MinTTL = 123,
#'       DefaultTTL = 123,
#'       MaxTTL = 123
#'     ),
#'     CacheBehaviors = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PathPattern = "string",
#'           TargetOriginId = "string",
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           TrustedKeyGroups = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string",
#'           RealtimeLogConfigArn = "string",
#'           CachePolicyId = "string",
#'           OriginRequestPolicyId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           MinTTL = 123,
#'           DefaultTTL = 123,
#'           MaxTTL = 123
#'         )
#'       )
#'     ),
#'     CustomErrorResponses = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           ErrorCode = 123,
#'           ResponsePagePath = "string",
#'           ResponseCode = "string",
#'           ErrorCachingMinTTL = 123
#'         )
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       IncludeCookies = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE,
#'     ViewerCertificate = list(
#'       CloudFrontDefaultCertificate = TRUE|FALSE,
#'       IAMCertificateId = "string",
#'       ACMCertificateArn = "string",
#'       SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'       MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'       Certificate = "string",
#'       CertificateSource = "cloudfront"|"iam"|"acm"
#'     ),
#'     Restrictions = list(
#'       GeoRestriction = list(
#'         RestrictionType = "blacklist"|"whitelist"|"none",
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     WebACLId = "string",
#'     HttpVersion = "http1.1"|"http2",
#'     IsIPV6Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_distribution
cloudfront_create_distribution <- function(DistributionConfig) {
  op <- new_operation(
    name = "CreateDistribution",
    http_method = "POST",
    http_path = "/2020-05-31/distribution",
    paginator = list()
  )
  input <- .cloudfront$create_distribution_input(DistributionConfig = DistributionConfig)
  output <- .cloudfront$create_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_distribution <- cloudfront_create_distribution

#' Create a new distribution with tags
#'
#' @description
#' Create a new distribution with tags.
#'
#' @usage
#' cloudfront_create_distribution_with_tags(DistributionConfigWithTags)
#'
#' @param DistributionConfigWithTags &#91;required&#93; The distribution's configuration information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Distribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InProgressInvalidationBatches = 123,
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     ActiveTrustedKeyGroups = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           KeyGroupId = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DistributionConfig = list(
#'       CallerReference = "string",
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       DefaultRootObject = "string",
#'       Origins = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             DomainName = "string",
#'             OriginPath = "string",
#'             CustomHeaders = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   HeaderName = "string",
#'                   HeaderValue = "string"
#'                 )
#'               )
#'             ),
#'             S3OriginConfig = list(
#'               OriginAccessIdentity = "string"
#'             ),
#'             CustomOriginConfig = list(
#'               HTTPPort = 123,
#'               HTTPSPort = 123,
#'               OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'               OriginSslProtocols = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                 )
#'               ),
#'               OriginReadTimeout = 123,
#'               OriginKeepaliveTimeout = 123
#'             ),
#'             ConnectionAttempts = 123,
#'             ConnectionTimeout = 123,
#'             OriginShield = list(
#'               Enabled = TRUE|FALSE,
#'               OriginShieldRegion = "string"
#'             )
#'           )
#'         )
#'       ),
#'       OriginGroups = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             FailoverCriteria = list(
#'               StatusCodes = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   123
#'                 )
#'               )
#'             ),
#'             Members = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   OriginId = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       DefaultCacheBehavior = list(
#'         TargetOriginId = "string",
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         TrustedKeyGroups = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'         AllowedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           ),
#'           CachedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             )
#'           )
#'         ),
#'         SmoothStreaming = TRUE|FALSE,
#'         Compress = TRUE|FALSE,
#'         LambdaFunctionAssociations = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               LambdaFunctionARN = "string",
#'               EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'               IncludeBody = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         FieldLevelEncryptionId = "string",
#'         RealtimeLogConfigArn = "string",
#'         CachePolicyId = "string",
#'         OriginRequestPolicyId = "string",
#'         ForwardedValues = list(
#'           QueryString = TRUE|FALSE,
#'           Cookies = list(
#'             Forward = "none"|"whitelist"|"all",
#'             WhitelistedNames = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           QueryStringCacheKeys = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MinTTL = 123,
#'         DefaultTTL = 123,
#'         MaxTTL = 123
#'       ),
#'       CacheBehaviors = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PathPattern = "string",
#'             TargetOriginId = "string",
#'             TrustedSigners = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             TrustedKeyGroups = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'             AllowedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               ),
#'               CachedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 )
#'               )
#'             ),
#'             SmoothStreaming = TRUE|FALSE,
#'             Compress = TRUE|FALSE,
#'             LambdaFunctionAssociations = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   LambdaFunctionARN = "string",
#'                   EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                   IncludeBody = TRUE|FALSE
#'                 )
#'               )
#'             ),
#'             FieldLevelEncryptionId = "string",
#'             RealtimeLogConfigArn = "string",
#'             CachePolicyId = "string",
#'             OriginRequestPolicyId = "string",
#'             ForwardedValues = list(
#'               QueryString = TRUE|FALSE,
#'               Cookies = list(
#'                 Forward = "none"|"whitelist"|"all",
#'                 WhitelistedNames = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               QueryStringCacheKeys = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             MinTTL = 123,
#'             DefaultTTL = 123,
#'             MaxTTL = 123
#'           )
#'         )
#'       ),
#'       CustomErrorResponses = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             ErrorCode = 123,
#'             ResponsePagePath = "string",
#'             ResponseCode = "string",
#'             ErrorCachingMinTTL = 123
#'           )
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         IncludeCookies = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE,
#'       ViewerCertificate = list(
#'         CloudFrontDefaultCertificate = TRUE|FALSE,
#'         IAMCertificateId = "string",
#'         ACMCertificateArn = "string",
#'         SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'         MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'         Certificate = "string",
#'         CertificateSource = "cloudfront"|"iam"|"acm"
#'       ),
#'       Restrictions = list(
#'         GeoRestriction = list(
#'           RestrictionType = "blacklist"|"whitelist"|"none",
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       WebACLId = "string",
#'       HttpVersion = "http1.1"|"http2",
#'       IsIPV6Enabled = TRUE|FALSE
#'     ),
#'     AliasICPRecordals = list(
#'       list(
#'         CNAME = "string",
#'         ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'       )
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_distribution_with_tags(
#'   DistributionConfigWithTags = list(
#'     DistributionConfig = list(
#'       CallerReference = "string",
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       DefaultRootObject = "string",
#'       Origins = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             DomainName = "string",
#'             OriginPath = "string",
#'             CustomHeaders = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   HeaderName = "string",
#'                   HeaderValue = "string"
#'                 )
#'               )
#'             ),
#'             S3OriginConfig = list(
#'               OriginAccessIdentity = "string"
#'             ),
#'             CustomOriginConfig = list(
#'               HTTPPort = 123,
#'               HTTPSPort = 123,
#'               OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'               OriginSslProtocols = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                 )
#'               ),
#'               OriginReadTimeout = 123,
#'               OriginKeepaliveTimeout = 123
#'             ),
#'             ConnectionAttempts = 123,
#'             ConnectionTimeout = 123,
#'             OriginShield = list(
#'               Enabled = TRUE|FALSE,
#'               OriginShieldRegion = "string"
#'             )
#'           )
#'         )
#'       ),
#'       OriginGroups = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             FailoverCriteria = list(
#'               StatusCodes = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   123
#'                 )
#'               )
#'             ),
#'             Members = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   OriginId = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       DefaultCacheBehavior = list(
#'         TargetOriginId = "string",
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         TrustedKeyGroups = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'         AllowedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           ),
#'           CachedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             )
#'           )
#'         ),
#'         SmoothStreaming = TRUE|FALSE,
#'         Compress = TRUE|FALSE,
#'         LambdaFunctionAssociations = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               LambdaFunctionARN = "string",
#'               EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'               IncludeBody = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         FieldLevelEncryptionId = "string",
#'         RealtimeLogConfigArn = "string",
#'         CachePolicyId = "string",
#'         OriginRequestPolicyId = "string",
#'         ForwardedValues = list(
#'           QueryString = TRUE|FALSE,
#'           Cookies = list(
#'             Forward = "none"|"whitelist"|"all",
#'             WhitelistedNames = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           QueryStringCacheKeys = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MinTTL = 123,
#'         DefaultTTL = 123,
#'         MaxTTL = 123
#'       ),
#'       CacheBehaviors = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PathPattern = "string",
#'             TargetOriginId = "string",
#'             TrustedSigners = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             TrustedKeyGroups = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'             AllowedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               ),
#'               CachedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 )
#'               )
#'             ),
#'             SmoothStreaming = TRUE|FALSE,
#'             Compress = TRUE|FALSE,
#'             LambdaFunctionAssociations = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   LambdaFunctionARN = "string",
#'                   EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                   IncludeBody = TRUE|FALSE
#'                 )
#'               )
#'             ),
#'             FieldLevelEncryptionId = "string",
#'             RealtimeLogConfigArn = "string",
#'             CachePolicyId = "string",
#'             OriginRequestPolicyId = "string",
#'             ForwardedValues = list(
#'               QueryString = TRUE|FALSE,
#'               Cookies = list(
#'                 Forward = "none"|"whitelist"|"all",
#'                 WhitelistedNames = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               QueryStringCacheKeys = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             MinTTL = 123,
#'             DefaultTTL = 123,
#'             MaxTTL = 123
#'           )
#'         )
#'       ),
#'       CustomErrorResponses = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             ErrorCode = 123,
#'             ResponsePagePath = "string",
#'             ResponseCode = "string",
#'             ErrorCachingMinTTL = 123
#'           )
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         IncludeCookies = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE,
#'       ViewerCertificate = list(
#'         CloudFrontDefaultCertificate = TRUE|FALSE,
#'         IAMCertificateId = "string",
#'         ACMCertificateArn = "string",
#'         SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'         MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'         Certificate = "string",
#'         CertificateSource = "cloudfront"|"iam"|"acm"
#'       ),
#'       Restrictions = list(
#'         GeoRestriction = list(
#'           RestrictionType = "blacklist"|"whitelist"|"none",
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       WebACLId = "string",
#'       HttpVersion = "http1.1"|"http2",
#'       IsIPV6Enabled = TRUE|FALSE
#'     ),
#'     Tags = list(
#'       Items = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_distribution_with_tags
cloudfront_create_distribution_with_tags <- function(DistributionConfigWithTags) {
  op <- new_operation(
    name = "CreateDistributionWithTags",
    http_method = "POST",
    http_path = "/2020-05-31/distribution?WithTags",
    paginator = list()
  )
  input <- .cloudfront$create_distribution_with_tags_input(DistributionConfigWithTags = DistributionConfigWithTags)
  output <- .cloudfront$create_distribution_with_tags_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_distribution_with_tags <- cloudfront_create_distribution_with_tags

#' Create a new field-level encryption configuration
#'
#' @description
#' Create a new field-level encryption configuration.
#'
#' @usage
#' cloudfront_create_field_level_encryption_config(
#'   FieldLevelEncryptionConfig)
#'
#' @param FieldLevelEncryptionConfig &#91;required&#93; The request to create a new field-level encryption configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryption = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FieldLevelEncryptionConfig = list(
#'       CallerReference = "string",
#'       Comment = "string",
#'       QueryArgProfileConfig = list(
#'         ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'         QueryArgProfiles = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               QueryArg = "string",
#'               ProfileId = "string"
#'             )
#'           )
#'         )
#'       ),
#'       ContentTypeProfileConfig = list(
#'         ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'         ContentTypeProfiles = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Format = "URLEncoded",
#'               ProfileId = "string",
#'               ContentType = "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_field_level_encryption_config(
#'   FieldLevelEncryptionConfig = list(
#'     CallerReference = "string",
#'     Comment = "string",
#'     QueryArgProfileConfig = list(
#'       ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'       QueryArgProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             QueryArg = "string",
#'             ProfileId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ContentTypeProfileConfig = list(
#'       ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'       ContentTypeProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Format = "URLEncoded",
#'             ProfileId = "string",
#'             ContentType = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_field_level_encryption_config
cloudfront_create_field_level_encryption_config <- function(FieldLevelEncryptionConfig) {
  op <- new_operation(
    name = "CreateFieldLevelEncryptionConfig",
    http_method = "POST",
    http_path = "/2020-05-31/field-level-encryption",
    paginator = list()
  )
  input <- .cloudfront$create_field_level_encryption_config_input(FieldLevelEncryptionConfig = FieldLevelEncryptionConfig)
  output <- .cloudfront$create_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_field_level_encryption_config <- cloudfront_create_field_level_encryption_config

#' Create a field-level encryption profile
#'
#' @description
#' Create a field-level encryption profile.
#'
#' @usage
#' cloudfront_create_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig)
#'
#' @param FieldLevelEncryptionProfileConfig &#91;required&#93; The request to create a field-level encryption profile.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionProfile = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FieldLevelEncryptionProfileConfig = list(
#'       Name = "string",
#'       CallerReference = "string",
#'       Comment = "string",
#'       EncryptionEntities = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PublicKeyId = "string",
#'             ProviderId = "string",
#'             FieldPatterns = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig = list(
#'     Name = "string",
#'     CallerReference = "string",
#'     Comment = "string",
#'     EncryptionEntities = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PublicKeyId = "string",
#'           ProviderId = "string",
#'           FieldPatterns = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_field_level_encryption_profile
cloudfront_create_field_level_encryption_profile <- function(FieldLevelEncryptionProfileConfig) {
  op <- new_operation(
    name = "CreateFieldLevelEncryptionProfile",
    http_method = "POST",
    http_path = "/2020-05-31/field-level-encryption-profile",
    paginator = list()
  )
  input <- .cloudfront$create_field_level_encryption_profile_input(FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig)
  output <- .cloudfront$create_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_field_level_encryption_profile <- cloudfront_create_field_level_encryption_profile

#' Create a new invalidation
#'
#' @description
#' Create a new invalidation.
#'
#' @usage
#' cloudfront_create_invalidation(DistributionId, InvalidationBatch)
#'
#' @param DistributionId &#91;required&#93; The distribution's id.
#' @param InvalidationBatch &#91;required&#93; The batch information for the invalidation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Location = "string",
#'   Invalidation = list(
#'     Id = "string",
#'     Status = "string",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InvalidationBatch = list(
#'       Paths = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       CallerReference = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_invalidation(
#'   DistributionId = "string",
#'   InvalidationBatch = list(
#'     Paths = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     CallerReference = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_invalidation
cloudfront_create_invalidation <- function(DistributionId, InvalidationBatch) {
  op <- new_operation(
    name = "CreateInvalidation",
    http_method = "POST",
    http_path = "/2020-05-31/distribution/{DistributionId}/invalidation",
    paginator = list()
  )
  input <- .cloudfront$create_invalidation_input(DistributionId = DistributionId, InvalidationBatch = InvalidationBatch)
  output <- .cloudfront$create_invalidation_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_invalidation <- cloudfront_create_invalidation

#' Creates a key group that you can use with CloudFront signed URLs and
#' signed cookies
#'
#' @description
#' Creates a key group that you can use with [CloudFront signed URLs and
#' signed
#' cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
#' 
#' To create a key group, you must specify at least one public key for the
#' key group. After you create a key group, you can reference it from one
#' or more cache behaviors. When you reference a key group in a cache
#' behavior, CloudFront requires signed URLs or signed cookies for all
#' requests that match the cache behavior. The URLs or cookies must be
#' signed with a private key whose corresponding public key is in the key
#' group. The signed URL or cookie contains information about which public
#' key CloudFront should use to verify the signature. For more information,
#' see [Serving private
#' content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_key_group(KeyGroupConfig)
#'
#' @param KeyGroupConfig &#91;required&#93; A key group configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyGroup = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     KeyGroupConfig = list(
#'       Name = "string",
#'       Items = list(
#'         "string"
#'       ),
#'       Comment = "string"
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_key_group(
#'   KeyGroupConfig = list(
#'     Name = "string",
#'     Items = list(
#'       "string"
#'     ),
#'     Comment = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_key_group
cloudfront_create_key_group <- function(KeyGroupConfig) {
  op <- new_operation(
    name = "CreateKeyGroup",
    http_method = "POST",
    http_path = "/2020-05-31/key-group",
    paginator = list()
  )
  input <- .cloudfront$create_key_group_input(KeyGroupConfig = KeyGroupConfig)
  output <- .cloudfront$create_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_key_group <- cloudfront_create_key_group

#' Enables additional CloudWatch metrics for the specified CloudFront
#' distribution
#'
#' @description
#' Enables additional CloudWatch metrics for the specified CloudFront
#' distribution. The additional metrics incur an additional cost.
#' 
#' For more information, see [Viewing additional CloudFront distribution
#' metrics](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_monitoring_subscription(DistributionId,
#'   MonitoringSubscription)
#'
#' @param DistributionId &#91;required&#93; The ID of the distribution that you are enabling metrics for.
#' @param MonitoringSubscription &#91;required&#93; A monitoring subscription. This structure contains information about
#' whether additional CloudWatch metrics are enabled for a given CloudFront
#' distribution.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MonitoringSubscription = list(
#'     RealtimeMetricsSubscriptionConfig = list(
#'       RealtimeMetricsSubscriptionStatus = "Enabled"|"Disabled"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_monitoring_subscription(
#'   DistributionId = "string",
#'   MonitoringSubscription = list(
#'     RealtimeMetricsSubscriptionConfig = list(
#'       RealtimeMetricsSubscriptionStatus = "Enabled"|"Disabled"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_monitoring_subscription
cloudfront_create_monitoring_subscription <- function(DistributionId, MonitoringSubscription) {
  op <- new_operation(
    name = "CreateMonitoringSubscription",
    http_method = "POST",
    http_path = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
    paginator = list()
  )
  input <- .cloudfront$create_monitoring_subscription_input(DistributionId = DistributionId, MonitoringSubscription = MonitoringSubscription)
  output <- .cloudfront$create_monitoring_subscription_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_monitoring_subscription <- cloudfront_create_monitoring_subscription

#' Creates an origin request policy
#'
#' @description
#' Creates an origin request policy.
#' 
#' After you create an origin request policy, you can attach it to one or
#' more cache behaviors. When it’s attached to a cache behavior, the origin
#' request policy determines the values that CloudFront includes in
#' requests that it sends to the origin. Each request that CloudFront sends
#' to the origin includes the following:
#' 
#' -   The request body and the URL path (without the domain name) from the
#'     viewer request.
#' 
#' -   The headers that CloudFront automatically includes in every origin
#'     request, including `Host`, `User-Agent`, and `X-Amz-Cf-Id`.
#' 
#' -   All HTTP headers, cookies, and URL query strings that are specified
#'     in the cache policy or the origin request policy. These can include
#'     items from the viewer request and, in the case of headers,
#'     additional ones that are added by CloudFront.
#' 
#' CloudFront sends a request when it can’t find a valid object in its
#' cache that matches the request. If you want to send values to the origin
#' and also include them in the cache key, use `CachePolicy`.
#' 
#' For more information about origin request policies, see [Controlling
#' origin
#' requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_origin_request_policy(OriginRequestPolicyConfig)
#'
#' @param OriginRequestPolicyConfig &#91;required&#93; An origin request policy configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OriginRequestPolicy = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     OriginRequestPolicyConfig = list(
#'       Comment = "string",
#'       Name = "string",
#'       HeadersConfig = list(
#'         HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CookiesConfig = list(
#'         CookieBehavior = "none"|"whitelist"|"all",
#'         Cookies = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       QueryStringsConfig = list(
#'         QueryStringBehavior = "none"|"whitelist"|"all",
#'         QueryStrings = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_origin_request_policy(
#'   OriginRequestPolicyConfig = list(
#'     Comment = "string",
#'     Name = "string",
#'     HeadersConfig = list(
#'       HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'       Headers = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     CookiesConfig = list(
#'       CookieBehavior = "none"|"whitelist"|"all",
#'       Cookies = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     QueryStringsConfig = list(
#'       QueryStringBehavior = "none"|"whitelist"|"all",
#'       QueryStrings = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_origin_request_policy
cloudfront_create_origin_request_policy <- function(OriginRequestPolicyConfig) {
  op <- new_operation(
    name = "CreateOriginRequestPolicy",
    http_method = "POST",
    http_path = "/2020-05-31/origin-request-policy",
    paginator = list()
  )
  input <- .cloudfront$create_origin_request_policy_input(OriginRequestPolicyConfig = OriginRequestPolicyConfig)
  output <- .cloudfront$create_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_origin_request_policy <- cloudfront_create_origin_request_policy

#' Uploads a public key to CloudFront that you can use with signed URLs and
#' signed cookies, or with field-level encryption
#'
#' @description
#' Uploads a public key to CloudFront that you can use with [signed URLs
#' and signed
#' cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
#' or with [field-level
#' encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
#'
#' @usage
#' cloudfront_create_public_key(PublicKeyConfig)
#'
#' @param PublicKeyConfig &#91;required&#93; A CloudFront public key configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKey = list(
#'     Id = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PublicKeyConfig = list(
#'       CallerReference = "string",
#'       Name = "string",
#'       EncodedKey = "string",
#'       Comment = "string"
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_public_key(
#'   PublicKeyConfig = list(
#'     CallerReference = "string",
#'     Name = "string",
#'     EncodedKey = "string",
#'     Comment = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_public_key
cloudfront_create_public_key <- function(PublicKeyConfig) {
  op <- new_operation(
    name = "CreatePublicKey",
    http_method = "POST",
    http_path = "/2020-05-31/public-key",
    paginator = list()
  )
  input <- .cloudfront$create_public_key_input(PublicKeyConfig = PublicKeyConfig)
  output <- .cloudfront$create_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_public_key <- cloudfront_create_public_key

#' Creates a real-time log configuration
#'
#' @description
#' Creates a real-time log configuration.
#' 
#' After you create a real-time log configuration, you can attach it to one
#' or more cache behaviors to send real-time log data to the specified
#' Amazon Kinesis data stream.
#' 
#' For more information about real-time log configurations, see [Real-time
#' logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_realtime_log_config(EndPoints, Fields, Name,
#'   SamplingRate)
#'
#' @param EndPoints &#91;required&#93; Contains information about the Amazon Kinesis data stream where you are
#' sending real-time log data.
#' @param Fields &#91;required&#93; A list of fields to include in each real-time log record.
#' 
#' For more information about fields, see [Real-time log configuration
#' fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
#' in the *Amazon CloudFront Developer Guide*.
#' @param Name &#91;required&#93; A unique name to identify this real-time log configuration.
#' @param SamplingRate &#91;required&#93; The sampling rate for this real-time log configuration. The sampling
#' rate determines the percentage of viewer requests that are represented
#' in the real-time log data. You must provide an integer between 1 and
#' 100, inclusive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RealtimeLogConfig = list(
#'     ARN = "string",
#'     Name = "string",
#'     SamplingRate = 123,
#'     EndPoints = list(
#'       list(
#'         StreamType = "string",
#'         KinesisStreamConfig = list(
#'           RoleARN = "string",
#'           StreamARN = "string"
#'         )
#'       )
#'     ),
#'     Fields = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_realtime_log_config(
#'   EndPoints = list(
#'     list(
#'       StreamType = "string",
#'       KinesisStreamConfig = list(
#'         RoleARN = "string",
#'         StreamARN = "string"
#'       )
#'     )
#'   ),
#'   Fields = list(
#'     "string"
#'   ),
#'   Name = "string",
#'   SamplingRate = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_realtime_log_config
cloudfront_create_realtime_log_config <- function(EndPoints, Fields, Name, SamplingRate) {
  op <- new_operation(
    name = "CreateRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/realtime-log-config",
    paginator = list()
  )
  input <- .cloudfront$create_realtime_log_config_input(EndPoints = EndPoints, Fields = Fields, Name = Name, SamplingRate = SamplingRate)
  output <- .cloudfront$create_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_realtime_log_config <- cloudfront_create_realtime_log_config

#' This API is deprecated
#'
#' @description
#' This API is deprecated. Amazon CloudFront is deprecating real-time
#' messaging protocol (RTMP) distributions on December 31, 2020. For more
#' information, [read the
#' announcement](https://forums.aws.amazon.com/ann.jspa?annID=7356) on the
#' Amazon CloudFront discussion forum.
#'
#' @usage
#' cloudfront_create_streaming_distribution(StreamingDistributionConfig)
#'
#' @param StreamingDistributionConfig &#91;required&#93; The streaming distribution's configuration information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingDistribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     StreamingDistributionConfig = list(
#'       CallerReference = "string",
#'       S3Origin = list(
#'         DomainName = "string",
#'         OriginAccessIdentity = "string"
#'       ),
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_streaming_distribution(
#'   StreamingDistributionConfig = list(
#'     CallerReference = "string",
#'     S3Origin = list(
#'       DomainName = "string",
#'       OriginAccessIdentity = "string"
#'     ),
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     TrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_streaming_distribution
cloudfront_create_streaming_distribution <- function(StreamingDistributionConfig) {
  op <- new_operation(
    name = "CreateStreamingDistribution",
    http_method = "POST",
    http_path = "/2020-05-31/streaming-distribution",
    paginator = list()
  )
  input <- .cloudfront$create_streaming_distribution_input(StreamingDistributionConfig = StreamingDistributionConfig)
  output <- .cloudfront$create_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_streaming_distribution <- cloudfront_create_streaming_distribution

#' This API is deprecated
#'
#' @description
#' This API is deprecated. Amazon CloudFront is deprecating real-time
#' messaging protocol (RTMP) distributions on December 31, 2020. For more
#' information, [read the
#' announcement](https://forums.aws.amazon.com/ann.jspa?annID=7356) on the
#' Amazon CloudFront discussion forum.
#'
#' @usage
#' cloudfront_create_streaming_distribution_with_tags(
#'   StreamingDistributionConfigWithTags)
#'
#' @param StreamingDistributionConfigWithTags &#91;required&#93; The streaming distribution's configuration information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingDistribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     StreamingDistributionConfig = list(
#'       CallerReference = "string",
#'       S3Origin = list(
#'         DomainName = "string",
#'         OriginAccessIdentity = "string"
#'       ),
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   Location = "string",
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_streaming_distribution_with_tags(
#'   StreamingDistributionConfigWithTags = list(
#'     StreamingDistributionConfig = list(
#'       CallerReference = "string",
#'       S3Origin = list(
#'         DomainName = "string",
#'         OriginAccessIdentity = "string"
#'       ),
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE
#'     ),
#'     Tags = list(
#'       Items = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_streaming_distribution_with_tags
cloudfront_create_streaming_distribution_with_tags <- function(StreamingDistributionConfigWithTags) {
  op <- new_operation(
    name = "CreateStreamingDistributionWithTags",
    http_method = "POST",
    http_path = "/2020-05-31/streaming-distribution?WithTags",
    paginator = list()
  )
  input <- .cloudfront$create_streaming_distribution_with_tags_input(StreamingDistributionConfigWithTags = StreamingDistributionConfigWithTags)
  output <- .cloudfront$create_streaming_distribution_with_tags_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_streaming_distribution_with_tags <- cloudfront_create_streaming_distribution_with_tags

#' Deletes a cache policy
#'
#' @description
#' Deletes a cache policy.
#' 
#' You cannot delete a cache policy if it’s attached to a cache behavior.
#' First update your distributions to remove the cache policy from all
#' cache behaviors, then delete the cache policy.
#' 
#' To delete a cache policy, you must provide the policy’s identifier and
#' version. To get these values, you can use
#' [`list_cache_policies`][cloudfront_list_cache_policies] or
#' [`get_cache_policy`][cloudfront_get_cache_policy].
#'
#' @usage
#' cloudfront_delete_cache_policy(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The unique identifier for the cache policy that you are deleting. To get
#' the identifier, you can use
#' [`list_cache_policies`][cloudfront_list_cache_policies].
#' @param IfMatch The version of the cache policy that you are deleting. The version is
#' the cache policy’s `ETag` value, which you can get using
#' [`list_cache_policies`][cloudfront_list_cache_policies],
#' [`get_cache_policy`][cloudfront_get_cache_policy], or
#' [`get_cache_policy_config`][cloudfront_get_cache_policy_config].
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cache_policy(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_cache_policy
cloudfront_delete_cache_policy <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteCachePolicy",
    http_method = "DELETE",
    http_path = "/2020-05-31/cache-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_cache_policy_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_cache_policy <- cloudfront_delete_cache_policy

#' Delete an origin access identity
#'
#' @description
#' Delete an origin access identity.
#'
#' @usage
#' cloudfront_delete_cloud_front_origin_access_identity(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The origin access identity's ID.
#' @param IfMatch The value of the `ETag` header you received from a previous `GET` or
#' `PUT` request. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cloud_front_origin_access_identity(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_cloud_front_origin_access_identity
cloudfront_delete_cloud_front_origin_access_identity <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteCloudFrontOriginAccessIdentity",
    http_method = "DELETE",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_cloud_front_origin_access_identity_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_cloud_front_origin_access_identity <- cloudfront_delete_cloud_front_origin_access_identity

#' Delete a distribution
#'
#' @description
#' Delete a distribution.
#'
#' @usage
#' cloudfront_delete_distribution(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The distribution ID.
#' @param IfMatch The value of the `ETag` header that you received when you disabled the
#' distribution. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_distribution(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_distribution
cloudfront_delete_distribution <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteDistribution",
    http_method = "DELETE",
    http_path = "/2020-05-31/distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_distribution_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_distribution <- cloudfront_delete_distribution

#' Remove a field-level encryption configuration
#'
#' @description
#' Remove a field-level encryption configuration.
#'
#' @usage
#' cloudfront_delete_field_level_encryption_config(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The ID of the configuration you want to delete from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' configuration identity to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_field_level_encryption_config(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_field_level_encryption_config
cloudfront_delete_field_level_encryption_config <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteFieldLevelEncryptionConfig",
    http_method = "DELETE",
    http_path = "/2020-05-31/field-level-encryption/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_field_level_encryption_config_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_field_level_encryption_config <- cloudfront_delete_field_level_encryption_config

#' Remove a field-level encryption profile
#'
#' @description
#' Remove a field-level encryption profile.
#'
#' @usage
#' cloudfront_delete_field_level_encryption_profile(Id, IfMatch)
#'
#' @param Id &#91;required&#93; Request the ID of the profile you want to delete from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' profile to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_field_level_encryption_profile(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_field_level_encryption_profile
cloudfront_delete_field_level_encryption_profile <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteFieldLevelEncryptionProfile",
    http_method = "DELETE",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_field_level_encryption_profile_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_field_level_encryption_profile <- cloudfront_delete_field_level_encryption_profile

#' Deletes a key group
#'
#' @description
#' Deletes a key group.
#' 
#' You cannot delete a key group that is referenced in a cache behavior.
#' First update your distributions to remove the key group from all cache
#' behaviors, then delete the key group.
#' 
#' To delete a key group, you must provide the key group’s identifier and
#' version. To get these values, use
#' [`list_key_groups`][cloudfront_list_key_groups] followed by
#' [`get_key_group`][cloudfront_get_key_group] or
#' [`get_key_group_config`][cloudfront_get_key_group_config].
#'
#' @usage
#' cloudfront_delete_key_group(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The identifier of the key group that you are deleting. To get the
#' identifier, use [`list_key_groups`][cloudfront_list_key_groups].
#' @param IfMatch The version of the key group that you are deleting. The version is the
#' key group’s `ETag` value. To get the `ETag`, use
#' [`get_key_group`][cloudfront_get_key_group] or
#' [`get_key_group_config`][cloudfront_get_key_group_config].
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_key_group(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_key_group
cloudfront_delete_key_group <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteKeyGroup",
    http_method = "DELETE",
    http_path = "/2020-05-31/key-group/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_key_group_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_key_group <- cloudfront_delete_key_group

#' Disables additional CloudWatch metrics for the specified CloudFront
#' distribution
#'
#' @description
#' Disables additional CloudWatch metrics for the specified CloudFront
#' distribution.
#'
#' @usage
#' cloudfront_delete_monitoring_subscription(DistributionId)
#'
#' @param DistributionId &#91;required&#93; The ID of the distribution that you are disabling metrics for.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_monitoring_subscription(
#'   DistributionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_monitoring_subscription
cloudfront_delete_monitoring_subscription <- function(DistributionId) {
  op <- new_operation(
    name = "DeleteMonitoringSubscription",
    http_method = "DELETE",
    http_path = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
    paginator = list()
  )
  input <- .cloudfront$delete_monitoring_subscription_input(DistributionId = DistributionId)
  output <- .cloudfront$delete_monitoring_subscription_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_monitoring_subscription <- cloudfront_delete_monitoring_subscription

#' Deletes an origin request policy
#'
#' @description
#' Deletes an origin request policy.
#' 
#' You cannot delete an origin request policy if it’s attached to any cache
#' behaviors. First update your distributions to remove the origin request
#' policy from all cache behaviors, then delete the origin request policy.
#' 
#' To delete an origin request policy, you must provide the policy’s
#' identifier and version. To get the identifier, you can use
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies]
#' or [`get_origin_request_policy`][cloudfront_get_origin_request_policy].
#'
#' @usage
#' cloudfront_delete_origin_request_policy(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The unique identifier for the origin request policy that you are
#' deleting. To get the identifier, you can use
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#' @param IfMatch The version of the origin request policy that you are deleting. The
#' version is the origin request policy’s `ETag` value, which you can get
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies],
#' [`get_origin_request_policy`][cloudfront_get_origin_request_policy], or
#' [`get_origin_request_policy_config`][cloudfront_get_origin_request_policy_config].
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_origin_request_policy(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_origin_request_policy
cloudfront_delete_origin_request_policy <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteOriginRequestPolicy",
    http_method = "DELETE",
    http_path = "/2020-05-31/origin-request-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_origin_request_policy_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_origin_request_policy <- cloudfront_delete_origin_request_policy

#' Remove a public key you previously added to CloudFront
#'
#' @description
#' Remove a public key you previously added to CloudFront.
#'
#' @usage
#' cloudfront_delete_public_key(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The ID of the public key you want to remove from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' public key identity to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_public_key(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_public_key
cloudfront_delete_public_key <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeletePublicKey",
    http_method = "DELETE",
    http_path = "/2020-05-31/public-key/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_public_key_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_public_key <- cloudfront_delete_public_key

#' Deletes a real-time log configuration
#'
#' @description
#' Deletes a real-time log configuration.
#' 
#' You cannot delete a real-time log configuration if it’s attached to a
#' cache behavior. First update your distributions to remove the real-time
#' log configuration from all cache behaviors, then delete the real-time
#' log configuration.
#' 
#' To delete a real-time log configuration, you can provide the
#' configuration’s name or its Amazon Resource Name (ARN). You must provide
#' at least one. If you provide both, CloudFront uses the name to identify
#' the real-time log configuration to delete.
#'
#' @usage
#' cloudfront_delete_realtime_log_config(Name, ARN)
#'
#' @param Name The name of the real-time log configuration to delete.
#' @param ARN The Amazon Resource Name (ARN) of the real-time log configuration to
#' delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_realtime_log_config(
#'   Name = "string",
#'   ARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_realtime_log_config
cloudfront_delete_realtime_log_config <- function(Name = NULL, ARN = NULL) {
  op <- new_operation(
    name = "DeleteRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/delete-realtime-log-config/",
    paginator = list()
  )
  input <- .cloudfront$delete_realtime_log_config_input(Name = Name, ARN = ARN)
  output <- .cloudfront$delete_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_realtime_log_config <- cloudfront_delete_realtime_log_config

#' Delete a streaming distribution
#'
#' @description
#' Delete a streaming distribution. To delete an RTMP distribution using
#' the CloudFront API, perform the following steps.
#' 
#' **To delete an RTMP distribution using the CloudFront API**:
#' 
#' 1.  Disable the RTMP distribution.
#' 
#' 2.  Submit a `GET Streaming Distribution Config` request to get the
#'     current configuration and the `Etag` header for the distribution.
#' 
#' 3.  Update the XML document that was returned in the response to your
#'     `GET Streaming Distribution Config` request to change the value of
#'     `Enabled` to `false`.
#' 
#' 4.  Submit a `PUT Streaming Distribution Config` request to update the
#'     configuration for your distribution. In the request body, include
#'     the XML document that you updated in Step 3. Then set the value of
#'     the HTTP `If-Match` header to the value of the `ETag` header that
#'     CloudFront returned when you submitted the
#'     `GET Streaming Distribution Config` request in Step 2.
#' 
#' 5.  Review the response to the `PUT Streaming Distribution Config`
#'     request to confirm that the distribution was successfully disabled.
#' 
#' 6.  Submit a `GET Streaming Distribution Config` request to confirm that
#'     your changes have propagated. When propagation is complete, the
#'     value of `Status` is `Deployed`.
#' 
#' 7.  Submit a `DELETE Streaming Distribution` request. Set the value of
#'     the HTTP `If-Match` header to the value of the `ETag` header that
#'     CloudFront returned when you submitted the
#'     `GET Streaming Distribution Config` request in Step 2.
#' 
#' 8.  Review the response to your `DELETE Streaming Distribution` request
#'     to confirm that the distribution was successfully deleted.
#' 
#' For information about deleting a distribution using the CloudFront
#' console, see [Deleting a
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_delete_streaming_distribution(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The distribution ID.
#' @param IfMatch The value of the `ETag` header that you received when you disabled the
#' streaming distribution. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_streaming_distribution(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_streaming_distribution
cloudfront_delete_streaming_distribution <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteStreamingDistribution",
    http_method = "DELETE",
    http_path = "/2020-05-31/streaming-distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_streaming_distribution_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_streaming_distribution <- cloudfront_delete_streaming_distribution

#' Gets a cache policy, including the following metadata:
#'
#' @description
#' Gets a cache policy, including the following metadata:
#' 
#' -   The policy’s identifier.
#' 
#' -   The date and time when the policy was last modified.
#' 
#' To get a cache policy, you must provide the policy’s identifier. If the
#' cache policy is attached to a distribution’s cache behavior, you can get
#' the policy’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the cache policy
#' is not attached to a cache behavior, you can get the identifier using
#' [`list_cache_policies`][cloudfront_list_cache_policies].
#'
#' @usage
#' cloudfront_get_cache_policy(Id)
#'
#' @param Id &#91;required&#93; The unique identifier for the cache policy. If the cache policy is
#' attached to a distribution’s cache behavior, you can get the policy’s
#' identifier using [`list_distributions`][cloudfront_list_distributions]
#' or [`get_distribution`][cloudfront_get_distribution]. If the cache
#' policy is not attached to a cache behavior, you can get the identifier
#' using [`list_cache_policies`][cloudfront_list_cache_policies].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CachePolicy = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CachePolicyConfig = list(
#'       Comment = "string",
#'       Name = "string",
#'       DefaultTTL = 123,
#'       MaxTTL = 123,
#'       MinTTL = 123,
#'       ParametersInCacheKeyAndForwardedToOrigin = list(
#'         EnableAcceptEncodingGzip = TRUE|FALSE,
#'         EnableAcceptEncodingBrotli = TRUE|FALSE,
#'         HeadersConfig = list(
#'           HeaderBehavior = "none"|"whitelist",
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         CookiesConfig = list(
#'           CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'           Cookies = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         QueryStringsConfig = list(
#'           QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'           QueryStrings = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cache_policy(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cache_policy
cloudfront_get_cache_policy <- function(Id) {
  op <- new_operation(
    name = "GetCachePolicy",
    http_method = "GET",
    http_path = "/2020-05-31/cache-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_cache_policy_input(Id = Id)
  output <- .cloudfront$get_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cache_policy <- cloudfront_get_cache_policy

#' Gets a cache policy configuration
#'
#' @description
#' Gets a cache policy configuration.
#' 
#' To get a cache policy configuration, you must provide the policy’s
#' identifier. If the cache policy is attached to a distribution’s cache
#' behavior, you can get the policy’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the cache policy
#' is not attached to a cache behavior, you can get the identifier using
#' [`list_cache_policies`][cloudfront_list_cache_policies].
#'
#' @usage
#' cloudfront_get_cache_policy_config(Id)
#'
#' @param Id &#91;required&#93; The unique identifier for the cache policy. If the cache policy is
#' attached to a distribution’s cache behavior, you can get the policy’s
#' identifier using [`list_distributions`][cloudfront_list_distributions]
#' or [`get_distribution`][cloudfront_get_distribution]. If the cache
#' policy is not attached to a cache behavior, you can get the identifier
#' using [`list_cache_policies`][cloudfront_list_cache_policies].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CachePolicyConfig = list(
#'     Comment = "string",
#'     Name = "string",
#'     DefaultTTL = 123,
#'     MaxTTL = 123,
#'     MinTTL = 123,
#'     ParametersInCacheKeyAndForwardedToOrigin = list(
#'       EnableAcceptEncodingGzip = TRUE|FALSE,
#'       EnableAcceptEncodingBrotli = TRUE|FALSE,
#'       HeadersConfig = list(
#'         HeaderBehavior = "none"|"whitelist",
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CookiesConfig = list(
#'         CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'         Cookies = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       QueryStringsConfig = list(
#'         QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'         QueryStrings = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cache_policy_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cache_policy_config
cloudfront_get_cache_policy_config <- function(Id) {
  op <- new_operation(
    name = "GetCachePolicyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/cache-policy/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_cache_policy_config_input(Id = Id)
  output <- .cloudfront$get_cache_policy_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cache_policy_config <- cloudfront_get_cache_policy_config

#' Get the information about an origin access identity
#'
#' @description
#' Get the information about an origin access identity.
#'
#' @usage
#' cloudfront_get_cloud_front_origin_access_identity(Id)
#'
#' @param Id &#91;required&#93; The identity's ID.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CloudFrontOriginAccessIdentity = list(
#'     Id = "string",
#'     S3CanonicalUserId = "string",
#'     CloudFrontOriginAccessIdentityConfig = list(
#'       CallerReference = "string",
#'       Comment = "string"
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_front_origin_access_identity(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cloud_front_origin_access_identity
cloudfront_get_cloud_front_origin_access_identity <- function(Id) {
  op <- new_operation(
    name = "GetCloudFrontOriginAccessIdentity",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_cloud_front_origin_access_identity_input(Id = Id)
  output <- .cloudfront$get_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cloud_front_origin_access_identity <- cloudfront_get_cloud_front_origin_access_identity

#' Get the configuration information about an origin access identity
#'
#' @description
#' Get the configuration information about an origin access identity.
#'
#' @usage
#' cloudfront_get_cloud_front_origin_access_identity_config(Id)
#'
#' @param Id &#91;required&#93; The identity's ID.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CloudFrontOriginAccessIdentityConfig = list(
#'     CallerReference = "string",
#'     Comment = "string"
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_front_origin_access_identity_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cloud_front_origin_access_identity_config
cloudfront_get_cloud_front_origin_access_identity_config <- function(Id) {
  op <- new_operation(
    name = "GetCloudFrontOriginAccessIdentityConfig",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_cloud_front_origin_access_identity_config_input(Id = Id)
  output <- .cloudfront$get_cloud_front_origin_access_identity_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cloud_front_origin_access_identity_config <- cloudfront_get_cloud_front_origin_access_identity_config

#' Get the information about a distribution
#'
#' @description
#' Get the information about a distribution.
#'
#' @usage
#' cloudfront_get_distribution(Id)
#'
#' @param Id &#91;required&#93; The distribution's ID. If the ID is empty, an empty distribution
#' configuration is returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Distribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InProgressInvalidationBatches = 123,
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     ActiveTrustedKeyGroups = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           KeyGroupId = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DistributionConfig = list(
#'       CallerReference = "string",
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       DefaultRootObject = "string",
#'       Origins = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             DomainName = "string",
#'             OriginPath = "string",
#'             CustomHeaders = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   HeaderName = "string",
#'                   HeaderValue = "string"
#'                 )
#'               )
#'             ),
#'             S3OriginConfig = list(
#'               OriginAccessIdentity = "string"
#'             ),
#'             CustomOriginConfig = list(
#'               HTTPPort = 123,
#'               HTTPSPort = 123,
#'               OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'               OriginSslProtocols = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                 )
#'               ),
#'               OriginReadTimeout = 123,
#'               OriginKeepaliveTimeout = 123
#'             ),
#'             ConnectionAttempts = 123,
#'             ConnectionTimeout = 123,
#'             OriginShield = list(
#'               Enabled = TRUE|FALSE,
#'               OriginShieldRegion = "string"
#'             )
#'           )
#'         )
#'       ),
#'       OriginGroups = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             FailoverCriteria = list(
#'               StatusCodes = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   123
#'                 )
#'               )
#'             ),
#'             Members = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   OriginId = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       DefaultCacheBehavior = list(
#'         TargetOriginId = "string",
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         TrustedKeyGroups = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'         AllowedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           ),
#'           CachedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             )
#'           )
#'         ),
#'         SmoothStreaming = TRUE|FALSE,
#'         Compress = TRUE|FALSE,
#'         LambdaFunctionAssociations = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               LambdaFunctionARN = "string",
#'               EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'               IncludeBody = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         FieldLevelEncryptionId = "string",
#'         RealtimeLogConfigArn = "string",
#'         CachePolicyId = "string",
#'         OriginRequestPolicyId = "string",
#'         ForwardedValues = list(
#'           QueryString = TRUE|FALSE,
#'           Cookies = list(
#'             Forward = "none"|"whitelist"|"all",
#'             WhitelistedNames = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           QueryStringCacheKeys = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MinTTL = 123,
#'         DefaultTTL = 123,
#'         MaxTTL = 123
#'       ),
#'       CacheBehaviors = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PathPattern = "string",
#'             TargetOriginId = "string",
#'             TrustedSigners = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             TrustedKeyGroups = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'             AllowedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               ),
#'               CachedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 )
#'               )
#'             ),
#'             SmoothStreaming = TRUE|FALSE,
#'             Compress = TRUE|FALSE,
#'             LambdaFunctionAssociations = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   LambdaFunctionARN = "string",
#'                   EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                   IncludeBody = TRUE|FALSE
#'                 )
#'               )
#'             ),
#'             FieldLevelEncryptionId = "string",
#'             RealtimeLogConfigArn = "string",
#'             CachePolicyId = "string",
#'             OriginRequestPolicyId = "string",
#'             ForwardedValues = list(
#'               QueryString = TRUE|FALSE,
#'               Cookies = list(
#'                 Forward = "none"|"whitelist"|"all",
#'                 WhitelistedNames = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               QueryStringCacheKeys = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             MinTTL = 123,
#'             DefaultTTL = 123,
#'             MaxTTL = 123
#'           )
#'         )
#'       ),
#'       CustomErrorResponses = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             ErrorCode = 123,
#'             ResponsePagePath = "string",
#'             ResponseCode = "string",
#'             ErrorCachingMinTTL = 123
#'           )
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         IncludeCookies = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE,
#'       ViewerCertificate = list(
#'         CloudFrontDefaultCertificate = TRUE|FALSE,
#'         IAMCertificateId = "string",
#'         ACMCertificateArn = "string",
#'         SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'         MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'         Certificate = "string",
#'         CertificateSource = "cloudfront"|"iam"|"acm"
#'       ),
#'       Restrictions = list(
#'         GeoRestriction = list(
#'           RestrictionType = "blacklist"|"whitelist"|"none",
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       WebACLId = "string",
#'       HttpVersion = "http1.1"|"http2",
#'       IsIPV6Enabled = TRUE|FALSE
#'     ),
#'     AliasICPRecordals = list(
#'       list(
#'         CNAME = "string",
#'         ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_distribution
cloudfront_get_distribution <- function(Id) {
  op <- new_operation(
    name = "GetDistribution",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_distribution_input(Id = Id)
  output <- .cloudfront$get_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_distribution <- cloudfront_get_distribution

#' Get the configuration information about a distribution
#'
#' @description
#' Get the configuration information about a distribution.
#'
#' @usage
#' cloudfront_get_distribution_config(Id)
#'
#' @param Id &#91;required&#93; The distribution's ID. If the ID is empty, an empty distribution
#' configuration is returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionConfig = list(
#'     CallerReference = "string",
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     DefaultRootObject = "string",
#'     Origins = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           DomainName = "string",
#'           OriginPath = "string",
#'           CustomHeaders = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 HeaderName = "string",
#'                 HeaderValue = "string"
#'               )
#'             )
#'           ),
#'           S3OriginConfig = list(
#'             OriginAccessIdentity = "string"
#'           ),
#'           CustomOriginConfig = list(
#'             HTTPPort = 123,
#'             HTTPSPort = 123,
#'             OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'             OriginSslProtocols = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'               )
#'             ),
#'             OriginReadTimeout = 123,
#'             OriginKeepaliveTimeout = 123
#'           ),
#'           ConnectionAttempts = 123,
#'           ConnectionTimeout = 123,
#'           OriginShield = list(
#'             Enabled = TRUE|FALSE,
#'             OriginShieldRegion = "string"
#'           )
#'         )
#'       )
#'     ),
#'     OriginGroups = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           FailoverCriteria = list(
#'             StatusCodes = list(
#'               Quantity = 123,
#'               Items = list(
#'                 123
#'               )
#'             )
#'           ),
#'           Members = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 OriginId = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DefaultCacheBehavior = list(
#'       TargetOriginId = "string",
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       TrustedKeyGroups = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'       AllowedMethods = list(
#'         Quantity = 123,
#'         Items = list(
#'           "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'         ),
#'         CachedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           )
#'         )
#'       ),
#'       SmoothStreaming = TRUE|FALSE,
#'       Compress = TRUE|FALSE,
#'       LambdaFunctionAssociations = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             LambdaFunctionARN = "string",
#'             EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'             IncludeBody = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       FieldLevelEncryptionId = "string",
#'       RealtimeLogConfigArn = "string",
#'       CachePolicyId = "string",
#'       OriginRequestPolicyId = "string",
#'       ForwardedValues = list(
#'         QueryString = TRUE|FALSE,
#'         Cookies = list(
#'           Forward = "none"|"whitelist"|"all",
#'           WhitelistedNames = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         QueryStringCacheKeys = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       MinTTL = 123,
#'       DefaultTTL = 123,
#'       MaxTTL = 123
#'     ),
#'     CacheBehaviors = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PathPattern = "string",
#'           TargetOriginId = "string",
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           TrustedKeyGroups = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string",
#'           RealtimeLogConfigArn = "string",
#'           CachePolicyId = "string",
#'           OriginRequestPolicyId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           MinTTL = 123,
#'           DefaultTTL = 123,
#'           MaxTTL = 123
#'         )
#'       )
#'     ),
#'     CustomErrorResponses = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           ErrorCode = 123,
#'           ResponsePagePath = "string",
#'           ResponseCode = "string",
#'           ErrorCachingMinTTL = 123
#'         )
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       IncludeCookies = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE,
#'     ViewerCertificate = list(
#'       CloudFrontDefaultCertificate = TRUE|FALSE,
#'       IAMCertificateId = "string",
#'       ACMCertificateArn = "string",
#'       SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'       MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'       Certificate = "string",
#'       CertificateSource = "cloudfront"|"iam"|"acm"
#'     ),
#'     Restrictions = list(
#'       GeoRestriction = list(
#'         RestrictionType = "blacklist"|"whitelist"|"none",
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     WebACLId = "string",
#'     HttpVersion = "http1.1"|"http2",
#'     IsIPV6Enabled = TRUE|FALSE
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_distribution_config
cloudfront_get_distribution_config <- function(Id) {
  op <- new_operation(
    name = "GetDistributionConfig",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_distribution_config_input(Id = Id)
  output <- .cloudfront$get_distribution_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_distribution_config <- cloudfront_get_distribution_config

#' Get the field-level encryption configuration information
#'
#' @description
#' Get the field-level encryption configuration information.
#'
#' @usage
#' cloudfront_get_field_level_encryption(Id)
#'
#' @param Id &#91;required&#93; Request the ID for the field-level encryption configuration information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryption = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FieldLevelEncryptionConfig = list(
#'       CallerReference = "string",
#'       Comment = "string",
#'       QueryArgProfileConfig = list(
#'         ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'         QueryArgProfiles = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               QueryArg = "string",
#'               ProfileId = "string"
#'             )
#'           )
#'         )
#'       ),
#'       ContentTypeProfileConfig = list(
#'         ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'         ContentTypeProfiles = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Format = "URLEncoded",
#'               ProfileId = "string",
#'               ContentType = "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption
cloudfront_get_field_level_encryption <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryption",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption <- cloudfront_get_field_level_encryption

#' Get the field-level encryption configuration information
#'
#' @description
#' Get the field-level encryption configuration information.
#'
#' @usage
#' cloudfront_get_field_level_encryption_config(Id)
#'
#' @param Id &#91;required&#93; Request the ID for the field-level encryption configuration information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionConfig = list(
#'     CallerReference = "string",
#'     Comment = "string",
#'     QueryArgProfileConfig = list(
#'       ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'       QueryArgProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             QueryArg = "string",
#'             ProfileId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ContentTypeProfileConfig = list(
#'       ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'       ContentTypeProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Format = "URLEncoded",
#'             ProfileId = "string",
#'             ContentType = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_config
cloudfront_get_field_level_encryption_config <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionConfig",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_config_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_config <- cloudfront_get_field_level_encryption_config

#' Get the field-level encryption profile information
#'
#' @description
#' Get the field-level encryption profile information.
#'
#' @usage
#' cloudfront_get_field_level_encryption_profile(Id)
#'
#' @param Id &#91;required&#93; Get the ID for the field-level encryption profile information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionProfile = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FieldLevelEncryptionProfileConfig = list(
#'       Name = "string",
#'       CallerReference = "string",
#'       Comment = "string",
#'       EncryptionEntities = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PublicKeyId = "string",
#'             ProviderId = "string",
#'             FieldPatterns = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption_profile(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_profile
cloudfront_get_field_level_encryption_profile <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionProfile",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_profile_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_profile <- cloudfront_get_field_level_encryption_profile

#' Get the field-level encryption profile configuration information
#'
#' @description
#' Get the field-level encryption profile configuration information.
#'
#' @usage
#' cloudfront_get_field_level_encryption_profile_config(Id)
#'
#' @param Id &#91;required&#93; Get the ID for the field-level encryption profile configuration
#' information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionProfileConfig = list(
#'     Name = "string",
#'     CallerReference = "string",
#'     Comment = "string",
#'     EncryptionEntities = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PublicKeyId = "string",
#'           ProviderId = "string",
#'           FieldPatterns = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption_profile_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_profile_config
cloudfront_get_field_level_encryption_profile_config <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionProfileConfig",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_profile_config_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_profile_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_profile_config <- cloudfront_get_field_level_encryption_profile_config

#' Get the information about an invalidation
#'
#' @description
#' Get the information about an invalidation.
#'
#' @usage
#' cloudfront_get_invalidation(DistributionId, Id)
#'
#' @param DistributionId &#91;required&#93; The distribution's ID.
#' @param Id &#91;required&#93; The identifier for the invalidation request, for example,
#' `IDFDVBD632BHDS5`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Invalidation = list(
#'     Id = "string",
#'     Status = "string",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InvalidationBatch = list(
#'       Paths = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       CallerReference = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_invalidation(
#'   DistributionId = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_invalidation
cloudfront_get_invalidation <- function(DistributionId, Id) {
  op <- new_operation(
    name = "GetInvalidation",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{DistributionId}/invalidation/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_invalidation_input(DistributionId = DistributionId, Id = Id)
  output <- .cloudfront$get_invalidation_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_invalidation <- cloudfront_get_invalidation

#' Gets a key group, including the date and time when the key group was
#' last modified
#'
#' @description
#' Gets a key group, including the date and time when the key group was
#' last modified.
#' 
#' To get a key group, you must provide the key group’s identifier. If the
#' key group is referenced in a distribution’s cache behavior, you can get
#' the key group’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the key group is
#' not referenced in a cache behavior, you can get the identifier using
#' [`list_key_groups`][cloudfront_list_key_groups].
#'
#' @usage
#' cloudfront_get_key_group(Id)
#'
#' @param Id &#91;required&#93; The identifier of the key group that you are getting. To get the
#' identifier, use [`list_key_groups`][cloudfront_list_key_groups].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyGroup = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     KeyGroupConfig = list(
#'       Name = "string",
#'       Items = list(
#'         "string"
#'       ),
#'       Comment = "string"
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_key_group(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_key_group
cloudfront_get_key_group <- function(Id) {
  op <- new_operation(
    name = "GetKeyGroup",
    http_method = "GET",
    http_path = "/2020-05-31/key-group/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_key_group_input(Id = Id)
  output <- .cloudfront$get_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_key_group <- cloudfront_get_key_group

#' Gets a key group configuration
#'
#' @description
#' Gets a key group configuration.
#' 
#' To get a key group configuration, you must provide the key group’s
#' identifier. If the key group is referenced in a distribution’s cache
#' behavior, you can get the key group’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the key group is
#' not referenced in a cache behavior, you can get the identifier using
#' [`list_key_groups`][cloudfront_list_key_groups].
#'
#' @usage
#' cloudfront_get_key_group_config(Id)
#'
#' @param Id &#91;required&#93; The identifier of the key group whose configuration you are getting. To
#' get the identifier, use [`list_key_groups`][cloudfront_list_key_groups].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyGroupConfig = list(
#'     Name = "string",
#'     Items = list(
#'       "string"
#'     ),
#'     Comment = "string"
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_key_group_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_key_group_config
cloudfront_get_key_group_config <- function(Id) {
  op <- new_operation(
    name = "GetKeyGroupConfig",
    http_method = "GET",
    http_path = "/2020-05-31/key-group/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_key_group_config_input(Id = Id)
  output <- .cloudfront$get_key_group_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_key_group_config <- cloudfront_get_key_group_config

#' Gets information about whether additional CloudWatch metrics are enabled
#' for the specified CloudFront distribution
#'
#' @description
#' Gets information about whether additional CloudWatch metrics are enabled
#' for the specified CloudFront distribution.
#'
#' @usage
#' cloudfront_get_monitoring_subscription(DistributionId)
#'
#' @param DistributionId &#91;required&#93; The ID of the distribution that you are getting metrics information for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MonitoringSubscription = list(
#'     RealtimeMetricsSubscriptionConfig = list(
#'       RealtimeMetricsSubscriptionStatus = "Enabled"|"Disabled"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_monitoring_subscription(
#'   DistributionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_monitoring_subscription
cloudfront_get_monitoring_subscription <- function(DistributionId) {
  op <- new_operation(
    name = "GetMonitoringSubscription",
    http_method = "GET",
    http_path = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
    paginator = list()
  )
  input <- .cloudfront$get_monitoring_subscription_input(DistributionId = DistributionId)
  output <- .cloudfront$get_monitoring_subscription_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_monitoring_subscription <- cloudfront_get_monitoring_subscription

#' Gets an origin request policy, including the following metadata:
#'
#' @description
#' Gets an origin request policy, including the following metadata:
#' 
#' -   The policy’s identifier.
#' 
#' -   The date and time when the policy was last modified.
#' 
#' To get an origin request policy, you must provide the policy’s
#' identifier. If the origin request policy is attached to a distribution’s
#' cache behavior, you can get the policy’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the origin request
#' policy is not attached to a cache behavior, you can get the identifier
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#'
#' @usage
#' cloudfront_get_origin_request_policy(Id)
#'
#' @param Id &#91;required&#93; The unique identifier for the origin request policy. If the origin
#' request policy is attached to a distribution’s cache behavior, you can
#' get the policy’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the origin request
#' policy is not attached to a cache behavior, you can get the identifier
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OriginRequestPolicy = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     OriginRequestPolicyConfig = list(
#'       Comment = "string",
#'       Name = "string",
#'       HeadersConfig = list(
#'         HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CookiesConfig = list(
#'         CookieBehavior = "none"|"whitelist"|"all",
#'         Cookies = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       QueryStringsConfig = list(
#'         QueryStringBehavior = "none"|"whitelist"|"all",
#'         QueryStrings = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_origin_request_policy(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_origin_request_policy
cloudfront_get_origin_request_policy <- function(Id) {
  op <- new_operation(
    name = "GetOriginRequestPolicy",
    http_method = "GET",
    http_path = "/2020-05-31/origin-request-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_origin_request_policy_input(Id = Id)
  output <- .cloudfront$get_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_origin_request_policy <- cloudfront_get_origin_request_policy

#' Gets an origin request policy configuration
#'
#' @description
#' Gets an origin request policy configuration.
#' 
#' To get an origin request policy configuration, you must provide the
#' policy’s identifier. If the origin request policy is attached to a
#' distribution’s cache behavior, you can get the policy’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the origin request
#' policy is not attached to a cache behavior, you can get the identifier
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#'
#' @usage
#' cloudfront_get_origin_request_policy_config(Id)
#'
#' @param Id &#91;required&#93; The unique identifier for the origin request policy. If the origin
#' request policy is attached to a distribution’s cache behavior, you can
#' get the policy’s identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the origin request
#' policy is not attached to a cache behavior, you can get the identifier
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OriginRequestPolicyConfig = list(
#'     Comment = "string",
#'     Name = "string",
#'     HeadersConfig = list(
#'       HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'       Headers = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     CookiesConfig = list(
#'       CookieBehavior = "none"|"whitelist"|"all",
#'       Cookies = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     QueryStringsConfig = list(
#'       QueryStringBehavior = "none"|"whitelist"|"all",
#'       QueryStrings = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_origin_request_policy_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_origin_request_policy_config
cloudfront_get_origin_request_policy_config <- function(Id) {
  op <- new_operation(
    name = "GetOriginRequestPolicyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/origin-request-policy/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_origin_request_policy_config_input(Id = Id)
  output <- .cloudfront$get_origin_request_policy_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_origin_request_policy_config <- cloudfront_get_origin_request_policy_config

#' Gets a public key
#'
#' @description
#' Gets a public key.
#'
#' @usage
#' cloudfront_get_public_key(Id)
#'
#' @param Id &#91;required&#93; The identifier of the public key you are getting.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKey = list(
#'     Id = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PublicKeyConfig = list(
#'       CallerReference = "string",
#'       Name = "string",
#'       EncodedKey = "string",
#'       Comment = "string"
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_public_key(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_public_key
cloudfront_get_public_key <- function(Id) {
  op <- new_operation(
    name = "GetPublicKey",
    http_method = "GET",
    http_path = "/2020-05-31/public-key/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_public_key_input(Id = Id)
  output <- .cloudfront$get_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_public_key <- cloudfront_get_public_key

#' Gets a public key configuration
#'
#' @description
#' Gets a public key configuration.
#'
#' @usage
#' cloudfront_get_public_key_config(Id)
#'
#' @param Id &#91;required&#93; The identifier of the public key whose configuration you are getting.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKeyConfig = list(
#'     CallerReference = "string",
#'     Name = "string",
#'     EncodedKey = "string",
#'     Comment = "string"
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_public_key_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_public_key_config
cloudfront_get_public_key_config <- function(Id) {
  op <- new_operation(
    name = "GetPublicKeyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/public-key/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_public_key_config_input(Id = Id)
  output <- .cloudfront$get_public_key_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_public_key_config <- cloudfront_get_public_key_config

#' Gets a real-time log configuration
#'
#' @description
#' Gets a real-time log configuration.
#' 
#' To get a real-time log configuration, you can provide the
#' configuration’s name or its Amazon Resource Name (ARN). You must provide
#' at least one. If you provide both, CloudFront uses the name to identify
#' the real-time log configuration to get.
#'
#' @usage
#' cloudfront_get_realtime_log_config(Name, ARN)
#'
#' @param Name The name of the real-time log configuration to get.
#' @param ARN The Amazon Resource Name (ARN) of the real-time log configuration to
#' get.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RealtimeLogConfig = list(
#'     ARN = "string",
#'     Name = "string",
#'     SamplingRate = 123,
#'     EndPoints = list(
#'       list(
#'         StreamType = "string",
#'         KinesisStreamConfig = list(
#'           RoleARN = "string",
#'           StreamARN = "string"
#'         )
#'       )
#'     ),
#'     Fields = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_realtime_log_config(
#'   Name = "string",
#'   ARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_realtime_log_config
cloudfront_get_realtime_log_config <- function(Name = NULL, ARN = NULL) {
  op <- new_operation(
    name = "GetRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/get-realtime-log-config/",
    paginator = list()
  )
  input <- .cloudfront$get_realtime_log_config_input(Name = Name, ARN = ARN)
  output <- .cloudfront$get_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_realtime_log_config <- cloudfront_get_realtime_log_config

#' Gets information about a specified RTMP distribution, including the
#' distribution configuration
#'
#' @description
#' Gets information about a specified RTMP distribution, including the
#' distribution configuration.
#'
#' @usage
#' cloudfront_get_streaming_distribution(Id)
#'
#' @param Id &#91;required&#93; The streaming distribution's ID.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingDistribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     StreamingDistributionConfig = list(
#'       CallerReference = "string",
#'       S3Origin = list(
#'         DomainName = "string",
#'         OriginAccessIdentity = "string"
#'       ),
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_streaming_distribution(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_streaming_distribution
cloudfront_get_streaming_distribution <- function(Id) {
  op <- new_operation(
    name = "GetStreamingDistribution",
    http_method = "GET",
    http_path = "/2020-05-31/streaming-distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_streaming_distribution_input(Id = Id)
  output <- .cloudfront$get_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_streaming_distribution <- cloudfront_get_streaming_distribution

#' Get the configuration information about a streaming distribution
#'
#' @description
#' Get the configuration information about a streaming distribution.
#'
#' @usage
#' cloudfront_get_streaming_distribution_config(Id)
#'
#' @param Id &#91;required&#93; The streaming distribution's ID.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingDistributionConfig = list(
#'     CallerReference = "string",
#'     S3Origin = list(
#'       DomainName = "string",
#'       OriginAccessIdentity = "string"
#'     ),
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     TrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_streaming_distribution_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_streaming_distribution_config
cloudfront_get_streaming_distribution_config <- function(Id) {
  op <- new_operation(
    name = "GetStreamingDistributionConfig",
    http_method = "GET",
    http_path = "/2020-05-31/streaming-distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_streaming_distribution_config_input(Id = Id)
  output <- .cloudfront$get_streaming_distribution_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_streaming_distribution_config <- cloudfront_get_streaming_distribution_config

#' Gets a list of cache policies
#'
#' @description
#' Gets a list of cache policies.
#' 
#' You can optionally apply a filter to return only the managed policies
#' created by AWS, or only the custom policies created in your AWS account.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_cache_policies(Type, Marker, MaxItems)
#'
#' @param Type A filter to return only the specified kinds of cache policies. Valid
#' values are:
#' 
#' -   `managed` – Returns only the managed policies created by AWS.
#' 
#' -   `custom` – Returns only the custom policies created in your AWS
#'     account.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of cache policies. The response includes cache policies in the
#' list that occur after the marker. To get the next page of the list, set
#' this field’s value to the value of `NextMarker` from the current page’s
#' response.
#' @param MaxItems The maximum number of cache policies that you want in the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CachePolicyList = list(
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Type = "managed"|"custom",
#'         CachePolicy = list(
#'           Id = "string",
#'           LastModifiedTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           CachePolicyConfig = list(
#'             Comment = "string",
#'             Name = "string",
#'             DefaultTTL = 123,
#'             MaxTTL = 123,
#'             MinTTL = 123,
#'             ParametersInCacheKeyAndForwardedToOrigin = list(
#'               EnableAcceptEncodingGzip = TRUE|FALSE,
#'               EnableAcceptEncodingBrotli = TRUE|FALSE,
#'               HeadersConfig = list(
#'                 HeaderBehavior = "none"|"whitelist",
#'                 Headers = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               CookiesConfig = list(
#'                 CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'                 Cookies = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               QueryStringsConfig = list(
#'                 QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'                 QueryStrings = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_cache_policies(
#'   Type = "managed"|"custom",
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_cache_policies
cloudfront_list_cache_policies <- function(Type = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCachePolicies",
    http_method = "GET",
    http_path = "/2020-05-31/cache-policy",
    paginator = list()
  )
  input <- .cloudfront$list_cache_policies_input(Type = Type, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_cache_policies_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_cache_policies <- cloudfront_list_cache_policies

#' Lists origin access identities
#'
#' @description
#' Lists origin access identities.
#'
#' @usage
#' cloudfront_list_cloud_front_origin_access_identities(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of origin access identities. The results include identities in the list
#' that occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page's
#' response (which is also the ID of the last identity on that page).
#' @param MaxItems The maximum number of origin access identities you want in the response
#' body.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CloudFrontOriginAccessIdentityList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         S3CanonicalUserId = "string",
#'         Comment = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_cloud_front_origin_access_identities(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_cloud_front_origin_access_identities
cloudfront_list_cloud_front_origin_access_identities <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCloudFrontOriginAccessIdentities",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-identity/cloudfront",
    paginator = list()
  )
  input <- .cloudfront$list_cloud_front_origin_access_identities_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_cloud_front_origin_access_identities_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_cloud_front_origin_access_identities <- cloudfront_list_cloud_front_origin_access_identities

#' List CloudFront distributions
#'
#' @description
#' List CloudFront distributions.
#'
#' @usage
#' cloudfront_list_distributions(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of distributions. The results include distributions in the list that
#' occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page's
#' response (which is also the ID of the last distribution on that page).
#' @param MaxItems The maximum number of distributions you want in the response body.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         ARN = "string",
#'         Status = "string",
#'         LastModifiedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         DomainName = "string",
#'         Aliases = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         Origins = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Id = "string",
#'               DomainName = "string",
#'               OriginPath = "string",
#'               CustomHeaders = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     HeaderName = "string",
#'                     HeaderValue = "string"
#'                   )
#'                 )
#'               ),
#'               S3OriginConfig = list(
#'                 OriginAccessIdentity = "string"
#'               ),
#'               CustomOriginConfig = list(
#'                 HTTPPort = 123,
#'                 HTTPSPort = 123,
#'                 OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'                 OriginSslProtocols = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                   )
#'                 ),
#'                 OriginReadTimeout = 123,
#'                 OriginKeepaliveTimeout = 123
#'               ),
#'               ConnectionAttempts = 123,
#'               ConnectionTimeout = 123,
#'               OriginShield = list(
#'                 Enabled = TRUE|FALSE,
#'                 OriginShieldRegion = "string"
#'               )
#'             )
#'           )
#'         ),
#'         OriginGroups = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Id = "string",
#'               FailoverCriteria = list(
#'                 StatusCodes = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     123
#'                   )
#'                 )
#'               ),
#'               Members = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     OriginId = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         DefaultCacheBehavior = list(
#'           TargetOriginId = "string",
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           TrustedKeyGroups = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string",
#'           RealtimeLogConfigArn = "string",
#'           CachePolicyId = "string",
#'           OriginRequestPolicyId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           MinTTL = 123,
#'           DefaultTTL = 123,
#'           MaxTTL = 123
#'         ),
#'         CacheBehaviors = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               PathPattern = "string",
#'               TargetOriginId = "string",
#'               TrustedSigners = list(
#'                 Enabled = TRUE|FALSE,
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               TrustedKeyGroups = list(
#'                 Enabled = TRUE|FALSE,
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'               AllowedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 ),
#'                 CachedMethods = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                   )
#'                 )
#'               ),
#'               SmoothStreaming = TRUE|FALSE,
#'               Compress = TRUE|FALSE,
#'               LambdaFunctionAssociations = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     LambdaFunctionARN = "string",
#'                     EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                     IncludeBody = TRUE|FALSE
#'                   )
#'                 )
#'               ),
#'               FieldLevelEncryptionId = "string",
#'               RealtimeLogConfigArn = "string",
#'               CachePolicyId = "string",
#'               OriginRequestPolicyId = "string",
#'               ForwardedValues = list(
#'                 QueryString = TRUE|FALSE,
#'                 Cookies = list(
#'                   Forward = "none"|"whitelist"|"all",
#'                   WhitelistedNames = list(
#'                     Quantity = 123,
#'                     Items = list(
#'                       "string"
#'                     )
#'                   )
#'                 ),
#'                 Headers = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 ),
#'                 QueryStringCacheKeys = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               MinTTL = 123,
#'               DefaultTTL = 123,
#'               MaxTTL = 123
#'             )
#'           )
#'         ),
#'         CustomErrorResponses = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               ErrorCode = 123,
#'               ResponsePagePath = "string",
#'               ResponseCode = "string",
#'               ErrorCachingMinTTL = 123
#'             )
#'           )
#'         ),
#'         Comment = "string",
#'         PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'         Enabled = TRUE|FALSE,
#'         ViewerCertificate = list(
#'           CloudFrontDefaultCertificate = TRUE|FALSE,
#'           IAMCertificateId = "string",
#'           ACMCertificateArn = "string",
#'           SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'           MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'           Certificate = "string",
#'           CertificateSource = "cloudfront"|"iam"|"acm"
#'         ),
#'         Restrictions = list(
#'           GeoRestriction = list(
#'             RestrictionType = "blacklist"|"whitelist"|"none",
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         WebACLId = "string",
#'         HttpVersion = "http1.1"|"http2",
#'         IsIPV6Enabled = TRUE|FALSE,
#'         AliasICPRecordals = list(
#'           list(
#'             CNAME = "string",
#'             ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions
cloudfront_list_distributions <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListDistributions",
    http_method = "GET",
    http_path = "/2020-05-31/distribution",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_distributions_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions <- cloudfront_list_distributions

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that’s associated with the specified cache policy
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that’s associated with the specified cache policy.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_distributions_by_cache_policy_id(Marker, MaxItems,
#'   CachePolicyId)
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field’s value to the value of `NextMarker` from the current
#' page’s response.
#' @param MaxItems The maximum number of distribution IDs that you want in the response.
#' @param CachePolicyId &#91;required&#93; The ID of the cache policy whose associated distribution IDs you want to
#' list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionIdList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions_by_cache_policy_id(
#'   Marker = "string",
#'   MaxItems = "string",
#'   CachePolicyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_cache_policy_id
cloudfront_list_distributions_by_cache_policy_id <- function(Marker = NULL, MaxItems = NULL, CachePolicyId) {
  op <- new_operation(
    name = "ListDistributionsByCachePolicyId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_cache_policy_id_input(Marker = Marker, MaxItems = MaxItems, CachePolicyId = CachePolicyId)
  output <- .cloudfront$list_distributions_by_cache_policy_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_cache_policy_id <- cloudfront_list_distributions_by_cache_policy_id

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that references the specified key group
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that references the specified key group.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_distributions_by_key_group(Marker, MaxItems, KeyGroupId)
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field’s value to the value of `NextMarker` from the current
#' page’s response.
#' @param MaxItems The maximum number of distribution IDs that you want in the response.
#' @param KeyGroupId &#91;required&#93; The ID of the key group whose associated distribution IDs you are
#' listing.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionIdList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions_by_key_group(
#'   Marker = "string",
#'   MaxItems = "string",
#'   KeyGroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_key_group
cloudfront_list_distributions_by_key_group <- function(Marker = NULL, MaxItems = NULL, KeyGroupId) {
  op <- new_operation(
    name = "ListDistributionsByKeyGroup",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_key_group_input(Marker = Marker, MaxItems = MaxItems, KeyGroupId = KeyGroupId)
  output <- .cloudfront$list_distributions_by_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_key_group <- cloudfront_list_distributions_by_key_group

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that’s associated with the specified origin request policy
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that’s associated with the specified origin request policy.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_distributions_by_origin_request_policy_id(Marker,
#'   MaxItems, OriginRequestPolicyId)
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field’s value to the value of `NextMarker` from the current
#' page’s response.
#' @param MaxItems The maximum number of distribution IDs that you want in the response.
#' @param OriginRequestPolicyId &#91;required&#93; The ID of the origin request policy whose associated distribution IDs
#' you want to list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionIdList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions_by_origin_request_policy_id(
#'   Marker = "string",
#'   MaxItems = "string",
#'   OriginRequestPolicyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_origin_request_policy_id
cloudfront_list_distributions_by_origin_request_policy_id <- function(Marker = NULL, MaxItems = NULL, OriginRequestPolicyId) {
  op <- new_operation(
    name = "ListDistributionsByOriginRequestPolicyId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_origin_request_policy_id_input(Marker = Marker, MaxItems = MaxItems, OriginRequestPolicyId = OriginRequestPolicyId)
  output <- .cloudfront$list_distributions_by_origin_request_policy_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_origin_request_policy_id <- cloudfront_list_distributions_by_origin_request_policy_id

#' Gets a list of distributions that have a cache behavior that’s
#' associated with the specified real-time log configuration
#'
#' @description
#' Gets a list of distributions that have a cache behavior that’s
#' associated with the specified real-time log configuration.
#' 
#' You can specify the real-time log configuration by its name or its
#' Amazon Resource Name (ARN). You must provide at least one. If you
#' provide both, CloudFront uses the name to identify the real-time log
#' configuration to list distributions for.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_distributions_by_realtime_log_config(Marker, MaxItems,
#'   RealtimeLogConfigName, RealtimeLogConfigArn)
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distributions. The response includes distributions in the
#' list that occur after the marker. To get the next page of the list, set
#' this field’s value to the value of `NextMarker` from the current page’s
#' response.
#' @param MaxItems The maximum number of distributions that you want in the response.
#' @param RealtimeLogConfigName The name of the real-time log configuration whose associated
#' distributions you want to list.
#' @param RealtimeLogConfigArn The Amazon Resource Name (ARN) of the real-time log configuration whose
#' associated distributions you want to list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         ARN = "string",
#'         Status = "string",
#'         LastModifiedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         DomainName = "string",
#'         Aliases = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         Origins = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Id = "string",
#'               DomainName = "string",
#'               OriginPath = "string",
#'               CustomHeaders = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     HeaderName = "string",
#'                     HeaderValue = "string"
#'                   )
#'                 )
#'               ),
#'               S3OriginConfig = list(
#'                 OriginAccessIdentity = "string"
#'               ),
#'               CustomOriginConfig = list(
#'                 HTTPPort = 123,
#'                 HTTPSPort = 123,
#'                 OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'                 OriginSslProtocols = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                   )
#'                 ),
#'                 OriginReadTimeout = 123,
#'                 OriginKeepaliveTimeout = 123
#'               ),
#'               ConnectionAttempts = 123,
#'               ConnectionTimeout = 123,
#'               OriginShield = list(
#'                 Enabled = TRUE|FALSE,
#'                 OriginShieldRegion = "string"
#'               )
#'             )
#'           )
#'         ),
#'         OriginGroups = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Id = "string",
#'               FailoverCriteria = list(
#'                 StatusCodes = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     123
#'                   )
#'                 )
#'               ),
#'               Members = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     OriginId = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         DefaultCacheBehavior = list(
#'           TargetOriginId = "string",
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           TrustedKeyGroups = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string",
#'           RealtimeLogConfigArn = "string",
#'           CachePolicyId = "string",
#'           OriginRequestPolicyId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           MinTTL = 123,
#'           DefaultTTL = 123,
#'           MaxTTL = 123
#'         ),
#'         CacheBehaviors = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               PathPattern = "string",
#'               TargetOriginId = "string",
#'               TrustedSigners = list(
#'                 Enabled = TRUE|FALSE,
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               TrustedKeyGroups = list(
#'                 Enabled = TRUE|FALSE,
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'               AllowedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 ),
#'                 CachedMethods = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                   )
#'                 )
#'               ),
#'               SmoothStreaming = TRUE|FALSE,
#'               Compress = TRUE|FALSE,
#'               LambdaFunctionAssociations = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     LambdaFunctionARN = "string",
#'                     EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                     IncludeBody = TRUE|FALSE
#'                   )
#'                 )
#'               ),
#'               FieldLevelEncryptionId = "string",
#'               RealtimeLogConfigArn = "string",
#'               CachePolicyId = "string",
#'               OriginRequestPolicyId = "string",
#'               ForwardedValues = list(
#'                 QueryString = TRUE|FALSE,
#'                 Cookies = list(
#'                   Forward = "none"|"whitelist"|"all",
#'                   WhitelistedNames = list(
#'                     Quantity = 123,
#'                     Items = list(
#'                       "string"
#'                     )
#'                   )
#'                 ),
#'                 Headers = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 ),
#'                 QueryStringCacheKeys = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               MinTTL = 123,
#'               DefaultTTL = 123,
#'               MaxTTL = 123
#'             )
#'           )
#'         ),
#'         CustomErrorResponses = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               ErrorCode = 123,
#'               ResponsePagePath = "string",
#'               ResponseCode = "string",
#'               ErrorCachingMinTTL = 123
#'             )
#'           )
#'         ),
#'         Comment = "string",
#'         PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'         Enabled = TRUE|FALSE,
#'         ViewerCertificate = list(
#'           CloudFrontDefaultCertificate = TRUE|FALSE,
#'           IAMCertificateId = "string",
#'           ACMCertificateArn = "string",
#'           SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'           MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'           Certificate = "string",
#'           CertificateSource = "cloudfront"|"iam"|"acm"
#'         ),
#'         Restrictions = list(
#'           GeoRestriction = list(
#'             RestrictionType = "blacklist"|"whitelist"|"none",
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         WebACLId = "string",
#'         HttpVersion = "http1.1"|"http2",
#'         IsIPV6Enabled = TRUE|FALSE,
#'         AliasICPRecordals = list(
#'           list(
#'             CNAME = "string",
#'             ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions_by_realtime_log_config(
#'   Marker = "string",
#'   MaxItems = "string",
#'   RealtimeLogConfigName = "string",
#'   RealtimeLogConfigArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_realtime_log_config
cloudfront_list_distributions_by_realtime_log_config <- function(Marker = NULL, MaxItems = NULL, RealtimeLogConfigName = NULL, RealtimeLogConfigArn = NULL) {
  op <- new_operation(
    name = "ListDistributionsByRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/distributionsByRealtimeLogConfig/",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_realtime_log_config_input(Marker = Marker, MaxItems = MaxItems, RealtimeLogConfigName = RealtimeLogConfigName, RealtimeLogConfigArn = RealtimeLogConfigArn)
  output <- .cloudfront$list_distributions_by_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_realtime_log_config <- cloudfront_list_distributions_by_realtime_log_config

#' List the distributions that are associated with a specified AWS WAF web
#' ACL
#'
#' @description
#' List the distributions that are associated with a specified AWS WAF web
#' ACL.
#'
#' @usage
#' cloudfront_list_distributions_by_web_acl_id(Marker, MaxItems, WebACLId)
#'
#' @param Marker Use `Marker` and `MaxItems` to control pagination of results. If you
#' have more than `MaxItems` distributions that satisfy the request, the
#' response includes a `NextMarker` element. To get the next page of
#' results, submit another request. For the value of `Marker`, specify the
#' value of `NextMarker` from the last response. (For the first request,
#' omit `Marker`.)
#' @param MaxItems The maximum number of distributions that you want CloudFront to return
#' in the response body. The maximum and default values are both 100.
#' @param WebACLId &#91;required&#93; The ID of the AWS WAF web ACL that you want to list the associated
#' distributions. If you specify "null" for the ID, the request returns a
#' list of the distributions that aren't associated with a web ACL.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DistributionList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         ARN = "string",
#'         Status = "string",
#'         LastModifiedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         DomainName = "string",
#'         Aliases = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         Origins = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Id = "string",
#'               DomainName = "string",
#'               OriginPath = "string",
#'               CustomHeaders = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     HeaderName = "string",
#'                     HeaderValue = "string"
#'                   )
#'                 )
#'               ),
#'               S3OriginConfig = list(
#'                 OriginAccessIdentity = "string"
#'               ),
#'               CustomOriginConfig = list(
#'                 HTTPPort = 123,
#'                 HTTPSPort = 123,
#'                 OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'                 OriginSslProtocols = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                   )
#'                 ),
#'                 OriginReadTimeout = 123,
#'                 OriginKeepaliveTimeout = 123
#'               ),
#'               ConnectionAttempts = 123,
#'               ConnectionTimeout = 123,
#'               OriginShield = list(
#'                 Enabled = TRUE|FALSE,
#'                 OriginShieldRegion = "string"
#'               )
#'             )
#'           )
#'         ),
#'         OriginGroups = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Id = "string",
#'               FailoverCriteria = list(
#'                 StatusCodes = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     123
#'                   )
#'                 )
#'               ),
#'               Members = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     OriginId = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         DefaultCacheBehavior = list(
#'           TargetOriginId = "string",
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           TrustedKeyGroups = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string",
#'           RealtimeLogConfigArn = "string",
#'           CachePolicyId = "string",
#'           OriginRequestPolicyId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           MinTTL = 123,
#'           DefaultTTL = 123,
#'           MaxTTL = 123
#'         ),
#'         CacheBehaviors = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               PathPattern = "string",
#'               TargetOriginId = "string",
#'               TrustedSigners = list(
#'                 Enabled = TRUE|FALSE,
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               TrustedKeyGroups = list(
#'                 Enabled = TRUE|FALSE,
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'               AllowedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 ),
#'                 CachedMethods = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                   )
#'                 )
#'               ),
#'               SmoothStreaming = TRUE|FALSE,
#'               Compress = TRUE|FALSE,
#'               LambdaFunctionAssociations = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   list(
#'                     LambdaFunctionARN = "string",
#'                     EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                     IncludeBody = TRUE|FALSE
#'                   )
#'                 )
#'               ),
#'               FieldLevelEncryptionId = "string",
#'               RealtimeLogConfigArn = "string",
#'               CachePolicyId = "string",
#'               OriginRequestPolicyId = "string",
#'               ForwardedValues = list(
#'                 QueryString = TRUE|FALSE,
#'                 Cookies = list(
#'                   Forward = "none"|"whitelist"|"all",
#'                   WhitelistedNames = list(
#'                     Quantity = 123,
#'                     Items = list(
#'                       "string"
#'                     )
#'                   )
#'                 ),
#'                 Headers = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 ),
#'                 QueryStringCacheKeys = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               MinTTL = 123,
#'               DefaultTTL = 123,
#'               MaxTTL = 123
#'             )
#'           )
#'         ),
#'         CustomErrorResponses = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               ErrorCode = 123,
#'               ResponsePagePath = "string",
#'               ResponseCode = "string",
#'               ErrorCachingMinTTL = 123
#'             )
#'           )
#'         ),
#'         Comment = "string",
#'         PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'         Enabled = TRUE|FALSE,
#'         ViewerCertificate = list(
#'           CloudFrontDefaultCertificate = TRUE|FALSE,
#'           IAMCertificateId = "string",
#'           ACMCertificateArn = "string",
#'           SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'           MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'           Certificate = "string",
#'           CertificateSource = "cloudfront"|"iam"|"acm"
#'         ),
#'         Restrictions = list(
#'           GeoRestriction = list(
#'             RestrictionType = "blacklist"|"whitelist"|"none",
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         WebACLId = "string",
#'         HttpVersion = "http1.1"|"http2",
#'         IsIPV6Enabled = TRUE|FALSE,
#'         AliasICPRecordals = list(
#'           list(
#'             CNAME = "string",
#'             ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions_by_web_acl_id(
#'   Marker = "string",
#'   MaxItems = "string",
#'   WebACLId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_web_acl_id
cloudfront_list_distributions_by_web_acl_id <- function(Marker = NULL, MaxItems = NULL, WebACLId) {
  op <- new_operation(
    name = "ListDistributionsByWebACLId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByWebACLId/{WebACLId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_web_acl_id_input(Marker = Marker, MaxItems = MaxItems, WebACLId = WebACLId)
  output <- .cloudfront$list_distributions_by_web_acl_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_web_acl_id <- cloudfront_list_distributions_by_web_acl_id

#' List all field-level encryption configurations that have been created in
#' CloudFront for this account
#'
#' @description
#' List all field-level encryption configurations that have been created in
#' CloudFront for this account.
#'
#' @usage
#' cloudfront_list_field_level_encryption_configs(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of configurations. The results include configurations in the list that
#' occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page's
#' response (which is also the ID of the last configuration on that page).
#' @param MaxItems The maximum number of field-level encryption configurations you want in
#' the response body.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionList = list(
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         LastModifiedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Comment = "string",
#'         QueryArgProfileConfig = list(
#'           ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'           QueryArgProfiles = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 QueryArg = "string",
#'                 ProfileId = "string"
#'               )
#'             )
#'           )
#'         ),
#'         ContentTypeProfileConfig = list(
#'           ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'           ContentTypeProfiles = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 Format = "URLEncoded",
#'                 ProfileId = "string",
#'                 ContentType = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_field_level_encryption_configs(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_field_level_encryption_configs
cloudfront_list_field_level_encryption_configs <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFieldLevelEncryptionConfigs",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption",
    paginator = list()
  )
  input <- .cloudfront$list_field_level_encryption_configs_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_field_level_encryption_configs_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_field_level_encryption_configs <- cloudfront_list_field_level_encryption_configs

#' Request a list of field-level encryption profiles that have been created
#' in CloudFront for this account
#'
#' @description
#' Request a list of field-level encryption profiles that have been created
#' in CloudFront for this account.
#'
#' @usage
#' cloudfront_list_field_level_encryption_profiles(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of profiles. The results include profiles in the list that occur after
#' the marker. To get the next page of results, set the `Marker` to the
#' value of the `NextMarker` from the current page's response (which is
#' also the ID of the last profile on that page).
#' @param MaxItems The maximum number of field-level encryption profiles you want in the
#' response body.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionProfileList = list(
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         LastModifiedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Name = "string",
#'         EncryptionEntities = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               PublicKeyId = "string",
#'               ProviderId = "string",
#'               FieldPatterns = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         Comment = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_field_level_encryption_profiles(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_field_level_encryption_profiles
cloudfront_list_field_level_encryption_profiles <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFieldLevelEncryptionProfiles",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption-profile",
    paginator = list()
  )
  input <- .cloudfront$list_field_level_encryption_profiles_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_field_level_encryption_profiles_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_field_level_encryption_profiles <- cloudfront_list_field_level_encryption_profiles

#' Lists invalidation batches
#'
#' @description
#' Lists invalidation batches.
#'
#' @usage
#' cloudfront_list_invalidations(DistributionId, Marker, MaxItems)
#'
#' @param DistributionId &#91;required&#93; The distribution's ID.
#' @param Marker Use this parameter when paginating results to indicate where to begin in
#' your list of invalidation batches. Because the results are returned in
#' decreasing order from most recent to oldest, the most recent results are
#' on the first page, the second page will contain earlier results, and so
#' on. To get the next page of results, set `Marker` to the value of the
#' `NextMarker` from the current page's response. This value is the same as
#' the ID of the last invalidation batch on that page.
#' @param MaxItems The maximum number of invalidation batches that you want in the response
#' body.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InvalidationList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         CreateTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Status = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_invalidations(
#'   DistributionId = "string",
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_invalidations
cloudfront_list_invalidations <- function(DistributionId, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInvalidations",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{DistributionId}/invalidation",
    paginator = list()
  )
  input <- .cloudfront$list_invalidations_input(DistributionId = DistributionId, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_invalidations_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_invalidations <- cloudfront_list_invalidations

#' Gets a list of key groups
#'
#' @description
#' Gets a list of key groups.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_key_groups(Marker, MaxItems)
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of key groups. The response includes key groups in the list
#' that occur after the marker. To get the next page of the list, set this
#' field’s value to the value of `NextMarker` from the current page’s
#' response.
#' @param MaxItems The maximum number of key groups that you want in the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyGroupList = list(
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         KeyGroup = list(
#'           Id = "string",
#'           LastModifiedTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           KeyGroupConfig = list(
#'             Name = "string",
#'             Items = list(
#'               "string"
#'             ),
#'             Comment = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_key_groups(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_key_groups
cloudfront_list_key_groups <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListKeyGroups",
    http_method = "GET",
    http_path = "/2020-05-31/key-group",
    paginator = list()
  )
  input <- .cloudfront$list_key_groups_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_key_groups_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_key_groups <- cloudfront_list_key_groups

#' Gets a list of origin request policies
#'
#' @description
#' Gets a list of origin request policies.
#' 
#' You can optionally apply a filter to return only the managed policies
#' created by AWS, or only the custom policies created in your AWS account.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_origin_request_policies(Type, Marker, MaxItems)
#'
#' @param Type A filter to return only the specified kinds of origin request policies.
#' Valid values are:
#' 
#' -   `managed` – Returns only the managed policies created by AWS.
#' 
#' -   `custom` – Returns only the custom policies created in your AWS
#'     account.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of origin request policies. The response includes origin
#' request policies in the list that occur after the marker. To get the
#' next page of the list, set this field’s value to the value of
#' `NextMarker` from the current page’s response.
#' @param MaxItems The maximum number of origin request policies that you want in the
#' response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OriginRequestPolicyList = list(
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Type = "managed"|"custom",
#'         OriginRequestPolicy = list(
#'           Id = "string",
#'           LastModifiedTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           OriginRequestPolicyConfig = list(
#'             Comment = "string",
#'             Name = "string",
#'             HeadersConfig = list(
#'               HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             CookiesConfig = list(
#'               CookieBehavior = "none"|"whitelist"|"all",
#'               Cookies = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             QueryStringsConfig = list(
#'               QueryStringBehavior = "none"|"whitelist"|"all",
#'               QueryStrings = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_origin_request_policies(
#'   Type = "managed"|"custom",
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_origin_request_policies
cloudfront_list_origin_request_policies <- function(Type = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListOriginRequestPolicies",
    http_method = "GET",
    http_path = "/2020-05-31/origin-request-policy",
    paginator = list()
  )
  input <- .cloudfront$list_origin_request_policies_input(Type = Type, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_origin_request_policies_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_origin_request_policies <- cloudfront_list_origin_request_policies

#' List all public keys that have been added to CloudFront for this account
#'
#' @description
#' List all public keys that have been added to CloudFront for this
#' account.
#'
#' @usage
#' cloudfront_list_public_keys(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of public keys. The results include public keys in the list that occur
#' after the marker. To get the next page of results, set the `Marker` to
#' the value of the `NextMarker` from the current page's response (which is
#' also the ID of the last public key on that page).
#' @param MaxItems The maximum number of public keys you want in the response body.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKeyList = list(
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         Name = "string",
#'         CreatedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         EncodedKey = "string",
#'         Comment = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_public_keys(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_public_keys
cloudfront_list_public_keys <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "GET",
    http_path = "/2020-05-31/public-key",
    paginator = list()
  )
  input <- .cloudfront$list_public_keys_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_public_keys_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_public_keys <- cloudfront_list_public_keys

#' Gets a list of real-time log configurations
#'
#' @description
#' Gets a list of real-time log configurations.
#' 
#' You can optionally specify the maximum number of items to receive in the
#' response. If the total number of items in the list exceeds the maximum
#' that you specify, or the default maximum, the response is paginated. To
#' get the next page of items, send a subsequent request that specifies the
#' `NextMarker` value from the current response as the `Marker` value in
#' the subsequent request.
#'
#' @usage
#' cloudfront_list_realtime_log_configs(MaxItems, Marker)
#'
#' @param MaxItems The maximum number of real-time log configurations that you want in the
#' response.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of real-time log configurations. The response includes
#' real-time log configurations in the list that occur after the marker. To
#' get the next page of the list, set this field’s value to the value of
#' `NextMarker` from the current page’s response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RealtimeLogConfigs = list(
#'     MaxItems = 123,
#'     Items = list(
#'       list(
#'         ARN = "string",
#'         Name = "string",
#'         SamplingRate = 123,
#'         EndPoints = list(
#'           list(
#'             StreamType = "string",
#'             KinesisStreamConfig = list(
#'               RoleARN = "string",
#'               StreamARN = "string"
#'             )
#'           )
#'         ),
#'         Fields = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     IsTruncated = TRUE|FALSE,
#'     Marker = "string",
#'     NextMarker = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_realtime_log_configs(
#'   MaxItems = "string",
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_realtime_log_configs
cloudfront_list_realtime_log_configs <- function(MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListRealtimeLogConfigs",
    http_method = "GET",
    http_path = "/2020-05-31/realtime-log-config",
    paginator = list()
  )
  input <- .cloudfront$list_realtime_log_configs_input(MaxItems = MaxItems, Marker = Marker)
  output <- .cloudfront$list_realtime_log_configs_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_realtime_log_configs <- cloudfront_list_realtime_log_configs

#' List streaming distributions
#'
#' @description
#' List streaming distributions.
#'
#' @usage
#' cloudfront_list_streaming_distributions(Marker, MaxItems)
#'
#' @param Marker The value that you provided for the `Marker` request parameter.
#' @param MaxItems The value that you provided for the `MaxItems` request parameter.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingDistributionList = list(
#'     Marker = "string",
#'     NextMarker = "string",
#'     MaxItems = 123,
#'     IsTruncated = TRUE|FALSE,
#'     Quantity = 123,
#'     Items = list(
#'       list(
#'         Id = "string",
#'         ARN = "string",
#'         Status = "string",
#'         LastModifiedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         DomainName = "string",
#'         S3Origin = list(
#'           DomainName = "string",
#'           OriginAccessIdentity = "string"
#'         ),
#'         Aliases = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         Comment = "string",
#'         PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'         Enabled = TRUE|FALSE
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_streaming_distributions(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_streaming_distributions
cloudfront_list_streaming_distributions <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListStreamingDistributions",
    http_method = "GET",
    http_path = "/2020-05-31/streaming-distribution",
    paginator = list()
  )
  input <- .cloudfront$list_streaming_distributions_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_streaming_distributions_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_streaming_distributions <- cloudfront_list_streaming_distributions

#' List tags for a CloudFront resource
#'
#' @description
#' List tags for a CloudFront resource.
#'
#' @usage
#' cloudfront_list_tags_for_resource(Resource)
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     Items = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_tags_for_resource
cloudfront_list_tags_for_resource <- function(Resource) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2020-05-31/tagging",
    paginator = list()
  )
  input <- .cloudfront$list_tags_for_resource_input(Resource = Resource)
  output <- .cloudfront$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_tags_for_resource <- cloudfront_list_tags_for_resource

#' Add tags to a CloudFront resource
#'
#' @description
#' Add tags to a CloudFront resource.
#'
#' @usage
#' cloudfront_tag_resource(Resource, Tags)
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#' @param Tags &#91;required&#93; A complex type that contains zero or more `Tag` elements.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   Resource = "string",
#'   Tags = list(
#'     Items = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_tag_resource
cloudfront_tag_resource <- function(Resource, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2020-05-31/tagging?Operation=Tag",
    paginator = list()
  )
  input <- .cloudfront$tag_resource_input(Resource = Resource, Tags = Tags)
  output <- .cloudfront$tag_resource_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$tag_resource <- cloudfront_tag_resource

#' Remove tags from a CloudFront resource
#'
#' @description
#' Remove tags from a CloudFront resource.
#'
#' @usage
#' cloudfront_untag_resource(Resource, TagKeys)
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#' @param TagKeys &#91;required&#93; A complex type that contains zero or more `Tag` key elements.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   Resource = "string",
#'   TagKeys = list(
#'     Items = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_untag_resource
cloudfront_untag_resource <- function(Resource, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/2020-05-31/tagging?Operation=Untag",
    paginator = list()
  )
  input <- .cloudfront$untag_resource_input(Resource = Resource, TagKeys = TagKeys)
  output <- .cloudfront$untag_resource_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$untag_resource <- cloudfront_untag_resource

#' Updates a cache policy configuration
#'
#' @description
#' Updates a cache policy configuration.
#' 
#' When you update a cache policy configuration, all the fields are updated
#' with the values provided in the request. You cannot update some fields
#' independent of others. To update a cache policy configuration:
#' 
#' 1.  Use [`get_cache_policy_config`][cloudfront_get_cache_policy_config]
#'     to get the current configuration.
#' 
#' 2.  Locally modify the fields in the cache policy configuration that you
#'     want to update.
#' 
#' 3.  Call [`update_cache_policy`][cloudfront_update_cache_policy] by
#'     providing the entire cache policy configuration, including the
#'     fields that you modified and those that you didn’t.
#'
#' @usage
#' cloudfront_update_cache_policy(CachePolicyConfig, Id, IfMatch)
#'
#' @param CachePolicyConfig &#91;required&#93; A cache policy configuration.
#' @param Id &#91;required&#93; The unique identifier for the cache policy that you are updating. The
#' identifier is returned in a cache behavior’s `CachePolicyId` field in
#' the response to
#' [`get_distribution_config`][cloudfront_get_distribution_config].
#' @param IfMatch The version of the cache policy that you are updating. The version is
#' returned in the cache policy’s `ETag` field in the response to
#' [`get_cache_policy_config`][cloudfront_get_cache_policy_config].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CachePolicy = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CachePolicyConfig = list(
#'       Comment = "string",
#'       Name = "string",
#'       DefaultTTL = 123,
#'       MaxTTL = 123,
#'       MinTTL = 123,
#'       ParametersInCacheKeyAndForwardedToOrigin = list(
#'         EnableAcceptEncodingGzip = TRUE|FALSE,
#'         EnableAcceptEncodingBrotli = TRUE|FALSE,
#'         HeadersConfig = list(
#'           HeaderBehavior = "none"|"whitelist",
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         CookiesConfig = list(
#'           CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'           Cookies = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         QueryStringsConfig = list(
#'           QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'           QueryStrings = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_cache_policy(
#'   CachePolicyConfig = list(
#'     Comment = "string",
#'     Name = "string",
#'     DefaultTTL = 123,
#'     MaxTTL = 123,
#'     MinTTL = 123,
#'     ParametersInCacheKeyAndForwardedToOrigin = list(
#'       EnableAcceptEncodingGzip = TRUE|FALSE,
#'       EnableAcceptEncodingBrotli = TRUE|FALSE,
#'       HeadersConfig = list(
#'         HeaderBehavior = "none"|"whitelist",
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CookiesConfig = list(
#'         CookieBehavior = "none"|"whitelist"|"allExcept"|"all",
#'         Cookies = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       QueryStringsConfig = list(
#'         QueryStringBehavior = "none"|"whitelist"|"allExcept"|"all",
#'         QueryStrings = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_cache_policy
cloudfront_update_cache_policy <- function(CachePolicyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateCachePolicy",
    http_method = "PUT",
    http_path = "/2020-05-31/cache-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_cache_policy_input(CachePolicyConfig = CachePolicyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_cache_policy <- cloudfront_update_cache_policy

#' Update an origin access identity
#'
#' @description
#' Update an origin access identity.
#'
#' @usage
#' cloudfront_update_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig, Id, IfMatch)
#'
#' @param CloudFrontOriginAccessIdentityConfig &#91;required&#93; The identity's configuration information.
#' @param Id &#91;required&#93; The identity's id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' identity's configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CloudFrontOriginAccessIdentity = list(
#'     Id = "string",
#'     S3CanonicalUserId = "string",
#'     CloudFrontOriginAccessIdentityConfig = list(
#'       CallerReference = "string",
#'       Comment = "string"
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig = list(
#'     CallerReference = "string",
#'     Comment = "string"
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_cloud_front_origin_access_identity
cloudfront_update_cloud_front_origin_access_identity <- function(CloudFrontOriginAccessIdentityConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateCloudFrontOriginAccessIdentity",
    http_method = "PUT",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_cloud_front_origin_access_identity_input(CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_cloud_front_origin_access_identity <- cloudfront_update_cloud_front_origin_access_identity

#' Updates the configuration for a web distribution
#'
#' @description
#' Updates the configuration for a web distribution.
#' 
#' When you update a distribution, there are more required fields than when
#' you create a distribution. When you update your distribution by using
#' this API action, follow the steps here to get the current configuration
#' and then make your updates, to make sure that you include all of the
#' required fields. To view a summary, see [Required Fields for Create
#' Distribution and Update
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
#' in the *Amazon CloudFront Developer Guide*.
#' 
#' The update process includes getting the current distribution
#' configuration, updating the XML document that is returned to make your
#' changes, and then submitting an
#' [`update_distribution`][cloudfront_update_distribution] request to make
#' the updates.
#' 
#' For information about updating a distribution using the CloudFront
#' console instead, see [Creating a
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html)
#' in the *Amazon CloudFront Developer Guide*.
#' 
#' **To update a web distribution using the CloudFront API**
#' 
#' 1.  Submit a
#'     [`get_distribution_config`][cloudfront_get_distribution_config]
#'     request to get the current configuration and an `Etag` header for
#'     the distribution.
#' 
#'     If you update the distribution again, you must get a new `Etag`
#'     header.
#' 
#' 2.  Update the XML document that was returned in the response to your
#'     [`get_distribution_config`][cloudfront_get_distribution_config]
#'     request to include your changes.
#' 
#'     When you edit the XML file, be aware of the following:
#' 
#'     -   You must strip out the ETag parameter that is returned.
#' 
#'     -   Additional fields are required when you update a distribution.
#'         There may be fields included in the XML file for features that
#'         you haven't configured for your distribution. This is expected
#'         and required to successfully update the distribution.
#' 
#'     -   You can't change the value of `CallerReference`. If you try to
#'         change this value, CloudFront returns an `IllegalUpdate` error.
#' 
#'     -   The new configuration replaces the existing configuration; the
#'         values that you specify in an
#'         [`update_distribution`][cloudfront_update_distribution] request
#'         are not merged into your existing configuration. When you add,
#'         delete, or replace values in an element that allows multiple
#'         values (for example, `CNAME`), you must specify all of the
#'         values that you want to appear in the updated distribution. In
#'         addition, you must update the corresponding `Quantity` element.
#' 
#' 3.  Submit an [`update_distribution`][cloudfront_update_distribution]
#'     request to update the configuration for your distribution:
#' 
#'     -   In the request body, include the XML document that you updated
#'         in Step 2. The request body must include an XML document with a
#'         `DistributionConfig` element.
#' 
#'     -   Set the value of the HTTP `If-Match` header to the value of the
#'         `ETag` header that CloudFront returned when you submitted the
#'         [`get_distribution_config`][cloudfront_get_distribution_config]
#'         request in Step 1.
#' 
#' 4.  Review the response to the
#'     [`update_distribution`][cloudfront_update_distribution] request to
#'     confirm that the configuration was successfully updated.
#' 
#' 5.  Optional: Submit a [`get_distribution`][cloudfront_get_distribution]
#'     request to confirm that your changes have propagated. When
#'     propagation is complete, the value of `Status` is `Deployed`.
#'
#' @usage
#' cloudfront_update_distribution(DistributionConfig, Id, IfMatch)
#'
#' @param DistributionConfig &#91;required&#93; The distribution's configuration information.
#' @param Id &#91;required&#93; The distribution's id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' distribution's configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Distribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InProgressInvalidationBatches = 123,
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     ActiveTrustedKeyGroups = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           KeyGroupId = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DistributionConfig = list(
#'       CallerReference = "string",
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       DefaultRootObject = "string",
#'       Origins = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             DomainName = "string",
#'             OriginPath = "string",
#'             CustomHeaders = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   HeaderName = "string",
#'                   HeaderValue = "string"
#'                 )
#'               )
#'             ),
#'             S3OriginConfig = list(
#'               OriginAccessIdentity = "string"
#'             ),
#'             CustomOriginConfig = list(
#'               HTTPPort = 123,
#'               HTTPSPort = 123,
#'               OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'               OriginSslProtocols = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                 )
#'               ),
#'               OriginReadTimeout = 123,
#'               OriginKeepaliveTimeout = 123
#'             ),
#'             ConnectionAttempts = 123,
#'             ConnectionTimeout = 123,
#'             OriginShield = list(
#'               Enabled = TRUE|FALSE,
#'               OriginShieldRegion = "string"
#'             )
#'           )
#'         )
#'       ),
#'       OriginGroups = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             FailoverCriteria = list(
#'               StatusCodes = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   123
#'                 )
#'               )
#'             ),
#'             Members = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   OriginId = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       DefaultCacheBehavior = list(
#'         TargetOriginId = "string",
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         TrustedKeyGroups = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'         AllowedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           ),
#'           CachedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             )
#'           )
#'         ),
#'         SmoothStreaming = TRUE|FALSE,
#'         Compress = TRUE|FALSE,
#'         LambdaFunctionAssociations = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               LambdaFunctionARN = "string",
#'               EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'               IncludeBody = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         FieldLevelEncryptionId = "string",
#'         RealtimeLogConfigArn = "string",
#'         CachePolicyId = "string",
#'         OriginRequestPolicyId = "string",
#'         ForwardedValues = list(
#'           QueryString = TRUE|FALSE,
#'           Cookies = list(
#'             Forward = "none"|"whitelist"|"all",
#'             WhitelistedNames = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           QueryStringCacheKeys = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MinTTL = 123,
#'         DefaultTTL = 123,
#'         MaxTTL = 123
#'       ),
#'       CacheBehaviors = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PathPattern = "string",
#'             TargetOriginId = "string",
#'             TrustedSigners = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             TrustedKeyGroups = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'             AllowedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               ),
#'               CachedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 )
#'               )
#'             ),
#'             SmoothStreaming = TRUE|FALSE,
#'             Compress = TRUE|FALSE,
#'             LambdaFunctionAssociations = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   LambdaFunctionARN = "string",
#'                   EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                   IncludeBody = TRUE|FALSE
#'                 )
#'               )
#'             ),
#'             FieldLevelEncryptionId = "string",
#'             RealtimeLogConfigArn = "string",
#'             CachePolicyId = "string",
#'             OriginRequestPolicyId = "string",
#'             ForwardedValues = list(
#'               QueryString = TRUE|FALSE,
#'               Cookies = list(
#'                 Forward = "none"|"whitelist"|"all",
#'                 WhitelistedNames = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               QueryStringCacheKeys = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             MinTTL = 123,
#'             DefaultTTL = 123,
#'             MaxTTL = 123
#'           )
#'         )
#'       ),
#'       CustomErrorResponses = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             ErrorCode = 123,
#'             ResponsePagePath = "string",
#'             ResponseCode = "string",
#'             ErrorCachingMinTTL = 123
#'           )
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         IncludeCookies = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE,
#'       ViewerCertificate = list(
#'         CloudFrontDefaultCertificate = TRUE|FALSE,
#'         IAMCertificateId = "string",
#'         ACMCertificateArn = "string",
#'         SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'         MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'         Certificate = "string",
#'         CertificateSource = "cloudfront"|"iam"|"acm"
#'       ),
#'       Restrictions = list(
#'         GeoRestriction = list(
#'           RestrictionType = "blacklist"|"whitelist"|"none",
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       WebACLId = "string",
#'       HttpVersion = "http1.1"|"http2",
#'       IsIPV6Enabled = TRUE|FALSE
#'     ),
#'     AliasICPRecordals = list(
#'       list(
#'         CNAME = "string",
#'         ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_distribution(
#'   DistributionConfig = list(
#'     CallerReference = "string",
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     DefaultRootObject = "string",
#'     Origins = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           DomainName = "string",
#'           OriginPath = "string",
#'           CustomHeaders = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 HeaderName = "string",
#'                 HeaderValue = "string"
#'               )
#'             )
#'           ),
#'           S3OriginConfig = list(
#'             OriginAccessIdentity = "string"
#'           ),
#'           CustomOriginConfig = list(
#'             HTTPPort = 123,
#'             HTTPSPort = 123,
#'             OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'             OriginSslProtocols = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'               )
#'             ),
#'             OriginReadTimeout = 123,
#'             OriginKeepaliveTimeout = 123
#'           ),
#'           ConnectionAttempts = 123,
#'           ConnectionTimeout = 123,
#'           OriginShield = list(
#'             Enabled = TRUE|FALSE,
#'             OriginShieldRegion = "string"
#'           )
#'         )
#'       )
#'     ),
#'     OriginGroups = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           FailoverCriteria = list(
#'             StatusCodes = list(
#'               Quantity = 123,
#'               Items = list(
#'                 123
#'               )
#'             )
#'           ),
#'           Members = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 OriginId = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DefaultCacheBehavior = list(
#'       TargetOriginId = "string",
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       TrustedKeyGroups = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'       AllowedMethods = list(
#'         Quantity = 123,
#'         Items = list(
#'           "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'         ),
#'         CachedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           )
#'         )
#'       ),
#'       SmoothStreaming = TRUE|FALSE,
#'       Compress = TRUE|FALSE,
#'       LambdaFunctionAssociations = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             LambdaFunctionARN = "string",
#'             EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'             IncludeBody = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       FieldLevelEncryptionId = "string",
#'       RealtimeLogConfigArn = "string",
#'       CachePolicyId = "string",
#'       OriginRequestPolicyId = "string",
#'       ForwardedValues = list(
#'         QueryString = TRUE|FALSE,
#'         Cookies = list(
#'           Forward = "none"|"whitelist"|"all",
#'           WhitelistedNames = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         QueryStringCacheKeys = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       MinTTL = 123,
#'       DefaultTTL = 123,
#'       MaxTTL = 123
#'     ),
#'     CacheBehaviors = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PathPattern = "string",
#'           TargetOriginId = "string",
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           TrustedKeyGroups = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string",
#'           RealtimeLogConfigArn = "string",
#'           CachePolicyId = "string",
#'           OriginRequestPolicyId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           MinTTL = 123,
#'           DefaultTTL = 123,
#'           MaxTTL = 123
#'         )
#'       )
#'     ),
#'     CustomErrorResponses = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           ErrorCode = 123,
#'           ResponsePagePath = "string",
#'           ResponseCode = "string",
#'           ErrorCachingMinTTL = 123
#'         )
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       IncludeCookies = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE,
#'     ViewerCertificate = list(
#'       CloudFrontDefaultCertificate = TRUE|FALSE,
#'       IAMCertificateId = "string",
#'       ACMCertificateArn = "string",
#'       SSLSupportMethod = "sni-only"|"vip"|"static-ip",
#'       MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
#'       Certificate = "string",
#'       CertificateSource = "cloudfront"|"iam"|"acm"
#'     ),
#'     Restrictions = list(
#'       GeoRestriction = list(
#'         RestrictionType = "blacklist"|"whitelist"|"none",
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     WebACLId = "string",
#'     HttpVersion = "http1.1"|"http2",
#'     IsIPV6Enabled = TRUE|FALSE
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_distribution
cloudfront_update_distribution <- function(DistributionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateDistribution",
    http_method = "PUT",
    http_path = "/2020-05-31/distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_distribution_input(DistributionConfig = DistributionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_distribution <- cloudfront_update_distribution

#' Update a field-level encryption configuration
#'
#' @description
#' Update a field-level encryption configuration.
#'
#' @usage
#' cloudfront_update_field_level_encryption_config(
#'   FieldLevelEncryptionConfig, Id, IfMatch)
#'
#' @param FieldLevelEncryptionConfig &#91;required&#93; Request to update a field-level encryption configuration.
#' @param Id &#91;required&#93; The ID of the configuration you want to update.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' configuration identity to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryption = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FieldLevelEncryptionConfig = list(
#'       CallerReference = "string",
#'       Comment = "string",
#'       QueryArgProfileConfig = list(
#'         ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'         QueryArgProfiles = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               QueryArg = "string",
#'               ProfileId = "string"
#'             )
#'           )
#'         )
#'       ),
#'       ContentTypeProfileConfig = list(
#'         ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'         ContentTypeProfiles = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               Format = "URLEncoded",
#'               ProfileId = "string",
#'               ContentType = "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_field_level_encryption_config(
#'   FieldLevelEncryptionConfig = list(
#'     CallerReference = "string",
#'     Comment = "string",
#'     QueryArgProfileConfig = list(
#'       ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'       QueryArgProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             QueryArg = "string",
#'             ProfileId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ContentTypeProfileConfig = list(
#'       ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'       ContentTypeProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Format = "URLEncoded",
#'             ProfileId = "string",
#'             ContentType = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_field_level_encryption_config
cloudfront_update_field_level_encryption_config <- function(FieldLevelEncryptionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateFieldLevelEncryptionConfig",
    http_method = "PUT",
    http_path = "/2020-05-31/field-level-encryption/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_field_level_encryption_config_input(FieldLevelEncryptionConfig = FieldLevelEncryptionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_field_level_encryption_config <- cloudfront_update_field_level_encryption_config

#' Update a field-level encryption profile
#'
#' @description
#' Update a field-level encryption profile.
#'
#' @usage
#' cloudfront_update_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig, Id, IfMatch)
#'
#' @param FieldLevelEncryptionProfileConfig &#91;required&#93; Request to update a field-level encryption profile.
#' @param Id &#91;required&#93; The ID of the field-level encryption profile request.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' profile identity to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FieldLevelEncryptionProfile = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FieldLevelEncryptionProfileConfig = list(
#'       Name = "string",
#'       CallerReference = "string",
#'       Comment = "string",
#'       EncryptionEntities = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PublicKeyId = "string",
#'             ProviderId = "string",
#'             FieldPatterns = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig = list(
#'     Name = "string",
#'     CallerReference = "string",
#'     Comment = "string",
#'     EncryptionEntities = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PublicKeyId = "string",
#'           ProviderId = "string",
#'           FieldPatterns = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_field_level_encryption_profile
cloudfront_update_field_level_encryption_profile <- function(FieldLevelEncryptionProfileConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateFieldLevelEncryptionProfile",
    http_method = "PUT",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_field_level_encryption_profile_input(FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_field_level_encryption_profile <- cloudfront_update_field_level_encryption_profile

#' Updates a key group
#'
#' @description
#' Updates a key group.
#' 
#' When you update a key group, all the fields are updated with the values
#' provided in the request. You cannot update some fields independent of
#' others. To update a key group:
#' 
#' 1.  Get the current key group with
#'     [`get_key_group`][cloudfront_get_key_group] or
#'     [`get_key_group_config`][cloudfront_get_key_group_config].
#' 
#' 2.  Locally modify the fields in the key group that you want to update.
#'     For example, add or remove public key IDs.
#' 
#' 3.  Call [`update_key_group`][cloudfront_update_key_group] with the
#'     entire key group object, including the fields that you modified and
#'     those that you didn’t.
#'
#' @usage
#' cloudfront_update_key_group(KeyGroupConfig, Id, IfMatch)
#'
#' @param KeyGroupConfig &#91;required&#93; The key group configuration.
#' @param Id &#91;required&#93; The identifier of the key group that you are updating.
#' @param IfMatch The version of the key group that you are updating. The version is the
#' key group’s `ETag` value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   KeyGroup = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     KeyGroupConfig = list(
#'       Name = "string",
#'       Items = list(
#'         "string"
#'       ),
#'       Comment = "string"
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_key_group(
#'   KeyGroupConfig = list(
#'     Name = "string",
#'     Items = list(
#'       "string"
#'     ),
#'     Comment = "string"
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_key_group
cloudfront_update_key_group <- function(KeyGroupConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateKeyGroup",
    http_method = "PUT",
    http_path = "/2020-05-31/key-group/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_key_group_input(KeyGroupConfig = KeyGroupConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_key_group <- cloudfront_update_key_group

#' Updates an origin request policy configuration
#'
#' @description
#' Updates an origin request policy configuration.
#' 
#' When you update an origin request policy configuration, all the fields
#' are updated with the values provided in the request. You cannot update
#' some fields independent of others. To update an origin request policy
#' configuration:
#' 
#' 1.  Use
#'     [`get_origin_request_policy_config`][cloudfront_get_origin_request_policy_config]
#'     to get the current configuration.
#' 
#' 2.  Locally modify the fields in the origin request policy configuration
#'     that you want to update.
#' 
#' 3.  Call
#'     [`update_origin_request_policy`][cloudfront_update_origin_request_policy]
#'     by providing the entire origin request policy configuration,
#'     including the fields that you modified and those that you didn’t.
#'
#' @usage
#' cloudfront_update_origin_request_policy(OriginRequestPolicyConfig, Id,
#'   IfMatch)
#'
#' @param OriginRequestPolicyConfig &#91;required&#93; An origin request policy configuration.
#' @param Id &#91;required&#93; The unique identifier for the origin request policy that you are
#' updating. The identifier is returned in a cache behavior’s
#' `OriginRequestPolicyId` field in the response to
#' [`get_distribution_config`][cloudfront_get_distribution_config].
#' @param IfMatch The version of the origin request policy that you are updating. The
#' version is returned in the origin request policy’s `ETag` field in the
#' response to
#' [`get_origin_request_policy_config`][cloudfront_get_origin_request_policy_config].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OriginRequestPolicy = list(
#'     Id = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     OriginRequestPolicyConfig = list(
#'       Comment = "string",
#'       Name = "string",
#'       HeadersConfig = list(
#'         HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CookiesConfig = list(
#'         CookieBehavior = "none"|"whitelist"|"all",
#'         Cookies = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       QueryStringsConfig = list(
#'         QueryStringBehavior = "none"|"whitelist"|"all",
#'         QueryStrings = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_origin_request_policy(
#'   OriginRequestPolicyConfig = list(
#'     Comment = "string",
#'     Name = "string",
#'     HeadersConfig = list(
#'       HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
#'       Headers = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     CookiesConfig = list(
#'       CookieBehavior = "none"|"whitelist"|"all",
#'       Cookies = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     QueryStringsConfig = list(
#'       QueryStringBehavior = "none"|"whitelist"|"all",
#'       QueryStrings = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_origin_request_policy
cloudfront_update_origin_request_policy <- function(OriginRequestPolicyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateOriginRequestPolicy",
    http_method = "PUT",
    http_path = "/2020-05-31/origin-request-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_origin_request_policy_input(OriginRequestPolicyConfig = OriginRequestPolicyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_origin_request_policy <- cloudfront_update_origin_request_policy

#' Update public key information
#'
#' @description
#' Update public key information. Note that the only value you can change
#' is the comment.
#'
#' @usage
#' cloudfront_update_public_key(PublicKeyConfig, Id, IfMatch)
#'
#' @param PublicKeyConfig &#91;required&#93; A public key configuration.
#' @param Id &#91;required&#93; The identifier of the public key that you are updating.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' public key to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PublicKey = list(
#'     Id = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PublicKeyConfig = list(
#'       CallerReference = "string",
#'       Name = "string",
#'       EncodedKey = "string",
#'       Comment = "string"
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_public_key(
#'   PublicKeyConfig = list(
#'     CallerReference = "string",
#'     Name = "string",
#'     EncodedKey = "string",
#'     Comment = "string"
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_public_key
cloudfront_update_public_key <- function(PublicKeyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdatePublicKey",
    http_method = "PUT",
    http_path = "/2020-05-31/public-key/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_public_key_input(PublicKeyConfig = PublicKeyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_public_key <- cloudfront_update_public_key

#' Updates a real-time log configuration
#'
#' @description
#' Updates a real-time log configuration.
#' 
#' When you update a real-time log configuration, all the parameters are
#' updated with the values provided in the request. You cannot update some
#' parameters independent of others. To update a real-time log
#' configuration:
#' 
#' 1.  Call [`get_realtime_log_config`][cloudfront_get_realtime_log_config]
#'     to get the current real-time log configuration.
#' 
#' 2.  Locally modify the parameters in the real-time log configuration
#'     that you want to update.
#' 
#' 3.  Call this API
#'     ([`update_realtime_log_config`][cloudfront_update_realtime_log_config])
#'     by providing the entire real-time log configuration, including the
#'     parameters that you modified and those that you didn’t.
#' 
#' You cannot update a real-time log configuration’s `Name` or `ARN`.
#'
#' @usage
#' cloudfront_update_realtime_log_config(EndPoints, Fields, Name, ARN,
#'   SamplingRate)
#'
#' @param EndPoints Contains information about the Amazon Kinesis data stream where you are
#' sending real-time log data.
#' @param Fields A list of fields to include in each real-time log record.
#' 
#' For more information about fields, see [Real-time log configuration
#' fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
#' in the *Amazon CloudFront Developer Guide*.
#' @param Name The name for this real-time log configuration.
#' @param ARN The Amazon Resource Name (ARN) for this real-time log configuration.
#' @param SamplingRate The sampling rate for this real-time log configuration. The sampling
#' rate determines the percentage of viewer requests that are represented
#' in the real-time log data. You must provide an integer between 1 and
#' 100, inclusive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RealtimeLogConfig = list(
#'     ARN = "string",
#'     Name = "string",
#'     SamplingRate = 123,
#'     EndPoints = list(
#'       list(
#'         StreamType = "string",
#'         KinesisStreamConfig = list(
#'           RoleARN = "string",
#'           StreamARN = "string"
#'         )
#'       )
#'     ),
#'     Fields = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_realtime_log_config(
#'   EndPoints = list(
#'     list(
#'       StreamType = "string",
#'       KinesisStreamConfig = list(
#'         RoleARN = "string",
#'         StreamARN = "string"
#'       )
#'     )
#'   ),
#'   Fields = list(
#'     "string"
#'   ),
#'   Name = "string",
#'   ARN = "string",
#'   SamplingRate = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_realtime_log_config
cloudfront_update_realtime_log_config <- function(EndPoints = NULL, Fields = NULL, Name = NULL, ARN = NULL, SamplingRate = NULL) {
  op <- new_operation(
    name = "UpdateRealtimeLogConfig",
    http_method = "PUT",
    http_path = "/2020-05-31/realtime-log-config/",
    paginator = list()
  )
  input <- .cloudfront$update_realtime_log_config_input(EndPoints = EndPoints, Fields = Fields, Name = Name, ARN = ARN, SamplingRate = SamplingRate)
  output <- .cloudfront$update_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_realtime_log_config <- cloudfront_update_realtime_log_config

#' Update a streaming distribution
#'
#' @description
#' Update a streaming distribution.
#'
#' @usage
#' cloudfront_update_streaming_distribution(StreamingDistributionConfig,
#'   Id, IfMatch)
#'
#' @param StreamingDistributionConfig &#91;required&#93; The streaming distribution's configuration information.
#' @param Id &#91;required&#93; The streaming distribution's id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' streaming distribution's configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingDistribution = list(
#'     Id = "string",
#'     ARN = "string",
#'     Status = "string",
#'     LastModifiedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DomainName = "string",
#'     ActiveTrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           AwsAccountNumber = "string",
#'           KeyPairIds = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     StreamingDistributionConfig = list(
#'       CallerReference = "string",
#'       S3Origin = list(
#'         DomainName = "string",
#'         OriginAccessIdentity = "string"
#'       ),
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   ETag = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_streaming_distribution(
#'   StreamingDistributionConfig = list(
#'     CallerReference = "string",
#'     S3Origin = list(
#'       DomainName = "string",
#'       OriginAccessIdentity = "string"
#'     ),
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     TrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_streaming_distribution
cloudfront_update_streaming_distribution <- function(StreamingDistributionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateStreamingDistribution",
    http_method = "PUT",
    http_path = "/2020-05-31/streaming-distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_streaming_distribution_input(StreamingDistributionConfig = StreamingDistributionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_streaming_distribution <- cloudfront_update_streaming_distribution
