% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_disassociate_resolver_rule}
\alias{route53resolver_disassociate_resolver_rule}
\title{Removes the association between a specified Resolver rule and a
specified VPC}
\usage{
route53resolver_disassociate_resolver_rule(VPCId, ResolverRuleId)
}
\arguments{
\item{VPCId}{[required] The ID of the VPC that you want to disassociate the Resolver rule from.}

\item{ResolverRuleId}{[required] The ID of the Resolver rule that you want to disassociate from the
specified VPC.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResolverRuleAssociation = list(
    Id = "string",
    ResolverRuleId = "string",
    Name = "string",
    VPCId = "string",
    Status = "CREATING"|"COMPLETE"|"DELETING"|"FAILED"|"OVERRIDDEN",
    StatusMessage = "string"
  )
)
}
}
\description{
Removes the association between a specified Resolver rule and a
specified VPC.

If you disassociate a Resolver rule from a VPC, Resolver stops
forwarding DNS queries for the domain name that you specified in the
Resolver rule.
}
\section{Request syntax}{
\preformatted{svc$disassociate_resolver_rule(
  VPCId = "string",
  ResolverRuleId = "string"
)
}
}

\keyword{internal}
