% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_create_virtual_gateway}
\alias{appmesh_create_virtual_gateway}
\title{Creates a virtual gateway}
\usage{
appmesh_create_virtual_gateway(clientToken, meshName, meshOwner, spec,
  tags, virtualGatewayName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh to create the virtual gateway in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then the account that you specify must share the mesh with
your account before you can create the resource in the service mesh. For
more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The virtual gateway specification to apply.}

\item{tags}{Optional metadata that you can apply to the virtual gateway to assist
with categorization and organization. Each tag consists of a key and an
optional value, both of which you define. Tag keys can have a maximum
character length of 128 characters, and tag values can have a maximum
length of 256 characters.}

\item{virtualGatewayName}{[required] The name to use for the virtual gateway.}
}
\description{
Creates a virtual gateway.

A virtual gateway allows resources outside your mesh to communicate to
resources that are inside your mesh. The virtual gateway represents an
Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or
on an Amazon EC2 instance. Unlike a virtual node, which represents an
Envoy running with an application, a virtual gateway represents Envoy
deployed by itself.

For more information about virtual gateways, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html}{Virtual gateways}.
}
\section{Request syntax}{
\preformatted{svc$create_virtual_gateway(
  clientToken = "string",
  meshName = "string",
  meshOwner = "string",
  spec = list(
    backendDefaults = list(
      clientPolicy = list(
        tls = list(
          enforce = TRUE|FALSE,
          ports = list(
            123
          ),
          validation = list(
            trust = list(
              acm = list(
                certificateAuthorityArns = list(
                  "string"
                )
              ),
              file = list(
                certificateChain = "string"
              )
            )
          )
        )
      )
    ),
    listeners = list(
      list(
        connectionPool = list(
          grpc = list(
            maxRequests = 123
          ),
          http = list(
            maxConnections = 123,
            maxPendingRequests = 123
          ),
          http2 = list(
            maxRequests = 123
          )
        ),
        healthCheck = list(
          healthyThreshold = 123,
          intervalMillis = 123,
          path = "string",
          port = 123,
          protocol = "http"|"http2"|"grpc",
          timeoutMillis = 123,
          unhealthyThreshold = 123
        ),
        portMapping = list(
          port = 123,
          protocol = "http"|"http2"|"grpc"
        ),
        tls = list(
          certificate = list(
            acm = list(
              certificateArn = "string"
            ),
            file = list(
              certificateChain = "string",
              privateKey = "string"
            )
          ),
          mode = "STRICT"|"PERMISSIVE"|"DISABLED"
        )
      )
    ),
    logging = list(
      accessLog = list(
        file = list(
          path = "string"
        )
      )
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  virtualGatewayName = "string"
)
}
}

\keyword{internal}
