% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_put_integration}
\alias{apigateway_put_integration}
\title{Sets up a method's integration}
\usage{
apigateway_put_integration(restApiId, resourceId, httpMethod, type,
  integrationHttpMethod, uri, connectionType, connectionId, credentials,
  requestParameters, requestTemplates, passthroughBehavior,
  cacheNamespace, cacheKeyParameters, contentHandling, timeoutInMillis)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] [Required] Specifies a put integration request's resource ID.}

\item{httpMethod}{[required] [Required] Specifies a put integration request's HTTP method.}

\item{type}{[required] [Required] Specifies a put integration input's type.}

\item{integrationHttpMethod}{Specifies a put integration HTTP method. When the integration type is
HTTP or AWS, this field is required.}

\item{uri}{Specifies Uniform Resource Identifier (URI) of the integration endpoint.
\itemize{
\item For \code{HTTP} or \code{HTTP_PROXY} integrations, the URI must be a fully
formed, encoded HTTP(S) URL according to the \href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{RFC-3986 specification},
for either standard integration, where \code{connectionType} is not
\code{VPC_LINK}, or private integration, where \code{connectionType} is
\code{VPC_LINK}. For a private HTTP integration, the URI is not used for
routing.
\item For \code{AWS} or \code{AWS_PROXY} integrations, the URI is of the form
\code{arn:aws:apigateway:\{region\}:\{subdomain.service|service\}:path|action/\{service_api\}}.
Here, \code{\{Region\}} is the API Gateway region (e.g., \code{us-east-1});
\code{\{service\}} is the name of the integrated AWS service (e.g., \code{s3});
and \code{\{subdomain\}} is a designated subdomain supported by certain AWS
service for fast host-name lookup. \code{action} can be used for an AWS
service action-based API, using an
\code{Action=\{name\}&amp;\{p1\}=\{v1\}&amp;p2=\{v2\}...} query string. The
ensuing \code{\{service_api\}} refers to a supported action \code{\{name\}} plus
any required input parameters. Alternatively, \code{path} can be used for
an AWS service path-based API. The ensuing \code{service_api} refers to
the path to an AWS service resource, including the region of the
integrated AWS service, if applicable. For example, for integration
with the S3 API of
\code{<a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a>},
the \code{uri} can be either
\code{arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket=\{bucket\}&amp;Key=\{key\}}
or \code{arn:aws:apigateway:us-west-2:s3:path/\{bucket\}/\{key\}}
}}

\item{connectionType}{The type of the network connection to the integration endpoint. The
valid value is \code{INTERNET} for connections through the public routable
internet or \code{VPC_LINK} for private connections between API Gateway and a
network load balancer in a VPC. The default value is \code{INTERNET}.}

\item{connectionId}{The
(\href{https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id}{id})
of the VpcLink used for the integration when \code{connectionType=VPC_LINK}
and undefined, otherwise.}

\item{credentials}{Specifies whether credentials are required for a put integration.}

\item{requestParameters}{A key-value map specifying request parameters that are passed from the
method request to the back end. The key is an integration request
parameter name and the associated value is a method request parameter
value or static value that must be enclosed within single quotes and
pre-encoded as required by the back end. The method request parameter
value must match the pattern of \code{method.request.\{location\}.\{name\}},
where \code{location} is \code{querystring}, \code{path}, or \code{header} and \code{name} must
be a valid and unique method request parameter name.}

\item{requestTemplates}{Represents a map of Velocity templates that are applied on the request
payload based on the value of the Content-Type header sent by the
client. The content type value is the key in this map, and the template
(as a String) is the value.}

\item{passthroughBehavior}{Specifies the pass-through behavior for incoming requests based on the
Content-Type header in the request, and the available mapping templates
specified as the \code{requestTemplates} property on the Integration
resource. There are three valid values: \code{WHEN_NO_MATCH},
\code{WHEN_NO_TEMPLATES}, and \code{NEVER}.
\itemize{
\item \code{WHEN_NO_MATCH} passes the request body for unmapped content types
through to the integration back end without transformation.
\item \code{NEVER} rejects unmapped content types with an HTTP 415
'Unsupported Media Type' response.
\item \code{WHEN_NO_TEMPLATES} allows pass-through when the integration has NO
content types mapped to templates. However if there is at least one
content type defined, unmapped content types will be rejected with
the same 415 response.
}}

\item{cacheNamespace}{Specifies a put integration input's cache namespace.}

\item{cacheKeyParameters}{Specifies a put integration input's cache key parameters.}

\item{contentHandling}{Specifies how to handle request payload content type conversions.
Supported values are \code{CONVERT_TO_BINARY} and \code{CONVERT_TO_TEXT}, with the
following behaviors:
\itemize{
\item \code{CONVERT_TO_BINARY}: Converts a request payload from a
Base64-encoded string to the corresponding binary blob.
\item \code{CONVERT_TO_TEXT}: Converts a request payload from a binary blob to
a Base64-encoded string.
}

If this property is not defined, the request payload will be passed
through from the method request to integration request without
modification, provided that the \code{passthroughBehaviors} is configured to
support payload pass-through.}

\item{timeoutInMillis}{Custom timeout between 50 and 29,000 milliseconds. The default value is
29,000 milliseconds or 29 seconds.}
}
\description{
Sets up a method's integration.
}
\section{Request syntax}{
\preformatted{svc$put_integration(
  restApiId = "string",
  resourceId = "string",
  httpMethod = "string",
  type = "HTTP"|"AWS"|"MOCK"|"HTTP_PROXY"|"AWS_PROXY",
  integrationHttpMethod = "string",
  uri = "string",
  connectionType = "INTERNET"|"VPC_LINK",
  connectionId = "string",
  credentials = "string",
  requestParameters = list(
    "string"
  ),
  requestTemplates = list(
    "string"
  ),
  passthroughBehavior = "string",
  cacheNamespace = "string",
  cacheKeyParameters = list(
    "string"
  ),
  contentHandling = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
  timeoutInMillis = 123
)
}
}

\keyword{internal}
