% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmsap_operations.R
\name{ssmsap_register_application}
\alias{ssmsap_register_application}
\title{Register an SAP application with AWS Systems Manager for SAP}
\usage{
ssmsap_register_application(
  ApplicationId,
  ApplicationType,
  Instances,
  SapInstanceNumber = NULL,
  Sid = NULL,
  Tags = NULL,
  Credentials = NULL,
  DatabaseArn = NULL
)
}
\arguments{
\item{ApplicationId}{[required] The ID of the application.}

\item{ApplicationType}{[required] The type of the application.}

\item{Instances}{[required] The Amazon EC2 instances on which your SAP application is running.}

\item{SapInstanceNumber}{The SAP instance number of the application.}

\item{Sid}{The System ID of the application.}

\item{Tags}{The tags to be attached to the SAP application.}

\item{Credentials}{The credentials of the SAP application.}

\item{DatabaseArn}{The Amazon Resource Name of the SAP HANA database.}
}
\description{
Register an SAP application with AWS Systems Manager for SAP. You must meet the following requirements before registering.

See \url{https://www.paws-r-sdk.com/docs/ssmsap_register_application/} for full documentation.
}
\keyword{internal}
