% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_token}
\alias{licensemanager_create_token}
\title{Creates a long-lived token}
\usage{
licensemanager_create_token(
  LicenseArn,
  RoleArns = NULL,
  ExpirationInDays = NULL,
  TokenProperties = NULL,
  ClientToken
)
}
\arguments{
\item{LicenseArn}{[required] Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud
claim of the JWT token.}

\item{RoleArns}{Amazon Resource Name (ARN) of the IAM roles to embed in the token.
License Manager does not check whether the roles are in use.}

\item{ExpirationInDays}{Token expiration, in days, counted from token creation. The default is
365 days.}

\item{TokenProperties}{Data specified by the caller to be included in the JWT token. The data
is mapped to the amr claim of the JWT token.}

\item{ClientToken}{[required] Idempotency token, valid for 10 minutes.}
}
\description{
Creates a long-lived token.

See \url{https://www.paws-r-sdk.com/docs/licensemanager_create_token/} for full documentation.
}
\keyword{internal}
