# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Systems Manager for SAP
#'
#' @description
#' This API reference provides descriptions, syntax, and other details
#' about each of the actions and data types for AWS Systems Manager for
#' SAP. The topic for each action shows the API request parameters and
#' responses.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- ssmsap(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ssmsap()
#' svc$delete_resource_permission(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ssmsap_delete_resource_permission]{delete_resource_permission} \tab Removes permissions associated with the target database\cr
#'  \link[=ssmsap_deregister_application]{deregister_application} \tab Deregister an SAP application with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_get_application]{get_application} \tab Gets an application registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_get_component]{get_component} \tab Gets the component of an application registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_get_database]{get_database} \tab Gets the SAP HANA database of an application registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_get_operation]{get_operation} \tab Gets the details of an operation by specifying the operation ID\cr
#'  \link[=ssmsap_get_resource_permission]{get_resource_permission} \tab Gets permissions associated with the target database\cr
#'  \link[=ssmsap_list_applications]{list_applications} \tab Lists all the applications registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_list_components]{list_components} \tab Lists all the components registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_list_databases]{list_databases} \tab Lists the SAP HANA databases of an application registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_list_operations]{list_operations} \tab Lists the operations performed by AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags on an SAP HANA application and/or database registered with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_put_resource_permission]{put_resource_permission} \tab Adds permissions to the target database\cr
#'  \link[=ssmsap_register_application]{register_application} \tab Register an SAP application with AWS Systems Manager for SAP\cr
#'  \link[=ssmsap_start_application_refresh]{start_application_refresh} \tab Refreshes a registered application\cr
#'  \link[=ssmsap_tag_resource]{tag_resource} \tab Creates tag for a resource by specifying the ARN\cr
#'  \link[=ssmsap_untag_resource]{untag_resource} \tab Delete the tags for a resource\cr
#'  \link[=ssmsap_update_application_settings]{update_application_settings} \tab Updates the settings of an application registered with AWS Systems Manager for SAP
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ssmsap
#' @export
ssmsap <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .ssmsap$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ssmsap <- list()

.ssmsap$operations <- list()

.ssmsap$metadata <- list(
  service_name = "ssmsap",
  endpoints = list("*" = list(endpoint = "ssm-sap.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ssm-sap.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "ssm-sap.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ssm-sap.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Ssm Sap",
  api_version = "2018-05-10",
  signing_name = "ssm-sap",
  json_version = "1.1",
  target_prefix = ""
)

.ssmsap$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.ssmsap$metadata, handlers, config)
}
