# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ssm_service.R
NULL

#' Adds or overwrites one or more tags for the specified resource
#'
#' @description
#' Adds or overwrites one or more tags for the specified resource. *Tags* are metadata that you can assign to your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_add_tags_to_resource/](https://www.paws-r-sdk.com/docs/ssm_add_tags_to_resource/) for full documentation.
#'
#' @param ResourceType &#91;required&#93; Specifies the type of resource you are tagging.
#' 
#' The `ManagedInstance` type for this API operation is for on-premises
#' managed nodes. You must specify the name of the managed node in the
#' following format: `mi-ID_number `. For example, `mi-1a2b3c4d5e6f`.
#' @param ResourceId &#91;required&#93; The resource ID you want to tag.
#' 
#' Use the ID of the resource. Here are some examples:
#' 
#' `MaintenanceWindow`: `mw-012345abcde`
#' 
#' `PatchBaseline`: `pb-012345abcde`
#' 
#' `Automation`: `example-c160-4567-8519-012345abcde`
#' 
#' `OpsMetadata` object: `ResourceID` for tagging is created from the
#' Amazon Resource Name (ARN) for the object. Specifically, `ResourceID` is
#' created from the strings that come after the word `opsmetadata` in the
#' ARN. For example, an OpsMetadata object with an ARN of
#' `arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager`
#' has a `ResourceID` of either `aws/ssm/MyGroup/appmanager` or
#' `/aws/ssm/MyGroup/appmanager`.
#' 
#' For the `Document` and `Parameter` values, use the name of the resource.
#' If you're tagging a shared document, you must use the full ARN of the
#' document.
#' 
#' `ManagedInstance`: `mi-012345abcde`
#' 
#' The `ManagedInstance` type for this API operation is only for
#' on-premises managed nodes. You must specify the name of the managed node
#' in the following format: `mi-ID_number `. For example,
#' `mi-1a2b3c4d5e6f`.
#' @param Tags &#91;required&#93; One or more tags. The value parameter is required.
#' 
#' Don't enter personally identifiable information in this field.
#'
#' @keywords internal
#'
#' @rdname ssm_add_tags_to_resource
ssm_add_tags_to_resource <- function(ResourceType, ResourceId, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$add_tags_to_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, Tags = Tags)
  output <- .ssm$add_tags_to_resource_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$add_tags_to_resource <- ssm_add_tags_to_resource

#' Associates a related item to a Systems Manager OpsCenter OpsItem
#'
#' @description
#' Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of Amazon Web Services Systems Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_associate_ops_item_related_item/](https://www.paws-r-sdk.com/docs/ssm_associate_ops_item_related_item/) for full documentation.
#'
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem to which you want to associate a resource as a
#' related item.
#' @param AssociationType &#91;required&#93; The type of association that you want to create between an OpsItem and a
#' resource. OpsCenter supports `IsParentOf` and `RelatesTo` association
#' types.
#' @param ResourceType &#91;required&#93; The type of resource that you want to associate with an OpsItem.
#' OpsCenter supports the following types:
#' 
#' `AWS::SSMIncidents::IncidentRecord`: an Incident Manager incident.
#' 
#' `AWS::SSM::Document`: a Systems Manager (SSM) document.
#' @param ResourceUri &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Web Services resource that
#' you want to associate with the OpsItem.
#'
#' @keywords internal
#'
#' @rdname ssm_associate_ops_item_related_item
ssm_associate_ops_item_related_item <- function(OpsItemId, AssociationType, ResourceType, ResourceUri) {
  op <- new_operation(
    name = "AssociateOpsItemRelatedItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$associate_ops_item_related_item_input(OpsItemId = OpsItemId, AssociationType = AssociationType, ResourceType = ResourceType, ResourceUri = ResourceUri)
  output <- .ssm$associate_ops_item_related_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$associate_ops_item_related_item <- ssm_associate_ops_item_related_item

#' Attempts to cancel the command specified by the Command ID
#'
#' @description
#' Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_cancel_command/](https://www.paws-r-sdk.com/docs/ssm_cancel_command/) for full documentation.
#'
#' @param CommandId &#91;required&#93; The ID of the command you want to cancel.
#' @param InstanceIds (Optional) A list of managed node IDs on which you want to cancel the
#' command. If not provided, the command is canceled on every node on which
#' it was requested.
#'
#' @keywords internal
#'
#' @rdname ssm_cancel_command
ssm_cancel_command <- function(CommandId, InstanceIds = NULL) {
  op <- new_operation(
    name = "CancelCommand",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$cancel_command_input(CommandId = CommandId, InstanceIds = InstanceIds)
  output <- .ssm$cancel_command_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$cancel_command <- ssm_cancel_command

#' Stops a maintenance window execution that is already in progress and
#' cancels any tasks in the window that haven't already starting running
#'
#' @description
#' Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't already starting running. Tasks already in progress will continue to completion.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_cancel_maintenance_window_execution/](https://www.paws-r-sdk.com/docs/ssm_cancel_maintenance_window_execution/) for full documentation.
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution to stop.
#'
#' @keywords internal
#'
#' @rdname ssm_cancel_maintenance_window_execution
ssm_cancel_maintenance_window_execution <- function(WindowExecutionId) {
  op <- new_operation(
    name = "CancelMaintenanceWindowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$cancel_maintenance_window_execution_input(WindowExecutionId = WindowExecutionId)
  output <- .ssm$cancel_maintenance_window_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$cancel_maintenance_window_execution <- ssm_cancel_maintenance_window_execution

#' Generates an activation code and activation ID you can use to register
#' your on-premises servers, edge devices, or virtual machine (VM) with
#' Amazon Web Services Systems Manager
#'
#' @description
#' Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises machines using Systems Manager, see [Setting up Amazon Web Services Systems Manager for hybrid environments](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html) in the *Amazon Web Services Systems Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_activation/](https://www.paws-r-sdk.com/docs/ssm_create_activation/) for full documentation.
#'
#' @param Description A user-defined description of the resource that you want to register
#' with Systems Manager.
#' 
#' Don't enter personally identifiable information in this field.
#' @param DefaultInstanceName The name of the registered, managed node as it will appear in the Amazon
#' Web Services Systems Manager console or when you use the Amazon Web
#' Services command line tools to list Systems Manager resources.
#' 
#' Don't enter personally identifiable information in this field.
#' @param IamRole &#91;required&#93; The name of the Identity and Access Management (IAM) role that you want
#' to assign to the managed node. This IAM role must provide AssumeRole
#' permissions for the Amazon Web Services Systems Manager service
#' principal `ssm.amazonaws.com`. For more information, see [Create an IAM
#' service role for a hybrid
#' environment](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' You can't specify an IAM service-linked role for this parameter. You
#' must create a unique role.
#' @param RegistrationLimit Specify the maximum number of managed nodes you want to register. The
#' default value is `1`.
#' @param ExpirationDate The date by which this activation request should expire, in timestamp
#' format, such as "2021-07-07T00:00:00". You can specify a date up to 30
#' days in advance. If you don't provide an expiration date, the activation
#' code expires in 24 hours.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag an activation to
#' identify which servers or virtual machines (VMs) in your on-premises
#' environment you intend to activate. In this case, you could specify the
#' following key-value pairs:
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' When you install SSM Agent on your on-premises servers and VMs, you
#' specify an activation ID and code. When you specify the activation ID
#' and code, tags assigned to the activation are automatically applied to
#' the on-premises servers or VMs.
#' 
#' You can't add tags to or delete tags from an existing activation. You
#' can tag your on-premises servers, edge devices, and VMs after they
#' connect to Systems Manager for the first time and are assigned a managed
#' node ID. This means they are listed in the Amazon Web Services Systems
#' Manager console with an ID that is prefixed with "mi-". For information
#' about how to add tags to your managed nodes, see
#' [`add_tags_to_resource`][ssm_add_tags_to_resource]. For information
#' about how to remove tags from your managed nodes, see
#' [`remove_tags_from_resource`][ssm_remove_tags_from_resource].
#' @param RegistrationMetadata Reserved for internal use.
#'
#' @keywords internal
#'
#' @rdname ssm_create_activation
ssm_create_activation <- function(Description = NULL, DefaultInstanceName = NULL, IamRole, RegistrationLimit = NULL, ExpirationDate = NULL, Tags = NULL, RegistrationMetadata = NULL) {
  op <- new_operation(
    name = "CreateActivation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_activation_input(Description = Description, DefaultInstanceName = DefaultInstanceName, IamRole = IamRole, RegistrationLimit = RegistrationLimit, ExpirationDate = ExpirationDate, Tags = Tags, RegistrationMetadata = RegistrationMetadata)
  output <- .ssm$create_activation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_activation <- ssm_create_activation

#' A State Manager association defines the state that you want to maintain
#' on your managed nodes
#'
#' @description
#' A State Manager association defines the state that you want to maintain on your managed nodes. For example, an association can specify that anti-virus software must be installed and running on your managed nodes, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software isn't installed, then State Manager installs it. If the software is installed, but the service isn't running, then the association might instruct State Manager to start the service.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_association/](https://www.paws-r-sdk.com/docs/ssm_create_association/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the SSM Command document or Automation runbook that contains
#' the configuration information for the managed node.
#' 
#' You can specify Amazon Web Services-predefined documents, documents you
#' created, or a document that is shared with you from another Amazon Web
#' Services account.
#' 
#' For Systems Manager documents (SSM documents) that are shared with you
#' from other Amazon Web Services accounts, you must specify the complete
#' SSM document ARN, in the following format:
#' 
#' `arn:partition:ssm:region:account-id:document/document-name `
#' 
#' For example:
#' 
#' `arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document`
#' 
#' For Amazon Web Services-predefined documents and SSM documents you
#' created in your account, you only need to specify the document name. For
#' example, `AWS-ApplyPatchBaseline` or `My-Document`.
#' @param DocumentVersion The document version you want to associate with the target(s). Can be a
#' specific version or the default version.
#' 
#' State Manager doesn't support running associations that use a new
#' version of a document if that document is shared from another account.
#' State Manager always runs the `default` version of a document if shared
#' from another account, even though the Systems Manager console shows that
#' a new version was processed. If you want to run an association using a
#' new version of a document shared form another account, you must set the
#' document version to `default`.
#' @param InstanceId The managed node ID.
#' 
#' `InstanceId` has been deprecated. To specify a managed node ID for an
#' association, use the `Targets` parameter. Requests that include the
#' parameter `InstanceID` with Systems Manager documents (SSM documents)
#' that use schema version 2.0 or later will fail. In addition, if you use
#' the parameter `InstanceId`, you can't use the parameters
#' `AssociationName`, `DocumentVersion`, `MaxErrors`, `MaxConcurrency`,
#' `OutputLocation`, or `ScheduleExpression`. To use these parameters, you
#' must use the `Targets` parameter.
#' @param Parameters The parameters for the runtime configuration of the document.
#' @param Targets The targets for the association. You can target managed nodes by using
#' tags, Amazon Web Services resource groups, all managed nodes in an
#' Amazon Web Services account, or individual managed node IDs. You can
#' target all managed nodes in an Amazon Web Services account by specifying
#' the `InstanceIds` key with a value of `*`. For more information about
#' choosing targets for an association, see [Using targets and rate
#' controls with State Manager
#' associations](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param ScheduleExpression A cron expression when the association will be applied to the target(s).
#' @param OutputLocation An Amazon Simple Storage Service (Amazon S3) bucket where you want to
#' store the output details of the request.
#' @param AssociationName Specify a descriptive name for the association.
#' @param AutomationTargetParameterName Choose the parameter that will define how your automation will branch
#' out. This target is required for associations that use an Automation
#' runbook and target resources by using rate controls. Automation is a
#' capability of Amazon Web Services Systems Manager.
#' @param MaxErrors The number of errors that are allowed before the system stops sending
#' requests to run the association on additional targets. You can specify
#' either an absolute number of errors, for example 10, or a percentage of
#' the target set, for example 10%. If you specify 3, for example, the
#' system stops sending requests when the fourth error is received. If you
#' specify 0, then the system stops sending requests after the first error
#' is returned. If you run an association on 50 managed nodes and set
#' `MaxError` to 10%, then the system stops sending the request when the
#' sixth error is received.
#' 
#' Executions that are already running an association when `MaxErrors` is
#' reached are allowed to complete, but some of these executions may fail
#' as well. If you need to ensure that there won't be more than max-errors
#' failed executions, set `MaxConcurrency` to 1 so that executions proceed
#' one at a time.
#' @param MaxConcurrency The maximum number of targets allowed to run the association at the same
#' time. You can specify a number, for example 10, or a percentage of the
#' target set, for example 10%. The default value is 100%, which means all
#' targets run the association at the same time.
#' 
#' If a new managed node starts and attempts to run an association while
#' Systems Manager is running `MaxConcurrency` associations, the
#' association is allowed to run. During the next association interval, the
#' new managed node will process its association within the limit specified
#' for `MaxConcurrency`.
#' @param ComplianceSeverity The severity level to assign to the association.
#' @param SyncCompliance The mode for generating association compliance. You can specify `AUTO`
#' or `MANUAL`. In `AUTO` mode, the system uses the status of the
#' association execution to determine the compliance status. If the
#' association execution runs successfully, then the association is
#' `COMPLIANT`. If the association execution doesn't run successfully, the
#' association is `NON-COMPLIANT`.
#' 
#' In `MANUAL` mode, you must specify the `AssociationId` as a parameter
#' for the [`put_compliance_items`][ssm_put_compliance_items] API
#' operation. In this case, compliance data isn't managed by State Manager.
#' It is managed by your direct call to the
#' [`put_compliance_items`][ssm_put_compliance_items] API operation.
#' 
#' By default, all associations use `AUTO` mode.
#' @param ApplyOnlyAtCronInterval By default, when you create a new association, the system runs it
#' immediately after it is created and then according to the schedule you
#' specified. Specify this option if you don't want an association to run
#' immediately after you create it. This parameter isn't supported for rate
#' expressions.
#' @param CalendarNames The names or Amazon Resource Names (ARNs) of the Change Calendar type
#' documents you want to gate your associations under. The associations
#' only run when that change calendar is open. For more information, see
#' [Amazon Web Services Systems Manager Change
#' Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html).
#' @param TargetLocations A location is a combination of Amazon Web Services Regions and Amazon
#' Web Services accounts where you want to run the association. Use this
#' action to create an association in multiple Regions and multiple
#' accounts.
#' @param ScheduleOffset Number of days to wait after the scheduled day to run an association.
#' For example, if you specified a cron schedule of
#' `cron(0 0 ? * THU#2 *)`, you could specify an offset of 3 to run the
#' association each Sunday after the second Thursday of the month. For more
#' information about cron schedules for associations, see [Reference: Cron
#' and rate expressions for Systems
#' Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' To use offsets, you must specify the `ApplyOnlyAtCronInterval`
#' parameter. This option tells the system not to run an association
#' immediately after you create it.
#' @param TargetMaps A key-value mapping of document parameters to target resources. Both
#' Targets and TargetMaps can't be specified together.
#' @param Tags Adds or overwrites one or more tags for a State Manager association.
#' *Tags* are metadata that you can assign to your Amazon Web Services
#' resources. Tags enable you to categorize your resources in different
#' ways, for example, by purpose, owner, or environment. Each tag consists
#' of a key and an optional value, both of which you define.
#' @param AlarmConfiguration 
#'
#' @keywords internal
#'
#' @rdname ssm_create_association
ssm_create_association <- function(Name, DocumentVersion = NULL, InstanceId = NULL, Parameters = NULL, Targets = NULL, ScheduleExpression = NULL, OutputLocation = NULL, AssociationName = NULL, AutomationTargetParameterName = NULL, MaxErrors = NULL, MaxConcurrency = NULL, ComplianceSeverity = NULL, SyncCompliance = NULL, ApplyOnlyAtCronInterval = NULL, CalendarNames = NULL, TargetLocations = NULL, ScheduleOffset = NULL, TargetMaps = NULL, Tags = NULL, AlarmConfiguration = NULL) {
  op <- new_operation(
    name = "CreateAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_association_input(Name = Name, DocumentVersion = DocumentVersion, InstanceId = InstanceId, Parameters = Parameters, Targets = Targets, ScheduleExpression = ScheduleExpression, OutputLocation = OutputLocation, AssociationName = AssociationName, AutomationTargetParameterName = AutomationTargetParameterName, MaxErrors = MaxErrors, MaxConcurrency = MaxConcurrency, ComplianceSeverity = ComplianceSeverity, SyncCompliance = SyncCompliance, ApplyOnlyAtCronInterval = ApplyOnlyAtCronInterval, CalendarNames = CalendarNames, TargetLocations = TargetLocations, ScheduleOffset = ScheduleOffset, TargetMaps = TargetMaps, Tags = Tags, AlarmConfiguration = AlarmConfiguration)
  output <- .ssm$create_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_association <- ssm_create_association

#' Associates the specified Amazon Web Services Systems Manager document
#' (SSM document) with the specified managed nodes or targets
#'
#' @description
#' Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes or targets.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_association_batch/](https://www.paws-r-sdk.com/docs/ssm_create_association_batch/) for full documentation.
#'
#' @param Entries &#91;required&#93; One or more associations.
#'
#' @keywords internal
#'
#' @rdname ssm_create_association_batch
ssm_create_association_batch <- function(Entries) {
  op <- new_operation(
    name = "CreateAssociationBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_association_batch_input(Entries = Entries)
  output <- .ssm$create_association_batch_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_association_batch <- ssm_create_association_batch

#' Creates a Amazon Web Services Systems Manager (SSM document)
#'
#' @description
#' Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed nodes. For more information about SSM documents, including information about supported schemas, features, and syntax, see [Amazon Web Services Systems Manager Documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents.html) in the *Amazon Web Services Systems Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_document/](https://www.paws-r-sdk.com/docs/ssm_create_document/) for full documentation.
#'
#' @param Content &#91;required&#93; The content for the new SSM document in JSON or YAML format. The content
#' of the document must not exceed 64KB. This quota also includes the
#' content specified for input parameters at runtime. We recommend storing
#' the contents for your new document in an external JSON or YAML file and
#' referencing the file in a command.
#' 
#' For examples, see the following topics in the *Amazon Web Services
#' Systems Manager User Guide*.
#' 
#' -   [Create an SSM document (Amazon Web Services
#'     API)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html)
#' 
#' -   [Create an SSM document (Amazon Web Services
#'     CLI)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html)
#' 
#' -   [Create an SSM document
#'     (API)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html)
#' @param Requires A list of SSM documents required by a document. This parameter is used
#' exclusively by AppConfig. When a user creates an AppConfig configuration
#' in an SSM document, the user must also specify a required document for
#' validation purposes. In this case, an `ApplicationConfiguration`
#' document requires an `ApplicationConfigurationSchema` document for
#' validation purposes. For more information, see [What is
#' AppConfig?](https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html)
#' in the *AppConfig User Guide*.
#' @param Attachments A list of key-value pairs that describe attachments to a version of a
#' document.
#' @param Name &#91;required&#93; A name for the SSM document.
#' 
#' You can't use the following strings as document name prefixes. These are
#' reserved by Amazon Web Services for use as document name prefixes:
#' 
#' -   `aws`
#' 
#' -   `amazon`
#' 
#' -   `amzn`
#' @param DisplayName An optional field where you can specify a friendly name for the SSM
#' document. This value can differ for each version of the document. You
#' can update this value at a later time using the
#' [`update_document`][ssm_update_document] operation.
#' @param VersionName An optional field specifying the version of the artifact you are
#' creating with the document. For example, `Release12.1`. This value is
#' unique across all versions of a document, and can't be changed.
#' @param DocumentType The type of document to create.
#' 
#' The `DeploymentStrategy` document type is an internal-use-only document
#' type reserved for AppConfig.
#' @param DocumentFormat Specify the document format for the request. The document format can be
#' JSON, YAML, or TEXT. JSON is the default format.
#' @param TargetType Specify a target type to define the kinds of resources the document can
#' run on. For example, to run a document on EC2 instances, specify the
#' following value: `/AWS::EC2::Instance`. If you specify a value of '/'
#' the document can run on all types of resources. If you don't specify a
#' value, the document can't run on any resources. For a list of valid
#' resource types, see [Amazon Web Services resource and property types
#' reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
#' in the *CloudFormation User Guide*.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag an SSM document to
#' identify the types of targets or the environment where it will run. In
#' this case, you could specify the following key-value pairs:
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' To add tags to an existing SSM document, use the
#' [`add_tags_to_resource`][ssm_add_tags_to_resource] operation.
#'
#' @keywords internal
#'
#' @rdname ssm_create_document
ssm_create_document <- function(Content, Requires = NULL, Attachments = NULL, Name, DisplayName = NULL, VersionName = NULL, DocumentType = NULL, DocumentFormat = NULL, TargetType = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_document_input(Content = Content, Requires = Requires, Attachments = Attachments, Name = Name, DisplayName = DisplayName, VersionName = VersionName, DocumentType = DocumentType, DocumentFormat = DocumentFormat, TargetType = TargetType, Tags = Tags)
  output <- .ssm$create_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_document <- ssm_create_document

#' Creates a new maintenance window
#'
#' @description
#' Creates a new maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_create_maintenance_window/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the maintenance window.
#' @param Description An optional description for the maintenance window. We recommend
#' specifying a description to help you organize your maintenance windows.
#' @param StartDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become active. `StartDate` allows you to delay
#' activation of the maintenance window until the specified future date.
#' @param EndDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become inactive. `EndDate` allows you to set a
#' date and time in the future when the maintenance window will no longer
#' run.
#' @param Schedule &#91;required&#93; The schedule of the maintenance window in the form of a cron or rate
#' expression.
#' @param ScheduleTimezone The time zone that the scheduled maintenance window executions are based
#' on, in Internet Assigned Numbers Authority (IANA) format. For example:
#' "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
#' the [Time Zone Database](https://www.iana.org/time-zones) on the IANA
#' website.
#' @param ScheduleOffset The number of days to wait after the date and time specified by a cron
#' expression before running the maintenance window.
#' 
#' For example, the following cron expression schedules a maintenance
#' window to run on the third Tuesday of every month at 11:30 PM.
#' 
#' `cron(30 23 ? * TUE#3 *)`
#' 
#' If the schedule offset is `2`, the maintenance window won't run until
#' two days later.
#' @param Duration &#91;required&#93; The duration of the maintenance window in hours.
#' @param Cutoff &#91;required&#93; The number of hours before the end of the maintenance window that Amazon
#' Web Services Systems Manager stops scheduling new tasks for execution.
#' @param AllowUnassociatedTargets &#91;required&#93; Enables a maintenance window task to run on managed nodes, even if you
#' haven't registered those nodes as targets. If enabled, then you must
#' specify the unregistered managed nodes (by node ID) when you register a
#' task with the maintenance window.
#' 
#' If you don't enable this option, then you must specify
#' previously-registered targets when you register a task with the
#' maintenance window.
#' @param ClientToken User-provided idempotency token.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag a maintenance window to
#' identify the type of tasks it will run, the types of targets, and the
#' environment it will run in. In this case, you could specify the
#' following key-value pairs:
#' 
#' -   `Key=TaskType,Value=AgentUpdate`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' To add tags to an existing maintenance window, use the
#' [`add_tags_to_resource`][ssm_add_tags_to_resource] operation.
#'
#' @keywords internal
#'
#' @rdname ssm_create_maintenance_window
ssm_create_maintenance_window <- function(Name, Description = NULL, StartDate = NULL, EndDate = NULL, Schedule, ScheduleTimezone = NULL, ScheduleOffset = NULL, Duration, Cutoff, AllowUnassociatedTargets, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_maintenance_window_input(Name = Name, Description = Description, StartDate = StartDate, EndDate = EndDate, Schedule = Schedule, ScheduleTimezone = ScheduleTimezone, ScheduleOffset = ScheduleOffset, Duration = Duration, Cutoff = Cutoff, AllowUnassociatedTargets = AllowUnassociatedTargets, ClientToken = ClientToken, Tags = Tags)
  output <- .ssm$create_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_maintenance_window <- ssm_create_maintenance_window

#' Creates a new OpsItem
#'
#' @description
#' Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_ops_item/](https://www.paws-r-sdk.com/docs/ssm_create_ops_item/) for full documentation.
#'
#' @param Description &#91;required&#93; User-defined text that contains information about the OpsItem, in
#' Markdown format.
#' 
#' Provide enough information so that users viewing this OpsItem for the
#' first time understand the issue.
#' @param OpsItemType The type of OpsItem to create. Systems Manager supports the following
#' types of OpsItems:
#' 
#' -   `/aws/issue`
#' 
#'     This type of OpsItem is used for default OpsItems created by
#'     OpsCenter.
#' 
#' -   `/aws/changerequest`
#' 
#'     This type of OpsItem is used by Change Manager for reviewing and
#'     approving or rejecting change requests.
#' 
#' -   `/aws/insight`
#' 
#'     This type of OpsItem is used by OpsCenter for aggregating and
#'     reporting on duplicate OpsItems.
#' @param OperationalData Operational data is custom data that provides useful reference details
#' about the OpsItem. For example, you can specify log files, error
#' strings, license keys, troubleshooting tips, or other relevant data. You
#' enter operational data as key-value pairs. The key has a maximum length
#' of 128 characters. The value has a maximum size of 20 KB.
#' 
#' Operational data keys *can't* begin with the following: `amazon`, `aws`,
#' `amzn`, `ssm`, `/amazon`, `/aws`, `/amzn`, `/ssm`.
#' 
#' You can choose to make the data searchable by other users in the account
#' or you can restrict search access. Searchable data means that all users
#' with access to the OpsItem Overview page (as provided by the
#' [`describe_ops_items`][ssm_describe_ops_items] API operation) can view
#' and search on the specified data. Operational data that isn't searchable
#' is only viewable by users who have access to the OpsItem (as provided by
#' the [`get_ops_item`][ssm_get_ops_item] API operation).
#' 
#' Use the `/aws/resources` key in OperationalData to specify a related
#' resource in the request. Use the `/aws/automations` key in
#' OperationalData to associate an Automation runbook with the OpsItem. To
#' view Amazon Web Services CLI example commands that use these keys, see
#' [Creating OpsItems
#' manually](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-manually-create-OpsItems.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param Notifications The Amazon Resource Name (ARN) of an SNS topic where notifications are
#' sent when this OpsItem is edited or changed.
#' @param Priority The importance of this OpsItem in relation to other OpsItems in the
#' system.
#' @param RelatedOpsItems One or more OpsItems that share something in common with the current
#' OpsItems. For example, related OpsItems can include OpsItems with
#' similar error messages, impacted resources, or statuses for the impacted
#' resource.
#' @param Source &#91;required&#93; The origin of the OpsItem, such as Amazon EC2 or Systems Manager.
#' 
#' The source name can't contain the following strings: `aws`, `amazon`,
#' and `amzn`.
#' @param Title &#91;required&#93; A short heading that describes the nature of the OpsItem and the
#' impacted resource.
#' @param Tags Optional metadata that you assign to a resource.
#' 
#' Tags use a key-value pair. For example:
#' 
#' `Key=Department,Value=Finance`
#' 
#' To add tags to a new OpsItem, a user must have IAM permissions for both
#' the `ssm:CreateOpsItems` operation and the `ssm:AddTagsToResource`
#' operation. To add tags to an existing OpsItem, use the
#' [`add_tags_to_resource`][ssm_add_tags_to_resource] operation.
#' @param Category Specify a category to assign to an OpsItem.
#' @param Severity Specify a severity to assign to an OpsItem.
#' @param ActualStartTime The time a runbook workflow started. Currently reported only for the
#' OpsItem type `/aws/changerequest`.
#' @param ActualEndTime The time a runbook workflow ended. Currently reported only for the
#' OpsItem type `/aws/changerequest`.
#' @param PlannedStartTime The time specified in a change request for a runbook workflow to start.
#' Currently supported only for the OpsItem type `/aws/changerequest`.
#' @param PlannedEndTime The time specified in a change request for a runbook workflow to end.
#' Currently supported only for the OpsItem type `/aws/changerequest`.
#' @param AccountId The target Amazon Web Services account where you want to create an
#' OpsItem. To make this call, your account must be configured to work with
#' OpsItems across accounts. For more information, see [Set up
#' OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#'
#' @keywords internal
#'
#' @rdname ssm_create_ops_item
ssm_create_ops_item <- function(Description, OpsItemType = NULL, OperationalData = NULL, Notifications = NULL, Priority = NULL, RelatedOpsItems = NULL, Source, Title, Tags = NULL, Category = NULL, Severity = NULL, ActualStartTime = NULL, ActualEndTime = NULL, PlannedStartTime = NULL, PlannedEndTime = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "CreateOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_ops_item_input(Description = Description, OpsItemType = OpsItemType, OperationalData = OperationalData, Notifications = Notifications, Priority = Priority, RelatedOpsItems = RelatedOpsItems, Source = Source, Title = Title, Tags = Tags, Category = Category, Severity = Severity, ActualStartTime = ActualStartTime, ActualEndTime = ActualEndTime, PlannedStartTime = PlannedStartTime, PlannedEndTime = PlannedEndTime, AccountId = AccountId)
  output <- .ssm$create_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_ops_item <- ssm_create_ops_item

#' If you create a new application in Application Manager, Amazon Web
#' Services Systems Manager calls this API operation to specify information
#' about the new application, including the application type
#'
#' @description
#' If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_ops_metadata/](https://www.paws-r-sdk.com/docs/ssm_create_ops_metadata/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; A resource ID for a new Application Manager application.
#' @param Metadata Metadata for a new Application Manager application.
#' @param Tags Optional metadata that you assign to a resource. You can specify a
#' maximum of five tags for an OpsMetadata object. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag an OpsMetadata object to
#' identify an environment or target Amazon Web Services Region. In this
#' case, you could specify the following key-value pairs:
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' -   `Key=Region,Value=us-east-2`
#'
#' @keywords internal
#'
#' @rdname ssm_create_ops_metadata
ssm_create_ops_metadata <- function(ResourceId, Metadata = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateOpsMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_ops_metadata_input(ResourceId = ResourceId, Metadata = Metadata, Tags = Tags)
  output <- .ssm$create_ops_metadata_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_ops_metadata <- ssm_create_ops_metadata

#' Creates a patch baseline
#'
#' @description
#' Creates a patch baseline.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_create_patch_baseline/) for full documentation.
#'
#' @param OperatingSystem Defines the operating system the patch baseline applies to. The default
#' value is `WINDOWS`.
#' @param Name &#91;required&#93; The name of the patch baseline.
#' @param GlobalFilters A set of global filters used to include patches in the baseline.
#' @param ApprovalRules A set of rules used to include patches in the baseline.
#' @param ApprovedPatches A list of explicitly approved patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [About package name formats for approved and
#' rejected patch
#' lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param ApprovedPatchesComplianceLevel Defines the compliance level for approved patches. When an approved
#' patch is reported as missing, this value describes the severity of the
#' compliance violation. The default value is `UNSPECIFIED`.
#' @param ApprovedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security
#' updates that should be applied to the managed nodes. The default value
#' is `false`. Applies to Linux managed nodes only.
#' @param RejectedPatches A list of explicitly rejected patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [About package name formats for approved and
#' rejected patch
#' lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param RejectedPatchesAction The action for Patch Manager to take on patches included in the
#' `RejectedPackages` list.
#' 
#' -   **`ALLOW_AS_DEPENDENCY`** : A package in the `Rejected` patches list
#'     is installed only if it is a dependency of another package. It is
#'     considered compliant with the patch baseline, and its status is
#'     reported as `InstalledOther`. This is the default action if no
#'     option is specified.
#' 
#' -   **`BLOCK`** : Packages in the `RejectedPatches` list, and packages
#'     that include them as dependencies, aren't installed under any
#'     circumstances. If a package was installed before it was added to the
#'     Rejected patches list, it is considered non-compliant with the patch
#'     baseline, and its status is reported as `InstalledRejected`.
#' @param Description A description of the patch baseline.
#' @param Sources Information about the patches to use to update the managed nodes,
#' including target operating systems and source repositories. Applies to
#' Linux managed nodes only.
#' @param ClientToken User-provided idempotency token.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag a patch baseline to
#' identify the severity level of patches it specifies and the operating
#' system family it applies to. In this case, you could specify the
#' following key-value pairs:
#' 
#' -   `Key=PatchSeverity,Value=Critical`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' To add tags to an existing patch baseline, use the
#' [`add_tags_to_resource`][ssm_add_tags_to_resource] operation.
#'
#' @keywords internal
#'
#' @rdname ssm_create_patch_baseline
ssm_create_patch_baseline <- function(OperatingSystem = NULL, Name, GlobalFilters = NULL, ApprovalRules = NULL, ApprovedPatches = NULL, ApprovedPatchesComplianceLevel = NULL, ApprovedPatchesEnableNonSecurity = NULL, RejectedPatches = NULL, RejectedPatchesAction = NULL, Description = NULL, Sources = NULL, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_patch_baseline_input(OperatingSystem = OperatingSystem, Name = Name, GlobalFilters = GlobalFilters, ApprovalRules = ApprovalRules, ApprovedPatches = ApprovedPatches, ApprovedPatchesComplianceLevel = ApprovedPatchesComplianceLevel, ApprovedPatchesEnableNonSecurity = ApprovedPatchesEnableNonSecurity, RejectedPatches = RejectedPatches, RejectedPatchesAction = RejectedPatchesAction, Description = Description, Sources = Sources, ClientToken = ClientToken, Tags = Tags)
  output <- .ssm$create_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_patch_baseline <- ssm_create_patch_baseline

#' A resource data sync helps you view data from multiple sources in a
#' single location
#'
#' @description
#' A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems Manager offers two types of resource data sync: `SyncToDestination` and `SyncFromSource`.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_create_resource_data_sync/](https://www.paws-r-sdk.com/docs/ssm_create_resource_data_sync/) for full documentation.
#'
#' @param SyncName &#91;required&#93; A name for the configuration.
#' @param S3Destination Amazon S3 configuration details for the sync. This parameter is required
#' if the `SyncType` value is SyncToDestination.
#' @param SyncType Specify `SyncToDestination` to create a resource data sync that
#' synchronizes data to an S3 bucket for Inventory. If you specify
#' `SyncToDestination`, you must provide a value for `S3Destination`.
#' Specify `SyncFromSource` to synchronize data from a single account and
#' multiple Regions, or multiple Amazon Web Services accounts and Amazon
#' Web Services Regions, as listed in Organizations for Explorer. If you
#' specify `SyncFromSource`, you must provide a value for `SyncSource`. The
#' default value is `SyncToDestination`.
#' @param SyncSource Specify information about the data sources to synchronize. This
#' parameter is required if the `SyncType` value is SyncFromSource.
#'
#' @keywords internal
#'
#' @rdname ssm_create_resource_data_sync
ssm_create_resource_data_sync <- function(SyncName, S3Destination = NULL, SyncType = NULL, SyncSource = NULL) {
  op <- new_operation(
    name = "CreateResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_resource_data_sync_input(SyncName = SyncName, S3Destination = S3Destination, SyncType = SyncType, SyncSource = SyncSource)
  output <- .ssm$create_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_resource_data_sync <- ssm_create_resource_data_sync

#' Deletes an activation
#'
#' @description
#' Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You must manually de-register managed nodes.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_activation/](https://www.paws-r-sdk.com/docs/ssm_delete_activation/) for full documentation.
#'
#' @param ActivationId &#91;required&#93; The ID of the activation that you want to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_activation
ssm_delete_activation <- function(ActivationId) {
  op <- new_operation(
    name = "DeleteActivation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_activation_input(ActivationId = ActivationId)
  output <- .ssm$delete_activation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_activation <- ssm_delete_activation

#' Disassociates the specified Amazon Web Services Systems Manager document
#' (SSM document) from the specified managed node
#'
#' @description
#' Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed node. If you created the association by using the `Targets` parameter, then you must delete the association by using the association ID.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_association/](https://www.paws-r-sdk.com/docs/ssm_delete_association/) for full documentation.
#'
#' @param Name The name of the SSM document.
#' @param InstanceId The managed node ID.
#' 
#' `InstanceId` has been deprecated. To specify a managed node ID for an
#' association, use the `Targets` parameter. Requests that include the
#' parameter `InstanceID` with Systems Manager documents (SSM documents)
#' that use schema version 2.0 or later will fail. In addition, if you use
#' the parameter `InstanceId`, you can't use the parameters
#' `AssociationName`, `DocumentVersion`, `MaxErrors`, `MaxConcurrency`,
#' `OutputLocation`, or `ScheduleExpression`. To use these parameters, you
#' must use the `Targets` parameter.
#' @param AssociationId The association ID that you want to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_association
ssm_delete_association <- function(Name = NULL, InstanceId = NULL, AssociationId = NULL) {
  op <- new_operation(
    name = "DeleteAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_association_input(Name = Name, InstanceId = InstanceId, AssociationId = AssociationId)
  output <- .ssm$delete_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_association <- ssm_delete_association

#' Deletes the Amazon Web Services Systems Manager document (SSM document)
#' and all managed node associations to the document
#'
#' @description
#' Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the document.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_document/](https://www.paws-r-sdk.com/docs/ssm_delete_document/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the document.
#' @param DocumentVersion The version of the document that you want to delete. If not provided,
#' all versions of the document are deleted.
#' @param VersionName The version name of the document that you want to delete. If not
#' provided, all versions of the document are deleted.
#' @param Force Some SSM document types require that you specify a `Force` flag before
#' you can delete the document. For example, you must specify a `Force`
#' flag to delete a document of type `ApplicationConfigurationSchema`. You
#' can restrict access to the `Force` flag in an Identity and Access
#' Management (IAM) policy.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_document
ssm_delete_document <- function(Name, DocumentVersion = NULL, VersionName = NULL, Force = NULL) {
  op <- new_operation(
    name = "DeleteDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_document_input(Name = Name, DocumentVersion = DocumentVersion, VersionName = VersionName, Force = Force)
  output <- .ssm$delete_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_document <- ssm_delete_document

#' Delete a custom inventory type or the data associated with a custom
#' Inventory type
#'
#' @description
#' Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_inventory/](https://www.paws-r-sdk.com/docs/ssm_delete_inventory/) for full documentation.
#'
#' @param TypeName &#91;required&#93; The name of the custom inventory type for which you want to delete
#' either all previously collected data or the inventory type itself.
#' @param SchemaDeleteOption Use the `SchemaDeleteOption` to delete a custom inventory type (schema).
#' If you don't choose this option, the system only deletes existing
#' inventory data associated with the custom inventory type. Choose one of
#' the following options:
#' 
#' DisableSchema: If you choose this option, the system ignores all
#' inventory data for the specified version, and any earlier versions. To
#' enable this schema again, you must call the
#' [`put_inventory`][ssm_put_inventory] operation for a version greater
#' than the disabled version.
#' 
#' DeleteSchema: This option deletes the specified custom type from the
#' Inventory service. You can recreate the schema later, if you want.
#' @param DryRun Use this option to view a summary of the deletion request without
#' deleting any data or the data type. This option is useful when you only
#' want to understand what will be deleted. Once you validate that the data
#' to be deleted is what you intend to delete, you can run the same command
#' without specifying the `DryRun` option.
#' @param ClientToken User-provided idempotency token.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_inventory
ssm_delete_inventory <- function(TypeName, SchemaDeleteOption = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "DeleteInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_inventory_input(TypeName = TypeName, SchemaDeleteOption = SchemaDeleteOption, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ssm$delete_inventory_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_inventory <- ssm_delete_inventory

#' Deletes a maintenance window
#'
#' @description
#' Deletes a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_delete_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_maintenance_window
ssm_delete_maintenance_window <- function(WindowId) {
  op <- new_operation(
    name = "DeleteMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_maintenance_window_input(WindowId = WindowId)
  output <- .ssm$delete_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_maintenance_window <- ssm_delete_maintenance_window

#' Delete an OpsItem
#'
#' @description
#' Delete an OpsItem. You must have permission in Identity and Access Management (IAM) to delete an OpsItem.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_ops_item/](https://www.paws-r-sdk.com/docs/ssm_delete_ops_item/) for full documentation.
#'
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem that you want to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_ops_item
ssm_delete_ops_item <- function(OpsItemId) {
  op <- new_operation(
    name = "DeleteOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_ops_item_input(OpsItemId = OpsItemId)
  output <- .ssm$delete_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_ops_item <- ssm_delete_ops_item

#' Delete OpsMetadata related to an application
#'
#' @description
#' Delete OpsMetadata related to an application.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_ops_metadata/](https://www.paws-r-sdk.com/docs/ssm_delete_ops_metadata/) for full documentation.
#'
#' @param OpsMetadataArn &#91;required&#93; The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_ops_metadata
ssm_delete_ops_metadata <- function(OpsMetadataArn) {
  op <- new_operation(
    name = "DeleteOpsMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_ops_metadata_input(OpsMetadataArn = OpsMetadataArn)
  output <- .ssm$delete_ops_metadata_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_ops_metadata <- ssm_delete_ops_metadata

#' Delete a parameter from the system
#'
#' @description
#' Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_parameter/](https://www.paws-r-sdk.com/docs/ssm_delete_parameter/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parameter to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_parameter
ssm_delete_parameter <- function(Name) {
  op <- new_operation(
    name = "DeleteParameter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_parameter_input(Name = Name)
  output <- .ssm$delete_parameter_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_parameter <- ssm_delete_parameter

#' Delete a list of parameters
#'
#' @description
#' Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_parameters/](https://www.paws-r-sdk.com/docs/ssm_delete_parameters/) for full documentation.
#'
#' @param Names &#91;required&#93; The names of the parameters to delete. After deleting a parameter, wait
#' for at least 30 seconds to create a parameter with the same name.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_parameters
ssm_delete_parameters <- function(Names) {
  op <- new_operation(
    name = "DeleteParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_parameters_input(Names = Names)
  output <- .ssm$delete_parameters_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_parameters <- ssm_delete_parameters

#' Deletes a patch baseline
#'
#' @description
#' Deletes a patch baseline.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_delete_patch_baseline/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_patch_baseline
ssm_delete_patch_baseline <- function(BaselineId) {
  op <- new_operation(
    name = "DeletePatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_patch_baseline_input(BaselineId = BaselineId)
  output <- .ssm$delete_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_patch_baseline <- ssm_delete_patch_baseline

#' Deletes a resource data sync configuration
#'
#' @description
#' Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_resource_data_sync/](https://www.paws-r-sdk.com/docs/ssm_delete_resource_data_sync/) for full documentation.
#'
#' @param SyncName &#91;required&#93; The name of the configuration to delete.
#' @param SyncType Specify the type of resource data sync to delete.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_resource_data_sync
ssm_delete_resource_data_sync <- function(SyncName, SyncType = NULL) {
  op <- new_operation(
    name = "DeleteResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_resource_data_sync_input(SyncName = SyncName, SyncType = SyncType)
  output <- .ssm$delete_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_resource_data_sync <- ssm_delete_resource_data_sync

#' Deletes a Systems Manager resource policy
#'
#' @description
#' Deletes a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage your Systems Manager resources. Currently, `OpsItemGroup` is the only resource that supports Systems Manager resource policies. The resource policy for `OpsItemGroup` enables Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_delete_resource_policy/](https://www.paws-r-sdk.com/docs/ssm_delete_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource to which the policies are
#' attached.
#' @param PolicyId &#91;required&#93; The policy ID.
#' @param PolicyHash &#91;required&#93; ID of the current policy version. The hash helps to prevent multiple
#' calls from attempting to overwrite a policy.
#'
#' @keywords internal
#'
#' @rdname ssm_delete_resource_policy
ssm_delete_resource_policy <- function(ResourceArn, PolicyId, PolicyHash) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_resource_policy_input(ResourceArn = ResourceArn, PolicyId = PolicyId, PolicyHash = PolicyHash)
  output <- .ssm$delete_resource_policy_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_resource_policy <- ssm_delete_resource_policy

#' Removes the server or virtual machine from the list of registered
#' servers
#'
#' @description
#' Removes the server or virtual machine from the list of registered servers. You can reregister the node again at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_deregister_managed_instance/](https://www.paws-r-sdk.com/docs/ssm_deregister_managed_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID assigned to the managed node when you registered it using the
#' activation process.
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_managed_instance
ssm_deregister_managed_instance <- function(InstanceId) {
  op <- new_operation(
    name = "DeregisterManagedInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_managed_instance_input(InstanceId = InstanceId)
  output <- .ssm$deregister_managed_instance_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_managed_instance <- ssm_deregister_managed_instance

#' Removes a patch group from a patch baseline
#'
#' @description
#' Removes a patch group from a patch baseline.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_deregister_patch_baseline_for_patch_group/](https://www.paws-r-sdk.com/docs/ssm_deregister_patch_baseline_for_patch_group/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to deregister the patch group from.
#' @param PatchGroup &#91;required&#93; The name of the patch group that should be deregistered from the patch
#' baseline.
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_patch_baseline_for_patch_group
ssm_deregister_patch_baseline_for_patch_group <- function(BaselineId, PatchGroup) {
  op <- new_operation(
    name = "DeregisterPatchBaselineForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_patch_baseline_for_patch_group_input(BaselineId = BaselineId, PatchGroup = PatchGroup)
  output <- .ssm$deregister_patch_baseline_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_patch_baseline_for_patch_group <- ssm_deregister_patch_baseline_for_patch_group

#' Removes a target from a maintenance window
#'
#' @description
#' Removes a target from a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_deregister_target_from_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_deregister_target_from_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the target should be removed from.
#' @param WindowTargetId &#91;required&#93; The ID of the target definition to remove.
#' @param Safe The system checks if the target is being referenced by a task. If the
#' target is being referenced, the system returns an error and doesn't
#' deregister the target from the maintenance window.
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_target_from_maintenance_window
ssm_deregister_target_from_maintenance_window <- function(WindowId, WindowTargetId, Safe = NULL) {
  op <- new_operation(
    name = "DeregisterTargetFromMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_target_from_maintenance_window_input(WindowId = WindowId, WindowTargetId = WindowTargetId, Safe = Safe)
  output <- .ssm$deregister_target_from_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_target_from_maintenance_window <- ssm_deregister_target_from_maintenance_window

#' Removes a task from a maintenance window
#'
#' @description
#' Removes a task from a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_deregister_task_from_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_deregister_task_from_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the task should be removed from.
#' @param WindowTaskId &#91;required&#93; The ID of the task to remove from the maintenance window.
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_task_from_maintenance_window
ssm_deregister_task_from_maintenance_window <- function(WindowId, WindowTaskId) {
  op <- new_operation(
    name = "DeregisterTaskFromMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_task_from_maintenance_window_input(WindowId = WindowId, WindowTaskId = WindowTaskId)
  output <- .ssm$deregister_task_from_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_task_from_maintenance_window <- ssm_deregister_task_from_maintenance_window

#' Describes details about the activation, such as the date and time the
#' activation was created, its expiration date, the Identity and Access
#' Management (IAM) role assigned to the managed nodes in the activation,
#' and the number of nodes registered by using this activation
#'
#' @description
#' Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the number of nodes registered by using this activation.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_activations/](https://www.paws-r-sdk.com/docs/ssm_describe_activations/) for full documentation.
#'
#' @param Filters A filter to view information about your activations.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_activations
ssm_describe_activations <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeActivations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ActivationList")
  )
  input <- .ssm$describe_activations_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_activations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_activations <- ssm_describe_activations

#' Describes the association for the specified target or managed node
#'
#' @description
#' Describes the association for the specified target or managed node. If you created the association by using the `Targets` parameter, then you must retrieve the association by using the association ID.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_association/](https://www.paws-r-sdk.com/docs/ssm_describe_association/) for full documentation.
#'
#' @param Name The name of the SSM document.
#' @param InstanceId The managed node ID.
#' @param AssociationId The association ID for which you want information.
#' @param AssociationVersion Specify the association version to retrieve. To view the latest version,
#' either specify `$LATEST` for this parameter, or omit this parameter. To
#' view a list of all associations for a managed node, use
#' [`list_associations`][ssm_list_associations]. To get a list of versions
#' for a specific association, use
#' [`list_association_versions`][ssm_list_association_versions].
#'
#' @keywords internal
#'
#' @rdname ssm_describe_association
ssm_describe_association <- function(Name = NULL, InstanceId = NULL, AssociationId = NULL, AssociationVersion = NULL) {
  op <- new_operation(
    name = "DescribeAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_association_input(Name = Name, InstanceId = InstanceId, AssociationId = AssociationId, AssociationVersion = AssociationVersion)
  output <- .ssm$describe_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_association <- ssm_describe_association

#' Views information about a specific execution of a specific association
#'
#' @description
#' Views information about a specific execution of a specific association.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_association_execution_targets/](https://www.paws-r-sdk.com/docs/ssm_describe_association_execution_targets/) for full documentation.
#'
#' @param AssociationId &#91;required&#93; The association ID that includes the execution for which you want to
#' view details.
#' @param ExecutionId &#91;required&#93; The execution ID for which you want to view details.
#' @param Filters Filters for the request. You can specify the following filters and
#' values.
#' 
#' Status (EQUAL)
#' 
#' ResourceId (EQUAL)
#' 
#' ResourceType (EQUAL)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_association_execution_targets
ssm_describe_association_execution_targets <- function(AssociationId, ExecutionId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAssociationExecutionTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AssociationExecutionTargets")
  )
  input <- .ssm$describe_association_execution_targets_input(AssociationId = AssociationId, ExecutionId = ExecutionId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_association_execution_targets_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_association_execution_targets <- ssm_describe_association_execution_targets

#' Views all executions for a specific association ID
#'
#' @description
#' Views all executions for a specific association ID.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_association_executions/](https://www.paws-r-sdk.com/docs/ssm_describe_association_executions/) for full documentation.
#'
#' @param AssociationId &#91;required&#93; The association ID for which you want to view execution history details.
#' @param Filters Filters for the request. You can specify the following filters and
#' values.
#' 
#' ExecutionId (EQUAL)
#' 
#' Status (EQUAL)
#' 
#' CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_association_executions
ssm_describe_association_executions <- function(AssociationId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAssociationExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AssociationExecutions")
  )
  input <- .ssm$describe_association_executions_input(AssociationId = AssociationId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_association_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_association_executions <- ssm_describe_association_executions

#' Provides details about all active and terminated Automation executions
#'
#' @description
#' Provides details about all active and terminated Automation executions.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_automation_executions/](https://www.paws-r-sdk.com/docs/ssm_describe_automation_executions/) for full documentation.
#'
#' @param Filters Filters used to limit the scope of executions that are requested.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_automation_executions
ssm_describe_automation_executions <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAutomationExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AutomationExecutionMetadataList")
  )
  input <- .ssm$describe_automation_executions_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_automation_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_automation_executions <- ssm_describe_automation_executions

#' Information about all active and terminated step executions in an
#' Automation workflow
#'
#' @description
#' Information about all active and terminated step executions in an Automation workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_automation_step_executions/](https://www.paws-r-sdk.com/docs/ssm_describe_automation_step_executions/) for full documentation.
#'
#' @param AutomationExecutionId &#91;required&#93; The Automation execution ID for which you want step execution
#' descriptions.
#' @param Filters One or more filters to limit the number of step executions returned by
#' the request.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param ReverseOrder Indicates whether to list step executions in reverse order by start
#' time. The default value is 'false'.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_automation_step_executions
ssm_describe_automation_step_executions <- function(AutomationExecutionId, Filters = NULL, NextToken = NULL, MaxResults = NULL, ReverseOrder = NULL) {
  op <- new_operation(
    name = "DescribeAutomationStepExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "StepExecutions")
  )
  input <- .ssm$describe_automation_step_executions_input(AutomationExecutionId = AutomationExecutionId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, ReverseOrder = ReverseOrder)
  output <- .ssm$describe_automation_step_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_automation_step_executions <- ssm_describe_automation_step_executions

#' Lists all patches eligible to be included in a patch baseline
#'
#' @description
#' Lists all patches eligible to be included in a patch baseline.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_available_patches/](https://www.paws-r-sdk.com/docs/ssm_describe_available_patches/) for full documentation.
#'
#' @param Filters Each element in the array is a structure containing a key-value pair.
#' 
#' **Windows Server**
#' 
#' Supported keys for Windows Server managed node patches include the
#' following:
#' 
#' -   **`PATCH_SET`**
#' 
#'     Sample values: `OS` | `APPLICATION`
#' 
#' -   **`PRODUCT`**
#' 
#'     Sample values: `WindowsServer2012` | `Office 2010` |
#'     `MicrosoftDefenderAntivirus`
#' 
#' -   **`PRODUCT_FAMILY`**
#' 
#'     Sample values: `Windows` | `Office`
#' 
#' -   **`MSRC_SEVERITY`**
#' 
#'     Sample values: `ServicePacks` | `Important` | `Moderate`
#' 
#' -   **`CLASSIFICATION`**
#' 
#'     Sample values: `ServicePacks` | `SecurityUpdates` |
#'     `DefinitionUpdates`
#' 
#' -   **`PATCH_ID`**
#' 
#'     Sample values: `KB123456` | `KB4516046`
#' 
#' **Linux**
#' 
#' When specifying filters for Linux patches, you must specify a key-pair
#' for `PRODUCT`. For example, using the Command Line Interface (CLI), the
#' following command fails:
#' 
#' `aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615`
#' 
#' However, the following command succeeds:
#' 
#' `aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03 Key=CVE_ID,Values=CVE-2018-3615`
#' 
#' Supported keys for Linux managed node patches include the following:
#' 
#' -   **`PRODUCT`**
#' 
#'     Sample values: `AmazonLinux2018.03` | `AmazonLinux2.0`
#' 
#' -   **`NAME`**
#' 
#'     Sample values: `kernel-headers` | `samba-python` | `php`
#' 
#' -   **`SEVERITY`**
#' 
#'     Sample values: `Critical` | `Important` | `Medium` | `Low`
#' 
#' -   **`EPOCH`**
#' 
#'     Sample values: `0` | `1`
#' 
#' -   **`VERSION`**
#' 
#'     Sample values: `78.6.1` | `4.10.16`
#' 
#' -   **`RELEASE`**
#' 
#'     Sample values: `9.56.amzn1` | `1.amzn2`
#' 
#' -   **`ARCH`**
#' 
#'     Sample values: `i686` | `x86_64`
#' 
#' -   **`REPOSITORY`**
#' 
#'     Sample values: `Core` | `Updates`
#' 
#' -   **`ADVISORY_ID`**
#' 
#'     Sample values: `ALAS-2018-1058` | `ALAS2-2021-1594`
#' 
#' -   **`CVE_ID`**
#' 
#'     Sample values: `CVE-2018-3615` | `CVE-2020-1472`
#' 
#' -   **`BUGZILLA_ID`**
#' 
#'     Sample values: `1463241`
#' @param MaxResults The maximum number of patches to return (per page).
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_available_patches
ssm_describe_available_patches <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAvailablePatches",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Patches")
  )
  input <- .ssm$describe_available_patches_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_available_patches_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_available_patches <- ssm_describe_available_patches

#' Describes the specified Amazon Web Services Systems Manager document
#' (SSM document)
#'
#' @description
#' Describes the specified Amazon Web Services Systems Manager document (SSM document).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_document/](https://www.paws-r-sdk.com/docs/ssm_describe_document/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the SSM document.
#' @param DocumentVersion The document version for which you want information. Can be a specific
#' version or the default version.
#' @param VersionName An optional field specifying the version of the artifact associated with
#' the document. For example, "Release 12, Update 6". This value is unique
#' across all versions of a document, and can't be changed.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_document
ssm_describe_document <- function(Name, DocumentVersion = NULL, VersionName = NULL) {
  op <- new_operation(
    name = "DescribeDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_document_input(Name = Name, DocumentVersion = DocumentVersion, VersionName = VersionName)
  output <- .ssm$describe_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_document <- ssm_describe_document

#' Describes the permissions for a Amazon Web Services Systems Manager
#' document (SSM document)
#'
#' @description
#' Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's Amazon Web Services account ID) or publicly (*All*).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_document_permission/](https://www.paws-r-sdk.com/docs/ssm_describe_document_permission/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the document for which you are the owner.
#' @param PermissionType &#91;required&#93; The permission type for the document. The permission type can be
#' *Share*.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_document_permission
ssm_describe_document_permission <- function(Name, PermissionType, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDocumentPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_document_permission_input(Name = Name, PermissionType = PermissionType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_document_permission_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_document_permission <- ssm_describe_document_permission

#' All associations for the managed node(s)
#'
#' @description
#' All associations for the managed node(s).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_effective_instance_associations/](https://www.paws-r-sdk.com/docs/ssm_describe_effective_instance_associations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The managed node ID for which you want to view all associations.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_effective_instance_associations
ssm_describe_effective_instance_associations <- function(InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEffectiveInstanceAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Associations")
  )
  input <- .ssm$describe_effective_instance_associations_input(InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_effective_instance_associations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_effective_instance_associations <- ssm_describe_effective_instance_associations

#' Retrieves the current effective patches (the patch and the approval
#' state) for the specified patch baseline
#'
#' @description
#' Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Applies to patch baselines for Windows only.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_effective_patches_for_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_describe_effective_patches_for_patch_baseline/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to retrieve the effective patches for.
#' @param MaxResults The maximum number of patches to return (per page).
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_effective_patches_for_patch_baseline
ssm_describe_effective_patches_for_patch_baseline <- function(BaselineId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEffectivePatchesForPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "EffectivePatches")
  )
  input <- .ssm$describe_effective_patches_for_patch_baseline_input(BaselineId = BaselineId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_effective_patches_for_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_effective_patches_for_patch_baseline <- ssm_describe_effective_patches_for_patch_baseline

#' The status of the associations for the managed node(s)
#'
#' @description
#' The status of the associations for the managed node(s).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_instance_associations_status/](https://www.paws-r-sdk.com/docs/ssm_describe_instance_associations_status/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The managed node IDs for which you want association status information.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_associations_status
ssm_describe_instance_associations_status <- function(InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceAssociationsStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceAssociationStatusInfos")
  )
  input <- .ssm$describe_instance_associations_status_input(InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_instance_associations_status_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_associations_status <- ssm_describe_instance_associations_status

#' Provides information about one or more of your managed nodes, including
#' the operating system platform, SSM Agent version, association status,
#' and IP address
#'
#' @description
#' Provides information about one or more of your managed nodes, including the operating system platform, SSM Agent version, association status, and IP address. This operation does not return information for nodes that are either Stopped or Terminated.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_instance_information/](https://www.paws-r-sdk.com/docs/ssm_describe_instance_information/) for full documentation.
#'
#' @param InstanceInformationFilterList This is a legacy method. We recommend that you don't use this method.
#' Instead, use the `Filters` data type. `Filters` enables you to return
#' node information by filtering based on tags applied to managed nodes.
#' 
#' Attempting to use `InstanceInformationFilterList` and `Filters` leads to
#' an exception error.
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' managed nodes. You can filter based on tags applied to your managed
#' nodes. Tag filters can't be combined with other filter types. Use this
#' `Filters` data type instead of `InstanceInformationFilterList`, which is
#' deprecated.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results. The default value is 10 items.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_information
ssm_describe_instance_information <- function(InstanceInformationFilterList = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceInformation",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceInformationList")
  )
  input <- .ssm$describe_instance_information_input(InstanceInformationFilterList = InstanceInformationFilterList, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_instance_information_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_information <- ssm_describe_instance_information

#' Retrieves the high-level patch state of one or more managed nodes
#'
#' @description
#' Retrieves the high-level patch state of one or more managed nodes.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_instance_patch_states/](https://www.paws-r-sdk.com/docs/ssm_describe_instance_patch_states/) for full documentation.
#'
#' @param InstanceIds &#91;required&#93; The ID of the managed node for which patch state information should be
#' retrieved.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of managed nodes to return (per page).
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_patch_states
ssm_describe_instance_patch_states <- function(InstanceIds, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstancePatchStates",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstancePatchStates")
  )
  input <- .ssm$describe_instance_patch_states_input(InstanceIds = InstanceIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_instance_patch_states_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_patch_states <- ssm_describe_instance_patch_states

#' Retrieves the high-level patch state for the managed nodes in the
#' specified patch group
#'
#' @description
#' Retrieves the high-level patch state for the managed nodes in the specified patch group.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_instance_patch_states_for_patch_group/](https://www.paws-r-sdk.com/docs/ssm_describe_instance_patch_states_for_patch_group/) for full documentation.
#'
#' @param PatchGroup &#91;required&#93; The name of the patch group for which the patch state information should
#' be retrieved.
#' @param Filters Each entry in the array is a structure containing:
#' 
#' -   Key (string between 1 and 200 characters)
#' 
#' -   Values (array containing a single string)
#' 
#' -   Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of patches to return (per page).
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_patch_states_for_patch_group
ssm_describe_instance_patch_states_for_patch_group <- function(PatchGroup, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstancePatchStatesForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstancePatchStates")
  )
  input <- .ssm$describe_instance_patch_states_for_patch_group_input(PatchGroup = PatchGroup, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_instance_patch_states_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_patch_states_for_patch_group <- ssm_describe_instance_patch_states_for_patch_group

#' Retrieves information about the patches on the specified managed node
#' and their state relative to the patch baseline being used for the node
#'
#' @description
#' Retrieves information about the patches on the specified managed node and their state relative to the patch baseline being used for the node.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_instance_patches/](https://www.paws-r-sdk.com/docs/ssm_describe_instance_patches/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the managed node whose patch state information should be
#' retrieved.
#' @param Filters Each element in the array is a structure containing a key-value pair.
#' 
#' Supported keys for
#' [`describe_instance_patches`][ssm_describe_instance_patches]include the
#' following:
#' 
#' -   **`Classification`**
#' 
#'     Sample values: `Security` | `SecurityUpdates`
#' 
#' -   **`KBId`**
#' 
#'     Sample values: `KB4480056` | `java-1.7.0-openjdk.x86_64`
#' 
#' -   **`Severity`**
#' 
#'     Sample values: `Important` | `Medium` | `Low`
#' 
#' -   **`State`**
#' 
#'     Sample values: `Installed` | `InstalledOther` |
#'     `InstalledPendingReboot`
#' 
#'     For lists of all `State` values, see [Understanding patch compliance
#'     state
#'     values](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-compliance-states.html)
#'     in the *Amazon Web Services Systems Manager User Guide*.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of patches to return (per page).
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_patches
ssm_describe_instance_patches <- function(InstanceId, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstancePatches",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Patches")
  )
  input <- .ssm$describe_instance_patches_input(InstanceId = InstanceId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_instance_patches_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_patches <- ssm_describe_instance_patches

#' Describes a specific delete inventory operation
#'
#' @description
#' Describes a specific delete inventory operation.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_inventory_deletions/](https://www.paws-r-sdk.com/docs/ssm_describe_inventory_deletions/) for full documentation.
#'
#' @param DeletionId Specify the delete inventory ID for which you want information. This ID
#' was returned by the [`delete_inventory`][ssm_delete_inventory]
#' operation.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_inventory_deletions
ssm_describe_inventory_deletions <- function(DeletionId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInventoryDeletions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InventoryDeletions")
  )
  input <- .ssm$describe_inventory_deletions_input(DeletionId = DeletionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_inventory_deletions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_inventory_deletions <- ssm_describe_inventory_deletions

#' Retrieves the individual task executions (one per target) for a
#' particular task run as part of a maintenance window execution
#'
#' @description
#' Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_execution_task_invocations/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_execution_task_invocations/) for full documentation.
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution the task is part of.
#' @param TaskId &#91;required&#93; The ID of the specific task in the maintenance window task that should
#' be retrieved.
#' @param Filters Optional filters used to scope down the returned task invocations. The
#' supported filter key is `STATUS` with the corresponding values
#' `PENDING`, `IN_PROGRESS`, `SUCCESS`, `FAILED`, `TIMED_OUT`,
#' `CANCELLING`, and `CANCELLED`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_execution_task_invocations
ssm_describe_maintenance_window_execution_task_invocations <- function(WindowExecutionId, TaskId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowExecutionTaskInvocations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WindowExecutionTaskInvocationIdentities")
  )
  input <- .ssm$describe_maintenance_window_execution_task_invocations_input(WindowExecutionId = WindowExecutionId, TaskId = TaskId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_execution_task_invocations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_execution_task_invocations <- ssm_describe_maintenance_window_execution_task_invocations

#' For a given maintenance window execution, lists the tasks that were run
#'
#' @description
#' For a given maintenance window execution, lists the tasks that were run.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_execution_tasks/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_execution_tasks/) for full documentation.
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution whose task executions should
#' be retrieved.
#' @param Filters Optional filters used to scope down the returned tasks. The supported
#' filter key is `STATUS` with the corresponding values `PENDING`,
#' `IN_PROGRESS`, `SUCCESS`, `FAILED`, `TIMED_OUT`, `CANCELLING`, and
#' `CANCELLED`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_execution_tasks
ssm_describe_maintenance_window_execution_tasks <- function(WindowExecutionId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowExecutionTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WindowExecutionTaskIdentities")
  )
  input <- .ssm$describe_maintenance_window_execution_tasks_input(WindowExecutionId = WindowExecutionId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_execution_tasks_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_execution_tasks <- ssm_describe_maintenance_window_execution_tasks

#' Lists the executions of a maintenance window
#'
#' @description
#' Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_executions/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_executions/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window whose executions should be retrieved.
#' @param Filters Each entry in the array is a structure containing:
#' 
#' -   Key. A string between 1 and 128 characters. Supported keys include
#'     `ExecutedBefore` and `ExecutedAfter`.
#' 
#' -   Values. An array of strings, each between 1 and 256 characters.
#'     Supported values are date/time strings in a valid ISO 8601 date/time
#'     format, such as `2021-11-04T05:00:00Z`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_executions
ssm_describe_maintenance_window_executions <- function(WindowId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WindowExecutions")
  )
  input <- .ssm$describe_maintenance_window_executions_input(WindowId = WindowId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_executions <- ssm_describe_maintenance_window_executions

#' Retrieves information about upcoming executions of a maintenance window
#'
#' @description
#' Retrieves information about upcoming executions of a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_schedule/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_schedule/) for full documentation.
#'
#' @param WindowId The ID of the maintenance window to retrieve information about.
#' @param Targets The managed node ID or key-value pair to retrieve information about.
#' @param ResourceType The type of resource you want to retrieve information about. For
#' example, `INSTANCE`.
#' @param Filters Filters used to limit the range of results. For example, you can limit
#' maintenance window executions to only those scheduled before or after a
#' certain date and time.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_schedule
ssm_describe_maintenance_window_schedule <- function(WindowId = NULL, Targets = NULL, ResourceType = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ScheduledWindowExecutions")
  )
  input <- .ssm$describe_maintenance_window_schedule_input(WindowId = WindowId, Targets = Targets, ResourceType = ResourceType, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_schedule_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_schedule <- ssm_describe_maintenance_window_schedule

#' Lists the targets registered with the maintenance window
#'
#' @description
#' Lists the targets registered with the maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_targets/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_targets/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window whose targets should be retrieved.
#' @param Filters Optional filters that can be used to narrow down the scope of the
#' returned window targets. The supported filter keys are `Type`,
#' `WindowTargetId`, and `OwnerInformation`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_targets
ssm_describe_maintenance_window_targets <- function(WindowId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Targets")
  )
  input <- .ssm$describe_maintenance_window_targets_input(WindowId = WindowId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_targets_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_targets <- ssm_describe_maintenance_window_targets

#' Lists the tasks in a maintenance window
#'
#' @description
#' Lists the tasks in a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_tasks/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_window_tasks/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window whose tasks should be retrieved.
#' @param Filters Optional filters used to narrow down the scope of the returned tasks.
#' The supported filter keys are `WindowTaskId`, `TaskArn`, `Priority`, and
#' `TaskType`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_tasks
ssm_describe_maintenance_window_tasks <- function(WindowId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Tasks")
  )
  input <- .ssm$describe_maintenance_window_tasks_input(WindowId = WindowId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_tasks_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_tasks <- ssm_describe_maintenance_window_tasks

#' Retrieves the maintenance windows in an Amazon Web Services account
#'
#' @description
#' Retrieves the maintenance windows in an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_windows/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_windows/) for full documentation.
#'
#' @param Filters Optional filters used to narrow down the scope of the returned
#' maintenance windows. Supported filter keys are `Name` and `Enabled`. For
#' example, `Name=MyMaintenanceWindow` and `Enabled=True`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_windows
ssm_describe_maintenance_windows <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindows",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WindowIdentities")
  )
  input <- .ssm$describe_maintenance_windows_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_windows_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_windows <- ssm_describe_maintenance_windows

#' Retrieves information about the maintenance window targets or tasks that
#' a managed node is associated with
#'
#' @description
#' Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_windows_for_target/](https://www.paws-r-sdk.com/docs/ssm_describe_maintenance_windows_for_target/) for full documentation.
#'
#' @param Targets &#91;required&#93; The managed node ID or key-value pair to retrieve information about.
#' @param ResourceType &#91;required&#93; The type of resource you want to retrieve information about. For
#' example, `INSTANCE`.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_windows_for_target
ssm_describe_maintenance_windows_for_target <- function(Targets, ResourceType, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowsForTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WindowIdentities")
  )
  input <- .ssm$describe_maintenance_windows_for_target_input(Targets = Targets, ResourceType = ResourceType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_windows_for_target_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_windows_for_target <- ssm_describe_maintenance_windows_for_target

#' Query a set of OpsItems
#'
#' @description
#' Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_ops_items/](https://www.paws-r-sdk.com/docs/ssm_describe_ops_items/) for full documentation.
#'
#' @param OpsItemFilters One or more filters to limit the response.
#' 
#' -   Key: CreatedTime
#' 
#'     Operations: GreaterThan, LessThan
#' 
#' -   Key: LastModifiedBy
#' 
#'     Operations: Contains, Equals
#' 
#' -   Key: LastModifiedTime
#' 
#'     Operations: GreaterThan, LessThan
#' 
#' -   Key: Priority
#' 
#'     Operations: Equals
#' 
#' -   Key: Source
#' 
#'     Operations: Contains, Equals
#' 
#' -   Key: Status
#' 
#'     Operations: Equals
#' 
#' -   Key: Title*
#' 
#'     Operations: Equals,Contains
#' 
#' -   Key: OperationalData**
#' 
#'     Operations: Equals
#' 
#' -   Key: OperationalDataKey
#' 
#'     Operations: Equals
#' 
#' -   Key: OperationalDataValue
#' 
#'     Operations: Equals, Contains
#' 
#' -   Key: OpsItemId
#' 
#'     Operations: Equals
#' 
#' -   Key: ResourceId
#' 
#'     Operations: Contains
#' 
#' -   Key: AutomationId
#' 
#'     Operations: Equals
#' 
#' -   Key: AccountId
#' 
#'     Operations: Equals
#' 
#' *The Equals operator for Title matches the first 100 characters. If you
#' specify more than 100 characters, they system returns an error that the
#' filter value exceeds the length limit.
#' 
#' **If you filter the response by using the OperationalData operator,
#' specify a key-value pair by using the following JSON format:
#' \{"key":"key_name","value":"a_value"\}
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_ops_items
ssm_describe_ops_items <- function(OpsItemFilters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOpsItems",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "OpsItemSummaries")
  )
  input <- .ssm$describe_ops_items_input(OpsItemFilters = OpsItemFilters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_ops_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_ops_items <- ssm_describe_ops_items

#' Get information about a parameter
#'
#' @description
#' Get information about a parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_parameters/](https://www.paws-r-sdk.com/docs/ssm_describe_parameters/) for full documentation.
#'
#' @param Filters This data type is deprecated. Instead, use `ParameterFilters`.
#' @param ParameterFilters Filters to limit the request results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_parameters
ssm_describe_parameters <- function(Filters = NULL, ParameterFilters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .ssm$describe_parameters_input(Filters = Filters, ParameterFilters = ParameterFilters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_parameters_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_parameters <- ssm_describe_parameters

#' Lists the patch baselines in your Amazon Web Services account
#'
#' @description
#' Lists the patch baselines in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_patch_baselines/](https://www.paws-r-sdk.com/docs/ssm_describe_patch_baselines/) for full documentation.
#'
#' @param Filters Each element in the array is a structure containing a key-value pair.
#' 
#' Supported keys for
#' [`describe_patch_baselines`][ssm_describe_patch_baselines] include the
#' following:
#' 
#' -   **`NAME_PREFIX`**
#' 
#'     Sample values: `AWS-` | `My-`
#' 
#' -   **`OWNER`**
#' 
#'     Sample values: `AWS` | `Self`
#' 
#' -   **`OPERATING_SYSTEM`**
#' 
#'     Sample values: `AMAZON_LINUX` | `SUSE` | `WINDOWS`
#' @param MaxResults The maximum number of patch baselines to return (per page).
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_baselines
ssm_describe_patch_baselines <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePatchBaselines",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "BaselineIdentities")
  )
  input <- .ssm$describe_patch_baselines_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_patch_baselines_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_baselines <- ssm_describe_patch_baselines

#' Returns high-level aggregated patch compliance state information for a
#' patch group
#'
#' @description
#' Returns high-level aggregated patch compliance state information for a patch group.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_patch_group_state/](https://www.paws-r-sdk.com/docs/ssm_describe_patch_group_state/) for full documentation.
#'
#' @param PatchGroup &#91;required&#93; The name of the patch group whose patch snapshot should be retrieved.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_group_state
ssm_describe_patch_group_state <- function(PatchGroup) {
  op <- new_operation(
    name = "DescribePatchGroupState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_patch_group_state_input(PatchGroup = PatchGroup)
  output <- .ssm$describe_patch_group_state_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_group_state <- ssm_describe_patch_group_state

#' Lists all patch groups that have been registered with patch baselines
#'
#' @description
#' Lists all patch groups that have been registered with patch baselines.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_patch_groups/](https://www.paws-r-sdk.com/docs/ssm_describe_patch_groups/) for full documentation.
#'
#' @param MaxResults The maximum number of patch groups to return (per page).
#' @param Filters Each element in the array is a structure containing a key-value pair.
#' 
#' Supported keys for [`describe_patch_groups`][ssm_describe_patch_groups]
#' include the following:
#' 
#' -   **`NAME_PREFIX`**
#' 
#'     Sample values: `AWS-` | `My-`.
#' 
#' -   **`OPERATING_SYSTEM`**
#' 
#'     Sample values: `AMAZON_LINUX` | `SUSE` | `WINDOWS`
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_groups
ssm_describe_patch_groups <- function(MaxResults = NULL, Filters = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePatchGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Mappings")
  )
  input <- .ssm$describe_patch_groups_input(MaxResults = MaxResults, Filters = Filters, NextToken = NextToken)
  output <- .ssm$describe_patch_groups_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_groups <- ssm_describe_patch_groups

#' Lists the properties of available patches organized by product, product
#' family, classification, severity, and other properties of available
#' patches
#'
#' @description
#' Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for operations such as [`create_patch_baseline`][ssm_create_patch_baseline], [`update_patch_baseline`][ssm_update_patch_baseline], [`describe_available_patches`][ssm_describe_available_patches], and [`describe_patch_baselines`][ssm_describe_patch_baselines].
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_patch_properties/](https://www.paws-r-sdk.com/docs/ssm_describe_patch_properties/) for full documentation.
#'
#' @param OperatingSystem &#91;required&#93; The operating system type for which to list patches.
#' @param Property &#91;required&#93; The patch property for which you want to view patch details.
#' @param PatchSet Indicates whether to list patches for the Windows operating system or
#' for applications released by Microsoft. Not applicable for the Linux or
#' macOS operating systems.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_properties
ssm_describe_patch_properties <- function(OperatingSystem, Property, PatchSet = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePatchProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Properties")
  )
  input <- .ssm$describe_patch_properties_input(OperatingSystem = OperatingSystem, Property = Property, PatchSet = PatchSet, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_patch_properties_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_properties <- ssm_describe_patch_properties

#' Retrieves a list of all active sessions (both connected and
#' disconnected) or terminated sessions from the past 30 days
#'
#' @description
#' Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_describe_sessions/](https://www.paws-r-sdk.com/docs/ssm_describe_sessions/) for full documentation.
#'
#' @param State &#91;required&#93; The session status to retrieve a list of sessions for. For example,
#' "Active".
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param Filters One or more filters to limit the type of sessions returned by the
#' request.
#'
#' @keywords internal
#'
#' @rdname ssm_describe_sessions
ssm_describe_sessions <- function(State, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Sessions")
  )
  input <- .ssm$describe_sessions_input(State = State, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ssm$describe_sessions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_sessions <- ssm_describe_sessions

#' Deletes the association between an OpsItem and a related item
#'
#' @description
#' Deletes the association between an OpsItem and a related item. For example, this API operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of Amazon Web Services Systems Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_disassociate_ops_item_related_item/](https://www.paws-r-sdk.com/docs/ssm_disassociate_ops_item_related_item/) for full documentation.
#'
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem for which you want to delete an association
#' between the OpsItem and a related item.
#' @param AssociationId &#91;required&#93; The ID of the association for which you want to delete an association
#' between the OpsItem and a related item.
#'
#' @keywords internal
#'
#' @rdname ssm_disassociate_ops_item_related_item
ssm_disassociate_ops_item_related_item <- function(OpsItemId, AssociationId) {
  op <- new_operation(
    name = "DisassociateOpsItemRelatedItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$disassociate_ops_item_related_item_input(OpsItemId = OpsItemId, AssociationId = AssociationId)
  output <- .ssm$disassociate_ops_item_related_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$disassociate_ops_item_related_item <- ssm_disassociate_ops_item_related_item

#' Get detailed information about a particular Automation execution
#'
#' @description
#' Get detailed information about a particular Automation execution.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_automation_execution/](https://www.paws-r-sdk.com/docs/ssm_get_automation_execution/) for full documentation.
#'
#' @param AutomationExecutionId &#91;required&#93; The unique identifier for an existing automation execution to examine.
#' The execution ID is returned by StartAutomationExecution when the
#' execution of an Automation runbook is initiated.
#'
#' @keywords internal
#'
#' @rdname ssm_get_automation_execution
ssm_get_automation_execution <- function(AutomationExecutionId) {
  op <- new_operation(
    name = "GetAutomationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_automation_execution_input(AutomationExecutionId = AutomationExecutionId)
  output <- .ssm$get_automation_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_automation_execution <- ssm_get_automation_execution

#' Gets the state of a Amazon Web Services Systems Manager change calendar
#' at the current time or a specified time
#'
#' @description
#' Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If you specify a time, [`get_calendar_state`][ssm_get_calendar_state] returns the state of the calendar at that specific time, and returns the next time that the change calendar state will transition. If you don't specify a time, [`get_calendar_state`][ssm_get_calendar_state] uses the current time. Change Calendar entries have two possible states: `OPEN` or `CLOSED`.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_calendar_state/](https://www.paws-r-sdk.com/docs/ssm_get_calendar_state/) for full documentation.
#'
#' @param CalendarNames &#91;required&#93; The names or Amazon Resource Names (ARNs) of the Systems Manager
#' documents (SSM documents) that represent the calendar entries for which
#' you want to get the state.
#' @param AtTime (Optional) The specific time for which you want to get calendar state
#' information, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
#' format. If you don't specify a value or `AtTime`, the current time is
#' used.
#'
#' @keywords internal
#'
#' @rdname ssm_get_calendar_state
ssm_get_calendar_state <- function(CalendarNames, AtTime = NULL) {
  op <- new_operation(
    name = "GetCalendarState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_calendar_state_input(CalendarNames = CalendarNames, AtTime = AtTime)
  output <- .ssm$get_calendar_state_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_calendar_state <- ssm_get_calendar_state

#' Returns detailed information about command execution for an invocation
#' or plugin
#'
#' @description
#' Returns detailed information about command execution for an invocation or plugin.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_command_invocation/](https://www.paws-r-sdk.com/docs/ssm_get_command_invocation/) for full documentation.
#'
#' @param CommandId &#91;required&#93; (Required) The parent command ID of the invocation plugin.
#' @param InstanceId &#91;required&#93; (Required) The ID of the managed node targeted by the command. A
#' *managed node* can be an Amazon Elastic Compute Cloud (Amazon EC2)
#' instance, edge device, and on-premises server or VM in your hybrid
#' environment that is configured for Amazon Web Services Systems Manager.
#' @param PluginName The name of the step for which you want detailed results. If the
#' document contains only one step, you can omit the name and details for
#' that step. If the document contains more than one step, you must specify
#' the name of the step for which you want to view details. Be sure to
#' specify the name of the step, not the name of a plugin like
#' `aws:RunShellScript`.
#' 
#' To find the `PluginName`, check the document content and find the name
#' of the step you want details for. Alternatively, use
#' [`list_command_invocations`][ssm_list_command_invocations] with the
#' `CommandId` and `Details` parameters. The `PluginName` is the `Name`
#' attribute of the `CommandPlugin` object in the `CommandPlugins` list.
#'
#' @keywords internal
#'
#' @rdname ssm_get_command_invocation
ssm_get_command_invocation <- function(CommandId, InstanceId, PluginName = NULL) {
  op <- new_operation(
    name = "GetCommandInvocation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_command_invocation_input(CommandId = CommandId, InstanceId = InstanceId, PluginName = PluginName)
  output <- .ssm$get_command_invocation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_command_invocation <- ssm_get_command_invocation

#' Retrieves the Session Manager connection status for a managed node to
#' determine whether it is running and ready to receive Session Manager
#' connections
#'
#' @description
#' Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready to receive Session Manager connections.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_connection_status/](https://www.paws-r-sdk.com/docs/ssm_get_connection_status/) for full documentation.
#'
#' @param Target &#91;required&#93; The managed node ID.
#'
#' @keywords internal
#'
#' @rdname ssm_get_connection_status
ssm_get_connection_status <- function(Target) {
  op <- new_operation(
    name = "GetConnectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_connection_status_input(Target = Target)
  output <- .ssm$get_connection_status_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_connection_status <- ssm_get_connection_status

#' Retrieves the default patch baseline
#'
#' @description
#' Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_default_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_get_default_patch_baseline/) for full documentation.
#'
#' @param OperatingSystem Returns the default patch baseline for the specified operating system.
#'
#' @keywords internal
#'
#' @rdname ssm_get_default_patch_baseline
ssm_get_default_patch_baseline <- function(OperatingSystem = NULL) {
  op <- new_operation(
    name = "GetDefaultPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_default_patch_baseline_input(OperatingSystem = OperatingSystem)
  output <- .ssm$get_default_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_default_patch_baseline <- ssm_get_default_patch_baseline

#' Retrieves the current snapshot for the patch baseline the managed node
#' uses
#'
#' @description
#' Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the `AWS-RunPatchBaseline` Systems Manager document (SSM document).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_deployable_patch_snapshot_for_instance/](https://www.paws-r-sdk.com/docs/ssm_get_deployable_patch_snapshot_for_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the managed node for which the appropriate patch snapshot
#' should be retrieved.
#' @param SnapshotId &#91;required&#93; The snapshot ID provided by the user when running
#' `AWS-RunPatchBaseline`.
#' @param BaselineOverride Defines the basic information about a patch baseline override.
#'
#' @keywords internal
#'
#' @rdname ssm_get_deployable_patch_snapshot_for_instance
ssm_get_deployable_patch_snapshot_for_instance <- function(InstanceId, SnapshotId, BaselineOverride = NULL) {
  op <- new_operation(
    name = "GetDeployablePatchSnapshotForInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_deployable_patch_snapshot_for_instance_input(InstanceId = InstanceId, SnapshotId = SnapshotId, BaselineOverride = BaselineOverride)
  output <- .ssm$get_deployable_patch_snapshot_for_instance_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_deployable_patch_snapshot_for_instance <- ssm_get_deployable_patch_snapshot_for_instance

#' Gets the contents of the specified Amazon Web Services Systems Manager
#' document (SSM document)
#'
#' @description
#' Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_document/](https://www.paws-r-sdk.com/docs/ssm_get_document/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the SSM document.
#' @param VersionName An optional field specifying the version of the artifact associated with
#' the document. For example, "Release 12, Update 6". This value is unique
#' across all versions of a document and can't be changed.
#' @param DocumentVersion The document version for which you want information.
#' @param DocumentFormat Returns the document in the specified format. The document format can be
#' either JSON or YAML. JSON is the default format.
#'
#' @keywords internal
#'
#' @rdname ssm_get_document
ssm_get_document <- function(Name, VersionName = NULL, DocumentVersion = NULL, DocumentFormat = NULL) {
  op <- new_operation(
    name = "GetDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_document_input(Name = Name, VersionName = VersionName, DocumentVersion = DocumentVersion, DocumentFormat = DocumentFormat)
  output <- .ssm$get_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_document <- ssm_get_document

#' Query inventory information
#'
#' @description
#' Query inventory information. This includes managed node status, such as `Stopped` or `Terminated`.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_inventory/](https://www.paws-r-sdk.com/docs/ssm_get_inventory/) for full documentation.
#'
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param Aggregators Returns counts of inventory types based on one or more expressions. For
#' example, if you aggregate by using an expression that uses the
#' `AWS:InstanceInformation.PlatformType` type, you can see a count of how
#' many Windows and Linux managed nodes exist in your inventoried fleet.
#' @param ResultAttributes The list of inventory item types to return.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_get_inventory
ssm_get_inventory <- function(Filters = NULL, Aggregators = NULL, ResultAttributes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Entities")
  )
  input <- .ssm$get_inventory_input(Filters = Filters, Aggregators = Aggregators, ResultAttributes = ResultAttributes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$get_inventory_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_inventory <- ssm_get_inventory

#' Return a list of inventory type names for the account, or return a list
#' of attribute names for a specific Inventory item type
#'
#' @description
#' Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_inventory_schema/](https://www.paws-r-sdk.com/docs/ssm_get_inventory_schema/) for full documentation.
#'
#' @param TypeName The type of inventory item to return.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param Aggregator Returns inventory schemas that support aggregation. For example, this
#' call returns the `AWS:InstanceInformation` type, because it supports
#' aggregation based on the `PlatformName`, `PlatformType`, and
#' `PlatformVersion` attributes.
#' @param SubType Returns the sub-type schema for a specified inventory type.
#'
#' @keywords internal
#'
#' @rdname ssm_get_inventory_schema
ssm_get_inventory_schema <- function(TypeName = NULL, NextToken = NULL, MaxResults = NULL, Aggregator = NULL, SubType = NULL) {
  op <- new_operation(
    name = "GetInventorySchema",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Schemas")
  )
  input <- .ssm$get_inventory_schema_input(TypeName = TypeName, NextToken = NextToken, MaxResults = MaxResults, Aggregator = Aggregator, SubType = SubType)
  output <- .ssm$get_inventory_schema_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_inventory_schema <- ssm_get_inventory_schema

#' Retrieves a maintenance window
#'
#' @description
#' Retrieves a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window for which you want to retrieve
#' information.
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window
ssm_get_maintenance_window <- function(WindowId) {
  op <- new_operation(
    name = "GetMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_input(WindowId = WindowId)
  output <- .ssm$get_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window <- ssm_get_maintenance_window

#' Retrieves details about a specific a maintenance window execution
#'
#' @description
#' Retrieves details about a specific a maintenance window execution.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_execution/](https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_execution/) for full documentation.
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution that includes the task.
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_execution
ssm_get_maintenance_window_execution <- function(WindowExecutionId) {
  op <- new_operation(
    name = "GetMaintenanceWindowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_execution_input(WindowExecutionId = WindowExecutionId)
  output <- .ssm$get_maintenance_window_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_execution <- ssm_get_maintenance_window_execution

#' Retrieves the details about a specific task run as part of a maintenance
#' window execution
#'
#' @description
#' Retrieves the details about a specific task run as part of a maintenance window execution.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_execution_task/](https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_execution_task/) for full documentation.
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution that includes the task.
#' @param TaskId &#91;required&#93; The ID of the specific task execution in the maintenance window task
#' that should be retrieved.
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_execution_task
ssm_get_maintenance_window_execution_task <- function(WindowExecutionId, TaskId) {
  op <- new_operation(
    name = "GetMaintenanceWindowExecutionTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_execution_task_input(WindowExecutionId = WindowExecutionId, TaskId = TaskId)
  output <- .ssm$get_maintenance_window_execution_task_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_execution_task <- ssm_get_maintenance_window_execution_task

#' Retrieves information about a specific task running on a specific target
#'
#' @description
#' Retrieves information about a specific task running on a specific target.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_execution_task_invocation/](https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_execution_task_invocation/) for full documentation.
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution for which the task is a part.
#' @param TaskId &#91;required&#93; The ID of the specific task in the maintenance window task that should
#' be retrieved.
#' @param InvocationId &#91;required&#93; The invocation ID to retrieve.
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_execution_task_invocation
ssm_get_maintenance_window_execution_task_invocation <- function(WindowExecutionId, TaskId, InvocationId) {
  op <- new_operation(
    name = "GetMaintenanceWindowExecutionTaskInvocation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_execution_task_invocation_input(WindowExecutionId = WindowExecutionId, TaskId = TaskId, InvocationId = InvocationId)
  output <- .ssm$get_maintenance_window_execution_task_invocation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_execution_task_invocation <- ssm_get_maintenance_window_execution_task_invocation

#' Retrieves the details of a maintenance window task
#'
#' @description
#' Retrieves the details of a maintenance window task.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_task/](https://www.paws-r-sdk.com/docs/ssm_get_maintenance_window_task/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The maintenance window ID that includes the task to retrieve.
#' @param WindowTaskId &#91;required&#93; The maintenance window task ID to retrieve.
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_task
ssm_get_maintenance_window_task <- function(WindowId, WindowTaskId) {
  op <- new_operation(
    name = "GetMaintenanceWindowTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_task_input(WindowId = WindowId, WindowTaskId = WindowTaskId)
  output <- .ssm$get_maintenance_window_task_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_task <- ssm_get_maintenance_window_task

#' Get information about an OpsItem by using the ID
#'
#' @description
#' Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_ops_item/](https://www.paws-r-sdk.com/docs/ssm_get_ops_item/) for full documentation.
#'
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem that you want to get.
#' @param OpsItemArn The OpsItem Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname ssm_get_ops_item
ssm_get_ops_item <- function(OpsItemId, OpsItemArn = NULL) {
  op <- new_operation(
    name = "GetOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_ops_item_input(OpsItemId = OpsItemId, OpsItemArn = OpsItemArn)
  output <- .ssm$get_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_ops_item <- ssm_get_ops_item

#' View operational metadata related to an application in Application
#' Manager
#'
#' @description
#' View operational metadata related to an application in Application Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_ops_metadata/](https://www.paws-r-sdk.com/docs/ssm_get_ops_metadata/) for full documentation.
#'
#' @param OpsMetadataArn &#91;required&#93; The Amazon Resource Name (ARN) of an OpsMetadata Object to view.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_get_ops_metadata
ssm_get_ops_metadata <- function(OpsMetadataArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetOpsMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_ops_metadata_input(OpsMetadataArn = OpsMetadataArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$get_ops_metadata_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_ops_metadata <- ssm_get_ops_metadata

#' View a summary of operations metadata (OpsData) based on specified
#' filters and aggregators
#'
#' @description
#' View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_ops_summary/](https://www.paws-r-sdk.com/docs/ssm_get_ops_summary/) for full documentation.
#'
#' @param SyncName Specify the name of a resource data sync to get.
#' @param Filters Optional filters used to scope down the returned OpsData.
#' @param Aggregators Optional aggregators that return counts of OpsData based on one or more
#' expressions.
#' @param ResultAttributes The OpsData data type to return.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_get_ops_summary
ssm_get_ops_summary <- function(SyncName = NULL, Filters = NULL, Aggregators = NULL, ResultAttributes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetOpsSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Entities")
  )
  input <- .ssm$get_ops_summary_input(SyncName = SyncName, Filters = Filters, Aggregators = Aggregators, ResultAttributes = ResultAttributes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$get_ops_summary_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_ops_summary <- ssm_get_ops_summary

#' Get information about a single parameter by specifying the parameter
#' name
#'
#' @description
#' Get information about a single parameter by specifying the parameter name.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_parameter/](https://www.paws-r-sdk.com/docs/ssm_get_parameter/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parameter you want to query.
#' 
#' To query by parameter label, use `"Name": "name:label"`. To query by
#' parameter version, use `"Name": "name:version"`.
#' @param WithDecryption Return decrypted values for secure string parameters. This flag is
#' ignored for `String` and `StringList` parameter types.
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameter
ssm_get_parameter <- function(Name, WithDecryption = NULL) {
  op <- new_operation(
    name = "GetParameter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_parameter_input(Name = Name, WithDecryption = WithDecryption)
  output <- .ssm$get_parameter_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameter <- ssm_get_parameter

#' Retrieves the history of all changes to a parameter
#'
#' @description
#' Retrieves the history of all changes to a parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_parameter_history/](https://www.paws-r-sdk.com/docs/ssm_get_parameter_history/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parameter for which you want to review history.
#' @param WithDecryption Return decrypted values for secure string parameters. This flag is
#' ignored for `String` and `StringList` parameter types.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameter_history
ssm_get_parameter_history <- function(Name, WithDecryption = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetParameterHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .ssm$get_parameter_history_input(Name = Name, WithDecryption = WithDecryption, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$get_parameter_history_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameter_history <- ssm_get_parameter_history

#' Get information about one or more parameters by specifying multiple
#' parameter names
#'
#' @description
#' Get information about one or more parameters by specifying multiple parameter names.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_parameters/](https://www.paws-r-sdk.com/docs/ssm_get_parameters/) for full documentation.
#'
#' @param Names &#91;required&#93; Names of the parameters for which you want to query information.
#' 
#' To query by parameter label, use `"Name": "name:label"`. To query by
#' parameter version, use `"Name": "name:version"`.
#' @param WithDecryption Return decrypted secure string value. Return decrypted values for secure
#' string parameters. This flag is ignored for `String` and `StringList`
#' parameter types.
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameters
ssm_get_parameters <- function(Names, WithDecryption = NULL) {
  op <- new_operation(
    name = "GetParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_parameters_input(Names = Names, WithDecryption = WithDecryption)
  output <- .ssm$get_parameters_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameters <- ssm_get_parameters

#' Retrieve information about one or more parameters in a specific
#' hierarchy
#'
#' @description
#' Retrieve information about one or more parameters in a specific hierarchy.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_parameters_by_path/](https://www.paws-r-sdk.com/docs/ssm_get_parameters_by_path/) for full documentation.
#'
#' @param Path &#91;required&#93; The hierarchy for the parameter. Hierarchies start with a forward slash
#' (/). The hierarchy is the parameter name except the last part of the
#' parameter. For the API call to succeed, the last part of the parameter
#' name can't be in the path. A parameter name hierarchy can have a maximum
#' of 15 levels. Here is an example of a hierarchy:
#' `/Finance/Prod/IAD/WinServ2016/license33 `
#' @param Recursive Retrieve all parameters within a hierarchy.
#' 
#' If a user has access to a path, then the user can access all levels of
#' that path. For example, if a user has permission to access path `/a`,
#' then the user can also access `/a/b`. Even if a user has explicitly been
#' denied access in IAM for parameter `/a/b`, they can still call the
#' GetParametersByPath API operation recursively for `/a` and view `/a/b`.
#' @param ParameterFilters Filters to limit the request results.
#' 
#' The following `Key` values are supported for
#' [`get_parameters_by_path`][ssm_get_parameters_by_path]: `Type`, `KeyId`,
#' and `Label`.
#' 
#' The following `Key` values aren't supported for
#' [`get_parameters_by_path`][ssm_get_parameters_by_path]: `tag`,
#' `DataType`, `Name`, `Path`, and `Tier`.
#' @param WithDecryption Retrieve all parameters in a hierarchy with their value decrypted.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameters_by_path
ssm_get_parameters_by_path <- function(Path, Recursive = NULL, ParameterFilters = NULL, WithDecryption = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetParametersByPath",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .ssm$get_parameters_by_path_input(Path = Path, Recursive = Recursive, ParameterFilters = ParameterFilters, WithDecryption = WithDecryption, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$get_parameters_by_path_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameters_by_path <- ssm_get_parameters_by_path

#' Retrieves information about a patch baseline
#'
#' @description
#' Retrieves information about a patch baseline.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_get_patch_baseline/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to retrieve.
#' 
#' To retrieve information about an Amazon Web Services managed patch
#' baseline, specify the full Amazon Resource Name (ARN) of the baseline.
#' For example, for the baseline `AWS-AmazonLinuxDefaultPatchBaseline`,
#' specify
#' `arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7`
#' instead of `pb-0e392de35e7c563b7`.
#'
#' @keywords internal
#'
#' @rdname ssm_get_patch_baseline
ssm_get_patch_baseline <- function(BaselineId) {
  op <- new_operation(
    name = "GetPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_patch_baseline_input(BaselineId = BaselineId)
  output <- .ssm$get_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_patch_baseline <- ssm_get_patch_baseline

#' Retrieves the patch baseline that should be used for the specified patch
#' group
#'
#' @description
#' Retrieves the patch baseline that should be used for the specified patch group.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_patch_baseline_for_patch_group/](https://www.paws-r-sdk.com/docs/ssm_get_patch_baseline_for_patch_group/) for full documentation.
#'
#' @param PatchGroup &#91;required&#93; The name of the patch group whose patch baseline should be retrieved.
#' @param OperatingSystem Returns the operating system rule specified for patch groups using the
#' patch baseline.
#'
#' @keywords internal
#'
#' @rdname ssm_get_patch_baseline_for_patch_group
ssm_get_patch_baseline_for_patch_group <- function(PatchGroup, OperatingSystem = NULL) {
  op <- new_operation(
    name = "GetPatchBaselineForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_patch_baseline_for_patch_group_input(PatchGroup = PatchGroup, OperatingSystem = OperatingSystem)
  output <- .ssm$get_patch_baseline_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_patch_baseline_for_patch_group <- ssm_get_patch_baseline_for_patch_group

#' Returns an array of the Policy object
#'
#' @description
#' Returns an array of the `Policy` object.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_resource_policies/](https://www.paws-r-sdk.com/docs/ssm_get_resource_policies/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource to which the policies are
#' attached.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_get_resource_policies
ssm_get_resource_policies <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Policies")
  )
  input <- .ssm$get_resource_policies_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$get_resource_policies_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_resource_policies <- ssm_get_resource_policies

#' ServiceSetting is an account-level setting for an Amazon Web Services
#' service
#'
#' @description
#' `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of `false`. This means the user can't use this feature unless they change the setting to `true` and intentionally opt in for a paid feature.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_get_service_setting/](https://www.paws-r-sdk.com/docs/ssm_get_service_setting/) for full documentation.
#'
#' @param SettingId &#91;required&#93; The ID of the service setting to get. The setting ID can be one of the
#' following.
#' 
#' -   `/ssm/managed-instance/default-ec2-instance-management-role`
#' 
#' -   `/ssm/automation/customer-script-log-destination`
#' 
#' -   `/ssm/automation/customer-script-log-group-name`
#' 
#' -   `/ssm/documents/console/public-sharing-permission`
#' 
#' -   `/ssm/managed-instance/activation-tier`
#' 
#' -   `/ssm/opsinsights/opscenter`
#' 
#' -   `/ssm/parameter-store/default-parameter-tier`
#' 
#' -   `/ssm/parameter-store/high-throughput-enabled`
#'
#' @keywords internal
#'
#' @rdname ssm_get_service_setting
ssm_get_service_setting <- function(SettingId) {
  op <- new_operation(
    name = "GetServiceSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_service_setting_input(SettingId = SettingId)
  output <- .ssm$get_service_setting_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_service_setting <- ssm_get_service_setting

#' A parameter label is a user-defined alias to help you manage different
#' versions of a parameter
#'
#' @description
#' A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_label_parameter_version/](https://www.paws-r-sdk.com/docs/ssm_label_parameter_version/) for full documentation.
#'
#' @param Name &#91;required&#93; The parameter name on which you want to attach one or more labels.
#' @param ParameterVersion The specific version of the parameter on which you want to attach one or
#' more labels. If no version is specified, the system attaches the label
#' to the latest version.
#' @param Labels &#91;required&#93; One or more labels to attach to the specified parameter version.
#'
#' @keywords internal
#'
#' @rdname ssm_label_parameter_version
ssm_label_parameter_version <- function(Name, ParameterVersion = NULL, Labels) {
  op <- new_operation(
    name = "LabelParameterVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$label_parameter_version_input(Name = Name, ParameterVersion = ParameterVersion, Labels = Labels)
  output <- .ssm$label_parameter_version_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$label_parameter_version <- ssm_label_parameter_version

#' Retrieves all versions of an association for a specific association ID
#'
#' @description
#' Retrieves all versions of an association for a specific association ID.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_association_versions/](https://www.paws-r-sdk.com/docs/ssm_list_association_versions/) for full documentation.
#'
#' @param AssociationId &#91;required&#93; The association ID for which you want to view all versions.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_association_versions
ssm_list_association_versions <- function(AssociationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociationVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AssociationVersions")
  )
  input <- .ssm$list_association_versions_input(AssociationId = AssociationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_association_versions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_association_versions <- ssm_list_association_versions

#' Returns all State Manager associations in the current Amazon Web
#' Services account and Amazon Web Services Region
#'
#' @description
#' Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results to a specific State Manager association document or managed node by specifying a filter. State Manager is a capability of Amazon Web Services Systems Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_associations/](https://www.paws-r-sdk.com/docs/ssm_list_associations/) for full documentation.
#'
#' @param AssociationFilterList One or more filters. Use a filter to return a more specific list of
#' results.
#' 
#' Filtering associations using the `InstanceID` attribute only returns
#' legacy associations created using the `InstanceID` attribute.
#' Associations targeting the managed node that are part of the Target
#' Attributes `ResourceGroup` or `Tags` aren't returned.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_list_associations
ssm_list_associations <- function(AssociationFilterList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Associations")
  )
  input <- .ssm$list_associations_input(AssociationFilterList = AssociationFilterList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_associations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_associations <- ssm_list_associations

#' An invocation is copy of a command sent to a specific managed node
#'
#' @description
#' An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs [`send_command`][ssm_send_command] against three managed nodes, then a command invocation is created for each requested managed node ID. [`list_command_invocations`][ssm_list_command_invocations] provide status about command execution.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_command_invocations/](https://www.paws-r-sdk.com/docs/ssm_list_command_invocations/) for full documentation.
#'
#' @param CommandId (Optional) The invocations for a specific command ID.
#' @param InstanceId (Optional) The command execution details for a specific managed node ID.
#' @param MaxResults (Optional) The maximum number of items to return for this call. The call
#' also returns a token that you can specify in a subsequent call to get
#' the next set of results.
#' @param NextToken (Optional) The token for the next set of items to return. (You received
#' this token from a previous call.)
#' @param Filters (Optional) One or more filters. Use a filter to return a more specific
#' list of results.
#' @param Details (Optional) If set this returns the response of the command executions
#' and any command output. The default value is `false`.
#'
#' @keywords internal
#'
#' @rdname ssm_list_command_invocations
ssm_list_command_invocations <- function(CommandId = NULL, InstanceId = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, Details = NULL) {
  op <- new_operation(
    name = "ListCommandInvocations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CommandInvocations")
  )
  input <- .ssm$list_command_invocations_input(CommandId = CommandId, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, Details = Details)
  output <- .ssm$list_command_invocations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_command_invocations <- ssm_list_command_invocations

#' Lists the commands requested by users of the Amazon Web Services account
#'
#' @description
#' Lists the commands requested by users of the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_commands/](https://www.paws-r-sdk.com/docs/ssm_list_commands/) for full documentation.
#'
#' @param CommandId (Optional) If provided, lists only the specified command.
#' @param InstanceId (Optional) Lists commands issued against this managed node ID.
#' 
#' You can't specify a managed node ID in the same command that you specify
#' `Status` = `Pending`. This is because the command hasn't reached the
#' managed node yet.
#' @param MaxResults (Optional) The maximum number of items to return for this call. The call
#' also returns a token that you can specify in a subsequent call to get
#' the next set of results.
#' @param NextToken (Optional) The token for the next set of items to return. (You received
#' this token from a previous call.)
#' @param Filters (Optional) One or more filters. Use a filter to return a more specific
#' list of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_commands
ssm_list_commands <- function(CommandId = NULL, InstanceId = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListCommands",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Commands")
  )
  input <- .ssm$list_commands_input(CommandId = CommandId, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ssm$list_commands_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_commands <- ssm_list_commands

#' For a specified resource ID, this API operation returns a list of
#' compliance statuses for different resource types
#'
#' @description
#' For a specified resource ID, this API operation returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_compliance_items/](https://www.paws-r-sdk.com/docs/ssm_list_compliance_items/) for full documentation.
#'
#' @param Filters One or more compliance filters. Use a filter to return a more specific
#' list of results.
#' @param ResourceIds The ID for the resources from which to get compliance information.
#' Currently, you can only specify one resource ID.
#' @param ResourceTypes The type of resource from which to get compliance information.
#' Currently, the only supported resource type is `ManagedInstance`.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_compliance_items
ssm_list_compliance_items <- function(Filters = NULL, ResourceIds = NULL, ResourceTypes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComplianceItems",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ComplianceItems")
  )
  input <- .ssm$list_compliance_items_input(Filters = Filters, ResourceIds = ResourceIds, ResourceTypes = ResourceTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_compliance_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_compliance_items <- ssm_list_compliance_items

#' Returns a summary count of compliant and non-compliant resources for a
#' compliance type
#'
#' @description
#' Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_compliance_summaries/](https://www.paws-r-sdk.com/docs/ssm_list_compliance_summaries/) for full documentation.
#'
#' @param Filters One or more compliance or inventory filters. Use a filter to return a
#' more specific list of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. Currently, you can
#' specify null or 50. The call also returns a token that you can specify
#' in a subsequent call to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_compliance_summaries
ssm_list_compliance_summaries <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComplianceSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ComplianceSummaryItems")
  )
  input <- .ssm$list_compliance_summaries_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_compliance_summaries_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_compliance_summaries <- ssm_list_compliance_summaries

#' Information about approval reviews for a version of a change template in
#' Change Manager
#'
#' @description
#' Information about approval reviews for a version of a change template in Change Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_document_metadata_history/](https://www.paws-r-sdk.com/docs/ssm_list_document_metadata_history/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the change template.
#' @param DocumentVersion The version of the change template.
#' @param Metadata &#91;required&#93; The type of data for which details are being requested. Currently, the
#' only supported value is `DocumentReviews`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_document_metadata_history
ssm_list_document_metadata_history <- function(Name, DocumentVersion = NULL, Metadata, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDocumentMetadataHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_document_metadata_history_input(Name = Name, DocumentVersion = DocumentVersion, Metadata = Metadata, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_document_metadata_history_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_document_metadata_history <- ssm_list_document_metadata_history

#' List all versions for a document
#'
#' @description
#' List all versions for a document.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_document_versions/](https://www.paws-r-sdk.com/docs/ssm_list_document_versions/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the document. You can specify an Amazon Resource Name (ARN).
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_list_document_versions
ssm_list_document_versions <- function(Name, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDocumentVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DocumentVersions")
  )
  input <- .ssm$list_document_versions_input(Name = Name, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_document_versions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_document_versions <- ssm_list_document_versions

#' Returns all Systems Manager (SSM) documents in the current Amazon Web
#' Services account and Amazon Web Services Region
#'
#' @description
#' Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results of this request by using a filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_documents/](https://www.paws-r-sdk.com/docs/ssm_list_documents/) for full documentation.
#'
#' @param DocumentFilterList This data type is deprecated. Instead, use `Filters`.
#' @param Filters One or more `DocumentKeyValuesFilter` objects. Use a filter to return a
#' more specific list of results. For keys, you can specify one or more
#' key-value pair tags that have been applied to a document. Other valid
#' keys include `Owner`, `Name`, `PlatformTypes`, `DocumentType`, and
#' `TargetType`. For example, to return documents you own use
#' `Key=Owner,Values=Self`. To specify a custom key-value pair, use the
#' format `Key=tag:tagName,Values=valueName`.
#' 
#' This API operation only supports filtering documents by using a single
#' tag key and one or more tag values. For example:
#' `Key=tag:tagName,Values=valueName1,valueName2`
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_list_documents
ssm_list_documents <- function(DocumentFilterList = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDocuments",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DocumentIdentifiers")
  )
  input <- .ssm$list_documents_input(DocumentFilterList = DocumentFilterList, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_documents_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_documents <- ssm_list_documents

#' A list of inventory items returned by the request
#'
#' @description
#' A list of inventory items returned by the request.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_inventory_entries/](https://www.paws-r-sdk.com/docs/ssm_list_inventory_entries/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The managed node ID for which you want inventory information.
#' @param TypeName &#91;required&#93; The type of inventory item for which you want information.
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_inventory_entries
ssm_list_inventory_entries <- function(InstanceId, TypeName, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInventoryEntries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_inventory_entries_input(InstanceId = InstanceId, TypeName = TypeName, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_inventory_entries_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_inventory_entries <- ssm_list_inventory_entries

#' Returns a list of all OpsItem events in the current Amazon Web Services
#' Region and Amazon Web Services account
#'
#' @description
#' Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can limit the results to events associated with specific OpsItems by specifying a filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_ops_item_events/](https://www.paws-r-sdk.com/docs/ssm_list_ops_item_events/) for full documentation.
#'
#' @param Filters One or more OpsItem filters. Use a filter to return a more specific list
#' of results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_ops_item_events
ssm_list_ops_item_events <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOpsItemEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Summaries")
  )
  input <- .ssm$list_ops_item_events_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_ops_item_events_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_ops_item_events <- ssm_list_ops_item_events

#' Lists all related-item resources associated with a Systems Manager
#' OpsCenter OpsItem
#'
#' @description
#' Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability of Amazon Web Services Systems Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_ops_item_related_items/](https://www.paws-r-sdk.com/docs/ssm_list_ops_item_related_items/) for full documentation.
#'
#' @param OpsItemId The ID of the OpsItem for which you want to list all related-item
#' resources.
#' @param Filters One or more OpsItem filters. Use a filter to return a more specific list
#' of results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname ssm_list_ops_item_related_items
ssm_list_ops_item_related_items <- function(OpsItemId = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOpsItemRelatedItems",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Summaries")
  )
  input <- .ssm$list_ops_item_related_items_input(OpsItemId = OpsItemId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_ops_item_related_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_ops_item_related_items <- ssm_list_ops_item_related_items

#' Amazon Web Services Systems Manager calls this API operation when
#' displaying all Application Manager OpsMetadata objects or blobs
#'
#' @description
#' Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_ops_metadata/](https://www.paws-r-sdk.com/docs/ssm_list_ops_metadata/) for full documentation.
#'
#' @param Filters One or more filters to limit the number of OpsMetadata objects returned
#' by the call.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_ops_metadata
ssm_list_ops_metadata <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOpsMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "OpsMetadataList")
  )
  input <- .ssm$list_ops_metadata_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_ops_metadata_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_ops_metadata <- ssm_list_ops_metadata

#' Returns a resource-level summary count
#'
#' @description
#' Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_resource_compliance_summaries/](https://www.paws-r-sdk.com/docs/ssm_list_resource_compliance_summaries/) for full documentation.
#'
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_resource_compliance_summaries
ssm_list_resource_compliance_summaries <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResourceComplianceSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ResourceComplianceSummaryItems")
  )
  input <- .ssm$list_resource_compliance_summaries_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_resource_compliance_summaries_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_resource_compliance_summaries <- ssm_list_resource_compliance_summaries

#' Lists your resource data sync configurations
#'
#' @description
#' Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_resource_data_sync/](https://www.paws-r-sdk.com/docs/ssm_list_resource_data_sync/) for full documentation.
#'
#' @param SyncType View a list of resource data syncs according to the sync type. Specify
#' `SyncToDestination` to view resource data syncs that synchronize data to
#' an Amazon S3 bucket. Specify `SyncFromSource` to view resource data
#' syncs from Organizations or from multiple Amazon Web Services Regions.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @keywords internal
#'
#' @rdname ssm_list_resource_data_sync
ssm_list_resource_data_sync <- function(SyncType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ResourceDataSyncItems")
  )
  input <- .ssm$list_resource_data_sync_input(SyncType = SyncType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_resource_data_sync <- ssm_list_resource_data_sync

#' Returns a list of the tags assigned to the specified resource
#'
#' @description
#' Returns a list of the tags assigned to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ssm_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceType &#91;required&#93; Returns a list of tags for a specific resource type.
#' @param ResourceId &#91;required&#93; The resource ID for which you want to see a list of tags.
#'
#' @keywords internal
#'
#' @rdname ssm_list_tags_for_resource
ssm_list_tags_for_resource <- function(ResourceType, ResourceId) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_tags_for_resource_input(ResourceType = ResourceType, ResourceId = ResourceId)
  output <- .ssm$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_tags_for_resource <- ssm_list_tags_for_resource

#' Shares a Amazon Web Services Systems Manager document (SSM
#' document)publicly or privately
#'
#' @description
#' Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document privately, you must specify the Amazon Web Services user IDs for those people who can use the document. If you share a document publicly, you must specify *All* as the account ID.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_modify_document_permission/](https://www.paws-r-sdk.com/docs/ssm_modify_document_permission/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the document that you want to share.
#' @param PermissionType &#91;required&#93; The permission type for the document. The permission type can be
#' *Share*.
#' @param AccountIdsToAdd The Amazon Web Services users that should have access to the document.
#' The account IDs can either be a group of account IDs or *All*.
#' @param AccountIdsToRemove The Amazon Web Services users that should no longer have access to the
#' document. The Amazon Web Services user can either be a group of account
#' IDs or *All*. This action has a higher priority than *AccountIdsToAdd*.
#' If you specify an ID to add and the same ID to remove, the system
#' removes access to the document.
#' @param SharedDocumentVersion (Optional) The version of the document to share. If it isn't specified,
#' the system choose the `Default` version to share.
#'
#' @keywords internal
#'
#' @rdname ssm_modify_document_permission
ssm_modify_document_permission <- function(Name, PermissionType, AccountIdsToAdd = NULL, AccountIdsToRemove = NULL, SharedDocumentVersion = NULL) {
  op <- new_operation(
    name = "ModifyDocumentPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$modify_document_permission_input(Name = Name, PermissionType = PermissionType, AccountIdsToAdd = AccountIdsToAdd, AccountIdsToRemove = AccountIdsToRemove, SharedDocumentVersion = SharedDocumentVersion)
  output <- .ssm$modify_document_permission_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$modify_document_permission <- ssm_modify_document_permission

#' Registers a compliance type and other compliance details on a designated
#' resource
#'
#' @description
#' Registers a compliance type and other compliance details on a designated resource. This operation lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_put_compliance_items/](https://www.paws-r-sdk.com/docs/ssm_put_compliance_items/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specify an ID for this resource. For a managed node, this is the node
#' ID.
#' @param ResourceType &#91;required&#93; Specify the type of resource. `ManagedInstance` is currently the only
#' supported resource type.
#' @param ComplianceType &#91;required&#93; Specify the compliance type. For example, specify Association (for a
#' State Manager association), Patch, or Custom:`string`.
#' @param ExecutionSummary &#91;required&#93; A summary of the call execution that includes an execution ID, the type
#' of execution (for example, `Command`), and the date/time of the
#' execution using a datetime object that is saved in the following format:
#' yyyy-MM-dd'T'HH:mm:ss'Z'.
#' @param Items &#91;required&#93; Information about the compliance as defined by the resource type. For
#' example, for a patch compliance type, `Items` includes information about
#' the PatchSeverity, Classification, and so on.
#' @param ItemContentHash MD5 or SHA-256 content hash. The content hash is used to determine if
#' existing information should be overwritten or ignored. If the content
#' hashes match, the request to put compliance information is ignored.
#' @param UploadType The mode for uploading compliance items. You can specify `COMPLETE` or
#' `PARTIAL`. In `COMPLETE` mode, the system overwrites all existing
#' compliance information for the resource. You must provide a full list of
#' compliance items each time you send the request.
#' 
#' In `PARTIAL` mode, the system overwrites compliance information for a
#' specific association. The association must be configured with
#' `SyncCompliance` set to `MANUAL`. By default, all requests use
#' `COMPLETE` mode.
#' 
#' This attribute is only valid for association compliance.
#'
#' @keywords internal
#'
#' @rdname ssm_put_compliance_items
ssm_put_compliance_items <- function(ResourceId, ResourceType, ComplianceType, ExecutionSummary, Items, ItemContentHash = NULL, UploadType = NULL) {
  op <- new_operation(
    name = "PutComplianceItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_compliance_items_input(ResourceId = ResourceId, ResourceType = ResourceType, ComplianceType = ComplianceType, ExecutionSummary = ExecutionSummary, Items = Items, ItemContentHash = ItemContentHash, UploadType = UploadType)
  output <- .ssm$put_compliance_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_compliance_items <- ssm_put_compliance_items

#' Bulk update custom inventory items on one or more managed nodes
#'
#' @description
#' Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it doesn't already exist, or updates an inventory item, if it does exist.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_put_inventory/](https://www.paws-r-sdk.com/docs/ssm_put_inventory/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; An managed node ID where you want to add or update inventory items.
#' @param Items &#91;required&#93; The inventory items that you want to add or update on managed nodes.
#'
#' @keywords internal
#'
#' @rdname ssm_put_inventory
ssm_put_inventory <- function(InstanceId, Items) {
  op <- new_operation(
    name = "PutInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_inventory_input(InstanceId = InstanceId, Items = Items)
  output <- .ssm$put_inventory_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_inventory <- ssm_put_inventory

#' Add a parameter to the system
#'
#' @description
#' Add a parameter to the system.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_put_parameter/](https://www.paws-r-sdk.com/docs/ssm_put_parameter/) for full documentation.
#'
#' @param Name &#91;required&#93; The fully qualified name of the parameter that you want to add to the
#' system. The fully qualified name includes the complete hierarchy of the
#' parameter path and name. For parameters in a hierarchy, you must include
#' a leading forward slash character (/) when you create or reference a
#' parameter. For example: `/Dev/DBServer/MySQL/db-string13`
#' 
#' Naming Constraints:
#' 
#' -   Parameter names are case sensitive.
#' 
#' -   A parameter name must be unique within an Amazon Web Services Region
#' 
#' -   A parameter name can't be prefixed with "`aws`" or "`ssm`"
#'     (case-insensitive).
#' 
#' -   Parameter names can include only the following symbols and letters:
#'     `a-zA-Z0-9_.-`
#' 
#'     In addition, the slash character ( / ) is used to delineate
#'     hierarchies in parameter names. For example:
#'     `/Dev/Production/East/Project-ABC/MyParameter`
#' 
#' -   A parameter name can't include spaces.
#' 
#' -   Parameter hierarchies are limited to a maximum depth of fifteen
#'     levels.
#' 
#' For additional information about valid values for parameter names, see
#' [Creating Systems Manager
#' parameters](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' The maximum length constraint of 2048 characters listed below includes
#' 1037 characters reserved for internal use by Systems Manager. The
#' maximum length for a parameter name that you create is 1011 characters.
#' This includes the characters in the ARN that precede the name you
#' specify, such as `arn:aws:ssm:us-east-2:111122223333:parameter/`.
#' @param Description Information about the parameter that you want to add to the system.
#' Optional but recommended.
#' 
#' Don't enter personally identifiable information in this field.
#' @param Value &#91;required&#93; The parameter value that you want to add to the system. Standard
#' parameters have a value limit of 4 KB. Advanced parameters have a value
#' limit of 8 KB.
#' 
#' Parameters can't be referenced or nested in the values of other
#' parameters. You can't include `{{}}` or `{{ssm:parameter-name}}` in a
#' parameter value.
#' @param Type The type of parameter that you want to add to the system.
#' 
#' `SecureString` isn't currently supported for CloudFormation templates.
#' 
#' Items in a `StringList` must be separated by a comma (,). You can't use
#' other punctuation or special character to escape items in the list. If
#' you have a parameter value that requires a comma, then use the `String`
#' data type.
#' 
#' Specifying a parameter type isn't required when updating a parameter.
#' You must specify a parameter type when creating a parameter.
#' @param KeyId The Key Management Service (KMS) ID that you want to use to encrypt a
#' parameter. Use a custom key for better security. Required for parameters
#' that use the `SecureString` data type.
#' 
#' If you don't specify a key ID, the system uses the default key
#' associated with your Amazon Web Services account which is not as secure
#' as using a custom key.
#' 
#' -   To use a custom KMS key, choose the `SecureString` data type with
#'     the `Key ID` parameter.
#' @param Overwrite Overwrite an existing parameter. The default value is `false`.
#' @param AllowedPattern A regular expression used to validate the parameter value. For example,
#' for String types with values restricted to numbers, you can specify the
#' following: AllowedPattern=^\\d+$
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag a Systems Manager
#' parameter to identify the type of resource to which it applies, the
#' environment, or the type of configuration data referenced by the
#' parameter. In this case, you could specify the following key-value
#' pairs:
#' 
#' -   `Key=Resource,Value=S3bucket`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=ParameterType,Value=LicenseKey`
#' 
#' To add tags to an existing Systems Manager parameter, use the
#' [`add_tags_to_resource`][ssm_add_tags_to_resource] operation.
#' @param Tier The parameter tier to assign to a parameter.
#' 
#' Parameter Store offers a standard tier and an advanced tier for
#' parameters. Standard parameters have a content size limit of 4 KB and
#' can't be configured to use parameter policies. You can create a maximum
#' of 10,000 standard parameters for each Region in an Amazon Web Services
#' account. Standard parameters are offered at no additional cost.
#' 
#' Advanced parameters have a content size limit of 8 KB and can be
#' configured to use parameter policies. You can create a maximum of
#' 100,000 advanced parameters for each Region in an Amazon Web Services
#' account. Advanced parameters incur a charge. For more information, see
#' [Standard and advanced parameter
#' tiers](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' You can change a standard parameter to an advanced parameter any time.
#' But you can't revert an advanced parameter to a standard parameter.
#' Reverting an advanced parameter to a standard parameter would result in
#' data loss because the system would truncate the size of the parameter
#' from 8 KB to 4 KB. Reverting would also remove any policies attached to
#' the parameter. Lastly, advanced parameters use a different form of
#' encryption than standard parameters.
#' 
#' If you no longer need an advanced parameter, or if you no longer want to
#' incur charges for an advanced parameter, you must delete it and recreate
#' it as a new standard parameter.
#' 
#' **Using the Default Tier Configuration**
#' 
#' In [`put_parameter`][ssm_put_parameter] requests, you can specify the
#' tier to create the parameter in. Whenever you specify a tier in the
#' request, Parameter Store creates or updates the parameter according to
#' that request. However, if you don't specify a tier in a request,
#' Parameter Store assigns the tier based on the current Parameter Store
#' default tier configuration.
#' 
#' The default tier when you begin using Parameter Store is the
#' standard-parameter tier. If you use the advanced-parameter tier, you can
#' specify one of the following as the default:
#' 
#' -   **Advanced**: With this option, Parameter Store evaluates all
#'     requests as advanced parameters.
#' 
#' -   **Intelligent-Tiering**: With this option, Parameter Store evaluates
#'     each request to determine if the parameter is standard or advanced.
#' 
#'     If the request doesn't include any options that require an advanced
#'     parameter, the parameter is created in the standard-parameter tier.
#'     If one or more options requiring an advanced parameter are included
#'     in the request, Parameter Store create a parameter in the
#'     advanced-parameter tier.
#' 
#'     This approach helps control your parameter-related costs by always
#'     creating standard parameters unless an advanced parameter is
#'     necessary.
#' 
#' Options that require an advanced parameter include the following:
#' 
#' -   The content size of the parameter is more than 4 KB.
#' 
#' -   The parameter uses a parameter policy.
#' 
#' -   More than 10,000 parameters already exist in your Amazon Web
#'     Services account in the current Amazon Web Services Region.
#' 
#' For more information about configuring the default tier option, see
#' [Specifying a default parameter
#' tier](https://docs.aws.amazon.com/systems-manager/latest/userguide/) in
#' the *Amazon Web Services Systems Manager User Guide*.
#' @param Policies One or more policies to apply to a parameter. This operation takes a
#' JSON array. Parameter Store, a capability of Amazon Web Services Systems
#' Manager supports the following policy types:
#' 
#' Expiration: This policy deletes the parameter after it expires. When you
#' create the policy, you specify the expiration date. You can update the
#' expiration date and time by updating the policy. Updating the
#' *parameter* doesn't affect the expiration date and time. When the
#' expiration time is reached, Parameter Store deletes the parameter.
#' 
#' ExpirationNotification: This policy initiates an event in Amazon
#' CloudWatch Events that notifies you about the expiration. By using this
#' policy, you can receive notification before or after the expiration time
#' is reached, in units of days or hours.
#' 
#' NoChangeNotification: This policy initiates a CloudWatch Events event if
#' a parameter hasn't been modified for a specified period of time. This
#' policy type is useful when, for example, a secret needs to be changed
#' within a period of time, but it hasn't been changed.
#' 
#' All existing policies are preserved until you send new policies or an
#' empty policy. For more information about parameter policies, see
#' [Assigning parameter
#' policies](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html).
#' @param DataType The data type for a `String` parameter. Supported data types include
#' plain text and Amazon Machine Image (AMI) IDs.
#' 
#' **The following data type values are supported.**
#' 
#' -   `text`
#' 
#' -   `aws:ec2:image`
#' 
#' -   `aws:ssm:integration`
#' 
#' When you create a `String` parameter and specify `aws:ec2:image`, Amazon
#' Web Services Systems Manager validates the parameter value is in the
#' required format, such as `ami-12345abcdeEXAMPLE`, and that the specified
#' AMI is available in your Amazon Web Services account.
#' 
#' If the action is successful, the service sends back an HTTP 200 response
#' which indicates a successful [`put_parameter`][ssm_put_parameter] call
#' for all cases except for data type `aws:ec2:image`. If you call
#' [`put_parameter`][ssm_put_parameter] with `aws:ec2:image` data type, a
#' successful HTTP 200 response does not guarantee that your parameter was
#' successfully created or updated. The `aws:ec2:image` value is validated
#' asynchronously, and the [`put_parameter`][ssm_put_parameter] call
#' returns before the validation is complete. If you submit an invalid AMI
#' value, the PutParameter operation will return success, but the
#' asynchronous validation will fail and the parameter will not be created
#' or updated. To monitor whether your `aws:ec2:image` parameters are
#' created successfully, see [Setting up notifications or trigger actions
#' based on Parameter Store
#' events](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-cwe.html).
#' For more information about AMI format validation , see [Native parameter
#' support for Amazon Machine Image (AMI)
#' IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
#'
#' @keywords internal
#'
#' @rdname ssm_put_parameter
ssm_put_parameter <- function(Name, Description = NULL, Value, Type = NULL, KeyId = NULL, Overwrite = NULL, AllowedPattern = NULL, Tags = NULL, Tier = NULL, Policies = NULL, DataType = NULL) {
  op <- new_operation(
    name = "PutParameter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_parameter_input(Name = Name, Description = Description, Value = Value, Type = Type, KeyId = KeyId, Overwrite = Overwrite, AllowedPattern = AllowedPattern, Tags = Tags, Tier = Tier, Policies = Policies, DataType = DataType)
  output <- .ssm$put_parameter_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_parameter <- ssm_put_parameter

#' Creates or updates a Systems Manager resource policy
#'
#' @description
#' Creates or updates a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage your Systems Manager resources. Currently, `OpsItemGroup` is the only resource that supports Systems Manager resource policies. The resource policy for `OpsItemGroup` enables Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_put_resource_policy/](https://www.paws-r-sdk.com/docs/ssm_put_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource to which you want to attach a
#' policy.
#' @param Policy &#91;required&#93; A policy you want to associate with a resource.
#' @param PolicyId The policy ID.
#' @param PolicyHash ID of the current policy version. The hash helps to prevent a situation
#' where multiple users attempt to overwrite a policy. You must provide
#' this hash when updating or deleting a policy.
#'
#' @keywords internal
#'
#' @rdname ssm_put_resource_policy
ssm_put_resource_policy <- function(ResourceArn, Policy, PolicyId = NULL, PolicyHash = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_resource_policy_input(ResourceArn = ResourceArn, Policy = Policy, PolicyId = PolicyId, PolicyHash = PolicyHash)
  output <- .ssm$put_resource_policy_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_resource_policy <- ssm_put_resource_policy

#' Defines the default patch baseline for the relevant operating system
#'
#' @description
#' Defines the default patch baseline for the relevant operating system.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_register_default_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_register_default_patch_baseline/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline that should be the default patch baseline.
#'
#' @keywords internal
#'
#' @rdname ssm_register_default_patch_baseline
ssm_register_default_patch_baseline <- function(BaselineId) {
  op <- new_operation(
    name = "RegisterDefaultPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_default_patch_baseline_input(BaselineId = BaselineId)
  output <- .ssm$register_default_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_default_patch_baseline <- ssm_register_default_patch_baseline

#' Registers a patch baseline for a patch group
#'
#' @description
#' Registers a patch baseline for a patch group.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_register_patch_baseline_for_patch_group/](https://www.paws-r-sdk.com/docs/ssm_register_patch_baseline_for_patch_group/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to register with the patch group.
#' @param PatchGroup &#91;required&#93; The name of the patch group to be registered with the patch baseline.
#'
#' @keywords internal
#'
#' @rdname ssm_register_patch_baseline_for_patch_group
ssm_register_patch_baseline_for_patch_group <- function(BaselineId, PatchGroup) {
  op <- new_operation(
    name = "RegisterPatchBaselineForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_patch_baseline_for_patch_group_input(BaselineId = BaselineId, PatchGroup = PatchGroup)
  output <- .ssm$register_patch_baseline_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_patch_baseline_for_patch_group <- ssm_register_patch_baseline_for_patch_group

#' Registers a target with a maintenance window
#'
#' @description
#' Registers a target with a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_register_target_with_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_register_target_with_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the target should be registered with.
#' @param ResourceType &#91;required&#93; The type of target being registered with the maintenance window.
#' @param Targets &#91;required&#93; The targets to register with the maintenance window. In other words, the
#' managed nodes to run commands on when the maintenance window runs.
#' 
#' If a single maintenance window task is registered with multiple targets,
#' its task invocations occur sequentially and not in parallel. If your
#' task must run on multiple targets at the same time, register a task for
#' each target individually and assign each task the same priority level.
#' 
#' You can specify targets using managed node IDs, resource group names, or
#' tags that have been applied to managed nodes.
#' 
#' **Example 1**: Specify managed node IDs
#' 
#' `Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>,<instance-id-3>`
#' 
#' **Example 2**: Use tag key-pairs applied to managed nodes
#' 
#' `Key=tag:<my-tag-key>,Values=<my-tag-value-1>,<my-tag-value-2>`
#' 
#' **Example 3**: Use tag-keys applied to managed nodes
#' 
#' `Key=tag-key,Values=<my-tag-key-1>,<my-tag-key-2>`
#' 
#' **Example 4**: Use resource group names
#' 
#' `Key=resource-groups:Name,Values=<resource-group-name>`
#' 
#' **Example 5**: Use filters for resource group types
#' 
#' `Key=resource-groups:ResourceTypeFilters,Values=<resource-type-1>,<resource-type-2>`
#' 
#' For `Key=resource-groups:ResourceTypeFilters`, specify resource types in
#' the following format
#' 
#' `Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC`
#' 
#' For more information about these examples formats, including the best
#' use case for each one, see [Examples: Register targets with a
#' maintenance
#' window](https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param OwnerInformation User-provided value that will be included in any Amazon CloudWatch
#' Events events raised while running tasks for these targets in this
#' maintenance window.
#' @param Name An optional name for the target.
#' @param Description An optional description for the target.
#' @param ClientToken User-provided idempotency token.
#'
#' @keywords internal
#'
#' @rdname ssm_register_target_with_maintenance_window
ssm_register_target_with_maintenance_window <- function(WindowId, ResourceType, Targets, OwnerInformation = NULL, Name = NULL, Description = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "RegisterTargetWithMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_target_with_maintenance_window_input(WindowId = WindowId, ResourceType = ResourceType, Targets = Targets, OwnerInformation = OwnerInformation, Name = Name, Description = Description, ClientToken = ClientToken)
  output <- .ssm$register_target_with_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_target_with_maintenance_window <- ssm_register_target_with_maintenance_window

#' Adds a new task to a maintenance window
#'
#' @description
#' Adds a new task to a maintenance window.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_register_task_with_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_register_task_with_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the task should be added to.
#' @param Targets The targets (either managed nodes or maintenance window targets).
#' 
#' One or more targets must be specified for maintenance window Run
#' Command-type tasks. Depending on the task, targets are optional for
#' other maintenance window task types (Automation, Lambda, and Step
#' Functions). For more information about running tasks that don't specify
#' targets, see [Registering maintenance window tasks without
#' targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' Specify managed nodes using the following format:
#' 
#' `Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>`
#' 
#' Specify maintenance window targets using the following format:
#' 
#' `Key=WindowTargetIds,Values=<window-target-id-1>,<window-target-id-2>`
#' @param TaskArn &#91;required&#93; The ARN of the task to run.
#' @param ServiceRoleArn The Amazon Resource Name (ARN) of the IAM service role for Amazon Web
#' Services Systems Manager to assume when running a maintenance window
#' task. If you do not specify a service role ARN, Systems Manager uses
#' your account's service-linked role. If no service-linked role for
#' Systems Manager exists in your account, it is created when you run
#' [`register_task_with_maintenance_window`][ssm_register_task_with_maintenance_window].
#' 
#' For more information, see the following topics in the in the *Amazon Web
#' Services Systems Manager User Guide*:
#' 
#' -   [Using service-linked roles for Systems
#'     Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
#' 
#' -   [Should I use a service-linked role or a custom service role to run
#'     maintenance window
#'     tasks?](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
#' @param TaskType &#91;required&#93; The type of task being registered.
#' @param TaskParameters The parameters that should be passed to the task when it is run.
#' 
#' `TaskParameters` has been deprecated. To specify parameters to pass to a
#' task when it runs, instead use the `Parameters` option in the
#' `TaskInvocationParameters` structure. For information about how Systems
#' Manager handles these options for the supported maintenance window task
#' types, see MaintenanceWindowTaskInvocationParameters.
#' @param TaskInvocationParameters The parameters that the task should use during execution. Populate only
#' the fields that match the task type. All other fields should be empty.
#' @param Priority The priority of the task in the maintenance window, the lower the number
#' the higher the priority. Tasks in a maintenance window are scheduled in
#' priority order with tasks that have the same priority scheduled in
#' parallel.
#' @param MaxConcurrency The maximum number of targets this task can be run for, in parallel.
#' 
#' Although this element is listed as "Required: No", a value can be
#' omitted only when you are registering or updating a [targetless
#' task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
#' You must provide a value in all other cases.
#' 
#' For maintenance window tasks without a target specified, you can't
#' supply a value for this option. Instead, the system inserts a
#' placeholder value of `1`. This value doesn't affect the running of your
#' task.
#' @param MaxErrors The maximum number of errors allowed before this task stops being
#' scheduled.
#' 
#' Although this element is listed as "Required: No", a value can be
#' omitted only when you are registering or updating a [targetless
#' task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
#' You must provide a value in all other cases.
#' 
#' For maintenance window tasks without a target specified, you can't
#' supply a value for this option. Instead, the system inserts a
#' placeholder value of `1`. This value doesn't affect the running of your
#' task.
#' @param LoggingInfo A structure containing information about an Amazon Simple Storage
#' Service (Amazon S3) bucket to write managed node-level logs to.
#' 
#' `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage
#' Service (Amazon S3) bucket to contain logs, instead use the
#' `OutputS3BucketName` and `OutputS3KeyPrefix` options in the
#' `TaskInvocationParameters` structure. For information about how Amazon
#' Web Services Systems Manager handles these options for the supported
#' maintenance window task types, see
#' MaintenanceWindowTaskInvocationParameters.
#' @param Name An optional name for the task.
#' @param Description An optional description for the task.
#' @param ClientToken User-provided idempotency token.
#' @param CutoffBehavior Indicates whether tasks should continue to run after the cutoff time
#' specified in the maintenance windows is reached.
#' 
#' -   `CONTINUE_TASK`: When the cutoff time is reached, any tasks that are
#'     running continue. The default value.
#' 
#' -   `CANCEL_TASK`:
#' 
#'     -   For Automation, Lambda, Step Functions tasks: When the cutoff
#'         time is reached, any task invocations that are already running
#'         continue, but no new task invocations are started.
#' 
#'     -   For Run Command tasks: When the cutoff time is reached, the
#'         system sends a [`cancel_command`][ssm_cancel_command] operation
#'         that attempts to cancel the command associated with the task.
#'         However, there is no guarantee that the command will be
#'         terminated and the underlying process stopped.
#' 
#'     The status for tasks that are not completed is `TIMED_OUT`.
#' @param AlarmConfiguration The CloudWatch alarm you want to apply to your maintenance window task.
#'
#' @keywords internal
#'
#' @rdname ssm_register_task_with_maintenance_window
ssm_register_task_with_maintenance_window <- function(WindowId, Targets = NULL, TaskArn, ServiceRoleArn = NULL, TaskType, TaskParameters = NULL, TaskInvocationParameters = NULL, Priority = NULL, MaxConcurrency = NULL, MaxErrors = NULL, LoggingInfo = NULL, Name = NULL, Description = NULL, ClientToken = NULL, CutoffBehavior = NULL, AlarmConfiguration = NULL) {
  op <- new_operation(
    name = "RegisterTaskWithMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_task_with_maintenance_window_input(WindowId = WindowId, Targets = Targets, TaskArn = TaskArn, ServiceRoleArn = ServiceRoleArn, TaskType = TaskType, TaskParameters = TaskParameters, TaskInvocationParameters = TaskInvocationParameters, Priority = Priority, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, LoggingInfo = LoggingInfo, Name = Name, Description = Description, ClientToken = ClientToken, CutoffBehavior = CutoffBehavior, AlarmConfiguration = AlarmConfiguration)
  output <- .ssm$register_task_with_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_task_with_maintenance_window <- ssm_register_task_with_maintenance_window

#' Removes tag keys from the specified resource
#'
#' @description
#' Removes tag keys from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_remove_tags_from_resource/](https://www.paws-r-sdk.com/docs/ssm_remove_tags_from_resource/) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of resource from which you want to remove a tag.
#' 
#' The `ManagedInstance` type for this API operation is only for
#' on-premises managed nodes. Specify the name of the managed node in the
#' following format: `mi-ID_number `. For example, `mi-1a2b3c4d5e6f`.
#' @param ResourceId &#91;required&#93; The ID of the resource from which you want to remove tags. For example:
#' 
#' ManagedInstance: mi-012345abcde
#' 
#' MaintenanceWindow: mw-012345abcde
#' 
#' `Automation`: `example-c160-4567-8519-012345abcde`
#' 
#' PatchBaseline: pb-012345abcde
#' 
#' OpsMetadata object: `ResourceID` for tagging is created from the Amazon
#' Resource Name (ARN) for the object. Specifically, `ResourceID` is
#' created from the strings that come after the word `opsmetadata` in the
#' ARN. For example, an OpsMetadata object with an ARN of
#' `arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager`
#' has a `ResourceID` of either `aws/ssm/MyGroup/appmanager` or
#' `/aws/ssm/MyGroup/appmanager`.
#' 
#' For the Document and Parameter values, use the name of the resource.
#' 
#' The `ManagedInstance` type for this API operation is only for
#' on-premises managed nodes. Specify the name of the managed node in the
#' following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.
#' @param TagKeys &#91;required&#93; Tag keys that you want to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname ssm_remove_tags_from_resource
ssm_remove_tags_from_resource <- function(ResourceType, ResourceId, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$remove_tags_from_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .ssm$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$remove_tags_from_resource <- ssm_remove_tags_from_resource

#' ServiceSetting is an account-level setting for an Amazon Web Services
#' service
#'
#' @description
#' `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_reset_service_setting/](https://www.paws-r-sdk.com/docs/ssm_reset_service_setting/) for full documentation.
#'
#' @param SettingId &#91;required&#93; The Amazon Resource Name (ARN) of the service setting to reset. The
#' setting ID can be one of the following.
#' 
#' -   `/ssm/managed-instance/default-ec2-instance-management-role`
#' 
#' -   `/ssm/automation/customer-script-log-destination`
#' 
#' -   `/ssm/automation/customer-script-log-group-name`
#' 
#' -   `/ssm/documents/console/public-sharing-permission`
#' 
#' -   `/ssm/managed-instance/activation-tier`
#' 
#' -   `/ssm/opsinsights/opscenter`
#' 
#' -   `/ssm/parameter-store/default-parameter-tier`
#' 
#' -   `/ssm/parameter-store/high-throughput-enabled`
#'
#' @keywords internal
#'
#' @rdname ssm_reset_service_setting
ssm_reset_service_setting <- function(SettingId) {
  op <- new_operation(
    name = "ResetServiceSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$reset_service_setting_input(SettingId = SettingId)
  output <- .ssm$reset_service_setting_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$reset_service_setting <- ssm_reset_service_setting

#' Reconnects a session to a managed node after it has been disconnected
#'
#' @description
#' Reconnects a session to a managed node after it has been disconnected. Connections can be resumed for disconnected sessions, but not terminated sessions.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_resume_session/](https://www.paws-r-sdk.com/docs/ssm_resume_session/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The ID of the disconnected session to resume.
#'
#' @keywords internal
#'
#' @rdname ssm_resume_session
ssm_resume_session <- function(SessionId) {
  op <- new_operation(
    name = "ResumeSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$resume_session_input(SessionId = SessionId)
  output <- .ssm$resume_session_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$resume_session <- ssm_resume_session

#' Sends a signal to an Automation execution to change the current behavior
#' or status of the execution
#'
#' @description
#' Sends a signal to an Automation execution to change the current behavior or status of the execution.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_send_automation_signal/](https://www.paws-r-sdk.com/docs/ssm_send_automation_signal/) for full documentation.
#'
#' @param AutomationExecutionId &#91;required&#93; The unique identifier for an existing Automation execution that you want
#' to send the signal to.
#' @param SignalType &#91;required&#93; The type of signal to send to an Automation execution.
#' @param Payload The data sent with the signal. The data schema depends on the type of
#' signal used in the request.
#' 
#' For `Approve` and `Reject` signal types, the payload is an optional
#' comment that you can send with the signal type. For example:
#' 
#' `Comment="Looks good"`
#' 
#' For `StartStep` and `Resume` signal types, you must send the name of the
#' Automation step to start or resume as the payload. For example:
#' 
#' `StepName="step1"`
#' 
#' For the `StopStep` signal type, you must send the step execution ID as
#' the payload. For example:
#' 
#' `StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"`
#'
#' @keywords internal
#'
#' @rdname ssm_send_automation_signal
ssm_send_automation_signal <- function(AutomationExecutionId, SignalType, Payload = NULL) {
  op <- new_operation(
    name = "SendAutomationSignal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$send_automation_signal_input(AutomationExecutionId = AutomationExecutionId, SignalType = SignalType, Payload = Payload)
  output <- .ssm$send_automation_signal_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$send_automation_signal <- ssm_send_automation_signal

#' Runs commands on one or more managed nodes
#'
#' @description
#' Runs commands on one or more managed nodes.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_send_command/](https://www.paws-r-sdk.com/docs/ssm_send_command/) for full documentation.
#'
#' @param InstanceIds The IDs of the managed nodes where the command should run. Specifying
#' managed node IDs is most useful when you are targeting a limited number
#' of managed nodes, though you can specify up to 50 IDs.
#' 
#' To target a larger number of managed nodes, or if you prefer not to list
#' individual node IDs, we recommend using the `Targets` option instead.
#' Using `Targets`, which accepts tag key-value pairs to identify the
#' managed nodes to send commands to, you can a send command to tens,
#' hundreds, or thousands of nodes at once.
#' 
#' For more information about how to use targets, see [Using targets and
#' rate controls to send commands to a
#' fleet](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param Targets An array of search criteria that targets managed nodes using a
#' `Key,Value` combination that you specify. Specifying targets is most
#' useful when you want to send a command to a large number of managed
#' nodes at once. Using `Targets`, which accepts tag key-value pairs to
#' identify managed nodes, you can send a command to tens, hundreds, or
#' thousands of nodes at once.
#' 
#' To send a command to a smaller number of managed nodes, you can use the
#' `InstanceIds` option instead.
#' 
#' For more information about how to use targets, see [Sending commands to
#' a
#' fleet](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param DocumentName &#91;required&#93; The name of the Amazon Web Services Systems Manager document (SSM
#' document) to run. This can be a public document or a custom document. To
#' run a shared document belonging to another account, specify the document
#' Amazon Resource Name (ARN). For more information about how to use shared
#' documents, see [Using shared SSM
#' documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-ssm-sharing.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' If you specify a document name or ARN that hasn't been shared with your
#' account, you receive an `InvalidDocument` error.
#' @param DocumentVersion The SSM document version to use in the request. You can specify
#' $DEFAULT, $LATEST, or a specific version number. If you run commands by
#' using the Command Line Interface (Amazon Web Services CLI), then you
#' must escape the first two options by using a backslash. If you specify a
#' version number, then you don't need to use the backslash. For example:
#' 
#' --document-version "$DEFAULT"
#' 
#' --document-version "$LATEST"
#' 
#' --document-version "3"
#' @param DocumentHash The Sha256 or Sha1 hash created by the system when the document was
#' created.
#' 
#' Sha1 hashes have been deprecated.
#' @param DocumentHashType Sha256 or Sha1.
#' 
#' Sha1 hashes have been deprecated.
#' @param TimeoutSeconds If this time is reached and the command hasn't already started running,
#' it won't run.
#' @param Comment User-specified information about the command, such as a brief
#' description of what the command should do.
#' @param Parameters The required and optional parameters specified in the document being
#' run.
#' @param OutputS3Region (Deprecated) You can no longer specify this parameter. The system
#' ignores it. Instead, Systems Manager automatically determines the Amazon
#' Web Services Region of the S3 bucket.
#' @param OutputS3BucketName The name of the S3 bucket where command execution responses should be
#' stored.
#' @param OutputS3KeyPrefix The directory structure within the S3 bucket where the responses should
#' be stored.
#' @param MaxConcurrency (Optional) The maximum number of managed nodes that are allowed to run
#' the command at the same time. You can specify a number such as 10 or a
#' percentage such as 10%. The default value is `50`. For more information
#' about how to use `MaxConcurrency`, see [Using concurrency
#' controls](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param MaxErrors The maximum number of errors allowed without the command failing. When
#' the command fails one more time beyond the value of `MaxErrors`, the
#' systems stops sending the command to additional targets. You can specify
#' a number like 10 or a percentage like 10%. The default value is `0`. For
#' more information about how to use `MaxErrors`, see [Using error
#' controls](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param ServiceRoleArn The ARN of the Identity and Access Management (IAM) service role to use
#' to publish Amazon Simple Notification Service (Amazon SNS) notifications
#' for Run Command commands.
#' 
#' This role must provide the `sns:Publish` permission for your
#' notification topic. For information about creating and using this
#' service role, see [Monitoring Systems Manager status changes using
#' Amazon SNS
#' notifications](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param NotificationConfig Configurations for sending notifications.
#' @param CloudWatchOutputConfig Enables Amazon Web Services Systems Manager to send Run Command output
#' to Amazon CloudWatch Logs. Run Command is a capability of Amazon Web
#' Services Systems Manager.
#' @param AlarmConfiguration The CloudWatch alarm you want to apply to your command.
#'
#' @keywords internal
#'
#' @rdname ssm_send_command
ssm_send_command <- function(InstanceIds = NULL, Targets = NULL, DocumentName, DocumentVersion = NULL, DocumentHash = NULL, DocumentHashType = NULL, TimeoutSeconds = NULL, Comment = NULL, Parameters = NULL, OutputS3Region = NULL, OutputS3BucketName = NULL, OutputS3KeyPrefix = NULL, MaxConcurrency = NULL, MaxErrors = NULL, ServiceRoleArn = NULL, NotificationConfig = NULL, CloudWatchOutputConfig = NULL, AlarmConfiguration = NULL) {
  op <- new_operation(
    name = "SendCommand",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$send_command_input(InstanceIds = InstanceIds, Targets = Targets, DocumentName = DocumentName, DocumentVersion = DocumentVersion, DocumentHash = DocumentHash, DocumentHashType = DocumentHashType, TimeoutSeconds = TimeoutSeconds, Comment = Comment, Parameters = Parameters, OutputS3Region = OutputS3Region, OutputS3BucketName = OutputS3BucketName, OutputS3KeyPrefix = OutputS3KeyPrefix, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, ServiceRoleArn = ServiceRoleArn, NotificationConfig = NotificationConfig, CloudWatchOutputConfig = CloudWatchOutputConfig, AlarmConfiguration = AlarmConfiguration)
  output <- .ssm$send_command_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$send_command <- ssm_send_command

#' Runs an association immediately and only one time
#'
#' @description
#' Runs an association immediately and only one time. This operation can be helpful when troubleshooting associations.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_start_associations_once/](https://www.paws-r-sdk.com/docs/ssm_start_associations_once/) for full documentation.
#'
#' @param AssociationIds &#91;required&#93; The association IDs that you want to run immediately and only one time.
#'
#' @keywords internal
#'
#' @rdname ssm_start_associations_once
ssm_start_associations_once <- function(AssociationIds) {
  op <- new_operation(
    name = "StartAssociationsOnce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_associations_once_input(AssociationIds = AssociationIds)
  output <- .ssm$start_associations_once_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_associations_once <- ssm_start_associations_once

#' Initiates execution of an Automation runbook
#'
#' @description
#' Initiates execution of an Automation runbook.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_start_automation_execution/](https://www.paws-r-sdk.com/docs/ssm_start_automation_execution/) for full documentation.
#'
#' @param DocumentName &#91;required&#93; The name of the SSM document to run. This can be a public document or a
#' custom document. To run a shared document belonging to another account,
#' specify the document ARN. For more information about how to use shared
#' documents, see [Using shared SSM
#' documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-ssm-sharing.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param DocumentVersion The version of the Automation runbook to use for this execution.
#' @param Parameters A key-value map of execution parameters, which match the declared
#' parameters in the Automation runbook.
#' @param ClientToken User-provided idempotency token. The token must be unique, is case
#' insensitive, enforces the UUID format, and can't be reused.
#' @param Mode The execution mode of the automation. Valid modes include the following:
#' Auto and Interactive. The default mode is Auto.
#' @param TargetParameterName The name of the parameter used as the target resource for the
#' rate-controlled execution. Required if you specify targets.
#' @param Targets A key-value mapping to target resources. Required if you specify
#' TargetParameterName.
#' @param TargetMaps A key-value mapping of document parameters to target resources. Both
#' Targets and TargetMaps can't be specified together.
#' @param MaxConcurrency The maximum number of targets allowed to run this task in parallel. You
#' can specify a number, such as 10, or a percentage, such as 10%. The
#' default value is `10`.
#' @param MaxErrors The number of errors that are allowed before the system stops running
#' the automation on additional targets. You can specify either an absolute
#' number of errors, for example 10, or a percentage of the target set, for
#' example 10%. If you specify 3, for example, the system stops running the
#' automation when the fourth error is received. If you specify 0, then the
#' system stops running the automation on additional targets after the
#' first error result is returned. If you run an automation on 50 resources
#' and set max-errors to 10%, then the system stops running the automation
#' on additional targets when the sixth error is received.
#' 
#' Executions that are already running an automation when max-errors is
#' reached are allowed to complete, but some of these executions may fail
#' as well. If you need to ensure that there won't be more than max-errors
#' failed executions, set max-concurrency to 1 so the executions proceed
#' one at a time.
#' @param TargetLocations A location is a combination of Amazon Web Services Regions and/or Amazon
#' Web Services accounts where you want to run the automation. Use this
#' operation to start an automation in multiple Amazon Web Services Regions
#' and multiple Amazon Web Services accounts. For more information, see
#' [Running Automation workflows in multiple Amazon Web Services Regions
#' and Amazon Web Services
#' accounts](https://docs.aws.amazon.com/systems-manager/latest/userguide/running-automations-multiple-accounts-regions.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param Tags Optional metadata that you assign to a resource. You can specify a
#' maximum of five tags for an automation. Tags enable you to categorize a
#' resource in different ways, such as by purpose, owner, or environment.
#' For example, you might want to tag an automation to identify an
#' environment or operating system. In this case, you could specify the
#' following key-value pairs:
#' 
#' -   `Key=environment,Value=test`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' To add tags to an existing automation, use the
#' [`add_tags_to_resource`][ssm_add_tags_to_resource] operation.
#' @param AlarmConfiguration The CloudWatch alarm you want to apply to your automation.
#'
#' @keywords internal
#'
#' @rdname ssm_start_automation_execution
ssm_start_automation_execution <- function(DocumentName, DocumentVersion = NULL, Parameters = NULL, ClientToken = NULL, Mode = NULL, TargetParameterName = NULL, Targets = NULL, TargetMaps = NULL, MaxConcurrency = NULL, MaxErrors = NULL, TargetLocations = NULL, Tags = NULL, AlarmConfiguration = NULL) {
  op <- new_operation(
    name = "StartAutomationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_automation_execution_input(DocumentName = DocumentName, DocumentVersion = DocumentVersion, Parameters = Parameters, ClientToken = ClientToken, Mode = Mode, TargetParameterName = TargetParameterName, Targets = Targets, TargetMaps = TargetMaps, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, TargetLocations = TargetLocations, Tags = Tags, AlarmConfiguration = AlarmConfiguration)
  output <- .ssm$start_automation_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_automation_execution <- ssm_start_automation_execution

#' Creates a change request for Change Manager
#'
#' @description
#' Creates a change request for Change Manager. The Automation runbooks specified in the change request run only after all required approvals for the change request have been received.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_start_change_request_execution/](https://www.paws-r-sdk.com/docs/ssm_start_change_request_execution/) for full documentation.
#'
#' @param ScheduledTime The date and time specified in the change request to run the Automation
#' runbooks.
#' 
#' The Automation runbooks specified for the runbook workflow can't run
#' until all required approvals for the change request have been received.
#' @param DocumentName &#91;required&#93; The name of the change template document to run during the runbook
#' workflow.
#' @param DocumentVersion The version of the change template document to run during the runbook
#' workflow.
#' @param Parameters A key-value map of parameters that match the declared parameters in the
#' change template document.
#' @param ChangeRequestName The name of the change request associated with the runbook workflow to
#' be run.
#' @param ClientToken The user-provided idempotency token. The token must be unique, is case
#' insensitive, enforces the UUID format, and can't be reused.
#' @param AutoApprove Indicates whether the change request can be approved automatically
#' without the need for manual approvals.
#' 
#' If `AutoApprovable` is enabled in a change template, then setting
#' `AutoApprove` to `true` in
#' [`start_change_request_execution`][ssm_start_change_request_execution]
#' creates a change request that bypasses approver review.
#' 
#' Change Calendar restrictions are not bypassed in this scenario. If the
#' state of an associated calendar is `CLOSED`, change freeze approvers
#' must still grant permission for this change request to run. If they
#' don't, the change won't be processed until the calendar state is again
#' `OPEN`.
#' @param Runbooks &#91;required&#93; Information about the Automation runbooks that are run during the
#' runbook workflow.
#' 
#' The Automation runbooks specified for the runbook workflow can't run
#' until all required approvals for the change request have been received.
#' @param Tags Optional metadata that you assign to a resource. You can specify a
#' maximum of five tags for a change request. Tags enable you to categorize
#' a resource in different ways, such as by purpose, owner, or environment.
#' For example, you might want to tag a change request to identify an
#' environment or target Amazon Web Services Region. In this case, you
#' could specify the following key-value pairs:
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' -   `Key=Region,Value=us-east-2`
#' @param ScheduledEndTime The time that the requester expects the runbook workflow related to the
#' change request to complete. The time is an estimate only that the
#' requester provides for reviewers.
#' @param ChangeDetails User-provided details about the change. If no details are provided,
#' content specified in the **Template information** section of the
#' associated change template is added.
#'
#' @keywords internal
#'
#' @rdname ssm_start_change_request_execution
ssm_start_change_request_execution <- function(ScheduledTime = NULL, DocumentName, DocumentVersion = NULL, Parameters = NULL, ChangeRequestName = NULL, ClientToken = NULL, AutoApprove = NULL, Runbooks, Tags = NULL, ScheduledEndTime = NULL, ChangeDetails = NULL) {
  op <- new_operation(
    name = "StartChangeRequestExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_change_request_execution_input(ScheduledTime = ScheduledTime, DocumentName = DocumentName, DocumentVersion = DocumentVersion, Parameters = Parameters, ChangeRequestName = ChangeRequestName, ClientToken = ClientToken, AutoApprove = AutoApprove, Runbooks = Runbooks, Tags = Tags, ScheduledEndTime = ScheduledEndTime, ChangeDetails = ChangeDetails)
  output <- .ssm$start_change_request_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_change_request_execution <- ssm_start_change_request_execution

#' Initiates a connection to a target (for example, a managed node) for a
#' Session Manager session
#'
#' @description
#' Initiates a connection to a target (for example, a managed node) for a Session Manager session. Returns a URL and token that can be used to open a WebSocket connection for sending input and receiving outputs.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_start_session/](https://www.paws-r-sdk.com/docs/ssm_start_session/) for full documentation.
#'
#' @param Target &#91;required&#93; The managed node to connect to for the session.
#' @param DocumentName The name of the SSM document you want to use to define the type of
#' session, input parameters, or preferences for the session. For example,
#' `SSM-SessionManagerRunShell`. You can call the
#' [`get_document`][ssm_get_document] API to verify the document exists
#' before attempting to start a session. If no document name is provided, a
#' shell to the managed node is launched by default. For more information,
#' see [Start a
#' session](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param Reason The reason for connecting to the instance. This value is included in the
#' details for the Amazon CloudWatch Events event created when you start
#' the session.
#' @param Parameters The values you want to specify for the parameters defined in the Session
#' document.
#'
#' @keywords internal
#'
#' @rdname ssm_start_session
ssm_start_session <- function(Target, DocumentName = NULL, Reason = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "StartSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_session_input(Target = Target, DocumentName = DocumentName, Reason = Reason, Parameters = Parameters)
  output <- .ssm$start_session_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_session <- ssm_start_session

#' Stop an Automation that is currently running
#'
#' @description
#' Stop an Automation that is currently running.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_stop_automation_execution/](https://www.paws-r-sdk.com/docs/ssm_stop_automation_execution/) for full documentation.
#'
#' @param AutomationExecutionId &#91;required&#93; The execution ID of the Automation to stop.
#' @param Type The stop request type. Valid types include the following: Cancel and
#' Complete. The default type is Cancel.
#'
#' @keywords internal
#'
#' @rdname ssm_stop_automation_execution
ssm_stop_automation_execution <- function(AutomationExecutionId, Type = NULL) {
  op <- new_operation(
    name = "StopAutomationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$stop_automation_execution_input(AutomationExecutionId = AutomationExecutionId, Type = Type)
  output <- .ssm$stop_automation_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$stop_automation_execution <- ssm_stop_automation_execution

#' Permanently ends a session and closes the data connection between the
#' Session Manager client and SSM Agent on the managed node
#'
#' @description
#' Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the managed node. A terminated session can't be resumed.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_terminate_session/](https://www.paws-r-sdk.com/docs/ssm_terminate_session/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The ID of the session to terminate.
#'
#' @keywords internal
#'
#' @rdname ssm_terminate_session
ssm_terminate_session <- function(SessionId) {
  op <- new_operation(
    name = "TerminateSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$terminate_session_input(SessionId = SessionId)
  output <- .ssm$terminate_session_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$terminate_session <- ssm_terminate_session

#' Remove a label or labels from a parameter
#'
#' @description
#' Remove a label or labels from a parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_unlabel_parameter_version/](https://www.paws-r-sdk.com/docs/ssm_unlabel_parameter_version/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the parameter from which you want to delete one or more
#' labels.
#' @param ParameterVersion &#91;required&#93; The specific version of the parameter which you want to delete one or
#' more labels from. If it isn't present, the call will fail.
#' @param Labels &#91;required&#93; One or more labels to delete from the specified parameter version.
#'
#' @keywords internal
#'
#' @rdname ssm_unlabel_parameter_version
ssm_unlabel_parameter_version <- function(Name, ParameterVersion, Labels) {
  op <- new_operation(
    name = "UnlabelParameterVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$unlabel_parameter_version_input(Name = Name, ParameterVersion = ParameterVersion, Labels = Labels)
  output <- .ssm$unlabel_parameter_version_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$unlabel_parameter_version <- ssm_unlabel_parameter_version

#' Updates an association
#'
#' @description
#' Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call [`update_association`][ssm_update_association], the system removes all optional parameters from the request and overwrites the association with null values for those parameters. This is by design. You must specify all optional parameters in the call, even if you are not changing the parameters. This includes the `Name` parameter. Before calling this API action, we recommend that you call the [`describe_association`][ssm_describe_association] API operation and make a note of all optional parameters required for your [`update_association`][ssm_update_association] call.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_association/](https://www.paws-r-sdk.com/docs/ssm_update_association/) for full documentation.
#'
#' @param AssociationId &#91;required&#93; The ID of the association you want to update.
#' @param Parameters The parameters you want to update for the association. If you create a
#' parameter using Parameter Store, a capability of Amazon Web Services
#' Systems Manager, you can reference the parameter using
#' `{{ssm:parameter-name}}`.
#' @param DocumentVersion The document version you want update for the association.
#' 
#' State Manager doesn't support running associations that use a new
#' version of a document if that document is shared from another account.
#' State Manager always runs the `default` version of a document if shared
#' from another account, even though the Systems Manager console shows that
#' a new version was processed. If you want to run an association using a
#' new version of a document shared form another account, you must set the
#' document version to `default`.
#' @param ScheduleExpression The cron expression used to schedule the association that you want to
#' update.
#' @param OutputLocation An S3 bucket where you want to store the results of this request.
#' @param Name The name of the SSM Command document or Automation runbook that contains
#' the configuration information for the managed node.
#' 
#' You can specify Amazon Web Services-predefined documents, documents you
#' created, or a document that is shared with you from another account.
#' 
#' For Systems Manager document (SSM document) that are shared with you
#' from other Amazon Web Services accounts, you must specify the complete
#' SSM document ARN, in the following format:
#' 
#' `arn:aws:ssm:region:account-id:document/document-name `
#' 
#' For example:
#' 
#' `arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document`
#' 
#' For Amazon Web Services-predefined documents and SSM documents you
#' created in your account, you only need to specify the document name. For
#' example, `AWS-ApplyPatchBaseline` or `My-Document`.
#' @param Targets The targets of the association.
#' @param AssociationName The name of the association that you want to update.
#' @param AssociationVersion This parameter is provided for concurrency control purposes. You must
#' specify the latest association version in the service. If you want to
#' ensure that this request succeeds, either specify `$LATEST`, or omit
#' this parameter.
#' @param AutomationTargetParameterName Choose the parameter that will define how your automation will branch
#' out. This target is required for associations that use an Automation
#' runbook and target resources by using rate controls. Automation is a
#' capability of Amazon Web Services Systems Manager.
#' @param MaxErrors The number of errors that are allowed before the system stops sending
#' requests to run the association on additional targets. You can specify
#' either an absolute number of errors, for example 10, or a percentage of
#' the target set, for example 10%. If you specify 3, for example, the
#' system stops sending requests when the fourth error is received. If you
#' specify 0, then the system stops sending requests after the first error
#' is returned. If you run an association on 50 managed nodes and set
#' `MaxError` to 10%, then the system stops sending the request when the
#' sixth error is received.
#' 
#' Executions that are already running an association when `MaxErrors` is
#' reached are allowed to complete, but some of these executions may fail
#' as well. If you need to ensure that there won't be more than max-errors
#' failed executions, set `MaxConcurrency` to 1 so that executions proceed
#' one at a time.
#' @param MaxConcurrency The maximum number of targets allowed to run the association at the same
#' time. You can specify a number, for example 10, or a percentage of the
#' target set, for example 10%. The default value is 100%, which means all
#' targets run the association at the same time.
#' 
#' If a new managed node starts and attempts to run an association while
#' Systems Manager is running `MaxConcurrency` associations, the
#' association is allowed to run. During the next association interval, the
#' new managed node will process its association within the limit specified
#' for `MaxConcurrency`.
#' @param ComplianceSeverity The severity level to assign to the association.
#' @param SyncCompliance The mode for generating association compliance. You can specify `AUTO`
#' or `MANUAL`. In `AUTO` mode, the system uses the status of the
#' association execution to determine the compliance status. If the
#' association execution runs successfully, then the association is
#' `COMPLIANT`. If the association execution doesn't run successfully, the
#' association is `NON-COMPLIANT`.
#' 
#' In `MANUAL` mode, you must specify the `AssociationId` as a parameter
#' for the [`put_compliance_items`][ssm_put_compliance_items] API
#' operation. In this case, compliance data isn't managed by State Manager,
#' a capability of Amazon Web Services Systems Manager. It is managed by
#' your direct call to the
#' [`put_compliance_items`][ssm_put_compliance_items] API operation.
#' 
#' By default, all associations use `AUTO` mode.
#' @param ApplyOnlyAtCronInterval By default, when you update an association, the system runs it
#' immediately after it is updated and then according to the schedule you
#' specified. Specify this option if you don't want an association to run
#' immediately after you update it. This parameter isn't supported for rate
#' expressions.
#' 
#' If you chose this option when you created an association and later you
#' edit that association or you make changes to the SSM document on which
#' that association is based (by using the Documents page in the console),
#' State Manager applies the association at the next specified cron
#' interval. For example, if you chose the `Latest` version of an SSM
#' document when you created an association and you edit the association by
#' choosing a different document version on the Documents page, State
#' Manager applies the association at the next specified cron interval if
#' you previously selected this option. If this option wasn't selected,
#' State Manager immediately runs the association.
#' 
#' You can reset this option. To do so, specify the
#' `no-apply-only-at-cron-interval` parameter when you update the
#' association from the command line. This parameter forces the association
#' to run immediately after updating it and according to the interval
#' specified.
#' @param CalendarNames The names or Amazon Resource Names (ARNs) of the Change Calendar type
#' documents you want to gate your associations under. The associations
#' only run when that change calendar is open. For more information, see
#' [Amazon Web Services Systems Manager Change
#' Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html).
#' @param TargetLocations A location is a combination of Amazon Web Services Regions and Amazon
#' Web Services accounts where you want to run the association. Use this
#' action to update an association in multiple Regions and multiple
#' accounts.
#' @param ScheduleOffset Number of days to wait after the scheduled day to run an association.
#' For example, if you specified a cron schedule of
#' `cron(0 0 ? * THU#2 *)`, you could specify an offset of 3 to run the
#' association each Sunday after the second Thursday of the month. For more
#' information about cron schedules for associations, see [Reference: Cron
#' and rate expressions for Systems
#' Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' To use offsets, you must specify the `ApplyOnlyAtCronInterval`
#' parameter. This option tells the system not to run an association
#' immediately after you create it.
#' @param TargetMaps A key-value mapping of document parameters to target resources. Both
#' Targets and TargetMaps can't be specified together.
#' @param AlarmConfiguration 
#'
#' @keywords internal
#'
#' @rdname ssm_update_association
ssm_update_association <- function(AssociationId, Parameters = NULL, DocumentVersion = NULL, ScheduleExpression = NULL, OutputLocation = NULL, Name = NULL, Targets = NULL, AssociationName = NULL, AssociationVersion = NULL, AutomationTargetParameterName = NULL, MaxErrors = NULL, MaxConcurrency = NULL, ComplianceSeverity = NULL, SyncCompliance = NULL, ApplyOnlyAtCronInterval = NULL, CalendarNames = NULL, TargetLocations = NULL, ScheduleOffset = NULL, TargetMaps = NULL, AlarmConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_association_input(AssociationId = AssociationId, Parameters = Parameters, DocumentVersion = DocumentVersion, ScheduleExpression = ScheduleExpression, OutputLocation = OutputLocation, Name = Name, Targets = Targets, AssociationName = AssociationName, AssociationVersion = AssociationVersion, AutomationTargetParameterName = AutomationTargetParameterName, MaxErrors = MaxErrors, MaxConcurrency = MaxConcurrency, ComplianceSeverity = ComplianceSeverity, SyncCompliance = SyncCompliance, ApplyOnlyAtCronInterval = ApplyOnlyAtCronInterval, CalendarNames = CalendarNames, TargetLocations = TargetLocations, ScheduleOffset = ScheduleOffset, TargetMaps = TargetMaps, AlarmConfiguration = AlarmConfiguration)
  output <- .ssm$update_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_association <- ssm_update_association

#' Updates the status of the Amazon Web Services Systems Manager document
#' (SSM document) associated with the specified managed node
#'
#' @description
#' Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified managed node.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_association_status/](https://www.paws-r-sdk.com/docs/ssm_update_association_status/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the SSM document.
#' @param InstanceId &#91;required&#93; The managed node ID.
#' @param AssociationStatus &#91;required&#93; The association status.
#'
#' @keywords internal
#'
#' @rdname ssm_update_association_status
ssm_update_association_status <- function(Name, InstanceId, AssociationStatus) {
  op <- new_operation(
    name = "UpdateAssociationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_association_status_input(Name = Name, InstanceId = InstanceId, AssociationStatus = AssociationStatus)
  output <- .ssm$update_association_status_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_association_status <- ssm_update_association_status

#' Updates one or more values for an SSM document
#'
#' @description
#' Updates one or more values for an SSM document.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_document/](https://www.paws-r-sdk.com/docs/ssm_update_document/) for full documentation.
#'
#' @param Content &#91;required&#93; A valid JSON or YAML string.
#' @param Attachments A list of key-value pairs that describe attachments to a version of a
#' document.
#' @param Name &#91;required&#93; The name of the SSM document that you want to update.
#' @param DisplayName The friendly name of the SSM document that you want to update. This
#' value can differ for each version of the document. If you don't specify
#' a value for this parameter in your request, the existing value is
#' applied to the new document version.
#' @param VersionName An optional field specifying the version of the artifact you are
#' updating with the document. For example, "Release 12, Update 6". This
#' value is unique across all versions of a document, and can't be changed.
#' @param DocumentVersion The version of the document that you want to update. Currently, Systems
#' Manager supports updating only the latest version of the document. You
#' can specify the version number of the latest version or use the
#' `$LATEST` variable.
#' 
#' If you change a document version for a State Manager association,
#' Systems Manager immediately runs the association unless you previously
#' specifed the `apply-only-at-cron-interval` parameter.
#' @param DocumentFormat Specify the document format for the new document version. Systems
#' Manager supports JSON and YAML documents. JSON is the default format.
#' @param TargetType Specify a new target type for the document.
#'
#' @keywords internal
#'
#' @rdname ssm_update_document
ssm_update_document <- function(Content, Attachments = NULL, Name, DisplayName = NULL, VersionName = NULL, DocumentVersion = NULL, DocumentFormat = NULL, TargetType = NULL) {
  op <- new_operation(
    name = "UpdateDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_document_input(Content = Content, Attachments = Attachments, Name = Name, DisplayName = DisplayName, VersionName = VersionName, DocumentVersion = DocumentVersion, DocumentFormat = DocumentFormat, TargetType = TargetType)
  output <- .ssm$update_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_document <- ssm_update_document

#' Set the default version of a document
#'
#' @description
#' Set the default version of a document.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_document_default_version/](https://www.paws-r-sdk.com/docs/ssm_update_document_default_version/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of a custom document that you want to set as the default
#' version.
#' @param DocumentVersion &#91;required&#93; The version of a custom document that you want to set as the default
#' version.
#'
#' @keywords internal
#'
#' @rdname ssm_update_document_default_version
ssm_update_document_default_version <- function(Name, DocumentVersion) {
  op <- new_operation(
    name = "UpdateDocumentDefaultVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_document_default_version_input(Name = Name, DocumentVersion = DocumentVersion)
  output <- .ssm$update_document_default_version_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_document_default_version <- ssm_update_document_default_version

#' Updates information related to approval reviews for a specific version
#' of a change template in Change Manager
#'
#' @description
#' Updates information related to approval reviews for a specific version of a change template in Change Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_document_metadata/](https://www.paws-r-sdk.com/docs/ssm_update_document_metadata/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the change template for which a version's metadata is to be
#' updated.
#' @param DocumentVersion The version of a change template in which to update approval metadata.
#' @param DocumentReviews &#91;required&#93; The change template review details to update.
#'
#' @keywords internal
#'
#' @rdname ssm_update_document_metadata
ssm_update_document_metadata <- function(Name, DocumentVersion = NULL, DocumentReviews) {
  op <- new_operation(
    name = "UpdateDocumentMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_document_metadata_input(Name = Name, DocumentVersion = DocumentVersion, DocumentReviews = DocumentReviews)
  output <- .ssm$update_document_metadata_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_document_metadata <- ssm_update_document_metadata

#' Updates an existing maintenance window
#'
#' @description
#' Updates an existing maintenance window. Only specified parameters are modified.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window/](https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window to update.
#' @param Name The name of the maintenance window.
#' @param Description An optional description for the update request.
#' @param StartDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become active. `StartDate` allows you to delay
#' activation of the maintenance window until the specified future date.
#' @param EndDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become inactive. `EndDate` allows you to set a
#' date and time in the future when the maintenance window will no longer
#' run.
#' @param Schedule The schedule of the maintenance window in the form of a cron or rate
#' expression.
#' @param ScheduleTimezone The time zone that the scheduled maintenance window executions are based
#' on, in Internet Assigned Numbers Authority (IANA) format. For example:
#' "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
#' the [Time Zone Database](https://www.iana.org/time-zones) on the IANA
#' website.
#' @param ScheduleOffset The number of days to wait after the date and time specified by a cron
#' expression before running the maintenance window.
#' 
#' For example, the following cron expression schedules a maintenance
#' window to run the third Tuesday of every month at 11:30 PM.
#' 
#' `cron(30 23 ? * TUE#3 *)`
#' 
#' If the schedule offset is `2`, the maintenance window won't run until
#' two days later.
#' @param Duration The duration of the maintenance window in hours.
#' @param Cutoff The number of hours before the end of the maintenance window that Amazon
#' Web Services Systems Manager stops scheduling new tasks for execution.
#' @param AllowUnassociatedTargets Whether targets must be registered with the maintenance window before
#' tasks can be defined for those targets.
#' @param Enabled Whether the maintenance window is enabled.
#' @param Replace If `True`, then all fields that are required by the
#' [`create_maintenance_window`][ssm_create_maintenance_window] operation
#' are also required for this API request. Optional fields that aren't
#' specified are set to null.
#'
#' @keywords internal
#'
#' @rdname ssm_update_maintenance_window
ssm_update_maintenance_window <- function(WindowId, Name = NULL, Description = NULL, StartDate = NULL, EndDate = NULL, Schedule = NULL, ScheduleTimezone = NULL, ScheduleOffset = NULL, Duration = NULL, Cutoff = NULL, AllowUnassociatedTargets = NULL, Enabled = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_maintenance_window_input(WindowId = WindowId, Name = Name, Description = Description, StartDate = StartDate, EndDate = EndDate, Schedule = Schedule, ScheduleTimezone = ScheduleTimezone, ScheduleOffset = ScheduleOffset, Duration = Duration, Cutoff = Cutoff, AllowUnassociatedTargets = AllowUnassociatedTargets, Enabled = Enabled, Replace = Replace)
  output <- .ssm$update_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_maintenance_window <- ssm_update_maintenance_window

#' Modifies the target of an existing maintenance window
#'
#' @description
#' Modifies the target of an existing maintenance window. You can change the following:
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window_target/](https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window_target/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The maintenance window ID with which to modify the target.
#' @param WindowTargetId &#91;required&#93; The target ID to modify.
#' @param Targets The targets to add or replace.
#' @param OwnerInformation User-provided value that will be included in any Amazon CloudWatch
#' Events events raised while running tasks for these targets in this
#' maintenance window.
#' @param Name A name for the update.
#' @param Description An optional description for the update.
#' @param Replace If `True`, then all fields that are required by the
#' [`register_target_with_maintenance_window`][ssm_register_target_with_maintenance_window]
#' operation are also required for this API request. Optional fields that
#' aren't specified are set to null.
#'
#' @keywords internal
#'
#' @rdname ssm_update_maintenance_window_target
ssm_update_maintenance_window_target <- function(WindowId, WindowTargetId, Targets = NULL, OwnerInformation = NULL, Name = NULL, Description = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceWindowTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_maintenance_window_target_input(WindowId = WindowId, WindowTargetId = WindowTargetId, Targets = Targets, OwnerInformation = OwnerInformation, Name = Name, Description = Description, Replace = Replace)
  output <- .ssm$update_maintenance_window_target_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_maintenance_window_target <- ssm_update_maintenance_window_target

#' Modifies a task assigned to a maintenance window
#'
#' @description
#' Modifies a task assigned to a maintenance window. You can't change the task type, but you can change the following values:
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window_task/](https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window_task/) for full documentation.
#'
#' @param WindowId &#91;required&#93; The maintenance window ID that contains the task to modify.
#' @param WindowTaskId &#91;required&#93; The task ID to modify.
#' @param Targets The targets (either managed nodes or tags) to modify. Managed nodes are
#' specified using the format
#' `Key=instanceids,Values=instanceID_1,instanceID_2`. Tags are specified
#' using the format ` Key=tag_name,Values=tag_value`.
#' 
#' One or more targets must be specified for maintenance window Run
#' Command-type tasks. Depending on the task, targets are optional for
#' other maintenance window task types (Automation, Lambda, and Step
#' Functions). For more information about running tasks that don't specify
#' targets, see [Registering maintenance window tasks without
#' targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param TaskArn The task ARN to modify.
#' @param ServiceRoleArn The Amazon Resource Name (ARN) of the IAM service role for Amazon Web
#' Services Systems Manager to assume when running a maintenance window
#' task. If you do not specify a service role ARN, Systems Manager uses
#' your account's service-linked role. If no service-linked role for
#' Systems Manager exists in your account, it is created when you run
#' [`register_task_with_maintenance_window`][ssm_register_task_with_maintenance_window].
#' 
#' For more information, see the following topics in the in the *Amazon Web
#' Services Systems Manager User Guide*:
#' 
#' -   [Using service-linked roles for Systems
#'     Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
#' 
#' -   [Should I use a service-linked role or a custom service role to run
#'     maintenance window
#'     tasks?](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
#' @param TaskParameters The parameters to modify.
#' 
#' `TaskParameters` has been deprecated. To specify parameters to pass to a
#' task when it runs, instead use the `Parameters` option in the
#' `TaskInvocationParameters` structure. For information about how Systems
#' Manager handles these options for the supported maintenance window task
#' types, see MaintenanceWindowTaskInvocationParameters.
#' 
#' The map has the following format:
#' 
#' Key: string, between 1 and 255 characters
#' 
#' Value: an array of strings, each string is between 1 and 255 characters
#' @param TaskInvocationParameters The parameters that the task should use during execution. Populate only
#' the fields that match the task type. All other fields should be empty.
#' 
#' When you update a maintenance window task that has options specified in
#' `TaskInvocationParameters`, you must provide again all the
#' `TaskInvocationParameters` values that you want to retain. The values
#' you don't specify again are removed. For example, suppose that when you
#' registered a Run Command task, you specified `TaskInvocationParameters`
#' values for `Comment`, `NotificationConfig`, and `OutputS3BucketName`. If
#' you update the maintenance window task and specify only a different
#' `OutputS3BucketName` value, the values for `Comment` and
#' `NotificationConfig` are removed.
#' @param Priority The new task priority to specify. The lower the number, the higher the
#' priority. Tasks that have the same priority are scheduled in parallel.
#' @param MaxConcurrency The new `MaxConcurrency` value you want to specify. `MaxConcurrency` is
#' the number of targets that are allowed to run this task, in parallel.
#' 
#' Although this element is listed as "Required: No", a value can be
#' omitted only when you are registering or updating a [targetless
#' task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
#' You must provide a value in all other cases.
#' 
#' For maintenance window tasks without a target specified, you can't
#' supply a value for this option. Instead, the system inserts a
#' placeholder value of `1`. This value doesn't affect the running of your
#' task.
#' @param MaxErrors The new `MaxErrors` value to specify. `MaxErrors` is the maximum number
#' of errors that are allowed before the task stops being scheduled.
#' 
#' Although this element is listed as "Required: No", a value can be
#' omitted only when you are registering or updating a [targetless
#' task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
#' You must provide a value in all other cases.
#' 
#' For maintenance window tasks without a target specified, you can't
#' supply a value for this option. Instead, the system inserts a
#' placeholder value of `1`. This value doesn't affect the running of your
#' task.
#' @param LoggingInfo The new logging location in Amazon S3 to specify.
#' 
#' `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage
#' Service (Amazon S3) bucket to contain logs, instead use the
#' `OutputS3BucketName` and `OutputS3KeyPrefix` options in the
#' `TaskInvocationParameters` structure. For information about how Amazon
#' Web Services Systems Manager handles these options for the supported
#' maintenance window task types, see
#' MaintenanceWindowTaskInvocationParameters.
#' @param Name The new task name to specify.
#' @param Description The new task description to specify.
#' @param Replace If True, then all fields that are required by the
#' [`register_task_with_maintenance_window`][ssm_register_task_with_maintenance_window]
#' operation are also required for this API request. Optional fields that
#' aren't specified are set to null.
#' @param CutoffBehavior Indicates whether tasks should continue to run after the cutoff time
#' specified in the maintenance windows is reached.
#' 
#' -   `CONTINUE_TASK`: When the cutoff time is reached, any tasks that are
#'     running continue. The default value.
#' 
#' -   `CANCEL_TASK`:
#' 
#'     -   For Automation, Lambda, Step Functions tasks: When the cutoff
#'         time is reached, any task invocations that are already running
#'         continue, but no new task invocations are started.
#' 
#'     -   For Run Command tasks: When the cutoff time is reached, the
#'         system sends a [`cancel_command`][ssm_cancel_command] operation
#'         that attempts to cancel the command associated with the task.
#'         However, there is no guarantee that the command will be
#'         terminated and the underlying process stopped.
#' 
#'     The status for tasks that are not completed is `TIMED_OUT`.
#' @param AlarmConfiguration The CloudWatch alarm you want to apply to your maintenance window task.
#'
#' @keywords internal
#'
#' @rdname ssm_update_maintenance_window_task
ssm_update_maintenance_window_task <- function(WindowId, WindowTaskId, Targets = NULL, TaskArn = NULL, ServiceRoleArn = NULL, TaskParameters = NULL, TaskInvocationParameters = NULL, Priority = NULL, MaxConcurrency = NULL, MaxErrors = NULL, LoggingInfo = NULL, Name = NULL, Description = NULL, Replace = NULL, CutoffBehavior = NULL, AlarmConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceWindowTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_maintenance_window_task_input(WindowId = WindowId, WindowTaskId = WindowTaskId, Targets = Targets, TaskArn = TaskArn, ServiceRoleArn = ServiceRoleArn, TaskParameters = TaskParameters, TaskInvocationParameters = TaskInvocationParameters, Priority = Priority, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, LoggingInfo = LoggingInfo, Name = Name, Description = Description, Replace = Replace, CutoffBehavior = CutoffBehavior, AlarmConfiguration = AlarmConfiguration)
  output <- .ssm$update_maintenance_window_task_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_maintenance_window_task <- ssm_update_maintenance_window_task

#' Changes the Identity and Access Management (IAM) role that is assigned
#' to the on-premises server, edge device, or virtual machines (VM)
#'
#' @description
#' Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more information, see [`create_activation`][ssm_create_activation].
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_managed_instance_role/](https://www.paws-r-sdk.com/docs/ssm_update_managed_instance_role/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the managed node where you want to update the role.
#' @param IamRole &#91;required&#93; The name of the Identity and Access Management (IAM) role that you want
#' to assign to the managed node. This IAM role must provide AssumeRole
#' permissions for the Amazon Web Services Systems Manager service
#' principal `ssm.amazonaws.com`. For more information, see [Create an IAM
#' service role for a hybrid
#' environment](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' 
#' You can't specify an IAM service-linked role for this parameter. You
#' must create a unique role.
#'
#' @keywords internal
#'
#' @rdname ssm_update_managed_instance_role
ssm_update_managed_instance_role <- function(InstanceId, IamRole) {
  op <- new_operation(
    name = "UpdateManagedInstanceRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_managed_instance_role_input(InstanceId = InstanceId, IamRole = IamRole)
  output <- .ssm$update_managed_instance_role_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_managed_instance_role <- ssm_update_managed_instance_role

#' Edit or change an OpsItem
#'
#' @description
#' Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_ops_item/](https://www.paws-r-sdk.com/docs/ssm_update_ops_item/) for full documentation.
#'
#' @param Description User-defined text that contains information about the OpsItem, in
#' Markdown format.
#' @param OperationalData Add new keys or edit existing key-value pairs of the OperationalData map
#' in the OpsItem object.
#' 
#' Operational data is custom data that provides useful reference details
#' about the OpsItem. For example, you can specify log files, error
#' strings, license keys, troubleshooting tips, or other relevant data. You
#' enter operational data as key-value pairs. The key has a maximum length
#' of 128 characters. The value has a maximum size of 20 KB.
#' 
#' Operational data keys *can't* begin with the following: `amazon`, `aws`,
#' `amzn`, `ssm`, `/amazon`, `/aws`, `/amzn`, `/ssm`.
#' 
#' You can choose to make the data searchable by other users in the account
#' or you can restrict search access. Searchable data means that all users
#' with access to the OpsItem Overview page (as provided by the
#' [`describe_ops_items`][ssm_describe_ops_items] API operation) can view
#' and search on the specified data. Operational data that isn't searchable
#' is only viewable by users who have access to the OpsItem (as provided by
#' the [`get_ops_item`][ssm_get_ops_item] API operation).
#' 
#' Use the `/aws/resources` key in OperationalData to specify a related
#' resource in the request. Use the `/aws/automations` key in
#' OperationalData to associate an Automation runbook with the OpsItem. To
#' view Amazon Web Services CLI example commands that use these keys, see
#' [Creating OpsItems
#' manually](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-manually-create-OpsItems.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param OperationalDataToDelete Keys that you want to remove from the OperationalData map.
#' @param Notifications The Amazon Resource Name (ARN) of an SNS topic where notifications are
#' sent when this OpsItem is edited or changed.
#' @param Priority The importance of this OpsItem in relation to other OpsItems in the
#' system.
#' @param RelatedOpsItems One or more OpsItems that share something in common with the current
#' OpsItems. For example, related OpsItems can include OpsItems with
#' similar error messages, impacted resources, or statuses for the impacted
#' resource.
#' @param Status The OpsItem status. Status can be `Open`, `In Progress`, or `Resolved`.
#' For more information, see [Editing OpsItem
#' details](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem.
#' @param Title A short heading that describes the nature of the OpsItem and the
#' impacted resource.
#' @param Category Specify a new category for an OpsItem.
#' @param Severity Specify a new severity for an OpsItem.
#' @param ActualStartTime The time a runbook workflow started. Currently reported only for the
#' OpsItem type `/aws/changerequest`.
#' @param ActualEndTime The time a runbook workflow ended. Currently reported only for the
#' OpsItem type `/aws/changerequest`.
#' @param PlannedStartTime The time specified in a change request for a runbook workflow to start.
#' Currently supported only for the OpsItem type `/aws/changerequest`.
#' @param PlannedEndTime The time specified in a change request for a runbook workflow to end.
#' Currently supported only for the OpsItem type `/aws/changerequest`.
#' @param OpsItemArn The OpsItem Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname ssm_update_ops_item
ssm_update_ops_item <- function(Description = NULL, OperationalData = NULL, OperationalDataToDelete = NULL, Notifications = NULL, Priority = NULL, RelatedOpsItems = NULL, Status = NULL, OpsItemId, Title = NULL, Category = NULL, Severity = NULL, ActualStartTime = NULL, ActualEndTime = NULL, PlannedStartTime = NULL, PlannedEndTime = NULL, OpsItemArn = NULL) {
  op <- new_operation(
    name = "UpdateOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_ops_item_input(Description = Description, OperationalData = OperationalData, OperationalDataToDelete = OperationalDataToDelete, Notifications = Notifications, Priority = Priority, RelatedOpsItems = RelatedOpsItems, Status = Status, OpsItemId = OpsItemId, Title = Title, Category = Category, Severity = Severity, ActualStartTime = ActualStartTime, ActualEndTime = ActualEndTime, PlannedStartTime = PlannedStartTime, PlannedEndTime = PlannedEndTime, OpsItemArn = OpsItemArn)
  output <- .ssm$update_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_ops_item <- ssm_update_ops_item

#' Amazon Web Services Systems Manager calls this API operation when you
#' edit OpsMetadata in Application Manager
#'
#' @description
#' Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_ops_metadata/](https://www.paws-r-sdk.com/docs/ssm_update_ops_metadata/) for full documentation.
#'
#' @param OpsMetadataArn &#91;required&#93; The Amazon Resource Name (ARN) of the OpsMetadata Object to update.
#' @param MetadataToUpdate Metadata to add to an OpsMetadata object.
#' @param KeysToDelete The metadata keys to delete from the OpsMetadata object.
#'
#' @keywords internal
#'
#' @rdname ssm_update_ops_metadata
ssm_update_ops_metadata <- function(OpsMetadataArn, MetadataToUpdate = NULL, KeysToDelete = NULL) {
  op <- new_operation(
    name = "UpdateOpsMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_ops_metadata_input(OpsMetadataArn = OpsMetadataArn, MetadataToUpdate = MetadataToUpdate, KeysToDelete = KeysToDelete)
  output <- .ssm$update_ops_metadata_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_ops_metadata <- ssm_update_ops_metadata

#' Modifies an existing patch baseline
#'
#' @description
#' Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_patch_baseline/](https://www.paws-r-sdk.com/docs/ssm_update_patch_baseline/) for full documentation.
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to update.
#' @param Name The name of the patch baseline.
#' @param GlobalFilters A set of global filters used to include patches in the baseline.
#' @param ApprovalRules A set of rules used to include patches in the baseline.
#' @param ApprovedPatches A list of explicitly approved patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [About package name formats for approved and
#' rejected patch
#' lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param ApprovedPatchesComplianceLevel Assigns a new compliance severity level to an existing patch baseline.
#' @param ApprovedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security
#' updates that should be applied to the managed nodes. The default value
#' is `false`. Applies to Linux managed nodes only.
#' @param RejectedPatches A list of explicitly rejected patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [About package name formats for approved and
#' rejected patch
#' lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *Amazon Web Services Systems Manager User Guide*.
#' @param RejectedPatchesAction The action for Patch Manager to take on patches included in the
#' `RejectedPackages` list.
#' 
#' -   **`ALLOW_AS_DEPENDENCY`** : A package in the `Rejected` patches list
#'     is installed only if it is a dependency of another package. It is
#'     considered compliant with the patch baseline, and its status is
#'     reported as `InstalledOther`. This is the default action if no
#'     option is specified.
#' 
#' -   **`BLOCK`** : Packages in the `RejectedPatches` list, and packages
#'     that include them as dependencies, aren't installed under any
#'     circumstances. If a package was installed before it was added to the
#'     `Rejected` patches list, it is considered non-compliant with the
#'     patch baseline, and its status is reported as `InstalledRejected`.
#' @param Description A description of the patch baseline.
#' @param Sources Information about the patches to use to update the managed nodes,
#' including target operating systems and source repositories. Applies to
#' Linux managed nodes only.
#' @param Replace If True, then all fields that are required by the
#' [`create_patch_baseline`][ssm_create_patch_baseline] operation are also
#' required for this API request. Optional fields that aren't specified are
#' set to null.
#'
#' @keywords internal
#'
#' @rdname ssm_update_patch_baseline
ssm_update_patch_baseline <- function(BaselineId, Name = NULL, GlobalFilters = NULL, ApprovalRules = NULL, ApprovedPatches = NULL, ApprovedPatchesComplianceLevel = NULL, ApprovedPatchesEnableNonSecurity = NULL, RejectedPatches = NULL, RejectedPatchesAction = NULL, Description = NULL, Sources = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdatePatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_patch_baseline_input(BaselineId = BaselineId, Name = Name, GlobalFilters = GlobalFilters, ApprovalRules = ApprovalRules, ApprovedPatches = ApprovedPatches, ApprovedPatchesComplianceLevel = ApprovedPatchesComplianceLevel, ApprovedPatchesEnableNonSecurity = ApprovedPatchesEnableNonSecurity, RejectedPatches = RejectedPatches, RejectedPatchesAction = RejectedPatchesAction, Description = Description, Sources = Sources, Replace = Replace)
  output <- .ssm$update_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_patch_baseline <- ssm_update_patch_baseline

#' Update a resource data sync
#'
#' @description
#' Update a resource data sync. After you create a resource data sync for a Region, you can't change the account options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the `Include only the current account` option, you can't edit that sync later and choose the `Include all accounts from my Organizations configuration` option. Instead, you must delete the first resource data sync, and create a new one.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_resource_data_sync/](https://www.paws-r-sdk.com/docs/ssm_update_resource_data_sync/) for full documentation.
#'
#' @param SyncName &#91;required&#93; The name of the resource data sync you want to update.
#' @param SyncType &#91;required&#93; The type of resource data sync. The supported `SyncType` is
#' SyncFromSource.
#' @param SyncSource &#91;required&#93; Specify information about the data sources to synchronize.
#'
#' @keywords internal
#'
#' @rdname ssm_update_resource_data_sync
ssm_update_resource_data_sync <- function(SyncName, SyncType, SyncSource) {
  op <- new_operation(
    name = "UpdateResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_resource_data_sync_input(SyncName = SyncName, SyncType = SyncType, SyncSource = SyncSource)
  output <- .ssm$update_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_resource_data_sync <- ssm_update_resource_data_sync

#' ServiceSetting is an account-level setting for an Amazon Web Services
#' service
#'
#' @description
#' `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
#'
#' See [https://www.paws-r-sdk.com/docs/ssm_update_service_setting/](https://www.paws-r-sdk.com/docs/ssm_update_service_setting/) for full documentation.
#'
#' @param SettingId &#91;required&#93; The Amazon Resource Name (ARN) of the service setting to update. For
#' example,
#' `arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled`.
#' The setting ID can be one of the following.
#' 
#' -   `/ssm/managed-instance/default-ec2-instance-management-role`
#' 
#' -   `/ssm/automation/customer-script-log-destination`
#' 
#' -   `/ssm/automation/customer-script-log-group-name`
#' 
#' -   `/ssm/documents/console/public-sharing-permission`
#' 
#' -   `/ssm/managed-instance/activation-tier`
#' 
#' -   `/ssm/opsinsights/opscenter`
#' 
#' -   `/ssm/parameter-store/default-parameter-tier`
#' 
#' -   `/ssm/parameter-store/high-throughput-enabled`
#' 
#' Permissions to update the
#' `/ssm/managed-instance/default-ec2-instance-management-role` setting
#' should only be provided to administrators. Implement least privilege
#' access when allowing individuals to configure or modify the Default Host
#' Management Configuration.
#' @param SettingValue &#91;required&#93; The new value to specify for the service setting. The following list
#' specifies the available values for each setting.
#' 
#' -   For `/ssm/managed-instance/default-ec2-instance-management-role`,
#'     enter the name of an IAM role.
#' 
#' -   For `/ssm/automation/customer-script-log-destination`, enter
#'     `CloudWatch`.
#' 
#' -   For `/ssm/automation/customer-script-log-group-name`, enter the name
#'     of an Amazon CloudWatch Logs log group.
#' 
#' -   For `/ssm/documents/console/public-sharing-permission`, enter
#'     `Enable` or `Disable`.
#' 
#' -   For `/ssm/managed-instance/activation-tier`, enter `standard` or
#'     `advanced`.
#' 
#' -   For `/ssm/opsinsights/opscenter`, enter `Enabled` or `Disabled`.
#' 
#' -   For `/ssm/parameter-store/default-parameter-tier`, enter `Standard`,
#'     `Advanced`, or `Intelligent-Tiering`
#' 
#' -   For `/ssm/parameter-store/high-throughput-enabled`, enter `true` or
#'     `false`.
#'
#' @keywords internal
#'
#' @rdname ssm_update_service_setting
ssm_update_service_setting <- function(SettingId, SettingValue) {
  op <- new_operation(
    name = "UpdateServiceSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_service_setting_input(SettingId = SettingId, SettingValue = SettingValue)
  output <- .ssm$update_service_setting_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_service_setting <- ssm_update_service_setting
