% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_import_stacks_to_stack_set}
\alias{cloudformation_import_stacks_to_stack_set}
\title{Import existing stacks into a new stack sets}
\usage{
cloudformation_import_stacks_to_stack_set(
  StackSetName,
  StackIds = NULL,
  StackIdsUrl = NULL,
  OrganizationalUnitIds = NULL,
  OperationPreferences = NULL,
  OperationId = NULL,
  CallAs = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name of the stack set. The name must be unique in the Region where
you create your stack set.}

\item{StackIds}{The IDs of the stacks you are importing into a stack set. You import up
to 10 stacks per stack set at a time.

Specify either \code{StackIds} or \code{StackIdsUrl}.}

\item{StackIdsUrl}{The Amazon S3 URL which contains list of stack ids to be inputted.

Specify either \code{StackIds} or \code{StackIdsUrl}.}

\item{OrganizationalUnitIds}{The list of OU ID's to which the stacks being imported has to be mapped
as deployment target.}

\item{OperationPreferences}{The user-specified preferences for how CloudFormation performs a stack
set operation.

For more information about maximum concurrent accounts and failure
tolerance, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options}{Stack set operation options}.}

\item{OperationId}{A unique, user defined, identifier for the stack set operation.}

\item{CallAs}{By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item For service managed stack sets, specify \code{DELEGATED_ADMIN}.
}}
}
\description{
Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new stack set in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_import_stacks_to_stack_set/} for full documentation.
}
\keyword{internal}
