% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetics_operations.R
\name{synthetics_update_canary}
\alias{synthetics_update_canary}
\title{Updates the configuration of a canary that has already been created}
\usage{
synthetics_update_canary(
  Name,
  Code = NULL,
  ExecutionRoleArn = NULL,
  RuntimeVersion = NULL,
  Schedule = NULL,
  RunConfig = NULL,
  SuccessRetentionPeriodInDays = NULL,
  FailureRetentionPeriodInDays = NULL,
  VpcConfig = NULL,
  VisualReference = NULL,
  ArtifactS3Location = NULL,
  ArtifactConfig = NULL
)
}
\arguments{
\item{Name}{[required] The name of the canary that you want to update. To find the names of
your canaries, use \code{\link[=synthetics_describe_canaries]{describe_canaries}}.

You cannot change the name of a canary that has already been created.}

\item{Code}{A structure that includes the entry point from which the canary should
start running your script. If the script is stored in an S3 bucket, the
bucket name, key, and version are also included.}

\item{ExecutionRoleArn}{The ARN of the IAM role to be used to run the canary. This role must
already exist, and must include \code{lambda.amazonaws.com} as a principal in
the trust policy. The role must also have the following permissions:
\itemize{
\item \code{s3:PutObject}
\item \code{s3:GetBucketLocation}
\item \code{s3:ListAllMyBuckets}
\item \code{cloudwatch:PutMetricData}
\item \code{logs:CreateLogGroup}
\item \code{logs:CreateLogStream}
\item \code{logs:CreateLogStream}
}}

\item{RuntimeVersion}{Specifies the runtime version to use for the canary. For a list of valid
runtime versions and for more information about runtime versions, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html}{Canary Runtime Versions}.}

\item{Schedule}{A structure that contains information about how often the canary is to
run, and when these runs are to stop.}

\item{RunConfig}{A structure that contains the timeout value that is used for each
individual run of the canary.

The environment variables keys and values are not encrypted. Do not
store sensitive information in this field.}

\item{SuccessRetentionPeriodInDays}{The number of days to retain data about successful runs of this canary.}

\item{FailureRetentionPeriodInDays}{The number of days to retain data about failed runs of this canary.}

\item{VpcConfig}{If this canary is to test an endpoint in a VPC, this structure contains
information about the subnet and security groups of the VPC endpoint.
For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html}{Running a Canary in a VPC}.}

\item{VisualReference}{Defines the screenshots to use as the baseline for comparisons during
visual monitoring comparisons during future runs of this canary. If you
omit this parameter, no changes are made to any baseline screenshots
that the canary might be using already.

Visual monitoring is supported only on canaries running the
\strong{syn-puppeteer-node-3.2} runtime or later. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/}{Visual monitoring}
and \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/}{Visual monitoring blueprint}}

\item{ArtifactS3Location}{The location in Amazon S3 where Synthetics stores artifacts from the
test runs of this canary. Artifacts include the log file, screenshots,
and HAR files. The name of the S3 bucket can't include a period (.).}

\item{ArtifactConfig}{A structure that contains the configuration for canary artifacts,
including the encryption-at-rest settings for artifacts that the canary
uploads to Amazon S3.}
}
\description{
Updates the configuration of a canary that has already been created.

See \url{https://www.paws-r-sdk.com/docs/synthetics_update_canary/} for full documentation.
}
\keyword{internal}
