% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_remove_tags}
\alias{cloudtrail_remove_tags}
\title{Removes the specified tags from a trail or event data store}
\usage{
cloudtrail_remove_tags(ResourceId, TagsList)
}
\arguments{
\item{ResourceId}{[required] Specifies the ARN of the trail or event data store from which tags
should be removed.

Example trail ARN format:
\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}

Example event data store ARN format:
\verb{arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE}}

\item{TagsList}{[required] Specifies a list of tags to be removed.}
}
\description{
Removes the specified tags from a trail or event data store.

See \url{https://paws-r.github.io/docs/cloudtrail/remove_tags.html} for full documentation.
}
\keyword{internal}
