% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_update_layer}
\alias{opsworks_update_layer}
\title{Updates a specified layer}
\usage{
opsworks_update_layer(LayerId, Name, Shortname, Attributes,
  CloudWatchLogsConfiguration, CustomInstanceProfileArn, CustomJson,
  CustomSecurityGroupIds, Packages, VolumeConfigurations,
  EnableAutoHealing, AutoAssignElasticIps, AutoAssignPublicIps,
  CustomRecipes, InstallUpdatesOnBoot, UseEbsOptimizedInstances,
  LifecycleEventConfiguration)
}
\arguments{
\item{LayerId}{[required] The layer ID.}

\item{Name}{The layer name, which is used by the console.}

\item{Shortname}{For custom layers only, use this parameter to specify the layer's short
name, which is used internally by AWS OpsWorks Stacks and by Chef. The
short name is also used as the name for the directory where your app
files are installed. It can have a maximum of 200 characters and must be
in the following format: /\code{\\A}[a-z0-9\-\\_\.]+\code{\\Z}/.

The built-in layers' short names are defined by AWS OpsWorks Stacks.
For more information, see the \href{https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html}{Layer Reference}}

\item{Attributes}{One or more user-defined key/value pairs to be added to the stack
attributes.}

\item{CloudWatchLogsConfiguration}{Specifies CloudWatch Logs configuration options for the layer. For more
information, see CloudWatchLogsLogStream.}

\item{CustomInstanceProfileArn}{The ARN of an IAM profile to be used for all of the layer's EC2
instances. For more information about IAM ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html}{Using Identifiers}.}

\item{CustomJson}{A JSON-formatted string containing custom stack configuration and
deployment attributes to be installed on the layer's instances. For
more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html}{Using Custom JSON}.}

\item{CustomSecurityGroupIds}{An array containing the layer's custom security group IDs.}

\item{Packages}{An array of \code{Package} objects that describe the layer's packages.}

\item{VolumeConfigurations}{A \code{VolumeConfigurations} object that describes the layer's Amazon EBS
volumes.}

\item{EnableAutoHealing}{Whether to disable auto healing for the layer.}

\item{AutoAssignElasticIps}{Whether to automatically assign an \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP address}
to the layer's instances. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html}{How to Edit a Layer}.}

\item{AutoAssignPublicIps}{For stacks that are running in a VPC, whether to automatically assign a
public IP address to the layer's instances. For more information, see
\href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html}{How to Edit a Layer}.}

\item{CustomRecipes}{A \code{LayerCustomRecipes} object that specifies the layer's custom
recipes.}

\item{InstallUpdatesOnBoot}{Whether to install operating system and package updates when the
instance boots. The default value is \code{true}. To control when updates are
installed, set this value to \code{false}. You must then update your
instances manually by using CreateDeployment to run the
\code{update_dependencies} stack command or manually running \code{yum} (Amazon
Linux) or \code{apt-get} (Ubuntu) on the instances.

We strongly recommend using the default value of \code{true}, to ensure that
your instances have the latest security updates.}

\item{UseEbsOptimizedInstances}{Whether to use Amazon EBS-optimized instances.}

\item{LifecycleEventConfiguration}{}
}
\description{
Updates a specified layer.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$update_layer(
  LayerId = "string",
  Name = "string",
  Shortname = "string",
  Attributes = list(
    "string"
  ),
  CloudWatchLogsConfiguration = list(
    Enabled = TRUE|FALSE,
    LogStreams = list(
      list(
        LogGroupName = "string",
        DatetimeFormat = "string",
        TimeZone = "LOCAL"|"UTC",
        File = "string",
        FileFingerprintLines = "string",
        MultiLineStartPattern = "string",
        InitialPosition = "start_of_file"|"end_of_file",
        Encoding = "ascii"|"big5"|"big5hkscs"|"cp037"|"cp424"|"cp437"|"cp500"|"cp720"|"cp737"|"cp775"|"cp850"|"cp852"|"cp855"|"cp856"|"cp857"|"cp858"|"cp860"|"cp861"|"cp862"|"cp863"|"cp864"|"cp865"|"cp866"|"cp869"|"cp874"|"cp875"|"cp932"|"cp949"|"cp950"|"cp1006"|"cp1026"|"cp1140"|"cp1250"|"cp1251"|"cp1252"|"cp1253"|"cp1254"|"cp1255"|"cp1256"|"cp1257"|"cp1258"|"euc_jp"|"euc_jis_2004"|"euc_jisx0213"|"euc_kr"|"gb2312"|"gbk"|"gb18030"|"hz"|"iso2022_jp"|"iso2022_jp_1"|"iso2022_jp_2"|"iso2022_jp_2004"|"iso2022_jp_3"|"iso2022_jp_ext"|"iso2022_kr"|"latin_1"|"iso8859_2"|"iso8859_3"|"iso8859_4"|"iso8859_5"|"iso8859_6"|"iso8859_7"|"iso8859_8"|"iso8859_9"|"iso8859_10"|"iso8859_13"|"iso8859_14"|"iso8859_15"|"iso8859_16"|"johab"|"koi8_r"|"koi8_u"|"mac_cyrillic"|"mac_greek"|"mac_iceland"|"mac_latin2"|"mac_roman"|"mac_turkish"|"ptcp154"|"shift_jis"|"shift_jis_2004"|"shift_jisx0213"|"utf_32"|"utf_32_be"|"utf_32_le"|"utf_16"|"utf_16_be"|"utf_16_le"|"utf_7"|"utf_8"|"utf_8_sig",
        BufferDuration = 123,
        BatchCount = 123,
        BatchSize = 123
      )
    )
  ),
  CustomInstanceProfileArn = "string",
  CustomJson = "string",
  CustomSecurityGroupIds = list(
    "string"
  ),
  Packages = list(
    "string"
  ),
  VolumeConfigurations = list(
    list(
      MountPoint = "string",
      RaidLevel = 123,
      NumberOfDisks = 123,
      Size = 123,
      VolumeType = "string",
      Iops = 123,
      Encrypted = TRUE|FALSE
    )
  ),
  EnableAutoHealing = TRUE|FALSE,
  AutoAssignElasticIps = TRUE|FALSE,
  AutoAssignPublicIps = TRUE|FALSE,
  CustomRecipes = list(
    Setup = list(
      "string"
    ),
    Configure = list(
      "string"
    ),
    Deploy = list(
      "string"
    ),
    Undeploy = list(
      "string"
    ),
    Shutdown = list(
      "string"
    )
  ),
  InstallUpdatesOnBoot = TRUE|FALSE,
  UseEbsOptimizedInstances = TRUE|FALSE,
  LifecycleEventConfiguration = list(
    Shutdown = list(
      ExecutionTimeout = 123,
      DelayUntilElbConnectionsDrained = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
