% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_get_license_configuration}
\alias{licensemanager_get_license_configuration}
\title{Gets detailed information about the specified license configuration}
\usage{
licensemanager_get_license_configuration(LicenseConfigurationArn)
}
\arguments{
\item{LicenseConfigurationArn}{[required] Amazon Resource Name (ARN) of the license configuration.}
}
\value{
A list with the following syntax:\preformatted{list(
  LicenseConfigurationId = "string",
  LicenseConfigurationArn = "string",
  Name = "string",
  Description = "string",
  LicenseCountingType = "vCPU"|"Instance"|"Core"|"Socket",
  LicenseRules = list(
    "string"
  ),
  LicenseCount = 123,
  LicenseCountHardLimit = TRUE|FALSE,
  ConsumedLicenses = 123,
  Status = "string",
  OwnerAccountId = "string",
  ConsumedLicenseSummaryList = list(
    list(
      ResourceType = "EC2_INSTANCE"|"EC2_HOST"|"EC2_AMI"|"RDS"|"SYSTEMS_MANAGER_MANAGED_INSTANCE",
      ConsumedLicenses = 123
    )
  ),
  ManagedResourceSummaryList = list(
    list(
      ResourceType = "EC2_INSTANCE"|"EC2_HOST"|"EC2_AMI"|"RDS"|"SYSTEMS_MANAGER_MANAGED_INSTANCE",
      AssociationCount = 123
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  ProductInformationList = list(
    list(
      ResourceType = "string",
      ProductInformationFilterList = list(
        list(
          ProductInformationFilterName = "string",
          ProductInformationFilterValue = list(
            "string"
          ),
          ProductInformationFilterComparator = "string"
        )
      )
    )
  ),
  AutomatedDiscoveryInformation = list(
    LastRunTime = as.POSIXct(
      "2015-01-01"
    )
  ),
  DisassociateWhenNotFound = TRUE|FALSE
)
}
}
\description{
Gets detailed information about the specified license configuration.
}
\section{Request syntax}{
\preformatted{svc$get_license_configuration(
  LicenseConfigurationArn = "string"
)
}
}

\keyword{internal}
