% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_batch_segment_job}
\alias{personalize_create_batch_segment_job}
\title{Creates a batch segment job}
\usage{
personalize_create_batch_segment_job(
  jobName,
  solutionVersionArn,
  filterArn = NULL,
  numResults = NULL,
  jobInput,
  jobOutput,
  roleArn,
  tags = NULL
)
}
\arguments{
\item{jobName}{[required] The name of the batch segment job to create.}

\item{solutionVersionArn}{[required] The Amazon Resource Name (ARN) of the solution version you want the
batch segment job to use to generate batch segments.}

\item{filterArn}{The ARN of the filter to apply to the batch segment job. For more
information on using filters, see \href{https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html}{Filtering batch recommendations}.}

\item{numResults}{The number of predicted users generated by the batch segment job for
each line of input data. The maximum number of users per segment is 5
million.}

\item{jobInput}{[required] The Amazon S3 path for the input data used to generate the batch segment
job.}

\item{jobOutput}{[required] The Amazon S3 path for the bucket where the job's output will be stored.}

\item{roleArn}{[required] The ARN of the Amazon Identity and Access Management role that has
permissions to read and write to your input and output Amazon S3 buckets
respectively.}

\item{tags}{A list of
\href{https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html}{tags}
to apply to the batch segment job.}
}
\description{
Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see \href{https://docs.aws.amazon.com/personalize/latest/dg/}{Getting batch recommendations and user segments}.

See \url{https://www.paws-r-sdk.com/docs/personalize_create_batch_segment_job/} for full documentation.
}
\keyword{internal}
