% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_associate_faces}
\alias{rekognition_associate_faces}
\title{Associates one or more faces with an existing UserID}
\usage{
rekognition_associate_faces(
  CollectionId,
  UserId,
  FaceIds,
  UserMatchThreshold = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{CollectionId}{[required] The ID of an existing collection containing the UserID.}

\item{UserId}{[required] The ID for the existing UserID.}

\item{FaceIds}{[required] An array of FaceIDs to associate with the UserID.}

\item{UserMatchThreshold}{An optional value specifying the minimum confidence in the UserID match
to return. The default value is 75.}

\item{ClientRequestToken}{Idempotent token used to identify the request to
\code{\link[=rekognition_associate_faces]{associate_faces}}. If you use the same
token with multiple \code{\link[=rekognition_associate_faces]{associate_faces}}
requests, the same response is returned. Use ClientRequestToken to
prevent the same request from being processed more than once.}
}
\description{
Associates one or more faces with an existing UserID. Takes an array of \code{FaceIds}. Each \code{FaceId} that are present in the \code{FaceIds} list is associated with the provided UserID. The maximum number of total \code{FaceIds} per UserID is 100.

See \url{https://www.paws-r-sdk.com/docs/rekognition_associate_faces/} for full documentation.
}
\keyword{internal}
